/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.utilization;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.query.SeekOperation;
import com.microsoft.store.partnercenter.models.utilizations.AzureUtilizationGranularity;
import com.microsoft.store.partnercenter.models.utilizations.AzureUtilizationRecord;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.models.utils.Tuple;
import com.microsoft.store.partnercenter.utilization.IAzureUtilizationCollection;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class AzureUtilizationCollectionOperations
extends BasePartnerComponent<Tuple<String, String>>
implements IAzureUtilizationCollection {
    public AzureUtilizationCollectionOperations(IPartner rootPartnerOperations, String customerId, String subscriptionId) {
        super(rootPartnerOperations, new Tuple<String, String>(customerId, subscriptionId));
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId must be set");
        }
        if (StringHelper.isNullOrWhiteSpace(subscriptionId)) {
            throw new IllegalArgumentException("subscriptionId must be set");
        }
    }

    @Override
    public ResourceCollection<AzureUtilizationRecord> query(DateTime startTime, DateTime endTime, AzureUtilizationGranularity granularity, boolean showDetails, int size) {
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        if (startTime != null) {
            parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetAzureUtilizationRecords").getParameters().get("StartTime"), startTime.withZone(DateTimeZone.UTC).toString("yyyy-MM-dd'T'HH:mm:ss'Z'")));
        }
        if (endTime != null) {
            parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetAzureUtilizationRecords").getParameters().get("EndTime"), endTime.withZone(DateTimeZone.UTC).toString("yyyy-MM-dd'T'HH:mm:ss'Z'")));
        }
        if (granularity != null) {
            parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetAzureUtilizationRecords").getParameters().get("Granularity"), granularity.toString()));
        }
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetAzureUtilizationRecords").getParameters().get("ShowDetails"), Boolean.toString(showDetails)));
        if (size > 0) {
            parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetAzureUtilizationRecords").getParameters().get("Size"), Integer.toString(size)));
        }
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<AzureUtilizationRecord>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetAzureUtilizationRecords").getPath(), ((Tuple)this.getContext()).getItem1(), ((Tuple)this.getContext()).getItem2()), parameters);
    }

    @Override
    public ResourceCollection<AzureUtilizationRecord> seek(String continuationToken, SeekOperation seekOperation) {
        if (StringHelper.isNullOrWhiteSpace(continuationToken)) {
            throw new IllegalArgumentException("continuationToken must be non empty");
        }
        if (seekOperation == null) {
            throw new IllegalArgumentException("SeekOperation can not be null");
        }
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(PartnerService.getInstance().getConfiguration().getApis().get("SeekAzureUtilizationRecords").getAdditionalHeaders().get("ContinuationToken"), continuationToken);
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("SeekAzureUtilizationRecords").getParameters().get("SeekOperation"), seekOperation.toString()));
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<AzureUtilizationRecord>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("SeekAzureUtilizationRecords").getPath(), ((Tuple)this.getContext()).getItem1(), ((Tuple)this.getContext()).getItem2()), headers, parameters);
    }
}

