/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.utils;

import com.microsoft.store.partnercenter.utils.StringHelper;

public class ParameterValidator {
    public static void isIntInclusive(int min, int max, int parameterValue, String errorMessage) {
        if (parameterValue < min || max < parameterValue) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void isValidUriQueryValue(String string, String errorMessage) {
        if (StringHelper.isEmptyOrContainsWhiteSpace(string)) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void isValidCountryCode(String countryCode) {
        if (StringHelper.isEmptyOrContainsWhiteSpace(countryCode)) {
            throw new IllegalArgumentException("Country can't be empty");
        }
        if (countryCode.length() != 2) {
            throw new IllegalArgumentException("Country has to be a 2 letter string");
        }
    }
}

