/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.microsoft.store.partnercenter.logging.PartnerLog;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class UriDeserializer
extends JsonDeserializer<URI> {
    public URI deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        JsonToken currentToken = parser.getCurrentToken();
        if (currentToken.equals((Object)JsonToken.VALUE_STRING)) {
            String linkUri = parser.getText().trim();
            try {
                return new URI(linkUri);
            }
            catch (URISyntaxException e) {
                PartnerLog.getInstance().logError(e.toString());
            }
        } else if (currentToken.equals((Object)JsonToken.VALUE_NULL)) {
            return null;
        }
        context.handleUnexpectedToken(URI.class, parser);
        throw JsonMappingException.from((JsonParser)parser, null);
    }
}

