/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.thrifty.compiler;

import com.microsoft.thrifty.compiler.spi.KotlinTypeProcessor;
import com.microsoft.thrifty.compiler.spi.TypeProcessor;
import java.util.Iterator;
import java.util.ServiceLoader;

public final class TypeProcessorService {
    private static TypeProcessorService instance;
    private ServiceLoader<TypeProcessor> serviceLoader = ServiceLoader.load(TypeProcessor.class);
    private ServiceLoader<KotlinTypeProcessor> kotlinProcessorLoader = ServiceLoader.load(KotlinTypeProcessor.class);

    public static synchronized TypeProcessorService getInstance() {
        if (instance == null) {
            instance = new TypeProcessorService();
        }
        return instance;
    }

    public TypeProcessor getJavaProcessor() {
        return this.loadSingleProcessor(this.serviceLoader.iterator());
    }

    public KotlinTypeProcessor getKotlinProcessor() {
        return this.loadSingleProcessor(this.kotlinProcessorLoader.iterator());
    }

    private <T> T loadSingleProcessor(Iterator<T> iter) {
        Object processor = null;
        if (iter.hasNext()) {
            processor = iter.next();
            if (iter.hasNext()) {
                System.err.println("Multiple processors found; using " + processor.getClass().getName());
            }
        }
        return (T)processor;
    }
}

