/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.thrifty.gradle;

import com.microsoft.thrifty.gen.NullabilityAnnotationType;
import com.microsoft.thrifty.gen.ThriftyCodeGenerator;
import com.microsoft.thrifty.gradle.JavaThriftOptions;
import com.microsoft.thrifty.gradle.KotlinThriftOptions;
import com.microsoft.thrifty.gradle.ThriftOptions;
import com.microsoft.thrifty.gradle.ThriftyTask$WhenMappings;
import com.microsoft.thrifty.kgen.KotlinCodeGenerator;
import com.microsoft.thrifty.schema.ErrorReporter;
import com.microsoft.thrifty.schema.FieldNamingPolicy;
import com.microsoft.thrifty.schema.LoadFailedException;
import com.microsoft.thrifty.schema.Loader;
import com.microsoft.thrifty.schema.Schema;
import com.squareup.kotlinpoet.FileSpec;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\n\u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\n\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020\u001eH\u0007R\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u00020\u00108\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\"\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0017\u0010\u0012\u001a\u0004\b\u0018\u0010\u000eR\u0018\u0010\u0019\u001a\u00020\u001a*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006("}, d2={"Lcom/microsoft/thrifty/gradle/ThriftyTask;", "Lorg/gradle/api/tasks/SourceTask;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "includePath", "Lorg/gradle/api/provider/ListProperty;", "Ljava/nio/file/Path;", "getIncludePath", "()Lorg/gradle/api/provider/ListProperty;", "options", "Lorg/gradle/api/provider/Property;", "Lcom/microsoft/thrifty/gradle/ThriftOptions;", "getOptions", "()Lorg/gradle/api/provider/Property;", "outputDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "outputDirectory$annotations", "()V", "getOutputDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "showStacktrace", "Lorg/gradle/api/logging/configuration/ShowStacktrace;", "showStacktrace$annotations", "getShowStacktrace", "namePolicy", "Lcom/microsoft/thrifty/schema/FieldNamingPolicy;", "getNamePolicy", "(Lcom/microsoft/thrifty/gradle/ThriftOptions;)Lcom/microsoft/thrifty/schema/FieldNamingPolicy;", "generateJavaThrifts", "", "schema", "Lcom/microsoft/thrifty/schema/Schema;", "Lcom/microsoft/thrifty/gradle/JavaThriftOptions;", "generateKotlinThrifts", "Lcom/microsoft/thrifty/gradle/KotlinThriftOptions;", "reportThriftParseError", "exception", "Lcom/microsoft/thrifty/schema/LoadFailedException;", "run", "thrifty-gradle-plugin"})
public class ThriftyTask
extends SourceTask {
    @OutputDirectory
    @NotNull
    private final DirectoryProperty outputDirectory;
    @InputFiles
    @NotNull
    private final ListProperty<Path> includePath;
    @Nested
    @NotNull
    private final Property<ThriftOptions> options;
    @Internal
    @NotNull
    private final Property<ShowStacktrace> showStacktrace;

    public static /* synthetic */ void outputDirectory$annotations() {
    }

    @NotNull
    public final DirectoryProperty getOutputDirectory() {
        return this.outputDirectory;
    }

    @NotNull
    public final ListProperty<Path> getIncludePath() {
        return this.includePath;
    }

    @NotNull
    public final Property<ThriftOptions> getOptions() {
        return this.options;
    }

    public static /* synthetic */ void showStacktrace$annotations() {
    }

    @NotNull
    public final Property<ShowStacktrace> getShowStacktrace() {
        return this.showStacktrace;
    }

    @TaskAction
    public final void run() {
        block7: {
            ThriftOptions opt;
            Loader schema;
            block6: {
                Loader loader;
                try {
                    Comparable<Path> it;
                    loader = new Loader();
                    Object object = this.includePath.get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"includePath.get()");
                    Iterable $this$forEach$iv = (Iterable)object;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (Path)element$iv;
                        boolean bl = false;
                        Path path = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"it");
                        loader.addIncludePath(path);
                    }
                    FileTree fileTree = this.getSource();
                    Intrinsics.checkExpressionValueIsNotNull((Object)fileTree, (String)"source");
                    $this$forEach$iv = (Iterable)fileTree;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (File)element$iv;
                        boolean bl = false;
                        Path path = ((File)it).toPath();
                        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"it.toPath()");
                        loader.addThriftFile(path);
                    }
                    loader = loader.load();
                }
                catch (LoadFailedException e) {
                    this.reportThriftParseError(e);
                    throw (Throwable)new GradleException("Thrift compilation failed");
                }
                schema = loader;
                try {
                    Object object = this.outputDirectory.getAsFile().get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"outputDirectory.asFile.get()");
                    FilesKt.deleteRecursively((File)((File)object));
                }
                catch (IOException e) {
                    this.getLogger().warn("Error clearing stale output", (Throwable)e);
                }
                opt = (ThriftOptions)this.options.get();
                if (!(opt instanceof KotlinThriftOptions)) break block6;
                this.generateKotlinThrifts((Schema)schema, (KotlinThriftOptions)opt);
                break block7;
            }
            if (!(opt instanceof JavaThriftOptions)) break block7;
            this.generateJavaThrifts((Schema)schema, (JavaThriftOptions)opt);
        }
    }

    private final void reportThriftParseError(LoadFailedException exception) {
        for (ErrorReporter.Report report : exception.getErrorReporter().getReports()) {
            LogLevel logLevel;
            switch (ThriftyTask$WhenMappings.$EnumSwitchMapping$0[report.getLevel().ordinal()]) {
                case 1: {
                    logLevel = LogLevel.WARN;
                    break;
                }
                case 2: {
                    logLevel = LogLevel.ERROR;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            LogLevel logLevel2 = logLevel;
            String message = logLevel2.name().charAt(0) + ": " + report.getLocation() + ": " + report.getMessage();
            this.getLogger().log(logLevel2, message);
        }
        ShowStacktrace showStacktrace = (ShowStacktrace)this.showStacktrace.get();
        if (showStacktrace != null) {
            switch (ThriftyTask$WhenMappings.$EnumSwitchMapping$1[showStacktrace.ordinal()]) {
                case 1: 
                case 2: {
                    this.getLogger().error("Thrift compilation failed", (Throwable)exception);
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
    }

    private final void generateJavaThrifts(Schema schema, JavaThriftOptions options) {
        NullabilityAnnotationType nullabilityAnnotationType;
        String it;
        boolean bl;
        boolean bl2;
        String string;
        ThriftyCodeGenerator thriftyCodeGenerator = new ThriftyCodeGenerator(schema, this.getNamePolicy(options));
        boolean bl3 = false;
        boolean bl4 = false;
        ThriftyCodeGenerator $this$apply = thriftyCodeGenerator;
        boolean bl5 = false;
        $this$apply.emitFileComment(true);
        $this$apply.emitGeneratedAnnotations(options.getGeneratedAnnotationType());
        $this$apply.emitParcelable(options.getParcelable());
        $this$apply.failOnUnknownEnumValues(!options.getAllowUnknownEnumValues());
        String string2 = options.getListType();
        if (string2 != null) {
            string = string2;
            bl2 = false;
            bl = false;
            it = string;
            boolean bl6 = false;
            $this$apply.withListType(it);
        }
        String string3 = options.getSetType();
        if (string3 != null) {
            string = string3;
            bl2 = false;
            bl = false;
            it = string;
            boolean bl7 = false;
            $this$apply.withSetType(it);
        }
        String string4 = options.getMapType();
        if (string4 != null) {
            string = string4;
            bl2 = false;
            bl = false;
            it = string;
            boolean bl8 = false;
            $this$apply.withMapType(it);
        }
        switch (ThriftyTask$WhenMappings.$EnumSwitchMapping$2[options.getNullabilityAnnotationKind().ordinal()]) {
            case 1: {
                nullabilityAnnotationType = NullabilityAnnotationType.ANDROID_SUPPORT;
                break;
            }
            case 2: {
                nullabilityAnnotationType = NullabilityAnnotationType.ANDROIDX;
                break;
            }
            case 3: {
                nullabilityAnnotationType = NullabilityAnnotationType.NONE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        NullabilityAnnotationType annoType = nullabilityAnnotationType;
        $this$apply.nullabilityAnnotationType(annoType);
        ThriftyCodeGenerator gen = thriftyCodeGenerator;
        Object object = this.outputDirectory.getAsFile().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"outputDirectory.asFile.get()");
        gen.generate((File)object);
    }

    private final void generateKotlinThrifts(Schema schema, KotlinThriftOptions options) {
        String it;
        boolean bl;
        boolean bl2;
        String string;
        KotlinCodeGenerator kotlinCodeGenerator = new KotlinCodeGenerator(this.getNamePolicy(options));
        boolean bl3 = false;
        boolean bl4 = false;
        KotlinCodeGenerator $this$apply = kotlinCodeGenerator;
        boolean bl5 = false;
        $this$apply.emitJvmName();
        $this$apply.filePerType();
        if (options.getParcelable()) {
            $this$apply.parcelize();
        }
        $this$apply.failOnUnknownEnumValues(!options.getAllowUnknownEnumValues());
        if (options.getBuilderlessDataClasses()) {
            $this$apply.builderlessDataClasses();
        }
        if (!options.getEmitServiceClients()) {
            $this$apply.omitServiceClients();
        } else {
            KotlinThriftOptions.ClientStyle clientStyle = options.getServiceClientStyle();
            if (clientStyle == null) {
                clientStyle = KotlinThriftOptions.ClientStyle.DEFAULT;
            }
            switch (ThriftyTask$WhenMappings.$EnumSwitchMapping$3[clientStyle.ordinal()]) {
                case 1: {
                    $this$apply.omitServiceClients();
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    $this$apply.coroutineServiceClients();
                }
            }
        }
        $this$apply.emitGeneratedAnnotations(options.getGeneratedAnnotationType());
        String string2 = options.getListType();
        if (string2 != null) {
            string = string2;
            bl2 = false;
            bl = false;
            it = string;
            boolean bl6 = false;
            $this$apply.listClassName(it);
        }
        String string3 = options.getSetType();
        if (string3 != null) {
            string = string3;
            bl2 = false;
            bl = false;
            it = string;
            boolean bl7 = false;
            $this$apply.setClassName(it);
        }
        String string4 = options.getMapType();
        if (string4 != null) {
            string = string4;
            bl2 = false;
            bl = false;
            it = string;
            boolean bl8 = false;
            $this$apply.mapClassName(it);
        }
        KotlinCodeGenerator gen = kotlinCodeGenerator;
        File dir = (File)this.outputDirectory.getAsFile().get();
        Iterable $this$forEach$iv = gen.generate(schema);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileSpec it2 = (FileSpec)element$iv;
            boolean bl9 = false;
            File file = dir;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"dir");
            it2.writeTo(file);
        }
    }

    private final FieldNamingPolicy getNamePolicy(@NotNull ThriftOptions $this$namePolicy) {
        FieldNamingPolicy fieldNamingPolicy;
        switch (ThriftyTask$WhenMappings.$EnumSwitchMapping$4[$this$namePolicy.getNameStyle().ordinal()]) {
            case 1: {
                fieldNamingPolicy = FieldNamingPolicy.Companion.getDEFAULT();
                break;
            }
            case 2: {
                fieldNamingPolicy = FieldNamingPolicy.Companion.getJAVA();
                break;
            }
            case 3: {
                fieldNamingPolicy = FieldNamingPolicy.Companion.getPASCAL();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return fieldNamingPolicy;
    }

    @Inject
    public ThriftyTask(@NotNull ObjectFactory objects) {
        Intrinsics.checkParameterIsNotNull((Object)objects, (String)"objects");
        DirectoryProperty directoryProperty = objects.directoryProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)directoryProperty, (String)"objects.directoryProperty()");
        this.outputDirectory = directoryProperty;
        ListProperty listProperty = objects.listProperty(Path.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)listProperty, (String)"objects.listProperty(Path::class.java)");
        this.includePath = listProperty;
        Property property = objects.property(ThriftOptions.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)property, (String)"objects.property(ThriftOptions::class.java)");
        this.options = property;
        Property property2 = objects.property(ShowStacktrace.class).convention((Object)ShowStacktrace.INTERNAL_EXCEPTIONS);
        Intrinsics.checkExpressionValueIsNotNull((Object)property2, (String)"objects.property(ShowSta\u2026race.INTERNAL_EXCEPTIONS)");
        this.showStacktrace = property2;
    }
}

