/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.thrifty.kgen;

import com.microsoft.thrifty.kgen.TypeUtilsKt;
import com.microsoft.thrifty.schema.BuiltinType;
import com.microsoft.thrifty.schema.EnumType;
import com.microsoft.thrifty.schema.ListType;
import com.microsoft.thrifty.schema.MapType;
import com.microsoft.thrifty.schema.ServiceType;
import com.microsoft.thrifty.schema.SetType;
import com.microsoft.thrifty.schema.StructType;
import com.microsoft.thrifty.schema.ThriftType;
import com.microsoft.thrifty.schema.TypedefType;
import com.microsoft.thrifty.schema.UserType;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeNames;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\nH\u0016J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\nH\u0016J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\nH\u0016J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\nH\u0016J\u0010\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020\nH\u0016J\u0010\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u00022\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u00020\nH\u0016\u00a8\u00060"}, d2={"Lcom/microsoft/thrifty/kgen/TypeNameVisitor;", "Lcom/microsoft/thrifty/schema/ThriftType$Visitor;", "Lcom/squareup/kotlinpoet/TypeName;", "()V", "userTypeName", "userType", "Lcom/microsoft/thrifty/schema/UserType;", "visitBinary", "Lcom/squareup/kotlinpoet/ClassName;", "binaryType", "Lcom/microsoft/thrifty/schema/BuiltinType;", "visitBool", "boolType", "visitByte", "byteType", "visitDouble", "doubleType", "visitEnum", "enumType", "Lcom/microsoft/thrifty/schema/EnumType;", "visitI16", "i16Type", "visitI32", "i32Type", "visitI64", "i64Type", "visitList", "listType", "Lcom/microsoft/thrifty/schema/ListType;", "visitMap", "mapType", "Lcom/microsoft/thrifty/schema/MapType;", "visitService", "serviceType", "Lcom/microsoft/thrifty/schema/ServiceType;", "visitSet", "setType", "Lcom/microsoft/thrifty/schema/SetType;", "visitString", "stringType", "visitStruct", "structType", "Lcom/microsoft/thrifty/schema/StructType;", "visitTypedef", "typedefType", "Lcom/microsoft/thrifty/schema/TypedefType;", "visitVoid", "voidType", "thrifty-kotlin-codegen"})
final class TypeNameVisitor
implements ThriftType.Visitor<TypeName> {
    public static final TypeNameVisitor INSTANCE;

    @NotNull
    public ClassName visitVoid(@NotNull BuiltinType voidType) {
        Intrinsics.checkParameterIsNotNull((Object)voidType, (String)"voidType");
        return TypeNames.UNIT;
    }

    @NotNull
    public ClassName visitBool(@NotNull BuiltinType boolType) {
        Intrinsics.checkParameterIsNotNull((Object)boolType, (String)"boolType");
        return TypeNames.BOOLEAN;
    }

    @NotNull
    public ClassName visitByte(@NotNull BuiltinType byteType) {
        Intrinsics.checkParameterIsNotNull((Object)byteType, (String)"byteType");
        return TypeNames.BYTE;
    }

    @NotNull
    public ClassName visitI16(@NotNull BuiltinType i16Type) {
        Intrinsics.checkParameterIsNotNull((Object)i16Type, (String)"i16Type");
        return TypeNames.SHORT;
    }

    @NotNull
    public ClassName visitI32(@NotNull BuiltinType i32Type) {
        Intrinsics.checkParameterIsNotNull((Object)i32Type, (String)"i32Type");
        return TypeNames.INT;
    }

    @NotNull
    public ClassName visitI64(@NotNull BuiltinType i64Type) {
        Intrinsics.checkParameterIsNotNull((Object)i64Type, (String)"i64Type");
        return TypeNames.LONG;
    }

    @NotNull
    public ClassName visitDouble(@NotNull BuiltinType doubleType) {
        Intrinsics.checkParameterIsNotNull((Object)doubleType, (String)"doubleType");
        return TypeNames.DOUBLE;
    }

    @NotNull
    public ClassName visitString(@NotNull BuiltinType stringType) {
        Intrinsics.checkParameterIsNotNull((Object)stringType, (String)"stringType");
        return TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(String.class));
    }

    @NotNull
    public ClassName visitBinary(@NotNull BuiltinType binaryType) {
        Intrinsics.checkParameterIsNotNull((Object)binaryType, (String)"binaryType");
        return TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(ByteString.class));
    }

    @NotNull
    public TypeName visitEnum(@NotNull EnumType enumType) {
        Intrinsics.checkParameterIsNotNull((Object)enumType, (String)"enumType");
        return this.userTypeName((UserType)enumType);
    }

    @NotNull
    public TypeName visitList(@NotNull ListType listType) {
        Intrinsics.checkParameterIsNotNull((Object)listType, (String)"listType");
        TypeName elementType = (TypeName)listType.getElementType().accept((ThriftType.Visitor)this);
        return (TypeName)ParameterizedTypeName.Companion.get(TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(List.class)), new TypeName[]{elementType});
    }

    @NotNull
    public TypeName visitSet(@NotNull SetType setType) {
        Intrinsics.checkParameterIsNotNull((Object)setType, (String)"setType");
        TypeName elementType = (TypeName)setType.getElementType().accept((ThriftType.Visitor)this);
        return (TypeName)ParameterizedTypeName.Companion.get(TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(Set.class)), new TypeName[]{elementType});
    }

    @NotNull
    public TypeName visitMap(@NotNull MapType mapType) {
        Intrinsics.checkParameterIsNotNull((Object)mapType, (String)"mapType");
        TypeName keyType = (TypeName)mapType.getKeyType().accept((ThriftType.Visitor)this);
        TypeName valueType = (TypeName)mapType.getValueType().accept((ThriftType.Visitor)this);
        return (TypeName)ParameterizedTypeName.Companion.get(TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(Map.class)), new TypeName[]{keyType, valueType});
    }

    @NotNull
    public TypeName visitStruct(@NotNull StructType structType) {
        Intrinsics.checkParameterIsNotNull((Object)structType, (String)"structType");
        return this.userTypeName((UserType)structType);
    }

    @NotNull
    public TypeName visitTypedef(@NotNull TypedefType typedefType) {
        Intrinsics.checkParameterIsNotNull((Object)typedefType, (String)"typedefType");
        return this.userTypeName((UserType)typedefType);
    }

    @NotNull
    public TypeName visitService(@NotNull ServiceType serviceType) {
        Intrinsics.checkParameterIsNotNull((Object)serviceType, (String)"serviceType");
        return this.userTypeName((UserType)serviceType);
    }

    private final TypeName userTypeName(UserType userType) {
        return (TypeName)new ClassName(TypeUtilsKt.getKotlinNamespace(userType), new String[]{userType.getName()});
    }

    private TypeNameVisitor() {
    }

    static {
        TypeNameVisitor typeNameVisitor;
        INSTANCE = typeNameVisitor = new TypeNameVisitor();
    }
}

