/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.thrifty.protocol;

import com.microsoft.thrifty.protocol.BaseProtocol;
import com.microsoft.thrifty.protocol.FieldMetadata;
import com.microsoft.thrifty.protocol.ListMetadata;
import com.microsoft.thrifty.protocol.MapMetadata;
import com.microsoft.thrifty.protocol.MessageMetadata;
import com.microsoft.thrifty.protocol.SetMetadata;
import com.microsoft.thrifty.protocol.StructMetadata;
import com.microsoft.thrifty.transport.Transport;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b9\u0018\u0000 r2\u00020\u0001:\u0006rstuvwB\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\bH\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0005H\u0016J\b\u0010\u0019\u001a\u00020\u0011H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0013H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0013H\u0002J\b\u0010&\u001a\u00020\u0013H\u0002J\b\u0010'\u001a\u00020\u0017H\u0002J\b\u0010(\u001a\u00020\u001bH\u0002J\b\u0010)\u001a\u00020$H\u0002J\b\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020\u0013H\u0002J\b\u0010-\u001a\u00020\u0013H\u0002J\u0010\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u00020\u0005H\u0002J\u0010\u00100\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\b\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u00020\u0013H\u0016J\b\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u00020\u0013H\u0016J\b\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u00020\u0013H\u0016J\b\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u00020\u0013H\u0016J\b\u0010=\u001a\u00020+H\u0016J\b\u0010>\u001a\u00020?H\u0016J\b\u0010@\u001a\u00020\u0013H\u0016J\b\u0010A\u001a\u00020\u0013H\u0016J\b\u0010B\u001a\u00020\u0013H\u0002J\u0010\u0010C\u001a\u00020\u00132\u0006\u0010D\u001a\u00020\u0017H\u0016J\u0010\u0010E\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0010\u0010F\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010G\u001a\u00020\u00132\u0006\u0010H\u001a\u00020\u001bH\u0016J \u0010I\u001a\u00020\u00132\u0006\u0010J\u001a\u00020+2\u0006\u0010K\u001a\u00020\"2\u0006\u0010L\u001a\u00020\u0011H\u0016J\b\u0010M\u001a\u00020\u0013H\u0016J\b\u0010N\u001a\u00020\u0013H\u0016J\u0010\u0010O\u001a\u00020\u00132\u0006\u0010P\u001a\u00020 H\u0016J\u0010\u0010Q\u001a\u00020\u00132\u0006\u0010R\u001a\u00020\"H\u0016J\u0010\u0010S\u001a\u00020\u00132\u0006\u0010T\u001a\u00020$H\u0016J\b\u0010U\u001a\u00020\u0013H\u0002J\b\u0010V\u001a\u00020\u0013H\u0002J\u0010\u0010W\u001a\u00020\u00132\u0006\u0010X\u001a\u00020\u001bH\u0002J\u0010\u0010Y\u001a\u00020\u00132\u0006\u0010X\u001a\u00020$H\u0002J\b\u0010Z\u001a\u00020\u0013H\u0002J\b\u0010[\u001a\u00020\u0013H\u0002J\u0010\u0010\\\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u0018\u0010]\u001a\u00020\u00132\u0006\u0010^\u001a\u00020\u00112\u0006\u0010_\u001a\u00020\"H\u0016J\b\u0010`\u001a\u00020\u0013H\u0016J \u0010a\u001a\u00020\u00132\u0006\u0010b\u001a\u00020\u00112\u0006\u0010c\u001a\u00020\u00112\u0006\u0010d\u001a\u00020\"H\u0016J\b\u0010e\u001a\u00020\u0013H\u0016J \u0010f\u001a\u00020\u00132\u0006\u0010g\u001a\u00020+2\u0006\u0010L\u001a\u00020\u00112\u0006\u0010h\u001a\u00020\"H\u0016J\b\u0010i\u001a\u00020\u0013H\u0016J\u0018\u0010j\u001a\u00020\u00132\u0006\u0010^\u001a\u00020\u00112\u0006\u0010k\u001a\u00020\"H\u0016J\b\u0010l\u001a\u00020\u0013H\u0016J\u0010\u0010m\u001a\u00020\u00132\u0006\u0010n\u001a\u00020+H\u0016J\u0010\u0010o\u001a\u00020\u00132\u0006\u0010p\u001a\u00020+H\u0016J\b\u0010q\u001a\u00020\u0013H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\fR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006x"}, d2={"Lcom/microsoft/thrifty/protocol/JsonProtocol;", "Lcom/microsoft/thrifty/protocol/BaseProtocol;", "transport", "Lcom/microsoft/thrifty/transport/Transport;", "fieldNamesAsString", "", "(Lcom/microsoft/thrifty/transport/Transport;Z)V", "context", "Lcom/microsoft/thrifty/protocol/JsonProtocol$JsonBaseContext;", "contextStack", "Lkotlin/collections/ArrayDeque;", "reader", "Lcom/microsoft/thrifty/protocol/JsonProtocol$LookaheadReader;", "tmpbuf", "", "isJsonNumeric", "b", "", "popContext", "", "pushContext", "c", "readBinary", "Lokio/ByteString;", "readBool", "readByte", "readDouble", "", "readFieldBegin", "Lcom/microsoft/thrifty/protocol/FieldMetadata;", "readFieldEnd", "readI16", "", "readI32", "", "readI64", "", "readJsonArrayEnd", "readJsonArrayStart", "readJsonBase64", "readJsonDouble", "readJsonInteger", "readJsonNumericChars", "", "readJsonObjectEnd", "readJsonObjectStart", "readJsonString", "skipContext", "readJsonSyntaxChar", "readListBegin", "Lcom/microsoft/thrifty/protocol/ListMetadata;", "readListEnd", "readMapBegin", "Lcom/microsoft/thrifty/protocol/MapMetadata;", "readMapEnd", "readMessageBegin", "Lcom/microsoft/thrifty/protocol/MessageMetadata;", "readMessageEnd", "readSetBegin", "Lcom/microsoft/thrifty/protocol/SetMetadata;", "readSetEnd", "readString", "readStructBegin", "Lcom/microsoft/thrifty/protocol/StructMetadata;", "readStructEnd", "reset", "resetContext", "writeBinary", "buf", "writeBool", "writeByte", "writeDouble", "dub", "writeFieldBegin", "fieldName", "fieldId", "typeId", "writeFieldEnd", "writeFieldStop", "writeI16", "i16", "writeI32", "i32", "writeI64", "i64", "writeJsonArrayEnd", "writeJsonArrayStart", "writeJsonDouble", "num", "writeJsonInteger", "writeJsonObjectEnd", "writeJsonObjectStart", "writeJsonString", "writeListBegin", "elementTypeId", "listSize", "writeListEnd", "writeMapBegin", "keyTypeId", "valueTypeId", "mapSize", "writeMapEnd", "writeMessageBegin", "name", "seqId", "writeMessageEnd", "writeSetBegin", "setSize", "writeSetEnd", "writeString", "str", "writeStructBegin", "structName", "writeStructEnd", "Companion", "JsonBaseContext", "JsonListContext", "JsonPairContext", "JsonTypes", "LookaheadReader", "thrifty-runtime"})
public final class JsonProtocol
extends BaseProtocol {
    private final ArrayDeque<JsonBaseContext> contextStack;
    private JsonBaseContext context;
    private LookaheadReader reader;
    private final byte[] tmpbuf;
    private final boolean fieldNamesAsString;
    private static final byte[] COMMA;
    private static final byte[] COLON;
    private static final byte[] LBRACE;
    private static final byte[] RBRACE;
    private static final byte[] LBRACKET;
    private static final byte[] RBRACKET;
    private static final byte[] QUOTE;
    private static final byte[] BACKSLASH;
    private static final byte[] ESCSEQ;
    private static final long VERSION = 1L;
    private static final byte[] JSON_CHAR_TABLE;
    private static final String ESCAPE_CHARS = "\"\\/bfnrt";
    private static final byte[] ESCAPE_CHAR_VALS;
    @NotNull
    public static final Companion Companion;

    private final void pushContext(JsonBaseContext c) {
        this.contextStack.addFirst((Object)this.context);
        this.context = c;
    }

    private final void popContext() {
        this.context = (JsonBaseContext)this.contextStack.removeFirst();
    }

    private final void resetContext() {
        while (!this.contextStack.isEmpty()) {
            this.popContext();
        }
    }

    @Override
    public void reset() {
        this.contextStack.clear();
        this.context = new JsonBaseContext();
        this.reader = new LookaheadReader();
    }

    private final void readJsonSyntaxChar(byte[] b) throws IOException {
        byte ch = this.reader.read();
        if (ch != b[0]) {
            throw (Throwable)new ProtocolException("Unexpected character:" + (char)ch);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void writeJsonString(byte[] b) throws IOException {
        this.context.write();
        this.transport.write(QUOTE);
        int len = b.length;
        int n = 0;
        int n2 = len;
        while (n < n2) {
            void i;
            if ((b[i] & 0xFF) >= 48) {
                if (b[i] == BACKSLASH[0]) {
                    this.transport.write(BACKSLASH);
                    this.transport.write(BACKSLASH);
                } else {
                    this.transport.write(b, (int)i, 1);
                }
            } else {
                this.tmpbuf[0] = JSON_CHAR_TABLE[b[i]];
                if (this.tmpbuf[0] == (byte)1) {
                    this.transport.write(b, (int)i, 1);
                } else if (this.tmpbuf[0] > 1) {
                    this.transport.write(BACKSLASH);
                    this.transport.write(this.tmpbuf, 0, 1);
                } else {
                    this.transport.write(ESCSEQ);
                    this.tmpbuf[0] = JsonProtocol.Companion.hexChar((byte)(b[i] >> 4));
                    this.tmpbuf[1] = JsonProtocol.Companion.hexChar(b[i]);
                    this.transport.write(this.tmpbuf, 0, 2);
                }
            }
            ++i;
        }
        this.transport.write(QUOTE);
    }

    private final void writeJsonInteger(long num) throws IOException {
        this.context.write();
        String str = String.valueOf(num);
        boolean escapeNum = this.context.escapeNum();
        if (escapeNum) {
            this.transport.write(QUOTE);
        }
        this.transport.write(StringsKt.encodeToByteArray((String)str));
        if (escapeNum) {
            this.transport.write(QUOTE);
        }
    }

    private final void writeJsonDouble(double num) throws IOException {
        boolean escapeNum;
        this.context.write();
        String str = String.valueOf(num);
        boolean special = false;
        switch (str.charAt(0)) {
            case 'I': 
            case 'N': {
                special = true;
                break;
            }
            case '-': {
                if (str.charAt(1) != 'I') break;
                special = true;
                break;
            }
        }
        boolean bl = escapeNum = special || this.context.escapeNum();
        if (escapeNum) {
            this.transport.write(QUOTE);
        }
        this.transport.write(StringsKt.encodeToByteArray((String)str));
        if (escapeNum) {
            this.transport.write(QUOTE);
        }
    }

    private final void writeJsonObjectStart() throws IOException {
        this.context.write();
        this.transport.write(LBRACE);
        this.pushContext(new JsonPairContext());
    }

    private final void writeJsonObjectEnd() throws IOException {
        this.popContext();
        this.transport.write(RBRACE);
    }

    private final void writeJsonArrayStart() throws IOException {
        this.context.write();
        this.transport.write(LBRACKET);
        this.pushContext(new JsonListContext());
    }

    private final void writeJsonArrayEnd() throws IOException {
        this.popContext();
        this.transport.write(RBRACKET);
    }

    @Override
    public void writeMessageBegin(@NotNull String name, byte typeId, int seqId) throws IOException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.resetContext();
        this.writeJsonArrayStart();
        this.writeJsonInteger(1L);
        this.writeJsonString(StringsKt.encodeToByteArray((String)name));
        this.writeJsonInteger(typeId);
        this.writeJsonInteger(seqId);
    }

    @Override
    public void writeMessageEnd() throws IOException {
        this.writeJsonArrayEnd();
    }

    @Override
    public void writeStructBegin(@NotNull String structName) throws IOException {
        Intrinsics.checkNotNullParameter((Object)structName, (String)"structName");
        this.writeJsonObjectStart();
    }

    @Override
    public void writeStructEnd() throws IOException {
        this.writeJsonObjectEnd();
    }

    @Override
    public void writeFieldBegin(@NotNull String fieldName, int fieldId, byte typeId) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        if (this.fieldNamesAsString) {
            this.writeString(fieldName);
        } else {
            this.writeJsonInteger(fieldId);
        }
        this.writeJsonObjectStart();
        this.writeJsonString(JsonTypes.ttypeToJson(typeId));
    }

    @Override
    public void writeFieldEnd() throws IOException {
        this.writeJsonObjectEnd();
    }

    @Override
    public void writeFieldStop() {
    }

    @Override
    public void writeMapBegin(byte keyTypeId, byte valueTypeId, int mapSize) throws IOException {
        this.writeJsonArrayStart();
        this.writeJsonString(JsonTypes.ttypeToJson(keyTypeId));
        this.writeJsonString(JsonTypes.ttypeToJson(valueTypeId));
        this.writeJsonInteger(mapSize);
        this.writeJsonObjectStart();
    }

    @Override
    public void writeMapEnd() throws IOException {
        this.writeJsonObjectEnd();
        this.writeJsonArrayEnd();
    }

    @Override
    public void writeListBegin(byte elementTypeId, int listSize) throws IOException {
        this.writeJsonArrayStart();
        this.writeJsonString(JsonTypes.ttypeToJson(elementTypeId));
        this.writeJsonInteger(listSize);
    }

    @Override
    public void writeListEnd() throws IOException {
        this.writeJsonArrayEnd();
    }

    @Override
    public void writeSetBegin(byte elementTypeId, int setSize) throws IOException {
        this.writeJsonArrayStart();
        this.writeJsonString(JsonTypes.ttypeToJson(elementTypeId));
        this.writeJsonInteger(setSize);
    }

    @Override
    public void writeSetEnd() throws IOException {
        this.writeJsonArrayEnd();
    }

    @Override
    public void writeBool(boolean b) throws IOException {
        this.writeJsonInteger(b ? 1L : 0L);
    }

    @Override
    public void writeByte(byte b) throws IOException {
        this.writeJsonInteger(b);
    }

    @Override
    public void writeI16(short i16) throws IOException {
        this.writeJsonInteger(i16);
    }

    @Override
    public void writeI32(int i32) throws IOException {
        this.writeJsonInteger(i32);
    }

    @Override
    public void writeI64(long i64) throws IOException {
        this.writeJsonInteger(i64);
    }

    @Override
    public void writeDouble(double dub) throws IOException {
        this.writeJsonDouble(dub);
    }

    @Override
    public void writeString(@NotNull String str) throws IOException {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this.writeJsonString(StringsKt.encodeToByteArray((String)str));
    }

    @Override
    public void writeBinary(@NotNull ByteString buf) throws IOException {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        this.writeString(buf.base64());
    }

    private final ByteString readJsonString(boolean skipContext) throws IOException {
        byte ch;
        Buffer buffer = new Buffer();
        ArrayList<Character> codeunits = new ArrayList<Character>();
        if (!skipContext) {
            this.context.read();
        }
        this.readJsonSyntaxChar(QUOTE);
        while ((ch = this.reader.read()) != QUOTE[0]) {
            if (ch == ESCSEQ[0]) {
                ch = this.reader.read();
                if (ch == ESCSEQ[1]) {
                    this.transport.read(this.tmpbuf, 0, 4);
                    short cu = (short)((JsonProtocol.Companion.hexVal(this.tmpbuf[0]) << 12) + (JsonProtocol.Companion.hexVal(this.tmpbuf[1]) << 8) + (JsonProtocol.Companion.hexVal(this.tmpbuf[2]) << 4) + JsonProtocol.Companion.hexVal(this.tmpbuf[3]));
                    try {
                        char c = (char)cu;
                        boolean bl = false;
                        if (Character.isHighSurrogate(c)) {
                            if (codeunits.size() > 0) {
                                throw (Throwable)new ProtocolException("Expected low surrogate char");
                            }
                            codeunits.add(Character.valueOf((char)cu));
                            continue;
                        }
                        c = (char)cu;
                        bl = false;
                        if (Character.isLowSurrogate(c)) {
                            if (codeunits.size() == 0) {
                                throw (Throwable)new ProtocolException("Expected high surrogate char");
                            }
                            codeunits.add(Character.valueOf((char)cu));
                            byte[] bytes = StringsKt.encodeToByteArray((String)new Buffer().writeUtf8CodePoint((int)((Character)codeunits.get(0)).charValue()).writeUtf8CodePoint((int)((Character)codeunits.get(1)).charValue()).readUtf8());
                            buffer.write(bytes);
                            codeunits.clear();
                            continue;
                        }
                        byte[] bytes = StringsKt.encodeToByteArray((String)new Buffer().writeUtf8CodePoint((int)cu).readUtf8());
                        buffer.write(bytes);
                        continue;
                    }
                    catch (IOException ex) {
                        throw (Throwable)new ProtocolException("Invalid unicode sequence");
                    }
                }
                int off = StringsKt.indexOf$default((CharSequence)ESCAPE_CHARS, (char)((char)ch), (int)0, (boolean)false, (int)6, null);
                if (off == -1) {
                    throw (Throwable)new ProtocolException("Expected control char");
                }
                ch = ESCAPE_CHAR_VALS[off];
            }
            buffer.write(new byte[]{ch});
        }
        return buffer.readByteString();
    }

    private final boolean isJsonNumeric(byte b) {
        switch ((char)b) {
            case '+': 
            case '-': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'E': 
            case 'e': {
                return true;
            }
        }
        return false;
    }

    private final String readJsonNumericChars() throws IOException {
        byte ch;
        StringBuilder strbld = new StringBuilder();
        while (this.isJsonNumeric(ch = this.reader.peek())) {
            strbld.append((char)this.reader.read());
        }
        String string = strbld.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"strbld.toString()");
        return string;
    }

    private final long readJsonInteger() throws IOException {
        long l;
        this.context.read();
        if (this.context.escapeNum()) {
            this.readJsonSyntaxChar(QUOTE);
        }
        String str = this.readJsonNumericChars();
        if (this.context.escapeNum()) {
            this.readJsonSyntaxChar(QUOTE);
        }
        try {
            String string = str;
            boolean bl = false;
            l = Long.parseLong(string);
        }
        catch (NumberFormatException ex) {
            throw (Throwable)new ProtocolException("Bad data encountered in numeric data");
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    private final double readJsonDouble() throws IOException {
        double d;
        this.context.read();
        if (this.reader.peek() == QUOTE[0]) {
            void var2_7;
            ByteString str = this.readJsonString(true);
            String string = str.utf8();
            boolean bl = false;
            double dub = Double.parseDouble(string);
            if (!this.context.escapeNum()) {
                double d2 = dub;
                boolean bl2 = false;
                if (!Double.isNaN(d2)) {
                    d2 = dub;
                    bl2 = false;
                    if (!Double.isInfinite(d2)) {
                        throw (Throwable)new ProtocolException("Numeric data unexpectedly quoted");
                    }
                }
            }
            d = var2_7;
        } else {
            double d3;
            if (this.context.escapeNum()) {
                this.readJsonSyntaxChar(QUOTE);
            }
            try {
                String string = this.readJsonNumericChars();
                boolean bl = false;
                d3 = Double.parseDouble(string);
            }
            catch (NumberFormatException ex) {
                throw (Throwable)new ProtocolException("Bad data encountered in numeric data");
            }
            d = d3;
        }
        return d;
    }

    private final ByteString readJsonBase64() throws IOException {
        ByteString str = this.readJsonString(false);
        ByteString byteString = ByteString.Companion.decodeBase64(str.utf8());
        Intrinsics.checkNotNull((Object)byteString);
        return byteString;
    }

    private final void readJsonObjectStart() throws IOException {
        this.context.read();
        this.readJsonSyntaxChar(LBRACE);
        this.pushContext(new JsonPairContext());
    }

    private final void readJsonObjectEnd() throws IOException {
        this.readJsonSyntaxChar(RBRACE);
        this.popContext();
    }

    private final void readJsonArrayStart() throws IOException {
        this.context.read();
        this.readJsonSyntaxChar(LBRACKET);
        this.pushContext(new JsonListContext());
    }

    private final void readJsonArrayEnd() throws IOException {
        this.readJsonSyntaxChar(RBRACKET);
        this.popContext();
    }

    @Override
    @NotNull
    public MessageMetadata readMessageBegin() throws IOException {
        this.resetContext();
        this.readJsonArrayStart();
        if (this.readJsonInteger() != 1L) {
            throw (Throwable)new ProtocolException("Message contained bad version.");
        }
        String name = this.readJsonString(false).utf8();
        byte type = (byte)this.readJsonInteger();
        int seqid = (int)this.readJsonInteger();
        return new MessageMetadata(name, type, seqid);
    }

    @Override
    public void readMessageEnd() throws IOException {
        this.readJsonArrayEnd();
    }

    @Override
    @NotNull
    public StructMetadata readStructBegin() throws IOException {
        this.readJsonObjectStart();
        return new StructMetadata("");
    }

    @Override
    public void readStructEnd() throws IOException {
        this.readJsonObjectEnd();
    }

    @Override
    @NotNull
    public FieldMetadata readFieldBegin() throws IOException {
        byte ch = this.reader.peek();
        byte type = 0;
        short id = 0;
        if (ch == RBRACE[0]) {
            type = 0;
        } else {
            id = (short)this.readJsonInteger();
            this.readJsonObjectStart();
            type = JsonTypes.jsonToTtype(this.readJsonString(false).toByteArray());
        }
        return new FieldMetadata("", type, id);
    }

    @Override
    public void readFieldEnd() throws IOException {
        this.readJsonObjectEnd();
    }

    @Override
    @NotNull
    public MapMetadata readMapBegin() throws IOException {
        this.readJsonArrayStart();
        byte keyType = JsonTypes.jsonToTtype(this.readJsonString(false).toByteArray());
        byte valueType = JsonTypes.jsonToTtype(this.readJsonString(false).toByteArray());
        int size = (int)this.readJsonInteger();
        this.readJsonObjectStart();
        return new MapMetadata(keyType, valueType, size);
    }

    @Override
    public void readMapEnd() throws IOException {
        this.readJsonObjectEnd();
        this.readJsonArrayEnd();
    }

    @Override
    @NotNull
    public ListMetadata readListBegin() throws IOException {
        this.readJsonArrayStart();
        byte elemType = JsonTypes.jsonToTtype(this.readJsonString(false).toByteArray());
        int size = (int)this.readJsonInteger();
        return new ListMetadata(elemType, size);
    }

    @Override
    public void readListEnd() throws IOException {
        this.readJsonArrayEnd();
    }

    @Override
    @NotNull
    public SetMetadata readSetBegin() throws IOException {
        this.readJsonArrayStart();
        byte elemType = JsonTypes.jsonToTtype(this.readJsonString(false).toByteArray());
        int size = (int)this.readJsonInteger();
        return new SetMetadata(elemType, size);
    }

    @Override
    public void readSetEnd() throws IOException {
        this.readJsonArrayEnd();
    }

    @Override
    public boolean readBool() throws IOException {
        return this.readJsonInteger() != 0L;
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)this.readJsonInteger();
    }

    @Override
    public short readI16() throws IOException {
        return (short)this.readJsonInteger();
    }

    @Override
    public int readI32() throws IOException {
        return (int)this.readJsonInteger();
    }

    @Override
    public long readI64() throws IOException {
        return this.readJsonInteger();
    }

    @Override
    public double readDouble() throws IOException {
        return this.readJsonDouble();
    }

    @Override
    @NotNull
    public String readString() throws IOException {
        return this.readJsonString(false).utf8();
    }

    @Override
    @NotNull
    public ByteString readBinary() throws IOException {
        return this.readJsonBase64();
    }

    @JvmOverloads
    public JsonProtocol(@NotNull Transport transport2, boolean fieldNamesAsString) {
        Intrinsics.checkNotNullParameter((Object)transport2, (String)"transport");
        super(transport2);
        this.fieldNamesAsString = fieldNamesAsString;
        this.contextStack = new ArrayDeque();
        this.context = new JsonBaseContext();
        this.reader = new LookaheadReader();
        this.tmpbuf = new byte[4];
    }

    public /* synthetic */ JsonProtocol(Transport transport2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(transport2, bl);
    }

    @JvmOverloads
    public JsonProtocol(@NotNull Transport transport2) {
        this(transport2, false, 2, null);
    }

    static {
        Companion = new Companion(null);
        COMMA = new byte[]{(byte)44};
        COLON = new byte[]{(byte)58};
        LBRACE = new byte[]{(byte)123};
        RBRACE = new byte[]{(byte)125};
        LBRACKET = new byte[]{(byte)91};
        RBRACKET = new byte[]{(byte)93};
        QUOTE = new byte[]{(byte)34};
        BACKSLASH = new byte[]{(byte)92};
        ESCSEQ = new byte[]{(byte)92, (byte)117, (byte)48, (byte)48};
        JSON_CHAR_TABLE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, (byte)98, (byte)116, (byte)110, 0, (byte)102, (byte)114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, (byte)34, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        ESCAPE_CHAR_VALS = new byte[]{(byte)34, (byte)92, (byte)47, (byte)8, (byte)12, (byte)10, (byte)13, (byte)9};
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/microsoft/thrifty/protocol/JsonProtocol$LookaheadReader;", "", "(Lcom/microsoft/thrifty/protocol/JsonProtocol;)V", "data", "", "hasData", "", "peek", "", "read", "thrifty-runtime"})
    private final class LookaheadReader {
        private boolean hasData;
        private final byte[] data = new byte[1];

        public final byte read() throws IOException {
            if (this.hasData) {
                this.hasData = false;
            } else {
                JsonProtocol.this.transport.read(this.data, 0, 1);
            }
            return this.data[0];
        }

        public final byte peek() throws IOException {
            if (!this.hasData) {
                JsonProtocol.this.transport.read(this.data, 0, 1);
            }
            this.hasData = true;
            return this.data[0];
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u000b\n\u0002\u0010\u0005\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0007J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0010H\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/microsoft/thrifty/protocol/JsonProtocol$JsonTypes;", "", "()V", "BOOLEAN", "", "BYTE", "DOUBLE", "I16", "I32", "I64", "LIST", "MAP", "SET", "STRING", "STRUCT", "jsonToTtype", "", "jsonId", "ttypeToJson", "typeId", "thrifty-runtime"})
    private static final class JsonTypes {
        @JvmField
        @NotNull
        public static final byte[] BOOLEAN;
        @JvmField
        @NotNull
        public static final byte[] BYTE;
        @JvmField
        @NotNull
        public static final byte[] I16;
        @JvmField
        @NotNull
        public static final byte[] I32;
        @JvmField
        @NotNull
        public static final byte[] I64;
        @JvmField
        @NotNull
        public static final byte[] DOUBLE;
        @JvmField
        @NotNull
        public static final byte[] STRUCT;
        @JvmField
        @NotNull
        public static final byte[] STRING;
        @JvmField
        @NotNull
        public static final byte[] MAP;
        @JvmField
        @NotNull
        public static final byte[] LIST;
        @JvmField
        @NotNull
        public static final byte[] SET;
        @NotNull
        public static final JsonTypes INSTANCE;

        @JvmStatic
        @NotNull
        public static final byte[] ttypeToJson(byte typeId) {
            byte[] byArray;
            switch (typeId) {
                case 0: {
                    throw (Throwable)new IllegalArgumentException("Unexpected STOP type");
                }
                case 1: {
                    throw (Throwable)new IllegalArgumentException("Unexpected VOID type");
                }
                case 2: {
                    byArray = BOOLEAN;
                    break;
                }
                case 3: {
                    byArray = BYTE;
                    break;
                }
                case 4: {
                    byArray = DOUBLE;
                    break;
                }
                case 6: {
                    byArray = I16;
                    break;
                }
                case 8: {
                    byArray = I32;
                    break;
                }
                case 10: {
                    byArray = I64;
                    break;
                }
                case 11: {
                    byArray = STRING;
                    break;
                }
                case 12: {
                    byArray = STRUCT;
                    break;
                }
                case 13: {
                    byArray = MAP;
                    break;
                }
                case 14: {
                    byArray = SET;
                    break;
                }
                case 15: {
                    byArray = LIST;
                    break;
                }
                default: {
                    throw (Throwable)new IllegalArgumentException("Unknown TType ID: " + typeId);
                }
            }
            return byArray;
        }

        @JvmStatic
        public static final byte jsonToTtype(@NotNull byte[] jsonId) {
            Intrinsics.checkNotNullParameter((Object)jsonId, (String)"jsonId");
            int result = 0;
            if (jsonId.length > 1) {
                block0 : switch ((char)jsonId[0]) {
                    case 'd': {
                        result = 4;
                        break;
                    }
                    case 'i': {
                        switch ((char)jsonId[1]) {
                            case '8': {
                                result = 3;
                                break block0;
                            }
                            case '1': {
                                result = 6;
                                break block0;
                            }
                            case '3': {
                                result = 8;
                                break block0;
                            }
                            case '6': {
                                result = 10;
                                break block0;
                            }
                        }
                        break;
                    }
                    case 'l': {
                        result = 15;
                        break;
                    }
                    case 'm': {
                        result = 13;
                        break;
                    }
                    case 'r': {
                        result = 12;
                        break;
                    }
                    case 's': {
                        result = jsonId[1] == (byte)116 ? 11 : 14;
                        break;
                    }
                    case 't': {
                        result = 2;
                        break;
                    }
                }
            }
            boolean bl = result != 0;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                StringBuilder stringBuilder = new StringBuilder().append("Unknown json type ID: ");
                byte[] byArray = jsonId;
                boolean bl5 = false;
                String string = Arrays.toString(byArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.util.Arrays.toString(this)");
                String string2 = stringBuilder.append(string).toString();
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            return (byte)result;
        }

        private JsonTypes() {
        }

        static {
            JsonTypes jsonTypes;
            INSTANCE = jsonTypes = new JsonTypes();
            BOOLEAN = new byte[]{(byte)116, (byte)102};
            BYTE = new byte[]{(byte)105, (byte)56};
            I16 = new byte[]{(byte)105, (byte)49, (byte)54};
            I32 = new byte[]{(byte)105, (byte)51, (byte)50};
            I64 = new byte[]{(byte)105, (byte)54, (byte)52};
            DOUBLE = new byte[]{(byte)100, (byte)98, (byte)108};
            STRUCT = new byte[]{(byte)114, (byte)101, (byte)99};
            STRING = new byte[]{(byte)115, (byte)116, (byte)114};
            MAP = new byte[]{(byte)109, (byte)97, (byte)112};
            LIST = new byte[]{(byte)108, (byte)115, (byte)116};
            SET = new byte[]{(byte)115, (byte)101, (byte)116};
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0012\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/microsoft/thrifty/protocol/JsonProtocol$JsonBaseContext;", "", "()V", "escapeNum", "", "read", "", "write", "thrifty-runtime"})
    private static class JsonBaseContext {
        public void write() throws IOException {
        }

        public void read() throws IOException {
        }

        public boolean escapeNum() {
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/microsoft/thrifty/protocol/JsonProtocol$JsonListContext;", "Lcom/microsoft/thrifty/protocol/JsonProtocol$JsonBaseContext;", "(Lcom/microsoft/thrifty/protocol/JsonProtocol;)V", "first", "", "read", "", "write", "thrifty-runtime"})
    private final class JsonListContext
    extends JsonBaseContext {
        private boolean first = true;

        @Override
        public void write() throws IOException {
            if (this.first) {
                this.first = false;
            } else {
                JsonProtocol.this.transport.write(COMMA);
            }
        }

        @Override
        public void read() throws IOException {
            if (this.first) {
                this.first = false;
            } else {
                JsonProtocol.this.readJsonSyntaxChar(COMMA);
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0004H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/microsoft/thrifty/protocol/JsonProtocol$JsonPairContext;", "Lcom/microsoft/thrifty/protocol/JsonProtocol$JsonBaseContext;", "(Lcom/microsoft/thrifty/protocol/JsonProtocol;)V", "colon", "", "first", "escapeNum", "read", "", "write", "thrifty-runtime"})
    private final class JsonPairContext
    extends JsonBaseContext {
        private boolean first = true;
        private boolean colon = true;

        @Override
        public void write() throws IOException {
            if (this.first) {
                this.first = false;
                this.colon = true;
            } else {
                JsonProtocol.this.transport.write(this.colon ? COLON : COMMA);
                this.colon = !this.colon;
            }
        }

        @Override
        public void read() throws IOException {
            if (this.first) {
                this.first = false;
                this.colon = true;
            } else {
                JsonProtocol.this.readJsonSyntaxChar(this.colon ? COLON : COMMA);
                this.colon = !this.colon;
            }
        }

        @Override
        public boolean escapeNum() {
            return this.colon;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/microsoft/thrifty/protocol/JsonProtocol$Companion;", "", "()V", "BACKSLASH", "", "COLON", "COMMA", "ESCAPE_CHARS", "", "ESCAPE_CHAR_VALS", "ESCSEQ", "JSON_CHAR_TABLE", "LBRACE", "LBRACKET", "QUOTE", "RBRACE", "RBRACKET", "VERSION", "", "hexChar", "", "value", "hexVal", "ch", "thrifty-runtime"})
    public static final class Companion {
        private final byte hexVal(byte ch) throws IOException {
            byte by;
            if (ch >= (byte)48 && ch <= (byte)57) {
                by = (byte)((char)ch - 48);
            } else if (ch >= (byte)97 && ch <= (byte)102) {
                by = (byte)((char)ch - 97 + 10);
            } else {
                throw (Throwable)new ProtocolException("Expected hex character");
            }
            return by;
        }

        private final byte hexChar(byte value) {
            byte b = (byte)(value & 0xF);
            return b < 10 ? (byte)(b + 48) : (byte)(b - 10 + 97);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

