/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.thrifty.service;

import com.microsoft.thrifty.Struct;
import com.microsoft.thrifty.ThriftException;
import com.microsoft.thrifty.protocol.Protocol;
import com.microsoft.thrifty.service.ClientBase;
import com.microsoft.thrifty.service.MethodCall;
import com.microsoft.thrifty.service.ServiceMethodCallback;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u001b\u001cB\u0017\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u001e\u0010\u0014\u001a\u00020\u00112\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0014\u0010\u0018\u001a\u00020\u00112\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\rH\u0004J\u001c\u0010\u001a\u001a\u00020\u00112\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00060\u000fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/microsoft/thrifty/service/AsyncClientBase;", "Lcom/microsoft/thrifty/service/ClientBase;", "Ljava/io/Closeable;", "protocol", "Lcom/microsoft/thrifty/protocol/Protocol;", "listener", "Lcom/microsoft/thrifty/service/AsyncClientBase$Listener;", "(Lcom/microsoft/thrifty/protocol/Protocol;Lcom/microsoft/thrifty/service/AsyncClientBase$Listener;)V", "callbackExecutor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "pendingCalls", "Ljava/util/concurrent/BlockingQueue;", "Lcom/microsoft/thrifty/service/MethodCall;", "workerThread", "Lcom/microsoft/thrifty/service/AsyncClientBase$WorkerThread;", "close", "", "error", "", "complete", "call", "result", "", "enqueue", "methodCall", "fail", "Listener", "WorkerThread", "thrifty-runtime"})
public class AsyncClientBase
extends ClientBase
implements Closeable {
    private final ExecutorService callbackExecutor;
    private final BlockingQueue<MethodCall<?>> pendingCalls;
    private final WorkerThread workerThread;
    private final Listener listener;

    protected final void enqueue(@NotNull MethodCall<?> methodCall) {
        Intrinsics.checkNotNullParameter(methodCall, (String)"methodCall");
        boolean bl = this.getRunning().get();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Cannot write to a closed service client";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = this.pendingCalls.offer(methodCall);
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Call queue is full";
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    @Override
    public void close() throws IOException {
        this.close(null);
    }

    private final void close(Throwable error) {
        if (!this.getRunning().compareAndSet(true, false)) {
            return;
        }
        this.workerThread.interrupt();
        this.closeProtocol();
        if (!this.pendingCalls.isEmpty()) {
            boolean bl = false;
            List incompleteCalls = new ArrayList();
            this.pendingCalls.drainTo(incompleteCalls);
            CancellationException e = new CancellationException();
            for (MethodCall call : incompleteCalls) {
                try {
                    this.fail(call, e);
                }
                catch (Exception exception) {}
            }
        }
        this.callbackExecutor.execute(new Runnable(this, error){
            final /* synthetic */ AsyncClientBase this$0;
            final /* synthetic */ Throwable $error;

            public final void run() {
                if (this.$error != null) {
                    AsyncClientBase.access$getListener$p(this.this$0).onError(this.$error);
                } else {
                    AsyncClientBase.access$getListener$p(this.this$0).onTransportClosed();
                }
            }
            {
                this.this$0 = asyncClientBase;
                this.$error = throwable;
            }
        });
        try {
            this.callbackExecutor.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void complete(MethodCall<?> call, Object result) {
        this.callbackExecutor.execute(new Runnable(call, result){
            final /* synthetic */ MethodCall $call;
            final /* synthetic */ Object $result;

            public final void run() {
                ServiceMethodCallback<Object> serviceMethodCallback = this.$call.callback;
                if (serviceMethodCallback == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.microsoft.thrifty.service.ServiceMethodCallback<kotlin.Any?>");
                }
                serviceMethodCallback.onSuccess(this.$result);
            }
            {
                this.$call = methodCall;
                this.$result = object;
            }
        });
    }

    private final void fail(MethodCall<?> call, Throwable error) {
        this.callbackExecutor.execute(new Runnable(call, error){
            final /* synthetic */ MethodCall $call;
            final /* synthetic */ Throwable $error;

            public final void run() {
                ServiceMethodCallback<T> serviceMethodCallback = this.$call.callback;
                Intrinsics.checkNotNull(serviceMethodCallback);
                serviceMethodCallback.onError(this.$error);
            }
            {
                this.$call = methodCall;
                this.$error = throwable;
            }
        });
    }

    protected AsyncClientBase(@NotNull Protocol protocol, @NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        super(protocol);
        this.listener = listener;
        this.callbackExecutor = Executors.newSingleThreadExecutor();
        this.pendingCalls = new LinkedBlockingQueue();
        this.workerThread = new WorkerThread();
        this.workerThread.setDaemon(true);
        this.workerThread.start();
    }

    public static final /* synthetic */ Listener access$getListener$p(AsyncClientBase $this) {
        return $this.listener;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0003H&\u00a8\u0006\u0007"}, d2={"Lcom/microsoft/thrifty/service/AsyncClientBase$Listener;", "", "onError", "", "error", "", "onTransportClosed", "thrifty-runtime"})
    public static interface Listener {
        public void onTransportClosed();

        public void onError(@NotNull Throwable var1);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/microsoft/thrifty/service/AsyncClientBase$WorkerThread;", "Ljava/lang/Thread;", "(Lcom/microsoft/thrifty/service/AsyncClientBase;)V", "invokeRequest", "", "run", "thrifty-runtime"})
    private final class WorkerThread
    extends Thread {
        @Override
        public void run() {
            Throwable error = null;
            while (AsyncClientBase.this.getRunning().get()) {
                try {
                    this.invokeRequest();
                }
                catch (Throwable e) {
                    error = e;
                    break;
                }
            }
            try {
                AsyncClientBase.this.close(error);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private final void invokeRequest() throws ThriftException, IOException, InterruptedException {
            MethodCall call = (MethodCall)AsyncClientBase.this.pendingCalls.take();
            if (!AsyncClientBase.this.getRunning().get()) {
                MethodCall methodCall = call;
                Intrinsics.checkNotNullExpressionValue((Object)methodCall, (String)"call");
                AsyncClientBase.this.fail(methodCall, new CancellationException());
                return;
            }
            Object result = null;
            Exception error = null;
            try {
                MethodCall methodCall = call;
                Intrinsics.checkNotNullExpressionValue((Object)methodCall, (String)"call");
                result = AsyncClientBase.this.invokeRequest(methodCall);
            }
            catch (IOException e) {
                MethodCall methodCall = call;
                Intrinsics.checkNotNullExpressionValue((Object)methodCall, (String)"call");
                AsyncClientBase.this.fail(methodCall, e);
                throw (Throwable)e;
            }
            catch (RuntimeException e) {
                MethodCall methodCall = call;
                Intrinsics.checkNotNullExpressionValue((Object)methodCall, (String)"call");
                AsyncClientBase.this.fail(methodCall, e);
                throw (Throwable)e;
            }
            catch (ClientBase.ServerException e) {
                error = e.getThriftException();
            }
            catch (Exception e) {
                if (!(e instanceof Struct)) {
                    throw (Throwable)((Object)new AssertionError("Unexpected exception", e));
                }
                error = e;
            }
            try {
                if (error != null) {
                    MethodCall methodCall = call;
                    Intrinsics.checkNotNullExpressionValue((Object)methodCall, (String)"call");
                    AsyncClientBase.this.fail(methodCall, error);
                } else {
                    MethodCall methodCall = call;
                    Intrinsics.checkNotNullExpressionValue((Object)methodCall, (String)"call");
                    AsyncClientBase.this.complete(methodCall, result);
                }
            }
            catch (RejectedExecutionException e) {
                if (error != null) {
                    ServiceMethodCallback serviceMethodCallback = call.callback;
                    Intrinsics.checkNotNull(serviceMethodCallback);
                    serviceMethodCallback.onError(error);
                }
                ServiceMethodCallback<Object> serviceMethodCallback = call.callback;
                if (serviceMethodCallback == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.microsoft.thrifty.service.ServiceMethodCallback<kotlin.Any?>");
                }
                serviceMethodCallback.onSuccess(result);
            }
        }
    }
}

