/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.thrifty.service;

import com.microsoft.thrifty.Struct;
import com.microsoft.thrifty.ThriftException;
import com.microsoft.thrifty.protocol.MessageMetadata;
import com.microsoft.thrifty.protocol.Protocol;
import com.microsoft.thrifty.service.MethodCall;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00060\u0001j\u0002`\u0002:\u0001\u0017B\u000f\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0006\u0010\u0010\u001a\u00020\u000fJ\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0004J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00122\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00060\fj\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/microsoft/thrifty/service/ClientBase;", "Ljava/io/Closeable;", "Lokio/Closeable;", "protocol", "Lcom/microsoft/thrifty/protocol/Protocol;", "(Lcom/microsoft/thrifty/protocol/Protocol;)V", "running", "Ljava/util/concurrent/atomic/AtomicBoolean;", "Lcom/microsoft/thrifty/internal/AtomicBoolean;", "getRunning", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "seqId", "Ljava/util/concurrent/atomic/AtomicInteger;", "Lcom/microsoft/thrifty/internal/AtomicInteger;", "close", "", "closeProtocol", "execute", "", "methodCall", "Lcom/microsoft/thrifty/service/MethodCall;", "invokeRequest", "call", "ServerException", "thrifty-runtime"})
public class ClientBase
implements Closeable {
    private final AtomicInteger seqId;
    @NotNull
    private final AtomicBoolean running;
    private final Protocol protocol;

    @NotNull
    public final AtomicBoolean getRunning() {
        return this.running;
    }

    @Nullable
    protected final Object execute(@NotNull MethodCall<?> methodCall) throws Exception {
        Object object;
        Intrinsics.checkNotNullParameter(methodCall, (String)"methodCall");
        boolean bl = this.running.get();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Cannot write to a closed service client";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        try {
            object = this.invokeRequest(methodCall);
        }
        catch (ServerException e) {
            throw (Throwable)e.getThriftException();
        }
        return object;
    }

    @Override
    public void close() throws IOException {
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        this.closeProtocol();
    }

    public final void closeProtocol() {
        try {
            this.protocol.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Nullable
    public final Object invokeRequest(@NotNull MethodCall<?> call) throws Exception {
        Object obj;
        Intrinsics.checkNotNullParameter(call, (String)"call");
        boolean isOneWay = call.callTypeId == 4;
        int sid = this.seqId.incrementAndGet();
        this.protocol.writeMessageBegin(call.name, call.callTypeId, sid);
        call.send(this.protocol);
        this.protocol.writeMessageEnd();
        this.protocol.flush();
        if (isOneWay) {
            return Unit.INSTANCE;
        }
        MessageMetadata metadata = this.protocol.readMessageBegin();
        if (metadata.seqId != sid) {
            throw (Throwable)new ThriftException(ThriftException.Kind.BAD_SEQUENCE_ID, "Unrecognized sequence ID");
        }
        if (metadata.type == 3) {
            ThriftException e = ThriftException.Companion.read(this.protocol);
            this.protocol.readMessageEnd();
            throw (Throwable)new ServerException(e);
        }
        if (metadata.type != 2) {
            throw (Throwable)new ThriftException(ThriftException.Kind.INVALID_MESSAGE_TYPE, "Invalid message type: " + metadata.type);
        }
        if (metadata.seqId != this.seqId.get()) {
            throw (Throwable)new ThriftException(ThriftException.Kind.BAD_SEQUENCE_ID, "Out-of-order response");
        }
        if (Intrinsics.areEqual((Object)metadata.name, (Object)call.name) ^ true) {
            throw (Throwable)new ThriftException(ThriftException.Kind.WRONG_METHOD_NAME, "Unexpected method name in reply; expected " + call.name + " but received " + metadata.name);
        }
        try {
            Object result = call.receive(this.protocol, metadata);
            this.protocol.readMessageEnd();
            obj = result;
        }
        catch (Exception e) {
            if (e instanceof Struct) {
                this.protocol.readMessageEnd();
            }
            throw (Throwable)e;
        }
        return obj;
    }

    protected ClientBase(@NotNull Protocol protocol) {
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        this.protocol = protocol;
        this.seqId = new AtomicInteger(0);
        this.running = new AtomicBoolean(true);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/microsoft/thrifty/service/ClientBase$ServerException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "thriftException", "Lcom/microsoft/thrifty/ThriftException;", "(Lcom/microsoft/thrifty/ThriftException;)V", "getThriftException", "()Lcom/microsoft/thrifty/ThriftException;", "thrifty-runtime"})
    public static final class ServerException
    extends Exception {
        @NotNull
        private final ThriftException thriftException;

        @NotNull
        public final ThriftException getThriftException() {
            return this.thriftException;
        }

        public ServerException(@NotNull ThriftException thriftException) {
            Intrinsics.checkNotNullParameter((Object)thriftException, (String)"thriftException");
            this.thriftException = thriftException;
        }
    }
}

