/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.thrifty.transport;

import com.microsoft.thrifty.transport.Transport;
import java.io.EOFException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J \u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\b\u0010\u0010\u001a\u00020\tH\u0002J \u0010\u0011\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/microsoft/thrifty/transport/FramedTransport;", "Lcom/microsoft/thrifty/transport/Transport;", "inner", "(Lcom/microsoft/thrifty/transport/Transport;)V", "pendingWrite", "Lcom/microsoft/thrifty/transport/FramedTransport$SimpleBuffer;", "remainingBytes", "", "close", "", "flush", "read", "buffer", "", "offset", "count", "readHeader", "write", "SimpleBuffer", "thrifty-runtime"})
public final class FramedTransport
implements Transport {
    private int remainingBytes;
    private SimpleBuffer pendingWrite;
    private final Transport inner;

    @Override
    public void close() {
        this.inner.close();
        this.pendingWrite = null;
    }

    @Override
    public int read(@NotNull byte[] buffer, int offset, int count) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        while (this.remainingBytes <= 0) {
            this.readHeader();
        }
        int toRead = RangesKt.coerceAtMost((int)count, (int)this.remainingBytes);
        int numRead = this.inner.read(buffer, offset, toRead);
        this.remainingBytes -= numRead;
        return numRead;
    }

    private final void readHeader() {
        int n;
        byte[] headerBytes = new byte[4];
        for (int numRead = 0; numRead < headerBytes.length; numRead += n) {
            n = this.inner.read(headerBytes, numRead, headerBytes.length - numRead);
            if (n != -1) continue;
            throw (Throwable)new EOFException();
        }
        this.remainingBytes = (headerBytes[0] & 0xFF) << 24 | (headerBytes[1] & 0xFF) << 16 | (headerBytes[2] & 0xFF) << 8 | headerBytes[3] & 0xFF;
    }

    @Override
    public void write(@NotNull byte[] buffer, int offset, int count) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (this.pendingWrite == null) {
            this.pendingWrite = new SimpleBuffer(count);
        }
        SimpleBuffer simpleBuffer = this.pendingWrite;
        Intrinsics.checkNotNull((Object)simpleBuffer);
        simpleBuffer.write(buffer, offset, count);
    }

    @Override
    public void flush() {
        SimpleBuffer simpleBuffer = this.pendingWrite;
        if (simpleBuffer == null) {
            return;
        }
        SimpleBuffer write = simpleBuffer;
        int size = write.getSize();
        if (size == 0) {
            return;
        }
        byte[] headerBytes = new byte[]{(byte)(size >> 24 & 0xFF), (byte)(size >> 16 & 0xFF), (byte)(size >> 8 & 0xFF), (byte)(size & 0xFF)};
        this.inner.write(headerBytes);
        this.inner.write(write.getBuf(), 0, size);
        write.reset();
    }

    public FramedTransport(@NotNull Transport inner) {
        Intrinsics.checkNotNullParameter((Object)inner, (String)"inner");
        this.inner = inner;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0006\u0010\u0011\u001a\u00020\u0012J\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u0004\u00a8\u0006\u0016"}, d2={"Lcom/microsoft/thrifty/transport/FramedTransport$SimpleBuffer;", "", "count", "", "(I)V", "buf", "", "getBuf", "()[B", "setBuf", "([B)V", "size", "getSize", "()I", "setSize", "nextPowerOfTwo", "num", "reset", "", "write", "buffer", "offset", "thrifty-runtime"})
    private static final class SimpleBuffer {
        @NotNull
        private byte[] buf;
        private int size;

        @NotNull
        public final byte[] getBuf() {
            return this.buf;
        }

        public final void setBuf(@NotNull byte[] byArray) {
            Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
            this.buf = byArray;
        }

        public final int getSize() {
            return this.size;
        }

        public final void setSize(int n) {
            this.size = n;
        }

        public final void write(@NotNull byte[] buffer, int offset, int count) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            if (this.size + count > this.buf.length) {
                byte[] byArray = this.buf;
                int n = this.nextPowerOfTwo(this.size + count);
                boolean bl = false;
                byte[] byArray2 = Arrays.copyOf(byArray, n);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
                this.buf = byArray2;
            }
            ArraysKt.copyInto((byte[])buffer, (byte[])this.buf, (int)this.size, (int)offset, (int)(offset + count));
            this.size += count;
        }

        public final void reset() {
            this.buf = new byte[32];
            this.size = 0;
        }

        private final int nextPowerOfTwo(int num) {
            int n = num - 1;
            n |= n >>> 1;
            n |= n >>> 2;
            n |= n >>> 4;
            n |= n >>> 8;
            n |= n >>> 16;
            return n + 1;
        }

        public SimpleBuffer(int count) {
            this.buf = new byte[RangesKt.coerceAtLeast((int)count, (int)32)];
        }

        public /* synthetic */ SimpleBuffer(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 32;
            }
            this(n);
        }

        public SimpleBuffer() {
            this(0, 1, null);
        }
    }
}

