/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.management.sql;

import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.sql.DacOperations;
import com.microsoft.windowsazure.management.sql.SqlManagementClientImpl;
import com.microsoft.windowsazure.management.sql.models.DacExportParameters;
import com.microsoft.windowsazure.management.sql.models.DacGetStatusResponse;
import com.microsoft.windowsazure.management.sql.models.DacImportExportResponse;
import com.microsoft.windowsazure.management.sql.models.DacImportParameters;
import com.microsoft.windowsazure.management.sql.models.StatusInfo;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DacOperationsImpl
implements ServiceOperations<SqlManagementClientImpl>,
DacOperations {
    private SqlManagementClientImpl client;

    DacOperationsImpl(SqlManagementClientImpl client) {
        this.client = client;
    }

    public SqlManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<DacImportExportResponse> exportDatabaseAsync(final String serverName, final DacExportParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<DacImportExportResponse>(){

            @Override
            public DacImportExportResponse call() throws Exception {
                return DacOperationsImpl.this.exportDatabase(serverName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DacImportExportResponse exportDatabase(String serverName, DacExportParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (parameters != null) {
            if (parameters.getBlobCredentials() != null) {
                if (parameters.getBlobCredentials().getStorageAccessKey() == null) {
                    throw new NullPointerException("parameters.BlobCredentials.StorageAccessKey");
                }
                if (parameters.getBlobCredentials().getUri() == null) {
                    throw new NullPointerException("parameters.BlobCredentials.Uri");
                }
            }
            if (parameters.getConnectionInfo() != null) {
                if (parameters.getConnectionInfo().getDatabaseName() == null) {
                    throw new NullPointerException("parameters.ConnectionInfo.DatabaseName");
                }
                if (parameters.getConnectionInfo().getPassword() == null) {
                    throw new NullPointerException("parameters.ConnectionInfo.Password");
                }
                if (parameters.getConnectionInfo().getServerName() == null) {
                    throw new NullPointerException("parameters.ConnectionInfo.ServerName");
                }
                if (parameters.getConnectionInfo().getUserName() == null) {
                    throw new NullPointerException("parameters.ConnectionInfo.UserName");
                }
            }
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"exportDatabaseAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/services/sqlservers/servers/" + serverName.trim() + "/DacOperations/Export";
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        if (parameters != null) {
            Element exportInputElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "ExportInput");
            requestDoc.appendChild(exportInputElement);
            if (parameters.getBlobCredentials() != null) {
                Element blobCredentialsElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "BlobCredentials");
                exportInputElement.appendChild(blobCredentialsElement);
                Attr typeAttribute = requestDoc.createAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
                typeAttribute.setValue("BlobStorageAccessKeyCredentials");
                blobCredentialsElement.setAttributeNode(typeAttribute);
                Element uriElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "Uri");
                uriElement.appendChild(requestDoc.createTextNode(parameters.getBlobCredentials().getUri().toString()));
                blobCredentialsElement.appendChild(uriElement);
                Element storageAccessKeyElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "StorageAccessKey");
                storageAccessKeyElement.appendChild(requestDoc.createTextNode(parameters.getBlobCredentials().getStorageAccessKey()));
                blobCredentialsElement.appendChild(storageAccessKeyElement);
            }
            if (parameters.getConnectionInfo() != null) {
                Element connectionInfoElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "ConnectionInfo");
                exportInputElement.appendChild(connectionInfoElement);
                Element databaseNameElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "DatabaseName");
                databaseNameElement.appendChild(requestDoc.createTextNode(parameters.getConnectionInfo().getDatabaseName()));
                connectionInfoElement.appendChild(databaseNameElement);
                Element passwordElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "Password");
                passwordElement.appendChild(requestDoc.createTextNode(parameters.getConnectionInfo().getPassword()));
                connectionInfoElement.appendChild(passwordElement);
                Element serverNameElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "ServerName");
                serverNameElement.appendChild(requestDoc.createTextNode(parameters.getConnectionInfo().getServerName()));
                connectionInfoElement.appendChild(serverNameElement);
                Element userNameElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "UserName");
                userNameElement.appendChild(requestDoc.createTextNode(parameters.getConnectionInfo().getUserName()));
                connectionInfoElement.appendChild(userNameElement);
            }
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            DacImportExportResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new DacImportExportResponse();
            DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
            documentBuilderFactory2.setNamespaceAware(true);
            DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
            Document responseDoc = documentBuilder2.parse((InputStream)new BOMInputStream(responseContent));
            Element guidElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/2003/10/Serialization/", (String)"guid");
            if (guidElement != null) {
                result.setGuid(guidElement.getTextContent());
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            DacImportExportResponse dacImportExportResponse = result;
            return dacImportExportResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<DacGetStatusResponse> getStatusAsync(final String serverName, final String fullyQualifiedServerName, final String username, final String password, final String requestId) {
        return this.getClient().getExecutorService().submit(new Callable<DacGetStatusResponse>(){

            @Override
            public DacGetStatusResponse call() throws Exception {
                return DacOperationsImpl.this.getStatus(serverName, fullyQualifiedServerName, username, password, requestId);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DacGetStatusResponse getStatus(String serverName, String fullyQualifiedServerName, String username, String password, String requestId) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (fullyQualifiedServerName == null) {
            throw new NullPointerException("fullyQualifiedServerName");
        }
        if (username == null) {
            throw new NullPointerException("username");
        }
        if (password == null) {
            throw new NullPointerException("password");
        }
        if (requestId == null) {
            throw new NullPointerException("requestId");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("fullyQualifiedServerName", fullyQualifiedServerName);
            tracingParameters.put("username", username);
            tracingParameters.put("password", password);
            tracingParameters.put("requestId", requestId);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getStatusAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/services/sqlservers/servers/" + serverName.trim() + "/DacOperations/Status" + "?";
        url = url + "servername=" + URLEncoder.encode(fullyQualifiedServerName.trim(), "UTF-8");
        url = url + "&" + "username=" + URLEncoder.encode(username.trim(), "UTF-8");
        url = url + "&" + "password=" + URLEncoder.encode(password.trim(), "UTF-8");
        url = url + "&" + "reqId=" + URLEncoder.encode(requestId.trim(), "UTF-8");
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            DacGetStatusResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new DacGetStatusResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element arrayOfStatusInfoElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"ArrayOfStatusInfo");
            if (arrayOfStatusInfoElement != null && arrayOfStatusInfoElement != null) {
                for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)arrayOfStatusInfoElement, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"StatusInfo").size(); ++i1) {
                    Element statusElement;
                    Element serverNameElement;
                    Element requestTypeElement;
                    Element requestIdElement;
                    Element queuedTimeElement;
                    Element lastModifiedTimeElement;
                    Element errorMessageElement;
                    Element databaseNameElement;
                    Element statusInfoElement = (Element)XmlUtility.getElementsByTagNameNS((Node)arrayOfStatusInfoElement, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"StatusInfo").get(i1);
                    StatusInfo statusInfoInstance = new StatusInfo();
                    result.getStatusInfoList().add(statusInfoInstance);
                    Element blobUriElement = XmlUtility.getElementByTagNameNS((Node)statusInfoElement, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"BlobUri");
                    if (blobUriElement != null) {
                        URI blobUriInstance = new URI(blobUriElement.getTextContent());
                        statusInfoInstance.setBlobUri(blobUriInstance);
                    }
                    if ((databaseNameElement = XmlUtility.getElementByTagNameNS((Node)statusInfoElement, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"DatabaseName")) != null) {
                        String databaseNameInstance = databaseNameElement.getTextContent();
                        statusInfoInstance.setDatabaseName(databaseNameInstance);
                    }
                    if ((errorMessageElement = XmlUtility.getElementByTagNameNS((Node)statusInfoElement, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"ErrorMessage")) != null) {
                        boolean isNil = false;
                        Attr nilAttribute = errorMessageElement.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "nil");
                        if (nilAttribute != null) {
                            isNil = "true".equals(nilAttribute.getValue());
                        }
                        if (!isNil) {
                            String errorMessageInstance = errorMessageElement.getTextContent();
                            statusInfoInstance.setErrorMessage(errorMessageInstance);
                        }
                    }
                    if ((lastModifiedTimeElement = XmlUtility.getElementByTagNameNS((Node)statusInfoElement, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"LastModifiedTime")) != null) {
                        Calendar lastModifiedTimeInstance = DatatypeConverter.parseDateTime((String)lastModifiedTimeElement.getTextContent());
                        statusInfoInstance.setLastModifiedTime(lastModifiedTimeInstance);
                    }
                    if ((queuedTimeElement = XmlUtility.getElementByTagNameNS((Node)statusInfoElement, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"QueuedTime")) != null) {
                        Calendar queuedTimeInstance = DatatypeConverter.parseDateTime((String)queuedTimeElement.getTextContent());
                        statusInfoInstance.setQueuedTime(queuedTimeInstance);
                    }
                    if ((requestIdElement = XmlUtility.getElementByTagNameNS((Node)statusInfoElement, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"RequestId")) != null) {
                        String requestIdInstance = requestIdElement.getTextContent();
                        statusInfoInstance.setRequestId(requestIdInstance);
                    }
                    if ((requestTypeElement = XmlUtility.getElementByTagNameNS((Node)statusInfoElement, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"RequestType")) != null) {
                        String requestTypeInstance = requestTypeElement.getTextContent();
                        statusInfoInstance.setRequestType(requestTypeInstance);
                    }
                    if ((serverNameElement = XmlUtility.getElementByTagNameNS((Node)statusInfoElement, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"ServerName")) != null) {
                        String serverNameInstance = serverNameElement.getTextContent();
                        statusInfoInstance.setServerName(serverNameInstance);
                    }
                    if ((statusElement = XmlUtility.getElementByTagNameNS((Node)statusInfoElement, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"Status")) == null) continue;
                    String statusInstance = statusElement.getTextContent();
                    statusInfoInstance.setStatus(statusInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            DacGetStatusResponse dacGetStatusResponse = result;
            return dacGetStatusResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<DacImportExportResponse> importDatabaseAsync(final String serverName, final DacImportParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<DacImportExportResponse>(){

            @Override
            public DacImportExportResponse call() throws Exception {
                return DacOperationsImpl.this.importDatabase(serverName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DacImportExportResponse importDatabase(String serverName, DacImportParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (parameters != null) {
            if (parameters.getBlobCredentials() != null) {
                if (parameters.getBlobCredentials().getStorageAccessKey() == null) {
                    throw new NullPointerException("parameters.BlobCredentials.StorageAccessKey");
                }
                if (parameters.getBlobCredentials().getUri() == null) {
                    throw new NullPointerException("parameters.BlobCredentials.Uri");
                }
            }
            if (parameters.getConnectionInfo() != null) {
                if (parameters.getConnectionInfo().getDatabaseName() == null) {
                    throw new NullPointerException("parameters.ConnectionInfo.DatabaseName");
                }
                if (parameters.getConnectionInfo().getPassword() == null) {
                    throw new NullPointerException("parameters.ConnectionInfo.Password");
                }
                if (parameters.getConnectionInfo().getServerName() == null) {
                    throw new NullPointerException("parameters.ConnectionInfo.ServerName");
                }
                if (parameters.getConnectionInfo().getUserName() == null) {
                    throw new NullPointerException("parameters.ConnectionInfo.UserName");
                }
            }
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"importDatabaseAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/services/sqlservers/servers/" + serverName.trim() + "/DacOperations/Import";
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        if (parameters != null) {
            Element importInputElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "ImportInput");
            requestDoc.appendChild(importInputElement);
            if (parameters.getAzureEdition() != null) {
                Element azureEditionElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "AzureEdition");
                azureEditionElement.appendChild(requestDoc.createTextNode(parameters.getAzureEdition()));
                importInputElement.appendChild(azureEditionElement);
            }
            if (parameters.getBlobCredentials() != null) {
                Element blobCredentialsElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "BlobCredentials");
                importInputElement.appendChild(blobCredentialsElement);
                Attr typeAttribute = requestDoc.createAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
                typeAttribute.setValue("BlobStorageAccessKeyCredentials");
                blobCredentialsElement.setAttributeNode(typeAttribute);
                Element uriElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "Uri");
                uriElement.appendChild(requestDoc.createTextNode(parameters.getBlobCredentials().getUri().toString()));
                blobCredentialsElement.appendChild(uriElement);
                Element storageAccessKeyElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "StorageAccessKey");
                storageAccessKeyElement.appendChild(requestDoc.createTextNode(parameters.getBlobCredentials().getStorageAccessKey()));
                blobCredentialsElement.appendChild(storageAccessKeyElement);
            }
            if (parameters.getConnectionInfo() != null) {
                Element connectionInfoElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "ConnectionInfo");
                importInputElement.appendChild(connectionInfoElement);
                Element databaseNameElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "DatabaseName");
                databaseNameElement.appendChild(requestDoc.createTextNode(parameters.getConnectionInfo().getDatabaseName()));
                connectionInfoElement.appendChild(databaseNameElement);
                Element passwordElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "Password");
                passwordElement.appendChild(requestDoc.createTextNode(parameters.getConnectionInfo().getPassword()));
                connectionInfoElement.appendChild(passwordElement);
                Element serverNameElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "ServerName");
                serverNameElement.appendChild(requestDoc.createTextNode(parameters.getConnectionInfo().getServerName()));
                connectionInfoElement.appendChild(serverNameElement);
                Element userNameElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "UserName");
                userNameElement.appendChild(requestDoc.createTextNode(parameters.getConnectionInfo().getUserName()));
                connectionInfoElement.appendChild(userNameElement);
            }
            Element databaseSizeInGBElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "DatabaseSizeInGB");
            databaseSizeInGBElement.appendChild(requestDoc.createTextNode(Integer.toString(parameters.getDatabaseSizeInGB())));
            importInputElement.appendChild(databaseSizeInGBElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            DacImportExportResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new DacImportExportResponse();
            DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
            documentBuilderFactory2.setNamespaceAware(true);
            DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
            Document responseDoc = documentBuilder2.parse((InputStream)new BOMInputStream(responseContent));
            Element guidElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/2003/10/Serialization/", (String)"guid");
            if (guidElement != null) {
                result.setGuid(guidElement.getTextContent());
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            DacImportExportResponse dacImportExportResponse = result;
            return dacImportExportResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

