/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.management.sql;

import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.sql.DatabaseOperationOperations;
import com.microsoft.windowsazure.management.sql.SqlManagementClientImpl;
import com.microsoft.windowsazure.management.sql.models.DatabaseOperation;
import com.microsoft.windowsazure.management.sql.models.DatabaseOperationGetResponse;
import com.microsoft.windowsazure.management.sql.models.DatabaseOperationListResponse;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DatabaseOperationOperationsImpl
implements ServiceOperations<SqlManagementClientImpl>,
DatabaseOperationOperations {
    private SqlManagementClientImpl client;

    DatabaseOperationOperationsImpl(SqlManagementClientImpl client) {
        this.client = client;
    }

    public SqlManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<DatabaseOperationGetResponse> getAsync(final String serverName, final String operationGuid) {
        return this.getClient().getExecutorService().submit(new Callable<DatabaseOperationGetResponse>(){

            @Override
            public DatabaseOperationGetResponse call() throws Exception {
                return DatabaseOperationOperationsImpl.this.get(serverName, operationGuid);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseOperationGetResponse get(String serverName, String operationGuid) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (operationGuid == null) {
            throw new NullPointerException("operationGuid");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("operationGuid", operationGuid);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = this.getClient().getCredentials().getSubscriptionId().trim() + "/services/sqlservers/servers/" + serverName.trim() + "/databaseoperations/" + operationGuid.trim();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            DatabaseOperationGetResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new DatabaseOperationGetResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element serviceResourceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource");
            if (serviceResourceElement != null) {
                Element lastModifyTimeElement;
                Element startTimeElement;
                Element errorStateElement;
                Element errorSeverityElement;
                Element errorElement;
                Element errorCodeElement;
                Element percentCompleteElement;
                Element databaseNameElement;
                Element sessionActivityIdElement;
                Element stateIdElement;
                Element idElement;
                Element parentLinkElement;
                Element selfLinkElement;
                Element stateElement;
                Element typeElement;
                DatabaseOperation serviceResourceInstance = new DatabaseOperation();
                result.setDatabaseOperation(serviceResourceInstance);
                Element nameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                if (nameElement != null) {
                    String nameInstance = nameElement.getTextContent();
                    serviceResourceInstance.setName(nameInstance);
                }
                if ((typeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type")) != null) {
                    String typeInstance = typeElement.getTextContent();
                    serviceResourceInstance.setType(typeInstance);
                }
                if ((stateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"State")) != null) {
                    String stateInstance = stateElement.getTextContent();
                    serviceResourceInstance.setState(stateInstance);
                }
                if ((selfLinkElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SelfLink")) != null) {
                    String selfLinkInstance = selfLinkElement.getTextContent();
                    serviceResourceInstance.setSelfLink(selfLinkInstance);
                }
                if ((parentLinkElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ParentLink")) != null) {
                    String parentLinkInstance = parentLinkElement.getTextContent();
                    serviceResourceInstance.setParentLink(parentLinkInstance);
                }
                if ((idElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Id")) != null) {
                    String idInstance = idElement.getTextContent();
                    serviceResourceInstance.setId(idInstance);
                }
                if ((stateIdElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StateId")) != null) {
                    int stateIdInstance = DatatypeConverter.parseInt((String)stateIdElement.getTextContent());
                    serviceResourceInstance.setStateId(stateIdInstance);
                }
                if ((sessionActivityIdElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SessionActivityId")) != null) {
                    String sessionActivityIdInstance = sessionActivityIdElement.getTextContent();
                    serviceResourceInstance.setSessionActivityId(sessionActivityIdInstance);
                }
                if ((databaseNameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DatabaseName")) != null) {
                    String databaseNameInstance = databaseNameElement.getTextContent();
                    serviceResourceInstance.setDatabaseName(databaseNameInstance);
                }
                if ((percentCompleteElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PercentComplete")) != null) {
                    int percentCompleteInstance = DatatypeConverter.parseInt((String)percentCompleteElement.getTextContent());
                    serviceResourceInstance.setPercentComplete(percentCompleteInstance);
                }
                if ((errorCodeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ErrorCode")) != null) {
                    int errorCodeInstance = DatatypeConverter.parseInt((String)errorCodeElement.getTextContent());
                    serviceResourceInstance.setErrorCode(errorCodeInstance);
                }
                if ((errorElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Error")) != null) {
                    String errorInstance = errorElement.getTextContent();
                    serviceResourceInstance.setError(errorInstance);
                }
                if ((errorSeverityElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ErrorSeverity")) != null) {
                    int errorSeverityInstance = DatatypeConverter.parseInt((String)errorSeverityElement.getTextContent());
                    serviceResourceInstance.setErrorSeverity(errorSeverityInstance);
                }
                if ((errorStateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ErrorState")) != null) {
                    int errorStateInstance = DatatypeConverter.parseInt((String)errorStateElement.getTextContent());
                    serviceResourceInstance.setErrorState(errorStateInstance);
                }
                if ((startTimeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StartTime")) != null) {
                    Calendar startTimeInstance = DatatypeConverter.parseDateTime((String)startTimeElement.getTextContent());
                    serviceResourceInstance.setStartTime(startTimeInstance);
                }
                if ((lastModifyTimeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LastModifyTime")) != null) {
                    Calendar lastModifyTimeInstance = DatatypeConverter.parseDateTime((String)lastModifyTimeElement.getTextContent());
                    serviceResourceInstance.setLastModifyTime(lastModifyTimeInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            DatabaseOperationGetResponse databaseOperationGetResponse = result;
            return databaseOperationGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<DatabaseOperationListResponse> listByDatabaseAsync(final String serverName, final String databaseName) {
        return this.getClient().getExecutorService().submit(new Callable<DatabaseOperationListResponse>(){

            @Override
            public DatabaseOperationListResponse call() throws Exception {
                return DatabaseOperationOperationsImpl.this.listByDatabase(serverName, databaseName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseOperationListResponse listByDatabase(String serverName, String databaseName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listByDatabaseAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = this.getClient().getCredentials().getSubscriptionId().trim() + "/services/sqlservers/servers/" + serverName.trim() + "/databaseoperations" + "?";
        url = url + "databaseName=" + URLEncoder.encode(databaseName.trim(), "UTF-8");
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            DatabaseOperationListResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new DatabaseOperationListResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element serviceResourcesSequenceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResources");
            if (serviceResourcesSequenceElement != null) {
                for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)serviceResourcesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource").size(); ++i1) {
                    Element lastModifyTimeElement;
                    Element startTimeElement;
                    Element errorStateElement;
                    Element errorSeverityElement;
                    Element errorElement;
                    Element errorCodeElement;
                    Element percentCompleteElement;
                    Element databaseNameElement;
                    Element sessionActivityIdElement;
                    Element stateIdElement;
                    Element idElement;
                    Element parentLinkElement;
                    Element selfLinkElement;
                    Element stateElement;
                    Element typeElement;
                    Element serviceResourcesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)serviceResourcesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource").get(i1);
                    DatabaseOperation serviceResourceInstance = new DatabaseOperation();
                    result.getDatabaseOperations().add(serviceResourceInstance);
                    Element nameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                    if (nameElement != null) {
                        String nameInstance = nameElement.getTextContent();
                        serviceResourceInstance.setName(nameInstance);
                    }
                    if ((typeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type")) != null) {
                        String typeInstance = typeElement.getTextContent();
                        serviceResourceInstance.setType(typeInstance);
                    }
                    if ((stateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"State")) != null) {
                        String stateInstance = stateElement.getTextContent();
                        serviceResourceInstance.setState(stateInstance);
                    }
                    if ((selfLinkElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SelfLink")) != null) {
                        String selfLinkInstance = selfLinkElement.getTextContent();
                        serviceResourceInstance.setSelfLink(selfLinkInstance);
                    }
                    if ((parentLinkElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ParentLink")) != null) {
                        String parentLinkInstance = parentLinkElement.getTextContent();
                        serviceResourceInstance.setParentLink(parentLinkInstance);
                    }
                    if ((idElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Id")) != null) {
                        String idInstance = idElement.getTextContent();
                        serviceResourceInstance.setId(idInstance);
                    }
                    if ((stateIdElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StateId")) != null) {
                        int stateIdInstance = DatatypeConverter.parseInt((String)stateIdElement.getTextContent());
                        serviceResourceInstance.setStateId(stateIdInstance);
                    }
                    if ((sessionActivityIdElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SessionActivityId")) != null) {
                        String sessionActivityIdInstance = sessionActivityIdElement.getTextContent();
                        serviceResourceInstance.setSessionActivityId(sessionActivityIdInstance);
                    }
                    if ((databaseNameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DatabaseName")) != null) {
                        String databaseNameInstance = databaseNameElement.getTextContent();
                        serviceResourceInstance.setDatabaseName(databaseNameInstance);
                    }
                    if ((percentCompleteElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PercentComplete")) != null) {
                        int percentCompleteInstance = DatatypeConverter.parseInt((String)percentCompleteElement.getTextContent());
                        serviceResourceInstance.setPercentComplete(percentCompleteInstance);
                    }
                    if ((errorCodeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ErrorCode")) != null) {
                        int errorCodeInstance = DatatypeConverter.parseInt((String)errorCodeElement.getTextContent());
                        serviceResourceInstance.setErrorCode(errorCodeInstance);
                    }
                    if ((errorElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Error")) != null) {
                        String errorInstance = errorElement.getTextContent();
                        serviceResourceInstance.setError(errorInstance);
                    }
                    if ((errorSeverityElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ErrorSeverity")) != null) {
                        int errorSeverityInstance = DatatypeConverter.parseInt((String)errorSeverityElement.getTextContent());
                        serviceResourceInstance.setErrorSeverity(errorSeverityInstance);
                    }
                    if ((errorStateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ErrorState")) != null) {
                        int errorStateInstance = DatatypeConverter.parseInt((String)errorStateElement.getTextContent());
                        serviceResourceInstance.setErrorState(errorStateInstance);
                    }
                    if ((startTimeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StartTime")) != null) {
                        Calendar startTimeInstance = DatatypeConverter.parseDateTime((String)startTimeElement.getTextContent());
                        serviceResourceInstance.setStartTime(startTimeInstance);
                    }
                    if ((lastModifyTimeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LastModifyTime")) == null) continue;
                    Calendar lastModifyTimeInstance = DatatypeConverter.parseDateTime((String)lastModifyTimeElement.getTextContent());
                    serviceResourceInstance.setLastModifyTime(lastModifyTimeInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            DatabaseOperationListResponse databaseOperationListResponse = result;
            return databaseOperationListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<DatabaseOperationListResponse> listByServerAsync(final String serverName) {
        return this.getClient().getExecutorService().submit(new Callable<DatabaseOperationListResponse>(){

            @Override
            public DatabaseOperationListResponse call() throws Exception {
                return DatabaseOperationOperationsImpl.this.listByServer(serverName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseOperationListResponse listByServer(String serverName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serverName", serverName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listByServerAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = this.getClient().getCredentials().getSubscriptionId().trim() + "/services/sqlservers/servers/" + serverName.trim() + "/databaseoperations" + "?" + "contentview=generic";
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            DatabaseOperationListResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new DatabaseOperationListResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element serviceResourcesSequenceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResources");
            if (serviceResourcesSequenceElement != null) {
                for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)serviceResourcesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource").size(); ++i1) {
                    Element lastModifyTimeElement;
                    Element startTimeElement;
                    Element errorStateElement;
                    Element errorSeverityElement;
                    Element errorElement;
                    Element errorCodeElement;
                    Element percentCompleteElement;
                    Element databaseNameElement;
                    Element sessionActivityIdElement;
                    Element stateIdElement;
                    Element idElement;
                    Element parentLinkElement;
                    Element selfLinkElement;
                    Element stateElement;
                    Element typeElement;
                    Element serviceResourcesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)serviceResourcesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource").get(i1);
                    DatabaseOperation serviceResourceInstance = new DatabaseOperation();
                    result.getDatabaseOperations().add(serviceResourceInstance);
                    Element nameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                    if (nameElement != null) {
                        String nameInstance = nameElement.getTextContent();
                        serviceResourceInstance.setName(nameInstance);
                    }
                    if ((typeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type")) != null) {
                        String typeInstance = typeElement.getTextContent();
                        serviceResourceInstance.setType(typeInstance);
                    }
                    if ((stateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"State")) != null) {
                        String stateInstance = stateElement.getTextContent();
                        serviceResourceInstance.setState(stateInstance);
                    }
                    if ((selfLinkElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SelfLink")) != null) {
                        String selfLinkInstance = selfLinkElement.getTextContent();
                        serviceResourceInstance.setSelfLink(selfLinkInstance);
                    }
                    if ((parentLinkElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ParentLink")) != null) {
                        String parentLinkInstance = parentLinkElement.getTextContent();
                        serviceResourceInstance.setParentLink(parentLinkInstance);
                    }
                    if ((idElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Id")) != null) {
                        String idInstance = idElement.getTextContent();
                        serviceResourceInstance.setId(idInstance);
                    }
                    if ((stateIdElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StateId")) != null) {
                        int stateIdInstance = DatatypeConverter.parseInt((String)stateIdElement.getTextContent());
                        serviceResourceInstance.setStateId(stateIdInstance);
                    }
                    if ((sessionActivityIdElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SessionActivityId")) != null) {
                        String sessionActivityIdInstance = sessionActivityIdElement.getTextContent();
                        serviceResourceInstance.setSessionActivityId(sessionActivityIdInstance);
                    }
                    if ((databaseNameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DatabaseName")) != null) {
                        String databaseNameInstance = databaseNameElement.getTextContent();
                        serviceResourceInstance.setDatabaseName(databaseNameInstance);
                    }
                    if ((percentCompleteElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PercentComplete")) != null) {
                        int percentCompleteInstance = DatatypeConverter.parseInt((String)percentCompleteElement.getTextContent());
                        serviceResourceInstance.setPercentComplete(percentCompleteInstance);
                    }
                    if ((errorCodeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ErrorCode")) != null) {
                        int errorCodeInstance = DatatypeConverter.parseInt((String)errorCodeElement.getTextContent());
                        serviceResourceInstance.setErrorCode(errorCodeInstance);
                    }
                    if ((errorElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Error")) != null) {
                        String errorInstance = errorElement.getTextContent();
                        serviceResourceInstance.setError(errorInstance);
                    }
                    if ((errorSeverityElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ErrorSeverity")) != null) {
                        int errorSeverityInstance = DatatypeConverter.parseInt((String)errorSeverityElement.getTextContent());
                        serviceResourceInstance.setErrorSeverity(errorSeverityInstance);
                    }
                    if ((errorStateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ErrorState")) != null) {
                        int errorStateInstance = DatatypeConverter.parseInt((String)errorStateElement.getTextContent());
                        serviceResourceInstance.setErrorState(errorStateInstance);
                    }
                    if ((startTimeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StartTime")) != null) {
                        Calendar startTimeInstance = DatatypeConverter.parseDateTime((String)startTimeElement.getTextContent());
                        serviceResourceInstance.setStartTime(startTimeInstance);
                    }
                    if ((lastModifyTimeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LastModifyTime")) == null) continue;
                    Calendar lastModifyTimeInstance = DatatypeConverter.parseDateTime((String)lastModifyTimeElement.getTextContent());
                    serviceResourceInstance.setLastModifyTime(lastModifyTimeInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            DatabaseOperationListResponse databaseOperationListResponse = result;
            return databaseOperationListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

