/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.management.sql;

import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.sql.DatabaseOperations;
import com.microsoft.windowsazure.management.sql.SqlManagementClientImpl;
import com.microsoft.windowsazure.management.sql.models.Database;
import com.microsoft.windowsazure.management.sql.models.DatabaseCreateParameters;
import com.microsoft.windowsazure.management.sql.models.DatabaseCreateResponse;
import com.microsoft.windowsazure.management.sql.models.DatabaseEventLog;
import com.microsoft.windowsazure.management.sql.models.DatabaseGetEventLogsParameters;
import com.microsoft.windowsazure.management.sql.models.DatabaseGetEventLogsResponse;
import com.microsoft.windowsazure.management.sql.models.DatabaseGetResponse;
import com.microsoft.windowsazure.management.sql.models.DatabaseListResponse;
import com.microsoft.windowsazure.management.sql.models.DatabaseUpdateParameters;
import com.microsoft.windowsazure.management.sql.models.DatabaseUpdateResponse;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DatabaseOperationsImpl
implements ServiceOperations<SqlManagementClientImpl>,
DatabaseOperations {
    private SqlManagementClientImpl client;

    DatabaseOperationsImpl(SqlManagementClientImpl client) {
        this.client = client;
    }

    public SqlManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<DatabaseCreateResponse> createAsync(final String serverName, final DatabaseCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<DatabaseCreateResponse>(){

            @Override
            public DatabaseCreateResponse call() throws Exception {
                return DatabaseOperationsImpl.this.create(serverName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseCreateResponse create(String serverName, DatabaseCreateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getEdition() == null) {
            throw new NullPointerException("parameters.Edition");
        }
        if (parameters.getName() == null) {
            throw new NullPointerException("parameters.Name");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/services/sqlservers/servers/" + serverName.trim() + "/databases";
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element serviceResourceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ServiceResource");
        requestDoc.appendChild(serviceResourceElement);
        Element nameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
        nameElement.appendChild(requestDoc.createTextNode(parameters.getName()));
        serviceResourceElement.appendChild(nameElement);
        Element editionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Edition");
        editionElement.appendChild(requestDoc.createTextNode(parameters.getEdition()));
        serviceResourceElement.appendChild(editionElement);
        Element maxSizeGBElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "MaxSizeGB");
        maxSizeGBElement.appendChild(requestDoc.createTextNode(Integer.toString(parameters.getMaximumDatabaseSizeInGB())));
        serviceResourceElement.appendChild(maxSizeGBElement);
        if (parameters.getCollationName() != null) {
            Element collationNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "CollationName");
            collationNameElement.appendChild(requestDoc.createTextNode(parameters.getCollationName()));
            serviceResourceElement.appendChild(collationNameElement);
        }
        if (parameters.getServiceObjectiveId() != null) {
            Element serviceObjectiveIdElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ServiceObjectiveId");
            serviceObjectiveIdElement.appendChild(requestDoc.createTextNode(parameters.getServiceObjectiveId()));
            serviceResourceElement.appendChild(serviceObjectiveIdElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 201) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            DatabaseCreateResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new DatabaseCreateResponse();
            DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
            documentBuilderFactory2.setNamespaceAware(true);
            DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
            Document responseDoc = documentBuilder2.parse((InputStream)new BOMInputStream(responseContent));
            Element serviceResourceElement2 = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource");
            if (serviceResourceElement2 != null) {
                Element serviceObjectiveIdElement2;
                Element serviceObjectiveAssignmentSuccessDateElement;
                Element serviceObjectiveAssignmentStateDescriptionElement;
                Element serviceObjectiveAssignmentStateElement;
                Element serviceObjectiveAssignmentErrorDescriptionElement;
                Element serviceObjectiveAssignmentErrorCodeElement;
                Element sizeMBElement;
                Element isSystemObjectElement;
                Element isFederationRootElement;
                Element creationDateElement;
                Element collationNameElement2;
                Element maxSizeGBElement2;
                Element editionElement2;
                Element stateElement;
                Element typeElement;
                Element idElement;
                Database serviceResourceInstance = new Database();
                result.setDatabase(serviceResourceInstance);
                Element nameElement2 = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                if (nameElement2 != null) {
                    String nameInstance = nameElement2.getTextContent();
                    serviceResourceInstance.setName(nameInstance);
                }
                if ((idElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Id")) != null) {
                    int idInstance = DatatypeConverter.parseInt((String)idElement.getTextContent());
                    serviceResourceInstance.setId(idInstance);
                }
                if ((typeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type")) != null) {
                    String typeInstance = typeElement.getTextContent();
                    serviceResourceInstance.setType(typeInstance);
                }
                if ((stateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"State")) != null) {
                    String stateInstance = stateElement.getTextContent();
                    serviceResourceInstance.setState(stateInstance);
                }
                if ((editionElement2 = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Edition")) != null) {
                    String editionInstance = editionElement2.getTextContent();
                    serviceResourceInstance.setEdition(editionInstance);
                }
                if ((maxSizeGBElement2 = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"MaxSizeGB")) != null) {
                    int maxSizeGBInstance = DatatypeConverter.parseInt((String)maxSizeGBElement2.getTextContent());
                    serviceResourceInstance.setMaximumDatabaseSizeInGB(maxSizeGBInstance);
                }
                if ((collationNameElement2 = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"CollationName")) != null) {
                    String collationNameInstance = collationNameElement2.getTextContent();
                    serviceResourceInstance.setCollationName(collationNameInstance);
                }
                if ((creationDateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"CreationDate")) != null) {
                    Calendar creationDateInstance = DatatypeConverter.parseDateTime((String)creationDateElement.getTextContent());
                    serviceResourceInstance.setCreationDate(creationDateInstance);
                }
                if ((isFederationRootElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsFederationRoot")) != null) {
                    boolean isFederationRootInstance = DatatypeConverter.parseBoolean((String)isFederationRootElement.getTextContent().toLowerCase());
                    serviceResourceInstance.setIsFederationRoot(isFederationRootInstance);
                }
                if ((isSystemObjectElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsSystemObject")) != null) {
                    boolean isSystemObjectInstance = DatatypeConverter.parseBoolean((String)isSystemObjectElement.getTextContent().toLowerCase());
                    serviceResourceInstance.setIsSystemObject(isSystemObjectInstance);
                }
                if ((sizeMBElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"SizeMB")) != null) {
                    String sizeMBInstance = sizeMBElement.getTextContent();
                    serviceResourceInstance.setSizeMB(sizeMBInstance);
                }
                if ((serviceObjectiveAssignmentErrorCodeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceObjectiveAssignmentErrorCode")) != null) {
                    String serviceObjectiveAssignmentErrorCodeInstance = serviceObjectiveAssignmentErrorCodeElement.getTextContent();
                    serviceResourceInstance.setServiceObjectiveAssignmentErrorCode(serviceObjectiveAssignmentErrorCodeInstance);
                }
                if ((serviceObjectiveAssignmentErrorDescriptionElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceObjectiveAssignmentErrorDescription")) != null) {
                    String serviceObjectiveAssignmentErrorDescriptionInstance = serviceObjectiveAssignmentErrorDescriptionElement.getTextContent();
                    serviceResourceInstance.setServiceObjectiveAssignmentErrorDescription(serviceObjectiveAssignmentErrorDescriptionInstance);
                }
                if ((serviceObjectiveAssignmentStateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceObjectiveAssignmentState")) != null) {
                    String serviceObjectiveAssignmentStateInstance = serviceObjectiveAssignmentStateElement.getTextContent();
                    serviceResourceInstance.setServiceObjectiveAssignmentState(serviceObjectiveAssignmentStateInstance);
                }
                if ((serviceObjectiveAssignmentStateDescriptionElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceObjectiveAssignmentStateDescription")) != null) {
                    String serviceObjectiveAssignmentStateDescriptionInstance = serviceObjectiveAssignmentStateDescriptionElement.getTextContent();
                    serviceResourceInstance.setServiceObjectiveAssignmentStateDescription(serviceObjectiveAssignmentStateDescriptionInstance);
                }
                if ((serviceObjectiveAssignmentSuccessDateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceObjectiveAssignmentSuccessDate")) != null) {
                    String serviceObjectiveAssignmentSuccessDateInstance = serviceObjectiveAssignmentSuccessDateElement.getTextContent();
                    serviceResourceInstance.setServiceObjectiveAssignmentSuccessDate(serviceObjectiveAssignmentSuccessDateInstance);
                }
                if ((serviceObjectiveIdElement2 = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceObjectiveId")) != null) {
                    String serviceObjectiveIdInstance = serviceObjectiveIdElement2.getTextContent();
                    serviceResourceInstance.setServiceObjectiveId(serviceObjectiveIdInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            DatabaseCreateResponse databaseCreateResponse = result;
            return databaseCreateResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> deleteAsync(final String serverName, final String databaseName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return DatabaseOperationsImpl.this.delete(serverName, databaseName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse delete(String serverName, String databaseName) throws IOException, ServiceException {
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/services/sqlservers/servers/" + serverName.trim() + "/databases/" + databaseName.trim();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<DatabaseGetResponse> getAsync(final String serverName, final String databaseName) {
        return this.getClient().getExecutorService().submit(new Callable<DatabaseGetResponse>(){

            @Override
            public DatabaseGetResponse call() throws Exception {
                return DatabaseOperationsImpl.this.get(serverName, databaseName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseGetResponse get(String serverName, String databaseName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/services/sqlservers/servers/" + serverName.trim() + "/databases/" + databaseName.trim();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            DatabaseGetResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new DatabaseGetResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element serviceResourceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource");
            if (serviceResourceElement != null) {
                Element serviceObjectiveIdElement;
                Element serviceObjectiveAssignmentSuccessDateElement;
                Element serviceObjectiveAssignmentStateDescriptionElement;
                Element serviceObjectiveAssignmentStateElement;
                Element serviceObjectiveAssignmentErrorDescriptionElement;
                Element serviceObjectiveAssignmentErrorCodeElement;
                Element sizeMBElement;
                Element isSystemObjectElement;
                Element isFederationRootElement;
                Element creationDateElement;
                Element collationNameElement;
                Element maxSizeGBElement;
                Element editionElement;
                Element stateElement;
                Element typeElement;
                Element idElement;
                Database serviceResourceInstance = new Database();
                result.setDatabase(serviceResourceInstance);
                Element nameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                if (nameElement != null) {
                    String nameInstance = nameElement.getTextContent();
                    serviceResourceInstance.setName(nameInstance);
                }
                if ((idElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Id")) != null) {
                    int idInstance = DatatypeConverter.parseInt((String)idElement.getTextContent());
                    serviceResourceInstance.setId(idInstance);
                }
                if ((typeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type")) != null) {
                    String typeInstance = typeElement.getTextContent();
                    serviceResourceInstance.setType(typeInstance);
                }
                if ((stateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"State")) != null) {
                    String stateInstance = stateElement.getTextContent();
                    serviceResourceInstance.setState(stateInstance);
                }
                if ((editionElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Edition")) != null) {
                    String editionInstance = editionElement.getTextContent();
                    serviceResourceInstance.setEdition(editionInstance);
                }
                if ((maxSizeGBElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MaxSizeGB")) != null) {
                    int maxSizeGBInstance = DatatypeConverter.parseInt((String)maxSizeGBElement.getTextContent());
                    serviceResourceInstance.setMaximumDatabaseSizeInGB(maxSizeGBInstance);
                }
                if ((collationNameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CollationName")) != null) {
                    String collationNameInstance = collationNameElement.getTextContent();
                    serviceResourceInstance.setCollationName(collationNameInstance);
                }
                if ((creationDateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CreationDate")) != null) {
                    Calendar creationDateInstance = DatatypeConverter.parseDateTime((String)creationDateElement.getTextContent());
                    serviceResourceInstance.setCreationDate(creationDateInstance);
                }
                if ((isFederationRootElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsFederationRoot")) != null) {
                    boolean isFederationRootInstance = DatatypeConverter.parseBoolean((String)isFederationRootElement.getTextContent().toLowerCase());
                    serviceResourceInstance.setIsFederationRoot(isFederationRootInstance);
                }
                if ((isSystemObjectElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsSystemObject")) != null) {
                    boolean isSystemObjectInstance = DatatypeConverter.parseBoolean((String)isSystemObjectElement.getTextContent().toLowerCase());
                    serviceResourceInstance.setIsSystemObject(isSystemObjectInstance);
                }
                if ((sizeMBElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SizeMB")) != null) {
                    String sizeMBInstance = sizeMBElement.getTextContent();
                    serviceResourceInstance.setSizeMB(sizeMBInstance);
                }
                if ((serviceObjectiveAssignmentErrorCodeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceObjectiveAssignmentErrorCode")) != null) {
                    String serviceObjectiveAssignmentErrorCodeInstance = serviceObjectiveAssignmentErrorCodeElement.getTextContent();
                    serviceResourceInstance.setServiceObjectiveAssignmentErrorCode(serviceObjectiveAssignmentErrorCodeInstance);
                }
                if ((serviceObjectiveAssignmentErrorDescriptionElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceObjectiveAssignmentErrorDescription")) != null) {
                    String serviceObjectiveAssignmentErrorDescriptionInstance = serviceObjectiveAssignmentErrorDescriptionElement.getTextContent();
                    serviceResourceInstance.setServiceObjectiveAssignmentErrorDescription(serviceObjectiveAssignmentErrorDescriptionInstance);
                }
                if ((serviceObjectiveAssignmentStateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceObjectiveAssignmentState")) != null) {
                    String serviceObjectiveAssignmentStateInstance = serviceObjectiveAssignmentStateElement.getTextContent();
                    serviceResourceInstance.setServiceObjectiveAssignmentState(serviceObjectiveAssignmentStateInstance);
                }
                if ((serviceObjectiveAssignmentStateDescriptionElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceObjectiveAssignmentStateDescription")) != null) {
                    String serviceObjectiveAssignmentStateDescriptionInstance = serviceObjectiveAssignmentStateDescriptionElement.getTextContent();
                    serviceResourceInstance.setServiceObjectiveAssignmentStateDescription(serviceObjectiveAssignmentStateDescriptionInstance);
                }
                if ((serviceObjectiveAssignmentSuccessDateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceObjectiveAssignmentSuccessDate")) != null) {
                    String serviceObjectiveAssignmentSuccessDateInstance = serviceObjectiveAssignmentSuccessDateElement.getTextContent();
                    serviceResourceInstance.setServiceObjectiveAssignmentSuccessDate(serviceObjectiveAssignmentSuccessDateInstance);
                }
                if ((serviceObjectiveIdElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceObjectiveId")) != null) {
                    String serviceObjectiveIdInstance = serviceObjectiveIdElement.getTextContent();
                    serviceResourceInstance.setServiceObjectiveId(serviceObjectiveIdInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            DatabaseGetResponse databaseGetResponse = result;
            return databaseGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<DatabaseGetEventLogsResponse> getEventLogsAsync(final String serverName, final String databaseName, final DatabaseGetEventLogsParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<DatabaseGetEventLogsResponse>(){

            @Override
            public DatabaseGetEventLogsResponse call() throws Exception {
                return DatabaseOperationsImpl.this.getEventLogs(serverName, databaseName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseGetEventLogsResponse getEventLogs(String serverName, String databaseName, DatabaseGetEventLogsParameters parameters) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getEventTypes() == null) {
            throw new NullPointerException("parameters.EventTypes");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getEventLogsAsync", tracingParameters);
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/services/sqlservers/servers/" + serverName.trim() + "/databases/" + databaseName.trim() + "/events" + "?";
        url = url + "startDate=" + URLEncoder.encode(simpleDateFormat.format(parameters.getStartDate().getTime()), "UTF-8");
        url = url + "&" + "intervalSizeInMinutes=" + URLEncoder.encode(Integer.toString(parameters.getIntervalSizeInMinutes()), "UTF-8");
        url = url + "&" + "eventTypes=" + URLEncoder.encode(parameters.getEventTypes().trim(), "UTF-8");
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            DatabaseGetEventLogsResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new DatabaseGetEventLogsResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element serviceResourcesSequenceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResources");
            if (serviceResourcesSequenceElement != null) {
                for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)serviceResourcesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource").size(); ++i1) {
                    Element additionalDataElement;
                    Element descriptionElement;
                    Element severityElement;
                    Element numberOfEventsElement;
                    Element eventSubtypeDescriptionElement;
                    Element eventSubtypeElement;
                    Element eventTypeElement;
                    Element eventCategoryElement;
                    Element intervalSizeInMinutesElement;
                    Element startTimeUtcElement;
                    Element databaseNameElement;
                    Element parentLinkElement;
                    Element selfLinkElement;
                    Element stateElement;
                    Element typeElement;
                    Element serviceResourcesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)serviceResourcesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource").get(i1);
                    DatabaseEventLog serviceResourceInstance = new DatabaseEventLog();
                    result.getEventLogs().add(serviceResourceInstance);
                    Element nameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                    if (nameElement != null) {
                        String nameInstance = nameElement.getTextContent();
                        serviceResourceInstance.setName(nameInstance);
                    }
                    if ((typeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type")) != null) {
                        String typeInstance = typeElement.getTextContent();
                        serviceResourceInstance.setType(typeInstance);
                    }
                    if ((stateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"State")) != null) {
                        String stateInstance = stateElement.getTextContent();
                        serviceResourceInstance.setState(stateInstance);
                    }
                    if ((selfLinkElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SelfLink")) != null) {
                        String selfLinkInstance = selfLinkElement.getTextContent();
                        serviceResourceInstance.setSelfLink(selfLinkInstance);
                    }
                    if ((parentLinkElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ParentLink")) != null) {
                        String parentLinkInstance = parentLinkElement.getTextContent();
                        serviceResourceInstance.setParentLink(parentLinkInstance);
                    }
                    if ((databaseNameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DatabaseName")) != null) {
                        String databaseNameInstance = databaseNameElement.getTextContent();
                        serviceResourceInstance.setDatabaseName(databaseNameInstance);
                    }
                    if ((startTimeUtcElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StartTimeUtc")) != null) {
                        Calendar startTimeUtcInstance = DatatypeConverter.parseDateTime((String)startTimeUtcElement.getTextContent());
                        serviceResourceInstance.setStartTimeUtc(startTimeUtcInstance);
                    }
                    if ((intervalSizeInMinutesElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IntervalSizeInMinutes")) != null) {
                        int intervalSizeInMinutesInstance = DatatypeConverter.parseInt((String)intervalSizeInMinutesElement.getTextContent());
                        serviceResourceInstance.setIntervalSizeInMinutes(intervalSizeInMinutesInstance);
                    }
                    if ((eventCategoryElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"EventCategory")) != null) {
                        String eventCategoryInstance = eventCategoryElement.getTextContent();
                        serviceResourceInstance.setEventCategory(eventCategoryInstance);
                    }
                    if ((eventTypeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"EventType")) != null) {
                        String eventTypeInstance = eventTypeElement.getTextContent();
                        serviceResourceInstance.setEventType(eventTypeInstance);
                    }
                    if ((eventSubtypeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"EventSubtype")) != null) {
                        String eventSubtypeInstance = eventSubtypeElement.getTextContent();
                        serviceResourceInstance.setEventSubtype(eventSubtypeInstance);
                    }
                    if ((eventSubtypeDescriptionElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"EventSubtypeDescription")) != null) {
                        String eventSubtypeDescriptionInstance = eventSubtypeDescriptionElement.getTextContent();
                        serviceResourceInstance.setEventSubtypeDescription(eventSubtypeDescriptionInstance);
                    }
                    if ((numberOfEventsElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"NumberOfEvents")) != null) {
                        int numberOfEventsInstance = DatatypeConverter.parseInt((String)numberOfEventsElement.getTextContent());
                        serviceResourceInstance.setNumberOfEvents(numberOfEventsInstance);
                    }
                    if ((severityElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Severity")) != null) {
                        int severityInstance = DatatypeConverter.parseInt((String)severityElement.getTextContent());
                        serviceResourceInstance.setSeverity(severityInstance);
                    }
                    if ((descriptionElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Description")) != null) {
                        String descriptionInstance = descriptionElement.getTextContent();
                        serviceResourceInstance.setDescription(descriptionInstance);
                    }
                    if ((additionalDataElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AdditionalData")) == null) continue;
                    boolean isNil = false;
                    Attr nilAttribute = additionalDataElement.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "nil");
                    if (nilAttribute != null) {
                        isNil = "true".equals(nilAttribute.getValue());
                    }
                    if (isNil) continue;
                    String additionalDataInstance = additionalDataElement.getTextContent();
                    serviceResourceInstance.setAdditionalData(additionalDataInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            DatabaseGetEventLogsResponse databaseGetEventLogsResponse = result;
            return databaseGetEventLogsResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<DatabaseListResponse> listAsync(final String serverName) {
        return this.getClient().getExecutorService().submit(new Callable<DatabaseListResponse>(){

            @Override
            public DatabaseListResponse call() throws Exception {
                return DatabaseOperationsImpl.this.list(serverName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseListResponse list(String serverName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serverName", serverName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/services/sqlservers/servers/" + serverName.trim() + "/databases" + "?" + "contentview=generic";
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            DatabaseListResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new DatabaseListResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element serviceResourcesSequenceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResources");
            if (serviceResourcesSequenceElement != null) {
                for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)serviceResourcesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource").size(); ++i1) {
                    Element serviceObjectiveIdElement;
                    Element serviceObjectiveAssignmentSuccessDateElement;
                    Element serviceObjectiveAssignmentStateDescriptionElement;
                    Element serviceObjectiveAssignmentStateElement;
                    Element serviceObjectiveAssignmentErrorDescriptionElement;
                    Element serviceObjectiveAssignmentErrorCodeElement;
                    Element sizeMBElement;
                    Element isSystemObjectElement;
                    Element isFederationRootElement;
                    Element creationDateElement;
                    Element collationNameElement;
                    Element maxSizeGBElement;
                    Element editionElement;
                    Element stateElement;
                    Element typeElement;
                    Element idElement;
                    Element serviceResourcesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)serviceResourcesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource").get(i1);
                    Database serviceResourceInstance = new Database();
                    result.getDatabases().add(serviceResourceInstance);
                    Element nameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                    if (nameElement != null) {
                        String nameInstance = nameElement.getTextContent();
                        serviceResourceInstance.setName(nameInstance);
                    }
                    if ((idElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Id")) != null) {
                        int idInstance = DatatypeConverter.parseInt((String)idElement.getTextContent());
                        serviceResourceInstance.setId(idInstance);
                    }
                    if ((typeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type")) != null) {
                        String typeInstance = typeElement.getTextContent();
                        serviceResourceInstance.setType(typeInstance);
                    }
                    if ((stateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"State")) != null) {
                        String stateInstance = stateElement.getTextContent();
                        serviceResourceInstance.setState(stateInstance);
                    }
                    if ((editionElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Edition")) != null) {
                        String editionInstance = editionElement.getTextContent();
                        serviceResourceInstance.setEdition(editionInstance);
                    }
                    if ((maxSizeGBElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MaxSizeGB")) != null) {
                        int maxSizeGBInstance = DatatypeConverter.parseInt((String)maxSizeGBElement.getTextContent());
                        serviceResourceInstance.setMaximumDatabaseSizeInGB(maxSizeGBInstance);
                    }
                    if ((collationNameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CollationName")) != null) {
                        String collationNameInstance = collationNameElement.getTextContent();
                        serviceResourceInstance.setCollationName(collationNameInstance);
                    }
                    if ((creationDateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CreationDate")) != null) {
                        Calendar creationDateInstance = DatatypeConverter.parseDateTime((String)creationDateElement.getTextContent());
                        serviceResourceInstance.setCreationDate(creationDateInstance);
                    }
                    if ((isFederationRootElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsFederationRoot")) != null) {
                        boolean isFederationRootInstance = DatatypeConverter.parseBoolean((String)isFederationRootElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsFederationRoot(isFederationRootInstance);
                    }
                    if ((isSystemObjectElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsSystemObject")) != null) {
                        boolean isSystemObjectInstance = DatatypeConverter.parseBoolean((String)isSystemObjectElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsSystemObject(isSystemObjectInstance);
                    }
                    if ((sizeMBElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SizeMB")) != null) {
                        String sizeMBInstance = sizeMBElement.getTextContent();
                        serviceResourceInstance.setSizeMB(sizeMBInstance);
                    }
                    if ((serviceObjectiveAssignmentErrorCodeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceObjectiveAssignmentErrorCode")) != null) {
                        String serviceObjectiveAssignmentErrorCodeInstance = serviceObjectiveAssignmentErrorCodeElement.getTextContent();
                        serviceResourceInstance.setServiceObjectiveAssignmentErrorCode(serviceObjectiveAssignmentErrorCodeInstance);
                    }
                    if ((serviceObjectiveAssignmentErrorDescriptionElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceObjectiveAssignmentErrorDescription")) != null) {
                        String serviceObjectiveAssignmentErrorDescriptionInstance = serviceObjectiveAssignmentErrorDescriptionElement.getTextContent();
                        serviceResourceInstance.setServiceObjectiveAssignmentErrorDescription(serviceObjectiveAssignmentErrorDescriptionInstance);
                    }
                    if ((serviceObjectiveAssignmentStateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceObjectiveAssignmentState")) != null) {
                        String serviceObjectiveAssignmentStateInstance = serviceObjectiveAssignmentStateElement.getTextContent();
                        serviceResourceInstance.setServiceObjectiveAssignmentState(serviceObjectiveAssignmentStateInstance);
                    }
                    if ((serviceObjectiveAssignmentStateDescriptionElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceObjectiveAssignmentStateDescription")) != null) {
                        String serviceObjectiveAssignmentStateDescriptionInstance = serviceObjectiveAssignmentStateDescriptionElement.getTextContent();
                        serviceResourceInstance.setServiceObjectiveAssignmentStateDescription(serviceObjectiveAssignmentStateDescriptionInstance);
                    }
                    if ((serviceObjectiveAssignmentSuccessDateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceObjectiveAssignmentSuccessDate")) != null) {
                        String serviceObjectiveAssignmentSuccessDateInstance = serviceObjectiveAssignmentSuccessDateElement.getTextContent();
                        serviceResourceInstance.setServiceObjectiveAssignmentSuccessDate(serviceObjectiveAssignmentSuccessDateInstance);
                    }
                    if ((serviceObjectiveIdElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceObjectiveId")) == null) continue;
                    String serviceObjectiveIdInstance = serviceObjectiveIdElement.getTextContent();
                    serviceResourceInstance.setServiceObjectiveId(serviceObjectiveIdInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            DatabaseListResponse databaseListResponse = result;
            return databaseListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<DatabaseUpdateResponse> updateAsync(final String serverName, final String databaseName, final DatabaseUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<DatabaseUpdateResponse>(){

            @Override
            public DatabaseUpdateResponse call() throws Exception {
                return DatabaseOperationsImpl.this.update(serverName, databaseName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseUpdateResponse update(String serverName, String databaseName, DatabaseUpdateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getCollationName() == null) {
            throw new NullPointerException("parameters.CollationName");
        }
        if (parameters.getEdition() == null) {
            throw new NullPointerException("parameters.Edition");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"updateAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/services/sqlservers/servers/" + serverName.trim() + "/databases/" + databaseName.trim();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element serviceResourceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ServiceResource");
        requestDoc.appendChild(serviceResourceElement);
        if (parameters.getName() != null) {
            Element nameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
            nameElement.appendChild(requestDoc.createTextNode(parameters.getName()));
            serviceResourceElement.appendChild(nameElement);
        }
        Element idElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Id");
        idElement.appendChild(requestDoc.createTextNode(Integer.toString(parameters.getId())));
        serviceResourceElement.appendChild(idElement);
        Element editionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Edition");
        editionElement.appendChild(requestDoc.createTextNode(parameters.getEdition()));
        serviceResourceElement.appendChild(editionElement);
        Element maxSizeGBElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "MaxSizeGB");
        maxSizeGBElement.appendChild(requestDoc.createTextNode(Integer.toString(parameters.getMaximumDatabaseSizeInGB())));
        serviceResourceElement.appendChild(maxSizeGBElement);
        Element collationNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "CollationName");
        collationNameElement.appendChild(requestDoc.createTextNode(parameters.getCollationName()));
        serviceResourceElement.appendChild(collationNameElement);
        if (parameters.getServiceObjectiveId() != null) {
            Element serviceObjectiveIdElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ServiceObjectiveId");
            serviceObjectiveIdElement.appendChild(requestDoc.createTextNode(parameters.getServiceObjectiveId()));
            serviceResourceElement.appendChild(serviceObjectiveIdElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            DatabaseUpdateResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new DatabaseUpdateResponse();
            DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
            documentBuilderFactory2.setNamespaceAware(true);
            DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
            Document responseDoc = documentBuilder2.parse((InputStream)new BOMInputStream(responseContent));
            Element serviceResourceElement2 = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource");
            if (serviceResourceElement2 != null) {
                Element serviceObjectiveIdElement2;
                Element serviceObjectiveAssignmentSuccessDateElement;
                Element serviceObjectiveAssignmentStateDescriptionElement;
                Element serviceObjectiveAssignmentStateElement;
                Element serviceObjectiveAssignmentErrorDescriptionElement;
                Element serviceObjectiveAssignmentErrorCodeElement;
                Element sizeMBElement;
                Element isSystemObjectElement;
                Element isFederationRootElement;
                Element creationDateElement;
                Element collationNameElement2;
                Element maxSizeGBElement2;
                Element editionElement2;
                Element stateElement;
                Element typeElement;
                Element idElement2;
                Database serviceResourceInstance = new Database();
                result.setDatabase(serviceResourceInstance);
                Element nameElement2 = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                if (nameElement2 != null) {
                    String nameInstance = nameElement2.getTextContent();
                    serviceResourceInstance.setName(nameInstance);
                }
                if ((idElement2 = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Id")) != null) {
                    int idInstance = DatatypeConverter.parseInt((String)idElement2.getTextContent());
                    serviceResourceInstance.setId(idInstance);
                }
                if ((typeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type")) != null) {
                    String typeInstance = typeElement.getTextContent();
                    serviceResourceInstance.setType(typeInstance);
                }
                if ((stateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"State")) != null) {
                    String stateInstance = stateElement.getTextContent();
                    serviceResourceInstance.setState(stateInstance);
                }
                if ((editionElement2 = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Edition")) != null) {
                    String editionInstance = editionElement2.getTextContent();
                    serviceResourceInstance.setEdition(editionInstance);
                }
                if ((maxSizeGBElement2 = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"MaxSizeGB")) != null) {
                    int maxSizeGBInstance = DatatypeConverter.parseInt((String)maxSizeGBElement2.getTextContent());
                    serviceResourceInstance.setMaximumDatabaseSizeInGB(maxSizeGBInstance);
                }
                if ((collationNameElement2 = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"CollationName")) != null) {
                    String collationNameInstance = collationNameElement2.getTextContent();
                    serviceResourceInstance.setCollationName(collationNameInstance);
                }
                if ((creationDateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"CreationDate")) != null) {
                    Calendar creationDateInstance = DatatypeConverter.parseDateTime((String)creationDateElement.getTextContent());
                    serviceResourceInstance.setCreationDate(creationDateInstance);
                }
                if ((isFederationRootElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsFederationRoot")) != null) {
                    boolean isFederationRootInstance = DatatypeConverter.parseBoolean((String)isFederationRootElement.getTextContent().toLowerCase());
                    serviceResourceInstance.setIsFederationRoot(isFederationRootInstance);
                }
                if ((isSystemObjectElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsSystemObject")) != null) {
                    boolean isSystemObjectInstance = DatatypeConverter.parseBoolean((String)isSystemObjectElement.getTextContent().toLowerCase());
                    serviceResourceInstance.setIsSystemObject(isSystemObjectInstance);
                }
                if ((sizeMBElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"SizeMB")) != null) {
                    String sizeMBInstance = sizeMBElement.getTextContent();
                    serviceResourceInstance.setSizeMB(sizeMBInstance);
                }
                if ((serviceObjectiveAssignmentErrorCodeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceObjectiveAssignmentErrorCode")) != null) {
                    String serviceObjectiveAssignmentErrorCodeInstance = serviceObjectiveAssignmentErrorCodeElement.getTextContent();
                    serviceResourceInstance.setServiceObjectiveAssignmentErrorCode(serviceObjectiveAssignmentErrorCodeInstance);
                }
                if ((serviceObjectiveAssignmentErrorDescriptionElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceObjectiveAssignmentErrorDescription")) != null) {
                    String serviceObjectiveAssignmentErrorDescriptionInstance = serviceObjectiveAssignmentErrorDescriptionElement.getTextContent();
                    serviceResourceInstance.setServiceObjectiveAssignmentErrorDescription(serviceObjectiveAssignmentErrorDescriptionInstance);
                }
                if ((serviceObjectiveAssignmentStateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceObjectiveAssignmentState")) != null) {
                    String serviceObjectiveAssignmentStateInstance = serviceObjectiveAssignmentStateElement.getTextContent();
                    serviceResourceInstance.setServiceObjectiveAssignmentState(serviceObjectiveAssignmentStateInstance);
                }
                if ((serviceObjectiveAssignmentStateDescriptionElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceObjectiveAssignmentStateDescription")) != null) {
                    String serviceObjectiveAssignmentStateDescriptionInstance = serviceObjectiveAssignmentStateDescriptionElement.getTextContent();
                    serviceResourceInstance.setServiceObjectiveAssignmentStateDescription(serviceObjectiveAssignmentStateDescriptionInstance);
                }
                if ((serviceObjectiveAssignmentSuccessDateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceObjectiveAssignmentSuccessDate")) != null) {
                    String serviceObjectiveAssignmentSuccessDateInstance = serviceObjectiveAssignmentSuccessDateElement.getTextContent();
                    serviceResourceInstance.setServiceObjectiveAssignmentSuccessDate(serviceObjectiveAssignmentSuccessDateInstance);
                }
                if ((serviceObjectiveIdElement2 = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceObjectiveId")) != null) {
                    String serviceObjectiveIdInstance = serviceObjectiveIdElement2.getTextContent();
                    serviceResourceInstance.setServiceObjectiveId(serviceObjectiveIdInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            DatabaseUpdateResponse databaseUpdateResponse = result;
            return databaseUpdateResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

