/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.management.sql;

import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.sql.ServiceObjectiveOperations;
import com.microsoft.windowsazure.management.sql.SqlManagementClientImpl;
import com.microsoft.windowsazure.management.sql.models.ServiceObjective;
import com.microsoft.windowsazure.management.sql.models.ServiceObjectiveGetResponse;
import com.microsoft.windowsazure.management.sql.models.ServiceObjectiveListResponse;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ServiceObjectiveOperationsImpl
implements ServiceOperations<SqlManagementClientImpl>,
ServiceObjectiveOperations {
    private SqlManagementClientImpl client;

    ServiceObjectiveOperationsImpl(SqlManagementClientImpl client) {
        this.client = client;
    }

    public SqlManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<ServiceObjectiveGetResponse> getAsync(final String serverName, final String serviceObjectiveId) {
        return this.getClient().getExecutorService().submit(new Callable<ServiceObjectiveGetResponse>(){

            @Override
            public ServiceObjectiveGetResponse call() throws Exception {
                return ServiceObjectiveOperationsImpl.this.get(serverName, serviceObjectiveId);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceObjectiveGetResponse get(String serverName, String serviceObjectiveId) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (serviceObjectiveId == null) {
            throw new NullPointerException("serviceObjectiveId");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("serviceObjectiveId", serviceObjectiveId);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = this.getClient().getCredentials().getSubscriptionId().trim() + "/services/sqlservers/servers/" + serverName.trim() + "/serviceobjectives/" + serviceObjectiveId.trim();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            ServiceObjectiveGetResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new ServiceObjectiveGetResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element serviceResourceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource");
            if (serviceResourceElement != null) {
                Element dimensionSettingsSequenceElement;
                Element enabledElement;
                Element descriptionElement;
                Element isSystemElement;
                Element isDefaultElement;
                Element idElement;
                Element parentLinkElement;
                Element selfLinkElement;
                Element stateElement;
                Element typeElement;
                ServiceObjective serviceResourceInstance = new ServiceObjective();
                result.setServiceObjective(serviceResourceInstance);
                Element nameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                if (nameElement != null) {
                    String nameInstance = nameElement.getTextContent();
                    serviceResourceInstance.setName(nameInstance);
                }
                if ((typeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type")) != null) {
                    String typeInstance = typeElement.getTextContent();
                    serviceResourceInstance.setType(typeInstance);
                }
                if ((stateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"State")) != null) {
                    String stateInstance = stateElement.getTextContent();
                    serviceResourceInstance.setState(stateInstance);
                }
                if ((selfLinkElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SelfLink")) != null) {
                    String selfLinkInstance = selfLinkElement.getTextContent();
                    serviceResourceInstance.setSelfLink(selfLinkInstance);
                }
                if ((parentLinkElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ParentLink")) != null) {
                    String parentLinkInstance = parentLinkElement.getTextContent();
                    serviceResourceInstance.setParentLink(parentLinkInstance);
                }
                if ((idElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Id")) != null) {
                    String idInstance = idElement.getTextContent();
                    serviceResourceInstance.setId(idInstance);
                }
                if ((isDefaultElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsDefault")) != null) {
                    boolean isDefaultInstance = DatatypeConverter.parseBoolean((String)isDefaultElement.getTextContent().toLowerCase());
                    serviceResourceInstance.setIsDefault(isDefaultInstance);
                }
                if ((isSystemElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsSystem")) != null) {
                    boolean isSystemInstance = DatatypeConverter.parseBoolean((String)isSystemElement.getTextContent().toLowerCase());
                    serviceResourceInstance.setIsSystem(isSystemInstance);
                }
                if ((descriptionElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Description")) != null) {
                    String descriptionInstance = descriptionElement.getTextContent();
                    serviceResourceInstance.setDescription(descriptionInstance);
                }
                if ((enabledElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Enabled")) != null) {
                    boolean enabledInstance = DatatypeConverter.parseBoolean((String)enabledElement.getTextContent().toLowerCase());
                    serviceResourceInstance.setEnabled(enabledInstance);
                }
                if ((dimensionSettingsSequenceElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DimensionSettings")) != null) {
                    for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)dimensionSettingsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource").size(); ++i1) {
                        Element isDefaultElement2;
                        Element ordinalElement;
                        Element descriptionElement2;
                        Element idElement2;
                        Element parentLinkElement2;
                        Element selfLinkElement2;
                        Element stateElement2;
                        Element typeElement2;
                        Element dimensionSettingsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)dimensionSettingsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource").get(i1);
                        ServiceObjective.DimensionSettingResponse serviceResourceInstance2 = new ServiceObjective.DimensionSettingResponse();
                        serviceResourceInstance.getDimensionSettings().add(serviceResourceInstance2);
                        Element nameElement2 = XmlUtility.getElementByTagNameNS((Node)dimensionSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                        if (nameElement2 != null) {
                            String nameInstance2 = nameElement2.getTextContent();
                            serviceResourceInstance2.setName(nameInstance2);
                        }
                        if ((typeElement2 = XmlUtility.getElementByTagNameNS((Node)dimensionSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type")) != null) {
                            String typeInstance2 = typeElement2.getTextContent();
                            serviceResourceInstance2.setType(typeInstance2);
                        }
                        if ((stateElement2 = XmlUtility.getElementByTagNameNS((Node)dimensionSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"State")) != null) {
                            String stateInstance2 = stateElement2.getTextContent();
                            serviceResourceInstance2.setState(stateInstance2);
                        }
                        if ((selfLinkElement2 = XmlUtility.getElementByTagNameNS((Node)dimensionSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SelfLink")) != null) {
                            String selfLinkInstance2 = selfLinkElement2.getTextContent();
                            serviceResourceInstance2.setSelfLink(selfLinkInstance2);
                        }
                        if ((parentLinkElement2 = XmlUtility.getElementByTagNameNS((Node)dimensionSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ParentLink")) != null) {
                            String parentLinkInstance2 = parentLinkElement2.getTextContent();
                            serviceResourceInstance2.setParentLink(parentLinkInstance2);
                        }
                        if ((idElement2 = XmlUtility.getElementByTagNameNS((Node)dimensionSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Id")) != null) {
                            String idInstance2 = idElement2.getTextContent();
                            serviceResourceInstance2.setId(idInstance2);
                        }
                        if ((descriptionElement2 = XmlUtility.getElementByTagNameNS((Node)dimensionSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Description")) != null) {
                            String descriptionInstance2 = descriptionElement2.getTextContent();
                            serviceResourceInstance2.setDescription(descriptionInstance2);
                        }
                        if ((ordinalElement = XmlUtility.getElementByTagNameNS((Node)dimensionSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Ordinal")) != null) {
                            byte ordinalInstance = DatatypeConverter.parseByte((String)ordinalElement.getTextContent());
                            serviceResourceInstance2.setOrdinal(ordinalInstance);
                        }
                        if ((isDefaultElement2 = XmlUtility.getElementByTagNameNS((Node)dimensionSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsDefault")) == null) continue;
                        boolean isDefaultInstance2 = DatatypeConverter.parseBoolean((String)isDefaultElement2.getTextContent().toLowerCase());
                        serviceResourceInstance2.setIsDefault(isDefaultInstance2);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ServiceObjectiveGetResponse serviceObjectiveGetResponse = result;
            return serviceObjectiveGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<ServiceObjectiveListResponse> listAsync(final String serverName) {
        return this.getClient().getExecutorService().submit(new Callable<ServiceObjectiveListResponse>(){

            @Override
            public ServiceObjectiveListResponse call() throws Exception {
                return ServiceObjectiveOperationsImpl.this.list(serverName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceObjectiveListResponse list(String serverName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serverName", serverName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = this.getClient().getCredentials().getSubscriptionId().trim() + "/services/sqlservers/servers/" + serverName.trim() + "/serviceobjectives";
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            ServiceObjectiveListResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new ServiceObjectiveListResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element serviceResourcesSequenceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResources");
            if (serviceResourcesSequenceElement != null) {
                for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)serviceResourcesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource").size(); ++i1) {
                    Element dimensionSettingsSequenceElement;
                    Element enabledElement;
                    Element descriptionElement;
                    Element isSystemElement;
                    Element isDefaultElement;
                    Element idElement;
                    Element parentLinkElement;
                    Element selfLinkElement;
                    Element stateElement;
                    Element typeElement;
                    Element serviceResourcesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)serviceResourcesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource").get(i1);
                    ServiceObjective serviceResourceInstance = new ServiceObjective();
                    result.getServiceObjectives().add(serviceResourceInstance);
                    Element nameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                    if (nameElement != null) {
                        String nameInstance = nameElement.getTextContent();
                        serviceResourceInstance.setName(nameInstance);
                    }
                    if ((typeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type")) != null) {
                        String typeInstance = typeElement.getTextContent();
                        serviceResourceInstance.setType(typeInstance);
                    }
                    if ((stateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"State")) != null) {
                        String stateInstance = stateElement.getTextContent();
                        serviceResourceInstance.setState(stateInstance);
                    }
                    if ((selfLinkElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SelfLink")) != null) {
                        String selfLinkInstance = selfLinkElement.getTextContent();
                        serviceResourceInstance.setSelfLink(selfLinkInstance);
                    }
                    if ((parentLinkElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ParentLink")) != null) {
                        String parentLinkInstance = parentLinkElement.getTextContent();
                        serviceResourceInstance.setParentLink(parentLinkInstance);
                    }
                    if ((idElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Id")) != null) {
                        String idInstance = idElement.getTextContent();
                        serviceResourceInstance.setId(idInstance);
                    }
                    if ((isDefaultElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsDefault")) != null) {
                        boolean isDefaultInstance = DatatypeConverter.parseBoolean((String)isDefaultElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsDefault(isDefaultInstance);
                    }
                    if ((isSystemElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsSystem")) != null) {
                        boolean isSystemInstance = DatatypeConverter.parseBoolean((String)isSystemElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsSystem(isSystemInstance);
                    }
                    if ((descriptionElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Description")) != null) {
                        String descriptionInstance = descriptionElement.getTextContent();
                        serviceResourceInstance.setDescription(descriptionInstance);
                    }
                    if ((enabledElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Enabled")) != null) {
                        boolean enabledInstance = DatatypeConverter.parseBoolean((String)enabledElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setEnabled(enabledInstance);
                    }
                    if ((dimensionSettingsSequenceElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DimensionSettings")) == null) continue;
                    for (int i2 = 0; i2 < XmlUtility.getElementsByTagNameNS((Node)dimensionSettingsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource").size(); ++i2) {
                        Element isDefaultElement2;
                        Element ordinalElement;
                        Element descriptionElement2;
                        Element idElement2;
                        Element parentLinkElement2;
                        Element selfLinkElement2;
                        Element stateElement2;
                        Element typeElement2;
                        Element dimensionSettingsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)dimensionSettingsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource").get(i2);
                        ServiceObjective.DimensionSettingResponse serviceResourceInstance2 = new ServiceObjective.DimensionSettingResponse();
                        serviceResourceInstance.getDimensionSettings().add(serviceResourceInstance2);
                        Element nameElement2 = XmlUtility.getElementByTagNameNS((Node)dimensionSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                        if (nameElement2 != null) {
                            String nameInstance2 = nameElement2.getTextContent();
                            serviceResourceInstance2.setName(nameInstance2);
                        }
                        if ((typeElement2 = XmlUtility.getElementByTagNameNS((Node)dimensionSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type")) != null) {
                            String typeInstance2 = typeElement2.getTextContent();
                            serviceResourceInstance2.setType(typeInstance2);
                        }
                        if ((stateElement2 = XmlUtility.getElementByTagNameNS((Node)dimensionSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"State")) != null) {
                            String stateInstance2 = stateElement2.getTextContent();
                            serviceResourceInstance2.setState(stateInstance2);
                        }
                        if ((selfLinkElement2 = XmlUtility.getElementByTagNameNS((Node)dimensionSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SelfLink")) != null) {
                            String selfLinkInstance2 = selfLinkElement2.getTextContent();
                            serviceResourceInstance2.setSelfLink(selfLinkInstance2);
                        }
                        if ((parentLinkElement2 = XmlUtility.getElementByTagNameNS((Node)dimensionSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ParentLink")) != null) {
                            String parentLinkInstance2 = parentLinkElement2.getTextContent();
                            serviceResourceInstance2.setParentLink(parentLinkInstance2);
                        }
                        if ((idElement2 = XmlUtility.getElementByTagNameNS((Node)dimensionSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Id")) != null) {
                            String idInstance2 = idElement2.getTextContent();
                            serviceResourceInstance2.setId(idInstance2);
                        }
                        if ((descriptionElement2 = XmlUtility.getElementByTagNameNS((Node)dimensionSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Description")) != null) {
                            String descriptionInstance2 = descriptionElement2.getTextContent();
                            serviceResourceInstance2.setDescription(descriptionInstance2);
                        }
                        if ((ordinalElement = XmlUtility.getElementByTagNameNS((Node)dimensionSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Ordinal")) != null) {
                            byte ordinalInstance = DatatypeConverter.parseByte((String)ordinalElement.getTextContent());
                            serviceResourceInstance2.setOrdinal(ordinalInstance);
                        }
                        if ((isDefaultElement2 = XmlUtility.getElementByTagNameNS((Node)dimensionSettingsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsDefault")) == null) continue;
                        boolean isDefaultInstance2 = DatatypeConverter.parseBoolean((String)isDefaultElement2.getTextContent().toLowerCase());
                        serviceResourceInstance2.setIsDefault(isDefaultInstance2);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            ServiceObjectiveListResponse serviceObjectiveListResponse = result;
            return serviceObjectiveListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

