/*
 * Decompiled with CFR 0.152.
 */
package com.midtrans;

import com.midtrans.Config;
import com.midtrans.Midtrans;
import com.midtrans.proxy.ProxyConfig;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ConfigBuilder {
    private String serverKey = Midtrans.getServerKey();
    private String clientKey = Midtrans.getClientKey();
    private Boolean isProduction = Midtrans.isProduction();
    private boolean enableLog = Midtrans.enableLog();
    private int connectionTimeout;
    private int readTimeout;
    private int writeTimeout;
    private int maxConnectionPoolSize;
    private int keepAliveDuration;
    private TimeUnit httpClientTimeUnit;
    private String irisIdempotencyKey = null;
    private String paymentIdempotencyKey = null;
    private String xAppendNotification = Midtrans.getPaymentAppendNotification();
    private String xOverrideNotification = Midtrans.getPaymentOverrideNotification();
    private ProxyConfig proxyConfig;
    private Map<String, String> customHeaders = null;
    public static final int DEFAULT_CONNECT_TIMEOUT = 10;
    public static final int DEFAULT_READ_TIMEOUT = 10;
    public static final int DEFAULT_WRITE_TIMEOUT = 10;
    public static final int DEFAULT_MAX_CONNECTION_POOL_SIZE = 16;
    public static final int DEFAULT_KEEP_ALIVE_DURATION = 300;

    public ConfigBuilder() {
        this.connectionTimeout = Midtrans.getConnectTimeout();
        this.readTimeout = Midtrans.getReadTimeout();
        this.maxConnectionPoolSize = Midtrans.getMaxConnectionPool();
        this.keepAliveDuration = Midtrans.getKeepAliveDuration();
        this.httpClientTimeUnit = Midtrans.getHttpClientTimeUnit();
        this.writeTimeout = Midtrans.getWriteTimeout();
        this.proxyConfig = Midtrans.getProxyConfig();
    }

    public ConfigBuilder setSERVER_KEY(String SERVER_KEY) {
        return this.setServerKey(SERVER_KEY);
    }

    public ConfigBuilder setServerKey(String serverKey) {
        this.serverKey = serverKey;
        return this;
    }

    public ConfigBuilder setCLIENT_KEY(String CLIENT_KEY) {
        return this.setClientKey(CLIENT_KEY);
    }

    public ConfigBuilder setClientKey(String clientKey) {
        this.clientKey = clientKey;
        return this;
    }

    public ConfigBuilder setIsProduction(Boolean isProduction) {
        this.isProduction = isProduction;
        return this;
    }

    public ConfigBuilder setConnectionTimeout(int connectionTimeout, TimeUnit timeUnit) {
        this.connectionTimeout = connectionTimeout;
        this.httpClientTimeUnit = timeUnit;
        return this;
    }

    public ConfigBuilder setConnectionTimeout(int connectionTimeout) {
        return this.setConnectionTimeout(connectionTimeout, null);
    }

    public ConfigBuilder setReadTimeout(int readTimeout, TimeUnit timeUnit) {
        this.readTimeout = readTimeout;
        this.httpClientTimeUnit = timeUnit;
        return this;
    }

    public ConfigBuilder setReadTimeout(int readTimeout) {
        return this.setReadTimeout(readTimeout, null);
    }

    public ConfigBuilder setWriteTimeout(int writeTimeout, TimeUnit timeUnit) {
        this.writeTimeout = writeTimeout;
        this.httpClientTimeUnit = timeUnit;
        return this;
    }

    public ConfigBuilder setWriteTimeout(int writeTimeout) {
        return this.setWriteTimeout(writeTimeout, null);
    }

    public ConfigBuilder setProxyConfig(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
        return this;
    }

    public ConfigBuilder setMaxConnectionPoolSize(int connectionPoolSize) {
        this.maxConnectionPoolSize = connectionPoolSize;
        return this;
    }

    public ConfigBuilder setKeepAliveDuration(int keepAliveDuration, TimeUnit timeUnit) {
        this.keepAliveDuration = keepAliveDuration;
        this.httpClientTimeUnit = timeUnit;
        return this;
    }

    public ConfigBuilder setKeepAliveDuration(int keepAliveDuration) {
        return this.setKeepAliveDuration(keepAliveDuration, null);
    }

    public ConfigBuilder setIrisIdempotencyKey(String irisIdempotencyKey) {
        this.irisIdempotencyKey = irisIdempotencyKey;
        return this;
    }

    public ConfigBuilder setPaymentIdempotencyKey(String paymentIdempotencyKey) {
        this.paymentIdempotencyKey = paymentIdempotencyKey;
        return this;
    }

    public ConfigBuilder setPaymentAppendNotification(String xAppendNotification) {
        this.xAppendNotification = xAppendNotification;
        return this;
    }

    public ConfigBuilder setPaymentOverrideNotification(String xOverrideNotification) {
        this.xOverrideNotification = xOverrideNotification;
        return this;
    }

    public ConfigBuilder setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders = customHeaders;
        return this;
    }

    public ConfigBuilder enableLog(boolean enableLog) {
        this.enableLog = enableLog;
        return this;
    }

    public Config build() {
        return new Config(this.serverKey, this.clientKey, this.isProduction, this.enableLog, this.connectionTimeout, this.readTimeout, this.writeTimeout, this.maxConnectionPoolSize, this.keepAliveDuration, this.httpClientTimeUnit, this.irisIdempotencyKey, this.paymentIdempotencyKey, this.xAppendNotification, this.xOverrideNotification, this.proxyConfig, this.customHeaders);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigBuilder)) {
            return false;
        }
        ConfigBuilder other = (ConfigBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serverKey = this.serverKey;
        String other$serverKey = other.serverKey;
        if (this$serverKey == null ? other$serverKey != null : !this$serverKey.equals(other$serverKey)) {
            return false;
        }
        String this$clientKey = this.clientKey;
        String other$clientKey = other.clientKey;
        if (this$clientKey == null ? other$clientKey != null : !this$clientKey.equals(other$clientKey)) {
            return false;
        }
        Boolean this$isProduction = this.isProduction;
        Boolean other$isProduction = other.isProduction;
        if (this$isProduction == null ? other$isProduction != null : !((Object)this$isProduction).equals(other$isProduction)) {
            return false;
        }
        if (this.enableLog != other.enableLog) {
            return false;
        }
        if (this.connectionTimeout != other.connectionTimeout) {
            return false;
        }
        if (this.readTimeout != other.readTimeout) {
            return false;
        }
        if (this.writeTimeout != other.writeTimeout) {
            return false;
        }
        if (this.maxConnectionPoolSize != other.maxConnectionPoolSize) {
            return false;
        }
        if (this.keepAliveDuration != other.keepAliveDuration) {
            return false;
        }
        TimeUnit this$httpClientTimeUnit = this.httpClientTimeUnit;
        TimeUnit other$httpClientTimeUnit = other.httpClientTimeUnit;
        if (this$httpClientTimeUnit == null ? other$httpClientTimeUnit != null : !((Object)((Object)this$httpClientTimeUnit)).equals((Object)other$httpClientTimeUnit)) {
            return false;
        }
        String this$irisIdempotencyKey = this.irisIdempotencyKey;
        String other$irisIdempotencyKey = other.irisIdempotencyKey;
        if (this$irisIdempotencyKey == null ? other$irisIdempotencyKey != null : !this$irisIdempotencyKey.equals(other$irisIdempotencyKey)) {
            return false;
        }
        String this$paymentIdempotencyKey = this.paymentIdempotencyKey;
        String other$paymentIdempotencyKey = other.paymentIdempotencyKey;
        if (this$paymentIdempotencyKey == null ? other$paymentIdempotencyKey != null : !this$paymentIdempotencyKey.equals(other$paymentIdempotencyKey)) {
            return false;
        }
        String this$xAppendNotification = this.xAppendNotification;
        String other$xAppendNotification = other.xAppendNotification;
        if (this$xAppendNotification == null ? other$xAppendNotification != null : !this$xAppendNotification.equals(other$xAppendNotification)) {
            return false;
        }
        String this$xOverrideNotification = this.xOverrideNotification;
        String other$xOverrideNotification = other.xOverrideNotification;
        if (this$xOverrideNotification == null ? other$xOverrideNotification != null : !this$xOverrideNotification.equals(other$xOverrideNotification)) {
            return false;
        }
        ProxyConfig this$proxyConfig = this.proxyConfig;
        ProxyConfig other$proxyConfig = other.proxyConfig;
        if (this$proxyConfig == null ? other$proxyConfig != null : !this$proxyConfig.equals(other$proxyConfig)) {
            return false;
        }
        Map<String, String> this$customHeaders = this.customHeaders;
        Map<String, String> other$customHeaders = other.customHeaders;
        return !(this$customHeaders == null ? other$customHeaders != null : !((Object)this$customHeaders).equals(other$customHeaders));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConfigBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serverKey = this.serverKey;
        result = result * 59 + ($serverKey == null ? 43 : $serverKey.hashCode());
        String $clientKey = this.clientKey;
        result = result * 59 + ($clientKey == null ? 43 : $clientKey.hashCode());
        Boolean $isProduction = this.isProduction;
        result = result * 59 + ($isProduction == null ? 43 : ((Object)$isProduction).hashCode());
        result = result * 59 + (this.enableLog ? 79 : 97);
        result = result * 59 + this.connectionTimeout;
        result = result * 59 + this.readTimeout;
        result = result * 59 + this.writeTimeout;
        result = result * 59 + this.maxConnectionPoolSize;
        result = result * 59 + this.keepAliveDuration;
        TimeUnit $httpClientTimeUnit = this.httpClientTimeUnit;
        result = result * 59 + ($httpClientTimeUnit == null ? 43 : ((Object)((Object)$httpClientTimeUnit)).hashCode());
        String $irisIdempotencyKey = this.irisIdempotencyKey;
        result = result * 59 + ($irisIdempotencyKey == null ? 43 : $irisIdempotencyKey.hashCode());
        String $paymentIdempotencyKey = this.paymentIdempotencyKey;
        result = result * 59 + ($paymentIdempotencyKey == null ? 43 : $paymentIdempotencyKey.hashCode());
        String $xAppendNotification = this.xAppendNotification;
        result = result * 59 + ($xAppendNotification == null ? 43 : $xAppendNotification.hashCode());
        String $xOverrideNotification = this.xOverrideNotification;
        result = result * 59 + ($xOverrideNotification == null ? 43 : $xOverrideNotification.hashCode());
        ProxyConfig $proxyConfig = this.proxyConfig;
        result = result * 59 + ($proxyConfig == null ? 43 : $proxyConfig.hashCode());
        Map<String, String> $customHeaders = this.customHeaders;
        result = result * 59 + ($customHeaders == null ? 43 : ((Object)$customHeaders).hashCode());
        return result;
    }
}

