/*
 * Decompiled with CFR 0.152.
 */
package com.midtrans.snapbi;

import com.midtrans.snapbi.SnapBiConfig;
import java.io.IOException;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.json.JSONObject;

public class SnapBiApiRequestor {
    private static final OkHttpClient client;

    public static JSONObject remoteCall(String url, Map<String, String> headers, Map<String, ?> body) throws IOException {
        JSONObject jsonBody = new JSONObject(body);
        String payloadJson = jsonBody.toString();
        MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
        RequestBody requestBody = RequestBody.create((MediaType)JSON, (String)payloadJson);
        Request.Builder requestBuilder = new Request.Builder().url(url).post(requestBody);
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            requestBuilder.addHeader(entry.getKey(), entry.getValue());
        }
        Request request = requestBuilder.build();
        try (Response response = client.newCall(request).execute();){
            String responseBody = response.body() != null ? response.body().string() : "";
            JSONObject jSONObject = new JSONObject(responseBody);
            return jSONObject;
        }
    }

    static {
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor();
        loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        if (SnapBiConfig.isEnableLogging()) {
            clientBuilder.addInterceptor((Interceptor)loggingInterceptor);
        }
        client = clientBuilder.build();
    }
}

