/*
 * Decompiled with CFR 0.152.
 */
package org.tbee.javafx.scene.layout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.Transition;
import javafx.application.Platform;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.util.Duration;
import org.tbee.javafx.scene.layout.MigPane;

public class LayoutAnimator {
    private static final String ANIM_REPLACE_ID = "mig-anim";
    public static final Duration ANIM_DURATION = new Duration(2000.0);
    private final MigPane pane;
    private final ArrayList<Node> addedNodes = new ArrayList();
    private final ArrayList<Node> removedNodes = new ArrayList();
    private final IdentityHashMap<Node, HashMap<TransType, Transition>> nodeAnimMap = new IdentityHashMap();
    private final IdentityHashMap<Node, Node> replacedNodeMap = new IdentityHashMap();

    public LayoutAnimator(MigPane pane) {
        this.pane = pane;
    }

    void animate(Node node, Rectangle2D toBounds) {
        this.nodeAnimMap.compute(node, (n, oldTrans) -> this.createOrUpdateAnimation((Node)n, (HashMap<TransType, Transition>)oldTrans, toBounds));
        Node replNode = this.replacedNodeMap.get(node);
        if (replNode != null) {
            this.nodeAnimMap.compute(replNode, (n, oldTrans) -> this.createOrUpdateAnimation((Node)n, (HashMap<TransType, Transition>)oldTrans, toBounds));
        }
    }

    private HashMap<TransType, Transition> createOrUpdateAnimation(Node node, HashMap<TransType, Transition> transMap, Rectangle2D toBounds) {
        if (transMap == null) {
            transMap = new HashMap();
        }
        double toOpacity = this.extractOpacity(node);
        transMap.compute(TransType.OPACITY, (transType, oldTrans) -> {
            if (toOpacity != -1.0) {
                if (oldTrans != null) {
                    oldTrans.stop();
                }
                FadeTransition fadeTrans = new FadeTransition(ANIM_DURATION, node);
                fadeTrans.setToValue(toOpacity);
                if (LayoutAnimator.isReplacement(node)) {
                    fadeTrans.setOnFinished(event -> {
                        Node realNode = (Node)node.getUserData();
                        if (realNode != null) {
                            Rectangle2D rb = LayoutAnimator.getBounds(node);
                            realNode.resizeRelocate(rb.getMinX(), rb.getMinY(), rb.getWidth(), rb.getHeight());
                            realNode.setVisible(true);
                        }
                        this.pane.remove(node);
                    });
                }
                fadeTrans.play();
                return fadeTrans;
            }
            return oldTrans;
        });
        if (toBounds != null) {
            transMap.compute(TransType.BOUNDS, (transType, oldTrans) -> {
                Rectangle2D curBounds = LayoutAnimator.getBounds(node);
                if (!(curBounds.equals((Object)toBounds) || oldTrans != null && ((LayoutTrans)oldTrans).toBounds.equals((Object)toBounds))) {
                    if (oldTrans != null) {
                        oldTrans.stop();
                    }
                    if (toOpacity == -1.0) {
                        LayoutTrans trans = new LayoutTrans(node, ANIM_DURATION, toBounds);
                        trans.play();
                        return trans;
                    }
                    node.resizeRelocate(toBounds.getMinX(), toBounds.getMinY(), toBounds.getWidth(), toBounds.getHeight());
                }
                return oldTrans;
            });
        }
        return transMap;
    }

    private double extractOpacity(Node node) {
        if (this.addedNodes.remove(node)) {
            node.setOpacity(0.0);
            return 1.0;
        }
        if (this.removedNodes.remove(node)) {
            return 0.0;
        }
        return -1.0;
    }

    void nodeAdded(Node node) {
        if (LayoutAnimator.isReplacement(node)) {
            return;
        }
        Node replNode = this.createReplacement(node);
        this.addedNodes.add(replNode);
        this.removedNodes.remove(node);
        node.setVisible(false);
        Platform.runLater(() -> this.pane.add(0, replNode));
    }

    void nodeRemoved(Node node) {
        if (LayoutAnimator.isReplacement(node)) {
            return;
        }
        Node replNode = this.createReplacement(node);
        this.removedNodes.add(replNode);
        this.addedNodes.remove(node);
        Platform.runLater(() -> {
            this.pane.add(0, replNode);
            this.animate(replNode, null);
        });
    }

    private static boolean isReplacement(Node node) {
        return ANIM_REPLACE_ID.equals(node.getId());
    }

    public Node createReplacement(Node node) {
        Rectangle2D b = LayoutAnimator.getBounds(node);
        ImageView replNode = new ImageView((Image)node.snapshot(new SnapshotParameters(), null));
        this.replacedNodeMap.put(node, (Node)replNode);
        replNode.setUserData((Object)node);
        replNode.setManaged(false);
        replNode.setId(ANIM_REPLACE_ID);
        replNode.resizeRelocate(b.getMinX(), b.getMinY(), b.getWidth(), b.getHeight());
        return replNode;
    }

    void start() {
    }

    private static Rectangle2D getBounds(Node node) {
        Bounds lBounds = node.getLayoutBounds();
        return new Rectangle2D(node.getLayoutX(), node.getLayoutY(), lBounds.getWidth(), lBounds.getHeight());
    }

    static enum TransType {
        BOUNDS,
        OPACITY;

    }

    private class LayoutTrans
    extends Transition {
        private final Node node;
        private final double fromX;
        private final double fromY;
        private final double fromW;
        private final double fromH;
        private final Rectangle2D toBounds;

        LayoutTrans(Node node, Duration duration, Rectangle2D toBounds) {
            this.node = node;
            this.fromX = node.getLayoutX();
            this.fromY = node.getLayoutY();
            Bounds bounds = node.getLayoutBounds();
            this.fromW = bounds.getWidth();
            this.fromH = bounds.getHeight();
            this.toBounds = toBounds;
            this.setCycleDuration(duration);
            this.setInterpolator(Interpolator.SPLINE((double)0.0, (double)0.0, (double)0.2, (double)0.8));
        }

        protected void interpolate(double frac) {
            double x = this.fromX + (this.toBounds.getMinX() - this.fromX) * frac;
            double y = this.fromY + (this.toBounds.getMinY() - this.fromY) * frac;
            double w = this.fromW + (this.toBounds.getWidth() - this.fromW) * frac;
            double h = this.fromH + (this.toBounds.getHeight() - this.fromH) * frac;
            LayoutAnimator.this.pane.incLayoutInhibit();
            this.node.resizeRelocate(x, y, w, h);
            LayoutAnimator.this.pane.decLayoutInhibit();
        }
    }
}

