/*
 * Decompiled with CFR 0.152.
 */
package org.tbee.javafx.scene.layout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.Transition;
import javafx.application.Platform;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.util.Duration;
import org.tbee.javafx.scene.layout.MigPane;

public class LayoutAnimator {
    private static final String ANIM_REPLACE_ID = "mig-anim";
    public static final Duration ANIM_DURATION = new Duration(2000.0);
    private final MigPane pane;
    private final ArrayList<Node> addedNodes = new ArrayList();
    private final ArrayList<Node> removedNodes = new ArrayList();
    private final IdentityHashMap<Node, HashMap<TransType, Transition>> nodeAnimMap = new IdentityHashMap();
    private final IdentityHashMap<Node, Node> replacedNodeMap = new IdentityHashMap();

    public LayoutAnimator(MigPane migPane) {
        this.pane = migPane;
    }

    void animate(Node node2, Rectangle2D rectangle2D) {
        this.nodeAnimMap.compute(node2, (node, hashMap) -> this.createOrUpdateAnimation((Node)node, (HashMap<TransType, Transition>)hashMap, rectangle2D));
        Node node3 = this.replacedNodeMap.get(node2);
        if (node3 != null) {
            this.nodeAnimMap.compute(node3, (node, hashMap) -> this.createOrUpdateAnimation((Node)node, (HashMap<TransType, Transition>)hashMap, rectangle2D));
        }
    }

    private HashMap<TransType, Transition> createOrUpdateAnimation(Node node, HashMap<TransType, Transition> hashMap, Rectangle2D rectangle2D) {
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        double d = this.extractOpacity(node);
        hashMap.compute(TransType.OPACITY, (transType, transition) -> {
            if (d != -1.0) {
                if (transition != null) {
                    transition.stop();
                }
                FadeTransition fadeTransition = new FadeTransition(ANIM_DURATION, node);
                fadeTransition.setToValue(d);
                if (LayoutAnimator.isReplacement(node)) {
                    fadeTransition.setOnFinished(actionEvent -> {
                        Node node2 = (Node)node.getUserData();
                        if (node2 != null) {
                            Rectangle2D rectangle2D = LayoutAnimator.getBounds(node);
                            node2.resizeRelocate(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getWidth(), rectangle2D.getHeight());
                            node2.setVisible(true);
                        }
                        this.pane.remove(node);
                    });
                }
                fadeTransition.play();
                return fadeTransition;
            }
            return transition;
        });
        if (rectangle2D != null) {
            hashMap.compute(TransType.BOUNDS, (transType, transition) -> {
                Rectangle2D rectangle2D2 = LayoutAnimator.getBounds(node);
                if (!(rectangle2D2.equals((Object)rectangle2D) || transition != null && ((LayoutTrans)((Object)transition)).toBounds.equals((Object)rectangle2D))) {
                    if (transition != null) {
                        transition.stop();
                    }
                    if (d == -1.0) {
                        LayoutTrans layoutTrans = new LayoutTrans(node, ANIM_DURATION, rectangle2D);
                        layoutTrans.play();
                        return layoutTrans;
                    }
                    node.resizeRelocate(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getWidth(), rectangle2D.getHeight());
                }
                return transition;
            });
        }
        return hashMap;
    }

    private double extractOpacity(Node node) {
        if (this.addedNodes.remove(node)) {
            node.setOpacity(0.0);
            return 1.0;
        }
        if (this.removedNodes.remove(node)) {
            return 0.0;
        }
        return -1.0;
    }

    void nodeAdded(Node node) {
        if (LayoutAnimator.isReplacement(node)) {
            return;
        }
        Node node2 = this.createReplacement(node);
        this.addedNodes.add(node2);
        this.removedNodes.remove(node);
        node.setVisible(false);
        Platform.runLater(() -> this.pane.add(0, node2));
    }

    void nodeRemoved(Node node) {
        if (LayoutAnimator.isReplacement(node)) {
            return;
        }
        Node node2 = this.createReplacement(node);
        this.removedNodes.add(node2);
        this.addedNodes.remove(node);
        Platform.runLater(() -> {
            this.pane.add(0, node2);
            this.animate(node2, null);
        });
    }

    private static boolean isReplacement(Node node) {
        return ANIM_REPLACE_ID.equals(node.getId());
    }

    public Node createReplacement(Node node) {
        Rectangle2D rectangle2D = LayoutAnimator.getBounds(node);
        ImageView imageView = new ImageView((Image)node.snapshot(new SnapshotParameters(), null));
        this.replacedNodeMap.put(node, (Node)imageView);
        imageView.setUserData((Object)node);
        imageView.setManaged(false);
        imageView.setId(ANIM_REPLACE_ID);
        imageView.resizeRelocate(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        return imageView;
    }

    void start() {
    }

    private static Rectangle2D getBounds(Node node) {
        Bounds bounds = node.getLayoutBounds();
        return new Rectangle2D(node.getLayoutX(), node.getLayoutY(), bounds.getWidth(), bounds.getHeight());
    }

    private class LayoutTrans
    extends Transition {
        private final Node node;
        private final double fromX;
        private final double fromY;
        private final double fromW;
        private final double fromH;
        private final Rectangle2D toBounds;

        LayoutTrans(Node node, Duration duration, Rectangle2D rectangle2D) {
            this.node = node;
            this.fromX = node.getLayoutX();
            this.fromY = node.getLayoutY();
            Bounds bounds = node.getLayoutBounds();
            this.fromW = bounds.getWidth();
            this.fromH = bounds.getHeight();
            this.toBounds = rectangle2D;
            this.setCycleDuration(duration);
            this.setInterpolator(Interpolator.SPLINE((double)0.0, (double)0.0, (double)0.2, (double)0.8));
        }

        protected void interpolate(double d) {
            double d2 = this.fromX + (this.toBounds.getMinX() - this.fromX) * d;
            double d3 = this.fromY + (this.toBounds.getMinY() - this.fromY) * d;
            double d4 = this.fromW + (this.toBounds.getWidth() - this.fromW) * d;
            double d5 = this.fromH + (this.toBounds.getHeight() - this.fromH) * d;
            LayoutAnimator.this.pane.incLayoutInhibit();
            this.node.resizeRelocate(d2, d3, d4, d5);
            LayoutAnimator.this.pane.decLayoutInhibit();
        }
    }

    static enum TransType {
        BOUNDS,
        OPACITY;

    }
}

