/*
 * Decompiled with CFR 0.152.
 */
package org.tbee.javafx.scene.layout;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Orientation;
import javafx.geometry.Rectangle2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Control;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.stage.Screen;
import javafx.stage.Window;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.BoundSize;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.ComponentWrapper;
import net.miginfocom.layout.ConstraintParser;
import net.miginfocom.layout.ContainerWrapper;
import net.miginfocom.layout.Grid;
import net.miginfocom.layout.LC;
import net.miginfocom.layout.LayoutCallback;
import net.miginfocom.layout.LayoutUtil;
import net.miginfocom.layout.PlatformDefaults;
import net.miginfocom.layout.UnitValue;
import org.tbee.javafx.scene.layout.LayoutAnimator;

public class MigPane
extends Pane {
    protected static final String FXML_CC_KEY = "MigPane.cc";
    private final ChangeListener<Boolean> gridInvalidator = (observableValue, bl, bl2) -> {
        this.invalidateGrid();
        this.requestLayout();
    };
    private Orientation bias = null;
    private boolean biasDirty = true;
    private boolean debug = false;
    private LC layoutConstraints = null;
    public static final String LAYOUTCONSTRAINTS_PROPERTY_ID = "layoutConstraints";
    private AC columnConstraints = null;
    public static final String COLUMNCONSTRAINTS_PROPERTY_ID = "columnConstraints";
    private AC rowConstraints = null;
    public static final String ROWCONSTRAINTS_PROPERTY_ID = "rowConstraints";
    private LayoutAnimator anim = null;
    private int animPrio = 0;
    private ArrayList<LayoutCallback> callbackList = null;
    private final LinkedHashMap<FX2ComponentWrapper, CC> wrapperToCCMap = new LinkedHashMap();
    private long lastSize = 0L;
    private Grid _grid;
    private int layoutInhibits = 0;
    private final List<Node> debugRectangles = new ArrayList<Node>();
    private Color debugCellColor = Color.RED;
    private Color debugExternalColor = Color.BLUE;
    private Color debugOutlineColor = Color.GREEN;
    private Color debugContainerOutlineColor = Color.PURPLE;

    public MigPane() {
        this.construct();
    }

    public MigPane(LC lC) {
        this.setLayoutConstraints(lC);
        this.construct();
    }

    public MigPane(LC lC, AC aC) {
        this.setLayoutConstraints(lC);
        this.setColumnConstraints(aC);
        this.construct();
    }

    public MigPane(LC lC, AC aC, AC aC2) {
        this.setLayoutConstraints(lC);
        this.setColumnConstraints(aC);
        this.setRowConstraints(aC2);
        this.construct();
    }

    public MigPane(String string) {
        this.setLayoutConstraints(ConstraintParser.parseLayoutConstraint((String)ConstraintParser.prepare((String)string)));
        this.construct();
    }

    public MigPane(String string, String string2) {
        this.setLayoutConstraints(ConstraintParser.parseLayoutConstraint((String)ConstraintParser.prepare((String)string)));
        this.setColumnConstraints(ConstraintParser.parseColumnConstraints((String)ConstraintParser.prepare((String)string2)));
        this.construct();
    }

    public MigPane(String string, String string2, String string3) {
        this.setLayoutConstraints(ConstraintParser.parseLayoutConstraint((String)ConstraintParser.prepare((String)string)));
        this.setColumnConstraints(ConstraintParser.parseColumnConstraints((String)ConstraintParser.prepare((String)string2)));
        this.setRowConstraints(ConstraintParser.parseRowConstraints((String)ConstraintParser.prepare((String)string3)));
        this.construct();
    }

    private void construct() {
        if (this.layoutConstraints == null) {
            this.setLayoutConstraints(new LC());
        }
        if (this.rowConstraints == null) {
            this.setRowConstraints(new AC());
        }
        if (this.columnConstraints == null) {
            this.setColumnConstraints(new AC());
        }
        this.getChildren().addListener(change -> {
            while (change.next()) {
                for (Node node : change.getRemoved()) {
                    node.visibleProperty().removeListener(this.gridInvalidator);
                    this.animateRemoved(node);
                    int n = this.wrapperToCCMap.size();
                    this.wrapperToCCMap.remove(new FX2ComponentWrapper(node));
                    if (this.wrapperToCCMap.size() == n) continue;
                    this.invalidateGrid();
                }
                for (Node node : change.getAddedSubList()) {
                    if (!node.isManaged()) continue;
                    CC cC = (CC)node.getProperties().remove((Object)FXML_CC_KEY);
                    FX2ComponentWrapper fX2ComponentWrapper = new FX2ComponentWrapper(node);
                    if (cC != null || !this.wrapperToCCMap.containsKey(fX2ComponentWrapper)) {
                        this.wrapperToCCMap.put(fX2ComponentWrapper, cC);
                    }
                    this.animateAdded(node);
                    node.visibleProperty().addListener(this.gridInvalidator);
                    this.invalidateGrid();
                }
            }
        });
    }

    protected double computeMinWidth(double d) {
        return this.computeWidth(d, 0);
    }

    protected double computeMinHeight(double d) {
        return this.computeHeight(d, 0);
    }

    protected double computePrefWidth(double d) {
        return this.computeWidth(d, 1);
    }

    protected double computePrefHeight(double d) {
        return this.computeHeight(d, 1);
    }

    protected double computeMaxWidth(double d) {
        return this.computeWidth(d, 2);
    }

    protected double computeMaxHeight(double d) {
        return this.computeHeight(d, 2);
    }

    protected double computeWidth(double d, int n) {
        int n2 = this.getHorIns();
        int n3 = (int)Math.ceil(d != -1.0 ? d : this.getHeight()) - n2;
        return n2 + LayoutUtil.getSizeSafe((int[])this.getGrid().getWidth(n3), (int)n);
    }

    protected double computeHeight(double d, int n) {
        int n2 = this.getVerIns();
        int n3 = (int)Math.ceil(d != -1.0 ? d : this.getWidth()) - n2;
        return n2 + LayoutUtil.getSizeSafe((int[])this.getGrid().getHeight(n3), (int)n);
    }

    private int getHorIns() {
        Insets insets = this.getInsets();
        return (int)Math.ceil(this.snapSpace(insets.getLeft()) + this.snapSpace(insets.getRight()));
    }

    private int getVerIns() {
        Insets insets = this.getInsets();
        return (int)Math.ceil(this.snapSpace(insets.getTop()) + this.snapSpace(insets.getBottom()));
    }

    public Orientation getContentBias() {
        if (this.biasDirty) {
            this.bias = null;
            for (Node node : this.getManagedChildren()) {
                Orientation orientation = node.getContentBias();
                if (orientation == Orientation.HORIZONTAL) {
                    this.bias = Orientation.HORIZONTAL;
                    break;
                }
                if (orientation == null) continue;
                this.bias = orientation;
            }
            this.biasDirty = false;
        }
        return this.bias;
    }

    public LC getLayoutConstraints() {
        return this.layoutConstraints;
    }

    public void setLayoutConstraints(LC lC) {
        this.layoutConstraints = lC;
        this.debug = lC != null && lC.getDebugMillis() > 0;
        this.invalidateGrid();
        this.requestLayout();
    }

    public MigPane withLayoutConstraints(LC lC) {
        this.setLayoutConstraints(lC);
        return this;
    }

    public AC getColumnConstraints() {
        return this.columnConstraints;
    }

    public void setColumnConstraints(AC aC) {
        this.columnConstraints = aC;
        this.invalidateGrid();
        this.requestLayout();
    }

    public MigPane withColumnConstraints(AC aC) {
        this.setColumnConstraints(aC);
        return this;
    }

    public AC getRowConstraints() {
        return this.rowConstraints;
    }

    public void setRowConstraints(AC aC) {
        this.rowConstraints = aC;
        this.invalidateGrid();
        this.requestLayout();
    }

    public MigPane withRowConstraints(AC aC) {
        this.setRowConstraints(aC);
        return this;
    }

    public CC getComponentConstraints(Node node) {
        return this.wrapperToCCMap.get(new FX2ComponentWrapper(node));
    }

    private LayoutAnimator getAnimator() {
        if (this.anim == null) {
            this.anim = new LayoutAnimator(this);
        }
        return this.anim;
    }

    private void startQueuedAnimations() {
        if (this.anim != null) {
            this.anim.start();
        }
    }

    public void animateAdded(Node node) {
        if (this.isNodeAnimated(node)) {
            this.getAnimator().nodeAdded(node);
        }
    }

    public void animateRemoved(Node node) {
        if (this.isNodeAnimated(node)) {
            this.getAnimator().nodeRemoved(node);
        }
    }

    public boolean animateBoundsChange(Node node, int n, int n2, int n3, int n4) {
        if (!this.isNodeAnimated(node)) {
            return false;
        }
        this.getAnimator().animate(node, new Rectangle2D((double)n, (double)n2, (double)n3, (double)n4));
        return true;
    }

    private boolean isNodeAnimated(Node node) {
        if (!this.isVisible()) {
            return false;
        }
        CC cC = this.wrapperToCCMap.get(new FX2ComponentWrapper(node));
        int n = cC != null ? cC.getAnimSpec().getPriority() : 0;
        return (long)n + (long)this.animPrio > 0L;
    }

    public void addLayoutCallback(LayoutCallback layoutCallback) {
        if (layoutCallback == null) {
            throw new NullPointerException();
        }
        if (this.callbackList == null) {
            this.callbackList = new ArrayList(1);
        }
        this.callbackList.add(layoutCallback);
        this.invalidateGrid();
    }

    public void removeLayoutCallback(LayoutCallback layoutCallback) {
        if (this.callbackList != null) {
            this.callbackList.remove(layoutCallback);
        }
    }

    public MigPane add(Node node, CC cC) {
        if (node.isManaged()) {
            this.wrapperToCCMap.put(new FX2ComponentWrapper(node), cC);
        }
        this.getChildren().add((Object)node);
        return this;
    }

    public MigPane add(Node node) {
        this.add(node, (CC)null);
        return this;
    }

    public MigPane add(Node node, String string) {
        CC cC = ConstraintParser.parseComponentConstraint((String)ConstraintParser.prepare((String)string));
        this.add(node, cC);
        return this;
    }

    public MigPane add(int n, Node node) {
        this.add(n, node, (CC)null);
        return this;
    }

    public MigPane add(int n, Node node, String string) {
        CC cC = ConstraintParser.parseComponentConstraint((String)ConstraintParser.prepare((String)string));
        this.add(n, node, cC);
        return this;
    }

    public MigPane add(int n, Node node, CC cC) {
        if (node.isManaged()) {
            this.wrapperToCCMap.put(new FX2ComponentWrapper(node), cC);
        }
        this.getChildren().add(n, (Object)node);
        return this;
    }

    public boolean remove(Node node) {
        return this.getChildren().remove((Object)node);
    }

    public Node remove(int n) {
        return (Node)this.getChildren().remove(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void layoutChildren() {
        this.incLayoutInhibit();
        try {
            long l;
            Grid grid = this.getGrid();
            Insets insets = this.getInsets();
            int[] nArray = new int[]{(int)insets.getLeft(), (int)insets.getTop(), (int)Math.ceil(this.getWidth() - (double)this.getHorIns()), (int)Math.ceil(this.getHeight() - (double)this.getVerIns())};
            grid.layout(nArray, this.getLayoutConstraints().getAlignX(), this.getLayoutConstraints().getAlignY(), this.debug);
            if (this.debug) {
                this.clearDebug();
                grid.paintDebug();
            }
            if (this.lastSize != (l = (long)grid.getHeight()[1] + ((long)grid.getWidth()[1] << 32))) {
                this.lastSize = l;
                Platform.runLater(this::adjustWindowSize);
            }
            this.startQueuedAnimations();
        }
        finally {
            this.decLayoutInhibit();
        }
    }

    public void requestLayout() {
        if (this.layoutInhibits > 0) {
            return;
        }
        this.biasDirty = true;
        if (this._grid != null) {
            this._grid.invalidateContainerSize();
        }
        super.requestLayout();
    }

    void incLayoutInhibit() {
        ++this.layoutInhibits;
    }

    void decLayoutInhibit() {
        --this.layoutInhibits;
    }

    private Grid getGrid() {
        if (this._grid == null) {
            this._grid = new Grid((ContainerWrapper)new FX2ContainerWrapper((Parent)this), this.getLayoutConstraints(), this.getRowConstraints(), this.getColumnConstraints(), this.wrapperToCCMap, this.callbackList);
        }
        return this._grid;
    }

    public void invalidateGrid() {
        this._grid = null;
        this.biasDirty = true;
    }

    private void adjustWindowSize() {
        Window window;
        BoundSize boundSize = this.layoutConstraints.getPackWidth();
        BoundSize boundSize2 = this.layoutConstraints.getPackHeight();
        Scene scene = this.getScene();
        Window window2 = window = scene != null ? scene.getWindow() : null;
        if (window == null || boundSize == BoundSize.NULL_SIZE && boundSize2 == BoundSize.NULL_SIZE) {
            return;
        }
        Parent parent = scene.getRoot();
        double d = window.getWidth();
        double d2 = window.getHeight();
        double d3 = parent.prefWidth(-1.0);
        double d4 = parent.prefHeight(-1.0);
        FX2ContainerWrapper fX2ContainerWrapper = new FX2ContainerWrapper(parent);
        double d5 = d - scene.getWidth();
        double d6 = d2 - scene.getHeight();
        double d7 = this.constrain(fX2ContainerWrapper, d, d3, boundSize) + d5;
        double d8 = this.constrain(fX2ContainerWrapper, d2, d4, boundSize2) + d6;
        double d9 = window.getX() - (d7 - d) * (double)(1.0f - this.layoutConstraints.getPackWidthAlign());
        double d10 = window.getY() - (d8 - d2) * (double)(1.0f - this.layoutConstraints.getPackHeightAlign());
        window.setX(d9);
        window.setY(d10);
        window.setWidth(d7);
        window.setHeight(d8);
    }

    private double constrain(ContainerWrapper containerWrapper, double d, double d2, BoundSize boundSize) {
        if (boundSize == null) {
            return d;
        }
        double d3 = d;
        UnitValue unitValue = boundSize.getPreferred();
        if (unitValue != null) {
            d3 = unitValue.getPixels((float)d2, containerWrapper, (ComponentWrapper)containerWrapper);
        }
        d3 = boundSize.constrain((int)Math.ceil(d3), (float)d2, containerWrapper);
        return boundSize.getGapPush() ? Math.max(d, d3) : d3;
    }

    public void clearDebug() {
        this.getChildren().removeAll(this.debugRectangles);
        this.debugRectangles.clear();
    }

    private void addDebugRectangle(double d, double d2, double d3, double d4, DebugRectangleType debugRectangleType) {
        DebugRectangle debugRectangle = new DebugRectangle(this.snap(d), this.snap(d2), this.snap(d + d3 - 1.0) - this.snap(d), this.snap(d2 + d4 - 1.0) - this.snap(d2));
        if (debugRectangleType == DebugRectangleType.CELL) {
            debugRectangle.setStroke((Paint)this.getDebugCellColor());
            debugRectangle.getStrokeDashArray().addAll((Object[])new Double[]{3.0, 3.0});
        } else if (debugRectangleType == DebugRectangleType.EXTERNAL) {
            debugRectangle.setStroke((Paint)this.getDebugExternalColor());
            debugRectangle.getStrokeDashArray().addAll((Object[])new Double[]{5.0, 5.0});
        } else if (debugRectangleType == DebugRectangleType.OUTLINE) {
            debugRectangle.setStroke((Paint)this.getDebugOutlineColor());
            debugRectangle.getStrokeDashArray().addAll((Object[])new Double[]{4.0, 4.0});
        } else if (debugRectangleType == DebugRectangleType.CONTAINER_OUTLINE) {
            debugRectangle.setStroke((Paint)this.getDebugContainerOutlineColor());
            debugRectangle.getStrokeDashArray().addAll((Object[])new Double[]{7.0, 7.0});
        } else {
            throw new IllegalStateException("Unknown debug rectangle type");
        }
        debugRectangle.setFill(null);
        debugRectangle.mouseTransparentProperty().set(true);
        this.getChildren().add((Object)debugRectangle);
        this.debugRectangles.add((Node)debugRectangle);
    }

    private double snap(double d) {
        return (double)((int)d) + 0.5;
    }

    public Color getDebugCellColor() {
        return this.debugCellColor;
    }

    public void setDebugCellColor(Color color) {
        this.debugCellColor = color;
    }

    public Color getDebugExternalColor() {
        return this.debugExternalColor;
    }

    public void setDebugExternalColor(Color color) {
        this.debugExternalColor = color;
    }

    public Color getDebugOutlineColor() {
        return this.debugOutlineColor;
    }

    public void setDebugOutlineColor(Color color) {
        this.debugOutlineColor = color;
    }

    public Color getDebugContainerOutlineColor() {
        return this.debugContainerOutlineColor;
    }

    public void setDebugContainerOutlineColor(Color color) {
        this.debugContainerOutlineColor = color;
    }

    static {
        PlatformDefaults.setDefaultDPI((Integer)96);
    }

    class FX2ComponentWrapper
    implements ComponentWrapper {
        protected final Node node;

        public FX2ComponentWrapper(Node node) {
            this.node = node;
        }

        public Object getComponent() {
            return this.node;
        }

        public ContainerWrapper getParent() {
            Parent parent = this.node.getParent();
            return parent != null ? new FX2ContainerWrapper(this.node.getParent()) : null;
        }

        public int getComponentType(boolean bl) {
            if (this.node instanceof TextField || this.node instanceof TextArea) {
                return 3;
            }
            if (this.node instanceof Group) {
                return 1;
            }
            return 0;
        }

        public int getX() {
            int n = (int)this.node.getLayoutX();
            return n;
        }

        public int getY() {
            int n = (int)this.node.getLayoutY();
            return n;
        }

        public int getWidth() {
            int n = (int)Math.ceil(this.node.getLayoutBounds().getWidth());
            return n;
        }

        public int getMinimumWidth(int n) {
            int n2 = (int)Math.ceil(this.node.minWidth((double)n));
            return n2;
        }

        public int getPreferredWidth(int n) {
            int n2 = (int)Math.ceil(this.node.prefWidth((double)n));
            return n2;
        }

        public int getMaximumWidth(int n) {
            if (this.node instanceof Region || this.node instanceof Control) {
                double d;
                double d2 = d = this.node instanceof Region ? ((Region)this.node).getMaxWidth() : ((Control)this.node).getMaxWidth();
                if (d == -1.0 || d == Double.NEGATIVE_INFINITY) {
                    return 2097051;
                }
            }
            return (int)Math.ceil(this.node.maxWidth((double)n));
        }

        public int getHeight() {
            int n = (int)Math.ceil(this.node.getLayoutBounds().getHeight());
            return n;
        }

        public int getMinimumHeight(int n) {
            int n2 = (int)Math.ceil(this.node.minHeight((double)n));
            return n2;
        }

        public int getPreferredHeight(int n) {
            int n2 = (int)Math.ceil(this.node.prefHeight((double)n));
            return n2;
        }

        public int getMaximumHeight(int n) {
            if (this.node instanceof Region || this.node instanceof Control) {
                double d;
                double d2 = d = this.node instanceof Region ? ((Region)this.node).getMaxHeight() : ((Control)this.node).getMaxHeight();
                if (d == -1.0 || d == Double.NEGATIVE_INFINITY) {
                    return 2097051;
                }
            }
            return (int)Math.ceil(this.node.maxHeight((double)n));
        }

        public int getBaseline(int n, int n2) {
            return (int)Math.round(this.node.getBaselineOffset());
        }

        public boolean hasBaseline() {
            return this.node.isResizable() && this.node.getBaselineOffset() != Double.NEGATIVE_INFINITY;
        }

        public int getScreenLocationX() {
            Bounds bounds = this.node.localToScene(this.node.getBoundsInLocal());
            int n = (int)(this.node.getScene().getX() + this.node.getScene().getX() + bounds.getMinX());
            return n;
        }

        public int getScreenLocationY() {
            Bounds bounds = this.node.localToScene(this.node.getBoundsInLocal());
            int n = (int)(this.node.getScene().getY() + this.node.getScene().getY() + bounds.getMinY());
            return n;
        }

        public int getScreenHeight() {
            int n = (int)Math.ceil(Screen.getPrimary().getBounds().getHeight());
            return n;
        }

        public int getScreenWidth() {
            int n = (int)Math.ceil(Screen.getPrimary().getBounds().getWidth());
            return n;
        }

        public int[] getVisualPadding() {
            return null;
        }

        public int getHorizontalScreenDPI() {
            return 96;
        }

        public int getVerticalScreenDPI() {
            return 96;
        }

        public float getPixelUnitFactor(boolean bl) {
            switch (PlatformDefaults.getLogicalPixelBase()) {
                case 100: {
                    return 1.0f;
                }
                case 101: {
                    Float f;
                    Float f2 = f = bl ? PlatformDefaults.getHorizontalScaleFactor() : PlatformDefaults.getVerticalScaleFactor();
                    if (f == null) {
                        f = Float.valueOf(1.0f);
                    }
                    return f.floatValue() * (float)(bl ? this.getHorizontalScreenDPI() : this.getVerticalScreenDPI()) / (float)PlatformDefaults.getDefaultDPI();
                }
            }
            return 1.0f;
        }

        public int getLayoutHashCode() {
            return 0;
        }

        public String getLinkId() {
            return this.node.getId();
        }

        public boolean isVisible() {
            return this.node.isVisible();
        }

        public int getContentBias() {
            Orientation orientation = this.node.getContentBias();
            return orientation == null ? -1 : orientation.ordinal();
        }

        public void paintDebugOutline(boolean bl) {
            CC cC = (CC)MigPane.this.wrapperToCCMap.get(this);
            DebugRectangleType debugRectangleType = cC != null && cC.isExternal() ? DebugRectangleType.EXTERNAL : DebugRectangleType.OUTLINE;
            MigPane.this.addDebugRectangle(this.node.getLayoutX() + this.node.getLayoutBounds().getMinX(), this.node.getLayoutY() + this.node.getLayoutBounds().getMinY(), this.getWidth(), this.getHeight(), debugRectangleType);
        }

        public int hashCode() {
            return this.node.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof FX2ComponentWrapper)) {
                return false;
            }
            return this.getComponent().equals(((FX2ComponentWrapper)object).getComponent());
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            if (!MigPane.this.animateBoundsChange(this.node, n, n2, n3, n4)) {
                this.node.resizeRelocate((double)n, (double)n2, (double)n3, (double)n4);
            }
        }
    }

    class FX2ContainerWrapper
    extends FX2ComponentWrapper
    implements ContainerWrapper {
        public FX2ContainerWrapper(Parent parent) {
            super((Node)parent);
        }

        public FX2ComponentWrapper[] getComponents() {
            return (FX2ComponentWrapper[])MigPane.this.getManagedChildren().stream().map(node -> new FX2ComponentWrapper((Node)node)).toArray(FX2ComponentWrapper[]::new);
        }

        public int getComponentCount() {
            return MigPane.this.wrapperToCCMap.size();
        }

        public Object getLayout() {
            return MigPane.this;
        }

        public boolean isLeftToRight() {
            ContainerWrapper containerWrapper;
            NodeOrientation nodeOrientation = MigPane.this.getNodeOrientation();
            if (nodeOrientation == NodeOrientation.INHERIT && (containerWrapper = this.getParent()) != null) {
                return containerWrapper.isLeftToRight();
            }
            return nodeOrientation != NodeOrientation.RIGHT_TO_LEFT;
        }

        public void paintDebugCell(int n, int n2, int n3, int n4) {
            MigPane.this.addDebugRectangle(n, n2, n3, n4, DebugRectangleType.CELL);
        }

        @Override
        public void paintDebugOutline(boolean bl) {
            MigPane.this.addDebugRectangle(0.0, 0.0, this.getWidth(), this.getHeight(), DebugRectangleType.CONTAINER_OUTLINE);
        }
    }

    class DebugRectangle
    extends Rectangle {
        public DebugRectangle(double d, double d2, double d3, double d4) {
            super(d, d2, d3, d4);
            this.setManaged(false);
        }
    }

    private static enum DebugRectangleType {
        CELL,
        OUTLINE,
        CONTAINER_OUTLINE,
        EXTERNAL;

    }
}

