/*
 * Decompiled with CFR 0.152.
 */
package com.miguno.akka.testing;

import akka.actor.ActorRef;
import akka.actor.Cancellable;
import akka.actor.Scheduler;
import com.miguno.akka.testing.MockCancellable;
import com.miguno.akka.testing.Task;
import com.miguno.akka.testing.VirtualTime;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.mutable.PriorityQueue;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001u4A!\u0001\u0002\u0001\u0017\tiQj\\2l'\u000eDW\rZ;mKJT!a\u0001\u0003\u0002\u000fQ,7\u000f^5oO*\u0011QAB\u0001\u0005C.\\\u0017M\u0003\u0002\b\u0011\u00051Q.[4v]>T\u0011!C\u0001\u0004G>l7\u0001A\n\u0004\u00011\u0011\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u0014/5\tAC\u0003\u0002\u0016-\u0005)\u0011m\u0019;pe*\tQ!\u0003\u0002\u0019)\tI1k\u00195fIVdWM\u001d\u0005\t5\u0001\u0011\t\u0011)A\u00057\u0005!A/[7f!\taR$D\u0001\u0003\u0013\tq\"AA\u0006WSJ$X/\u00197US6,\u0007\"\u0002\u0011\u0001\t\u0003\t\u0013A\u0002\u001fj]&$h\b\u0006\u0002#GA\u0011A\u0004\u0001\u0005\u00065}\u0001\ra\u0007\u0005\u0007K\u0001\u0001\u000b\u0015\u0002\u0014\u0002\u0005%$\u0007CA\u0007(\u0013\tAcB\u0001\u0003M_:<\u0007B\u0002\u0016\u0001A\u0003&1&A\u0003uCN\\7\u000fE\u0002-cMj\u0011!\f\u0006\u0003]=\nq!\\;uC\ndWM\u0003\u00021\u001d\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Ij#!\u0004)sS>\u0014\u0018\u000e^=Rk\u0016,X\r\u0005\u0002\u001di%\u0011QG\u0001\u0002\u0005)\u0006\u001c8\u000eC\u00038\u0001\u0011\u0005\u0001(\u0001\u0003uS\u000e\\G#A\u001d\u0011\u00055Q\u0014BA\u001e\u000f\u0005\u0011)f.\u001b;\t\u000bu\u0002A\u0011\t \u0002\u0019M\u001c\u0007.\u001a3vY\u0016|enY3\u0015\u0007}Z5\u000b\u0006\u0002A\u0007B\u00111#Q\u0005\u0003\u0005R\u00111bQ1oG\u0016dG.\u00192mK\")A\t\u0010a\u0002\u000b\u0006AQ\r_3dkR|'\u000f\u0005\u0002G\u00136\tqI\u0003\u0002I\u001d\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005);%\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u0015aE\b1\u0001N\u0003\u0015!W\r\\1z!\tq\u0015+D\u0001P\u0015\t\u0001v)\u0001\u0005ekJ\fG/[8o\u0013\t\u0011vJ\u0001\bGS:LG/\u001a#ve\u0006$\u0018n\u001c8\t\u000bQc\u0004\u0019A+\u0002\u0011I,hN\\1cY\u0016\u0004\"AV.\u000e\u0003]S!\u0001W-\u0002\t1\fgn\u001a\u0006\u00025\u0006!!.\u0019<b\u0013\tavK\u0001\u0005Sk:t\u0017M\u00197f\u0011\u0015q\u0006\u0001\"\u0011`\u0003!\u00198\r[3ek2,G\u0003\u00021cI\u001a$\"\u0001Q1\t\u000b\u0011k\u00069A#\t\u000b\rl\u0006\u0019A'\u0002\u0019%t\u0017\u000e^5bY\u0012+G.Y=\t\u000b\u0015l\u0006\u0019A'\u0002\u0011%tG/\u001a:wC2DQ\u0001V/A\u0002UCQ\u0001\u001b\u0001\u0005\n%\f!\"\u00193e)>$\u0016m]6t)\u0011\u0001%n\u001b7\t\u000b1;\u0007\u0019A'\t\u000bQ;\u0007\u0019A+\t\u000b\u0015<\u0007\u0019A7\u0011\u00075qW*\u0003\u0002p\u001d\t1q\n\u001d;j_:Da!\u001d\u0001\u0005\u0002\t\u0011\u0018AC2b]\u000e,G\u000eV1tWR\u0011\u0011h\u001d\u0005\u0006iB\u0004\raM\u0001\u0005i\u0006\u001c8\u000eC\u0004w\u0001\t\u0007I\u0011I<\u0002\u00195\f\u0007P\u0012:fcV,gnY=\u0016\u0003a\u0004\"!D=\n\u0005it!A\u0002#pk\ndW\r\u0003\u0004}\u0001\u0001\u0006I\u0001_\u0001\u000e[\u0006DhI]3rk\u0016t7-\u001f\u0011")
public class MockScheduler
implements Scheduler {
    private final VirtualTime time;
    private long id;
    private PriorityQueue<Task> tasks;
    private final double maxFrequency;

    public final Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
        return Scheduler.class.schedule((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)interval, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
    }

    public final Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, Function0<BoxedUnit> f, ExecutionContext executor) {
        return Scheduler.class.schedule((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)interval, f, (ExecutionContext)executor);
    }

    public final Cancellable scheduleOnce(FiniteDuration delay, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
        return Scheduler.class.scheduleOnce((Scheduler)this, (FiniteDuration)delay, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
    }

    public final Cancellable scheduleOnce(FiniteDuration delay, Function0<BoxedUnit> f, ExecutionContext executor) {
        return Scheduler.class.scheduleOnce((Scheduler)this, (FiniteDuration)delay, f, (ExecutionContext)executor);
    }

    public final ActorRef schedule$default$6(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message) {
        return Scheduler.class.schedule$default$6((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)interval, (ActorRef)receiver, (Object)message);
    }

    public final ActorRef scheduleOnce$default$5(FiniteDuration delay, ActorRef receiver, Object message) {
        return Scheduler.class.scheduleOnce$default$5((Scheduler)this, (FiniteDuration)delay, (ActorRef)receiver, (Object)message);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void tick() {
        Object object = this.time.lock();
        synchronized (object) {
            while (this.tasks.nonEmpty() && ((Task)this.tasks.head()).delay().$less$eq((Object)this.time.elapsed())) {
                BoxedUnit boxedUnit;
                Task head = (Task)this.tasks.dequeue();
                head.runnable().run();
                Option<FiniteDuration> option = head.interval();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    FiniteDuration interval = (FiniteDuration)some.x();
                    boxedUnit = this.tasks.$plus$eq((Object)new Task(head.delay().$plus(interval), head.id(), head.runnable(), head.interval()));
                    continue;
                }
                if (!None$.MODULE$.equals(option)) {
                    throw new MatchError(option);
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public Cancellable scheduleOnce(FiniteDuration delay, Runnable runnable, ExecutionContext executor) {
        return this.addToTasks(delay, runnable, (Option<FiniteDuration>)None$.MODULE$);
    }

    public Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, Runnable runnable, ExecutionContext executor) {
        return this.addToTasks(initialDelay, runnable, (Option<FiniteDuration>)Option$.MODULE$.apply((Object)interval));
    }

    private Cancellable addToTasks(FiniteDuration delay, Runnable runnable, Option<FiniteDuration> interval) {
        Object object = this.time.lock();
        synchronized (object) {
            ++this.id;
            FiniteDuration startTime = this.time.elapsed().$plus(delay);
            Task task = new Task(startTime, this.id, runnable, interval);
            this.tasks.$plus$eq((Object)task);
            MockCancellable mockCancellable = new MockCancellable(this, task);
            return mockCancellable;
        }
    }

    public void cancelTask(Task task) {
        Object object = this.time.lock();
        synchronized (object) {
            this.tasks = (PriorityQueue)this.tasks.filterNot((Function1)new Serializable(this, task){
                public static final long serialVersionUID = 0L;
                private final Task task$1;

                public final boolean apply(Task x) {
                    return x.id() == this.task$1.id();
                }
                {
                    this.task$1 = task$1;
                }
            });
            return;
        }
    }

    public double maxFrequency() {
        return this.maxFrequency;
    }

    public MockScheduler(VirtualTime time) {
        this.time = time;
        Scheduler.class.$init$((Scheduler)this);
        this.id = 0L;
        this.tasks = new PriorityQueue(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        this.maxFrequency = new package.DurationInt(package$.MODULE$.DurationInt(1)).second().$div((Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).millis());
    }
}

