/*
 * Decompiled with CFR 0.152.
 */
package com.mikemybytes.junit5.formatted;

import com.mikemybytes.junit5.formatted.FormatArgumentMatcherGroup;
import com.mikemybytes.junit5.formatted.FormatSpecification;
import com.mikemybytes.junit5.formatted.FormattedSourceData;
import com.mikemybytes.junit5.formatted.Preconditions;
import com.mikemybytes.junit5.formatted.RawArgumentsProcessor;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.junit.jupiter.params.provider.Arguments;

class ArgumentsExtractor {
    private final FormattedSourceData sourceData;
    private final FormatSpecification formatSpecification;
    private final RawArgumentsProcessor rawArgumentsProcessor;

    ArgumentsExtractor(FormattedSourceData sourceData, FormatSpecification formatSpecification, RawArgumentsProcessor rawArgumentsProcessor) {
        this.sourceData = sourceData;
        this.formatSpecification = formatSpecification;
        this.rawArgumentsProcessor = rawArgumentsProcessor;
    }

    Arguments extract(String line) {
        Matcher formatMatcher = this.formatSpecification.getPattern().matcher(line);
        Preconditions.require(formatMatcher.matches(), "Input does not match the expected format");
        List args = this.formatSpecification.getArgumentsOrder().stream().map(argIndex -> new ArgumentIndexMatcher((int)argIndex, new FormatArgumentMatcherGroup((int)argIndex))).sorted(Comparator.comparing(ArgumentIndexMatcher::getIndex)).map(aim -> formatMatcher.group(aim.getMatcherGroup().getName())).map(this::processArgumentValue).collect(Collectors.toList());
        List processedArgs = (List)this.rawArgumentsProcessor.apply(line, args);
        return Arguments.of((Object[])processedArgs.toArray());
    }

    private String processArgumentValue(String rawValue) {
        return rawValue.trim().replace("" + this.sourceData.getQuoteCharacter(), "");
    }

    private static class ArgumentIndexMatcher {
        private final int index;
        private final FormatArgumentMatcherGroup matcherGroup;

        public ArgumentIndexMatcher(int index, FormatArgumentMatcherGroup matcherGroup) {
            this.index = index;
            this.matcherGroup = matcherGroup;
        }

        public int getIndex() {
            return this.index;
        }

        public FormatArgumentMatcherGroup getMatcherGroup() {
            return this.matcherGroup;
        }
    }
}

