/*
 * Decompiled with CFR 0.152.
 */
package com.mikemybytes.junit5.formatted;

import com.mikemybytes.junit5.formatted.FormatArgumentMatcherGroup;
import com.mikemybytes.junit5.formatted.FormatSpecification;
import com.mikemybytes.junit5.formatted.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.jupiter.api.extension.ExtensionContext;

class FormatAnalyzer {
    private static final Pattern formatArgumentPlaceholderPattern = Pattern.compile("\\{(\\d+)}");

    FormatAnalyzer() {
    }

    FormatSpecification analyze(ExtensionContext context, String formatString) {
        List<MatchResult> matchResults = this.matchFormatArgumentPlaceholders(formatString);
        List<Integer> formatArgumentsOrder = this.extractTemplateArguments(context, matchResults);
        Pattern linePattern = this.prepareLinePattern(formatString, matchResults, formatArgumentsOrder);
        return new FormatSpecification(linePattern, formatArgumentsOrder);
    }

    private List<MatchResult> matchFormatArgumentPlaceholders(String formatString) {
        return formatArgumentPlaceholderPattern.matcher(formatString).results().collect(Collectors.toList());
    }

    private List<Integer> extractTemplateArguments(ExtensionContext context, List<MatchResult> matchingFormatArgumentPlaceholders) {
        int formatParameterCount;
        List<Integer> templateArguments = matchingFormatArgumentPlaceholders.stream().map(r -> {
            Preconditions.require(r.groupCount() == 1);
            return Integer.valueOf(r.group(1));
        }).collect(Collectors.toList());
        int methodParameterCount = this.getMethodParameterCount(context);
        Preconditions.require(methodParameterCount >= (formatParameterCount = templateArguments.size()), () -> "Number of method arguments is less than the number of format arguments");
        List expectedIndexes = IntStream.range(0, formatParameterCount).boxed().collect(Collectors.toList());
        boolean validArguments = new HashSet(templateArguments).containsAll(expectedIndexes) && templateArguments.size() == expectedIndexes.size();
        Preconditions.require(validArguments, () -> "Arguments provided in the format string are invalid: expected " + expectedIndexes + " but got " + templateArguments.stream().sorted().collect(Collectors.toList()));
        return templateArguments;
    }

    private Pattern prepareLinePattern(String formatString, List<MatchResult> matchingFormatArgumentPlaceholders, List<Integer> formatArgumentsOrder) {
        List<String> textParts = this.tokenize(formatString, matchingFormatArgumentPlaceholders);
        StringBuilder lineRegex = new StringBuilder();
        for (int i = 0; i < textParts.size(); ++i) {
            if (!textParts.get(i).isEmpty()) {
                lineRegex.append(Pattern.quote(textParts.get(i)));
            }
            if (i >= formatArgumentsOrder.size()) continue;
            FormatArgumentMatcherGroup group = new FormatArgumentMatcherGroup(formatArgumentsOrder.get(i));
            lineRegex.append(group.getRegex());
        }
        return Pattern.compile(lineRegex.toString());
    }

    private List<String> tokenize(String formatString, List<MatchResult> matchingFormatArgumentPlaceholders) {
        ArrayList<String> tokens = new ArrayList<String>();
        int startIndex = 0;
        for (MatchResult placeholder : matchingFormatArgumentPlaceholders) {
            int endIndex = placeholder.start();
            if (startIndex == endIndex) {
                tokens.add("");
            } else if (startIndex < formatString.length()) {
                String part = formatString.substring(startIndex, endIndex).strip();
                tokens.add(part);
            }
            startIndex = placeholder.end();
        }
        if (startIndex == formatString.length()) {
            tokens.add("");
        }
        return tokens;
    }

    private int getMethodParameterCount(ExtensionContext extensionContext) {
        return extensionContext.getRequiredTestMethod().getParameterCount();
    }
}

