/*
 * Decompiled with CFR 0.152.
 */
package com.mikemybytes.junit5.formatted;

import com.mikemybytes.junit5.formatted.ArgumentsExtractor;
import com.mikemybytes.junit5.formatted.FormatAnalyzer;
import com.mikemybytes.junit5.formatted.FormatSpecification;
import com.mikemybytes.junit5.formatted.FormattedSource;
import com.mikemybytes.junit5.formatted.FormattedSourceData;
import com.mikemybytes.junit5.formatted.Preconditions;
import com.mikemybytes.junit5.formatted.RawArgumentsProcessor;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.support.AnnotationConsumer;

class FormattedSourceArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<FormattedSource> {
    private FormattedSourceData sourceData;

    FormattedSourceArgumentsProvider() {
    }

    public void accept(FormattedSource annotation) {
        this.sourceData = FormattedSourceData.from(annotation);
    }

    public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
        Preconditions.require(this.sourceData != null);
        FormatSpecification specification = new FormatAnalyzer().analyze(context, this.sourceData.getFormatString());
        ArgumentsExtractor argumentsExtractor = new ArgumentsExtractor(this.sourceData, specification, RawArgumentsProcessor.passThrough());
        return this.sourceData.getLines().stream().map(argumentsExtractor::extract);
    }
}

