/*
 * Decompiled with CFR 0.152.
 */
package com.mikemybytes.junit5.formatted;

import com.mikemybytes.junit5.formatted.FormattedSource;
import com.mikemybytes.junit5.formatted.FormattedSourceTest;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

class FormattedSourceData {
    private final String formatString;
    private final List<String> lines;
    private final char quoteCharacter;

    static FormattedSourceData from(FormattedSource annotation) {
        List<String> lines = FormattedSourceData.extractLines(annotation.lines(), annotation.textBlock());
        return new FormattedSourceData(annotation.format(), lines, annotation.quoteCharacter());
    }

    static FormattedSourceData from(FormattedSourceTest annotation) {
        List<String> lines = FormattedSourceData.extractLines(annotation.lines(), annotation.textBlock());
        return new FormattedSourceData(annotation.format(), lines, annotation.quoteCharacter());
    }

    private static List<String> extractLines(String[] lines, String textBlock) {
        if (!textBlock.isEmpty()) {
            return textBlock.lines().collect(Collectors.toList());
        }
        return Arrays.asList(lines);
    }

    private FormattedSourceData(String formatString, List<String> lines, char quoteCharacter) {
        this.formatString = formatString;
        this.lines = lines;
        this.quoteCharacter = quoteCharacter;
    }

    String getFormatString() {
        return this.formatString;
    }

    List<String> getLines() {
        return this.lines;
    }

    char getQuoteCharacter() {
        return this.quoteCharacter;
    }
}

