/*
 * Decompiled with CFR 0.152.
 */
package com.mikemybytes.junit5.formatted;

import com.mikemybytes.junit5.formatted.FormattedSource;
import com.mikemybytes.junit5.formatted.FormattedSourceTest;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

class FormattedSourceData {
    private final String formatString;
    private final List<String> lines;
    private final char quoteCharacter;
    private final boolean ignoreWhitespaces;
    private final Set<String> nullValues;
    private final String emptyValue;

    static FormattedSourceData from(FormattedSource annotation) {
        List<String> lines = FormattedSourceData.extractLines(annotation.lines(), annotation.textBlock());
        return new FormattedSourceData(annotation.format(), lines, annotation.quoteCharacter(), annotation.ignoreLeadingAndTrailingWhitespace(), FormattedSourceData.toSet(annotation.nullValues()), annotation.emptyValue());
    }

    static FormattedSourceData from(FormattedSourceTest annotation) {
        List<String> lines = FormattedSourceData.extractLines(annotation.lines(), annotation.textBlock());
        return new FormattedSourceData(annotation.format(), lines, annotation.quoteCharacter(), annotation.ignoreLeadingAndTrailingWhitespace(), FormattedSourceData.toSet(annotation.nullValues()), annotation.emptyValue());
    }

    private static List<String> extractLines(String[] lines, String textBlock) {
        if (!textBlock.isEmpty()) {
            return textBlock.lines().collect(Collectors.toList());
        }
        return FormattedSourceData.toList(lines);
    }

    private static List<String> toList(String[] array) {
        return array != null ? Arrays.asList(array) : Collections.emptyList();
    }

    private static Set<String> toSet(String[] array) {
        return Set.copyOf(FormattedSourceData.toList(array));
    }

    private FormattedSourceData(String formatString, List<String> lines, char quoteCharacter, boolean ignoreWhitespaces, Set<String> nullValues, String emptyValue) {
        this.formatString = formatString;
        this.lines = lines;
        this.quoteCharacter = quoteCharacter;
        this.ignoreWhitespaces = ignoreWhitespaces;
        this.nullValues = nullValues;
        this.emptyValue = emptyValue;
    }

    String getFormatString() {
        return this.formatString;
    }

    List<String> getLines() {
        return this.lines;
    }

    char getQuoteCharacter() {
        return this.quoteCharacter;
    }

    public boolean isIgnoreWhitespaces() {
        return this.ignoreWhitespaces;
    }

    public Set<String> getNullValues() {
        return this.nullValues;
    }

    public String getEmptyValue() {
        return this.emptyValue;
    }
}

