/*
 * Decompiled with CFR 0.152.
 */
package com.mikemybytes.junit5.formatted;

import com.mikemybytes.junit5.formatted.FormatAnalyzer;
import com.mikemybytes.junit5.formatted.FormatSpecification;
import com.mikemybytes.junit5.formatted.LinePatternFactory;
import com.mikemybytes.junit5.formatted.Preconditions;
import java.util.HashSet;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class IndexedArgumentPlaceholdersFormatAnalyzer
implements FormatAnalyzer {
    private static final Pattern formatArgumentPlaceholderPattern = Pattern.compile("\\{(\\d+)}");

    IndexedArgumentPlaceholdersFormatAnalyzer() {
    }

    @Override
    public FormatSpecification analyze(String formatString, int methodParameterCount) {
        List<MatchResult> matchResults = this.matchFormatArgumentPlaceholders(formatString);
        List<Integer> formatArgumentsOrder = this.extractTemplateArguments(matchResults, methodParameterCount);
        Pattern linePattern = LinePatternFactory.create(formatString, matchResults, formatArgumentsOrder);
        return new FormatSpecification(linePattern, formatArgumentsOrder);
    }

    private List<MatchResult> matchFormatArgumentPlaceholders(String formatString) {
        return formatArgumentPlaceholderPattern.matcher(formatString).results().collect(Collectors.toList());
    }

    private List<Integer> extractTemplateArguments(List<MatchResult> matchingFormatArgumentPlaceholders, int methodParameterCount) {
        List<Integer> templateArguments = matchingFormatArgumentPlaceholders.stream().map(r -> {
            Preconditions.require(r.groupCount() == 1);
            return Integer.valueOf(r.group(1));
        }).collect(Collectors.toList());
        int formatParameterCount = templateArguments.size();
        Preconditions.require(methodParameterCount >= formatParameterCount, () -> "Number of method arguments is less than the number of format arguments");
        List expectedIndexes = IntStream.range(0, formatParameterCount).boxed().collect(Collectors.toList());
        boolean validArguments = new HashSet(templateArguments).containsAll(expectedIndexes) && templateArguments.size() == expectedIndexes.size();
        Preconditions.require(validArguments, () -> "Arguments provided in the format string are invalid: expected " + expectedIndexes + " but got " + templateArguments.stream().sorted().collect(Collectors.toList()));
        return templateArguments;
    }
}

