/*
 * Decompiled with CFR 0.152.
 */
package com.mikemybytes.junit5.formatted;

import com.mikemybytes.junit5.formatted.FormatArgumentMatcherGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

class LinePatternFactory {
    private LinePatternFactory() {
    }

    static Pattern create(String formatString, List<MatchResult> matchingFormatArgumentPlaceholders, List<Integer> formatArgumentsOrder) {
        List<String> textParts = LinePatternFactory.tokenize(formatString, matchingFormatArgumentPlaceholders);
        StringBuilder lineRegex = new StringBuilder();
        for (int i = 0; i < textParts.size(); ++i) {
            if (!textParts.get(i).isEmpty()) {
                lineRegex.append(Pattern.quote(textParts.get(i)));
            }
            if (i >= formatArgumentsOrder.size()) continue;
            FormatArgumentMatcherGroup group = new FormatArgumentMatcherGroup(formatArgumentsOrder.get(i));
            lineRegex.append(group.getRegex());
        }
        return Pattern.compile(lineRegex.toString());
    }

    private static List<String> tokenize(String formatString, List<MatchResult> matchingFormatArgumentPlaceholders) {
        ArrayList<String> tokens = new ArrayList<String>();
        int startIndex = 0;
        for (MatchResult placeholder : matchingFormatArgumentPlaceholders) {
            int endIndex = placeholder.start();
            if (startIndex == endIndex) {
                tokens.add("");
            } else if (startIndex < formatString.length()) {
                String part = formatString.substring(startIndex, endIndex);
                tokens.add(part);
            }
            startIndex = placeholder.end();
        }
        if (startIndex == formatString.length()) {
            tokens.add("");
        } else {
            tokens.add(formatString.substring(startIndex));
        }
        return tokens;
    }
}

