/*
 * Decompiled with CFR 0.152.
 */
package com.mikemybytes.junit5.formatted;

import com.mikemybytes.junit5.formatted.FormatAnalyzer;
import com.mikemybytes.junit5.formatted.FormatSpecification;
import com.mikemybytes.junit5.formatted.LinePatternFactory;
import com.mikemybytes.junit5.formatted.Preconditions;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class PositionalArgumentPlaceholdersFormatAnalyzer
implements FormatAnalyzer {
    private final String argumentPlaceholder;

    PositionalArgumentPlaceholdersFormatAnalyzer(String argumentPlaceholder) {
        this.argumentPlaceholder = argumentPlaceholder;
    }

    @Override
    public FormatSpecification analyze(String formatString, int methodParameterCount) {
        List<MatchResult> matchResults = this.matchFormatArgumentPlaceholders(formatString);
        int formatParameterCount = matchResults.size();
        Preconditions.require(methodParameterCount >= formatParameterCount, () -> "Number of method arguments is less than the number of format arguments");
        List<Integer> formatArgumentsOrder = IntStream.range(0, formatParameterCount).boxed().collect(Collectors.toList());
        Pattern linePattern = LinePatternFactory.create(formatString, matchResults, formatArgumentsOrder);
        return new FormatSpecification(linePattern, formatArgumentsOrder);
    }

    private List<MatchResult> matchFormatArgumentPlaceholders(String formatString) {
        return Pattern.compile(Pattern.quote(this.argumentPlaceholder)).matcher(formatString).results().collect(Collectors.toList());
    }
}

