/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries;

import com.mikepenz.aboutlibraries.entity.Library;
import com.mikepenz.aboutlibraries.entity.License;
import com.mikepenz.aboutlibraries.util.AndroidParserKt;
import com.mikepenz.aboutlibraries.util.Result;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u0017B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J)\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/mikepenz/aboutlibraries/Libs;", "", "libraries", "", "Lcom/mikepenz/aboutlibraries/entity/Library;", "licenses", "", "Lcom/mikepenz/aboutlibraries/entity/License;", "(Ljava/util/List;Ljava/util/Set;)V", "getLibraries", "()Ljava/util/List;", "getLicenses", "()Ljava/util/Set;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Builder", "aboutlibraries-core_debug"})
public final class Libs {
    @NotNull
    private final List<Library> libraries;
    @NotNull
    private final Set<License> licenses;

    public Libs(@NotNull List<Library> libraries2, @NotNull Set<License> licenses2) {
        Intrinsics.checkNotNullParameter(libraries2, (String)"libraries");
        Intrinsics.checkNotNullParameter(licenses2, (String)"licenses");
        this.libraries = libraries2;
        this.licenses = licenses2;
    }

    @NotNull
    public final List<Library> getLibraries() {
        return this.libraries;
    }

    @NotNull
    public final Set<License> getLicenses() {
        return this.licenses;
    }

    @NotNull
    public final List<Library> component1() {
        return this.libraries;
    }

    @NotNull
    public final Set<License> component2() {
        return this.licenses;
    }

    @NotNull
    public final Libs copy(@NotNull List<Library> libraries2, @NotNull Set<License> licenses2) {
        Intrinsics.checkNotNullParameter(libraries2, (String)"libraries");
        Intrinsics.checkNotNullParameter(licenses2, (String)"licenses");
        return new Libs(libraries2, licenses2);
    }

    public static /* synthetic */ Libs copy$default(Libs libs, List list, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            list = libs.libraries;
        }
        if ((n & 2) != 0) {
            set = libs.licenses;
        }
        return libs.copy(list, set);
    }

    @NotNull
    public String toString() {
        return "Libs(libraries=" + this.libraries + ", licenses=" + this.licenses + ")";
    }

    public int hashCode() {
        int result = ((Object)this.libraries).hashCode();
        result = result * 31 + ((Object)this.licenses).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Libs)) {
            return false;
        }
        Libs libs = (Libs)other;
        if (!Intrinsics.areEqual(this.libraries, libs.libraries)) {
            return false;
        }
        return Intrinsics.areEqual(this.licenses, libs.licenses);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/mikepenz/aboutlibraries/Libs$Builder;", "", "()V", "_stringData", "", "build", "Lcom/mikepenz/aboutlibraries/Libs;", "withJson", "stringData", "aboutlibraries-core_debug"})
    public static final class Builder {
        @Nullable
        private String _stringData;

        @NotNull
        public final Builder withJson(@NotNull String stringData) {
            Intrinsics.checkNotNullParameter((Object)stringData, (String)"stringData");
            this._stringData = stringData;
            return this;
        }

        @NotNull
        public final Libs build() {
            String data = this._stringData;
            if (data == null) {
                throw new IllegalStateException("Please provide the required library data via the available APIs.\nDepending on the platform this can be done for example via `LibsBuilder().withJson()`.\nFor Android there exists an `LibsBuilder.withContext()`, automatically loading the `aboutlibraries.json` file from the `raw` resources folder.\nWhen using compose or other parent modules, please check their corresponding APIs.");
            }
            Result result = AndroidParserKt.parseData(data);
            List<Library> libraries2 = result.component1();
            List<License> licenses2 = result.component2();
            Iterable $this$sortedBy$iv = libraries2;
            boolean $i$f$sortedBy = false;
            return new Libs(CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Library it = (Library)a;
                    boolean bl = false;
                    String string = it.getName().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    it = (Library)b;
                    Comparable comparable = (Comparable)((Object)string);
                    bl = false;
                    String string2 = it.getName().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string2)));
                }
            }), CollectionsKt.toMutableSet((Iterable)licenses2));
        }
    }
}

