/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries.util;

import android.content.Context;
import android.util.Log;
import com.mikepenz.aboutlibraries.Libs;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\u001a3\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\u0004\u0018\u00010\u00032\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00020\u0005\u00a2\u0006\u0002\b\u0007H\u0000\u001aH\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\u0004\u0018\u00010\u00062,\u0010\u0004\u001a(\u0012\u0004\u0012\u00020\u0006\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u0002H\u00020\b\u00a2\u0006\u0002\b\u0007H\u0000\u001a3\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\u0004\u0018\u00010\u00032\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002H\u00020\u0005\u00a2\u0006\u0002\b\u0007H\u0000\u001a\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0000\u001a\u0012\u0010\u0012\u001a\u00020\u0013*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010\u001a\u001a\u0010\u0015\u001a\u00020\u0013*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u000f\u001a\u0012\u0010\u0015\u001a\u00020\u0013*\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018\u00a8\u0006\u0019"}, d2={"forEachObject", "", "T", "Lorg/json/JSONArray;", "block", "Lkotlin/Function1;", "Lorg/json/JSONObject;", "Lkotlin/ExtensionFunctionType;", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "key", "forEachString", "getRawResourceId", "", "Landroid/content/Context;", "aString", "withContext", "Lcom/mikepenz/aboutlibraries/Libs$Builder;", "ctx", "withJson", "rawResId", "byteArray", "", "aboutlibraries-core_debug"})
public final class AndroidExtensionsKt {
    @NotNull
    public static final Libs.Builder withJson(@NotNull Libs.Builder $this$withJson, @NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)$this$withJson, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        return $this$withJson.withJson(new String(byteArray, Charsets.UTF_8));
    }

    @NotNull
    public static final Libs.Builder withContext(@NotNull Libs.Builder $this$withContext, @NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)$this$withContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return AndroidExtensionsKt.withJson($this$withContext, ctx, AndroidExtensionsKt.getRawResourceId(ctx, "aboutlibraries"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Libs.Builder withJson(@NotNull Libs.Builder $this$withJson, @NotNull Context ctx, int rawResId) {
        Intrinsics.checkNotNullParameter((Object)$this$withJson, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        try {
            InputStream inputStream = ctx.getResources().openRawResource(rawResId);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"ctx.resources.openRawResource(rawResId)");
            Closeable closeable = inputStream;
            Object object = Charsets.UTF_8;
            Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
            int n = 8192;
            closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
            Libs.Builder builder = $this$withJson;
            object = null;
            try {
                BufferedReader it = (BufferedReader)closeable;
                boolean bl = false;
                object2 = TextStreamsKt.readText((Reader)it);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
            builder.withJson((String)object2);
        }
        catch (Throwable t) {
            Log.e((String)"AboutLibraries", (String)"Unable to retrieve library information given the `raw` resource identifier. \nPlease make sure either the gradle plugin is properly set up, or the file is manually provided. ");
            System.out.println((Object)"Could not retrieve libraries");
        }
        return $this$withJson;
    }

    public static final int getRawResourceId(@NotNull Context $this$getRawResourceId, @NotNull String aString) {
        Intrinsics.checkNotNullParameter((Object)$this$getRawResourceId, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)aString, (String)"aString");
        return $this$getRawResourceId.getResources().getIdentifier(aString, "raw", $this$getRawResourceId.getPackageName());
    }

    @NotNull
    public static final <T> List<T> forEachObject(@Nullable JSONArray $this$forEachObject, @NotNull Function1<? super JSONObject, ? extends T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if ($this$forEachObject == null) {
            return CollectionsKt.emptyList();
        }
        List targetList = new ArrayList();
        int n = $this$forEachObject.length();
        for (int il = 0; il < n; ++il) {
            JSONObject jSONObject = $this$forEachObject.getJSONObject(il);
            Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"getJSONObject(il)");
            Object obj = block.invoke((Object)jSONObject);
            if (obj == null) continue;
            targetList.add(obj);
        }
        return targetList;
    }

    @NotNull
    public static final <T> List<T> forEachString(@Nullable JSONArray $this$forEachString, @NotNull Function1<? super String, ? extends T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if ($this$forEachString == null) {
            return CollectionsKt.emptyList();
        }
        List targetList = new ArrayList();
        int n = $this$forEachString.length();
        for (int il = 0; il < n; ++il) {
            String string = $this$forEachString.getString(il);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(il)");
            targetList.add(block.invoke((Object)string));
        }
        return targetList;
    }

    @NotNull
    public static final <T> List<T> forEachObject(@Nullable JSONObject $this$forEachObject, @NotNull Function2<? super JSONObject, ? super String, ? extends T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if ($this$forEachObject == null) {
            return CollectionsKt.emptyList();
        }
        List targetList = new ArrayList();
        Iterator iterator = $this$forEachObject.keys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"keys()");
        Iterator $this$forEach$iv = iterator;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            String it = (String)element$iv;
            boolean bl = false;
            JSONObject jSONObject = $this$forEachObject.getJSONObject(it);
            Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"getJSONObject(it)");
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            targetList.add(block.invoke((Object)jSONObject, (Object)it));
        }
        return targetList;
    }
}

