/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries.util;

import android.util.Log;
import com.mikepenz.aboutlibraries.entity.Developer;
import com.mikepenz.aboutlibraries.entity.Library;
import com.mikepenz.aboutlibraries.entity.License;
import com.mikepenz.aboutlibraries.entity.Organization;
import com.mikepenz.aboutlibraries.entity.Scm;
import com.mikepenz.aboutlibraries.util.AndroidExtensionsKt;
import com.mikepenz.aboutlibraries.util.AndroidParserKt;
import com.mikepenz.aboutlibraries.util.Result;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"parseData", "Lcom/mikepenz/aboutlibraries/util/Result;", "json", "", "aboutlibraries-core_debug"})
public final class AndroidParserKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Result parseData(@NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        try {
            void $this$associateByTo$iv$iv;
            JSONObject metaData = new JSONObject(json);
            List<License> licenses2 = AndroidExtensionsKt.forEachObject(metaData.getJSONObject("licenses"), parseData.licenses.1.INSTANCE);
            Iterable $this$associateBy$iv = licenses2;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                License license = (License)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                map.put(it.getHash(), element$iv$iv);
            }
            Map mappedLicenses = destination$iv$iv;
            List<Library> libraries2 = AndroidExtensionsKt.forEachObject(metaData.getJSONArray("libraries"), (Function1)new Function1<JSONObject, Library>((Map<String, License>)mappedLicenses){
                final /* synthetic */ Map<String, License> $mappedLicenses;
                {
                    this.$mappedLicenses = $mappedLicenses;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Library invoke(@NotNull JSONObject $this$forEachObject) {
                    Scm scm;
                    Organization organization;
                    void $this$mapNotNullTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)$this$forEachObject, (String)"$this$forEachObject");
                    Iterable $this$mapNotNull$iv = AndroidExtensionsKt.forEachString($this$forEachObject.optJSONArray("licenses"), (Function1)new Function1<String, License>(this.$mappedLicenses){
                        final /* synthetic */ Map<String, License> $mappedLicenses;
                        {
                            this.$mappedLicenses = $mappedLicenses;
                            super(1);
                        }

                        @Nullable
                        public final License invoke(@NotNull String $this$forEachString) {
                            Intrinsics.checkNotNullParameter((Object)$this$forEachString, (String)"$this$forEachString");
                            return this.$mappedLicenses.get($this$forEachString);
                        }
                    });
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        License it$iv$iv;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        License it = (License)element$iv$iv;
                        boolean bl2 = false;
                        if (it == null) continue;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    HashSet libLicenses2 = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
                    List<Developer> developers2 = AndroidExtensionsKt.forEachObject($this$forEachObject.optJSONArray("developers"), parseData.libraries.developers.1.INSTANCE);
                    JSONObject jSONObject = $this$forEachObject.optJSONObject("organization");
                    if (jSONObject != null) {
                        JSONObject it = jSONObject;
                        boolean bl = false;
                        String string = it.getString("name");
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.getString(\"name\")");
                        organization = new Organization(string, it.optString("url"));
                    } else {
                        organization = null;
                    }
                    Organization organization2 = organization;
                    JSONObject jSONObject2 = $this$forEachObject.optJSONObject("scm");
                    if (jSONObject2 != null) {
                        JSONObject it = jSONObject2;
                        boolean bl = false;
                        scm = new Scm(it.optString("connection"), it.optString("developerConnection"), it.optString("url"));
                    } else {
                        scm = null;
                    }
                    Scm scm2 = scm;
                    Set funding2 = CollectionsKt.toSet((Iterable)AndroidExtensionsKt.forEachObject($this$forEachObject.optJSONArray("funding"), parseData.libraries.funding.1.INSTANCE));
                    String string = $this$forEachObject.getString("uniqueId");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(\"uniqueId\")");
                    String string2 = $this$forEachObject.optString("artifactVersion");
                    String string3 = $this$forEachObject.getString("name");
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(\"name\")");
                    return new Library(string, string2, string3, $this$forEachObject.optString("description"), $this$forEachObject.optString("website"), developers2, organization2, scm2, libLicenses2, funding2, $this$forEachObject.optString("tag"));
                }
            });
            return new Result(libraries2, licenses2);
        }
        catch (Throwable t) {
            Log.e((String)"AboutLibraries", (String)("Failed to parse the meta data *.json file: " + t));
            return new Result(CollectionsKt.emptyList(), CollectionsKt.emptyList());
        }
    }
}

