/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries.util;

import android.util.Log;
import com.mikepenz.aboutlibraries.entity.Developer;
import com.mikepenz.aboutlibraries.entity.Funding;
import com.mikepenz.aboutlibraries.entity.Library;
import com.mikepenz.aboutlibraries.entity.License;
import com.mikepenz.aboutlibraries.entity.Organization;
import com.mikepenz.aboutlibraries.entity.Scm;
import com.mikepenz.aboutlibraries.util.AndroidExtensionsKt;
import com.mikepenz.aboutlibraries.util.Result;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.ImmutableList;
import kotlinx.collections.immutable.ImmutableSet;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"parseData", "Lcom/mikepenz/aboutlibraries/util/Result;", "json", "", "aboutlibraries-core_release"})
@SourceDebugExtension(value={"SMAP\nAndroidParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidParser.kt\ncom/mikepenz/aboutlibraries/util/AndroidParserKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1208#2,2:71\n1236#2,4:73\n1617#2,9:77\n1869#2:86\n1870#2:88\n1626#2:89\n1#3:87\n*S KotlinDebug\n*F\n+ 1 AndroidParser.kt\ncom/mikepenz/aboutlibraries/util/AndroidParserKt\n*L\n28#1:71,2\n28#1:73,4\n31#1:77,9\n31#1:86\n31#1:88\n31#1:89\n31#1:87\n*E\n"})
public final class AndroidParserKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Result parseData(@NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        try {
            void $this$associateByTo$iv$iv;
            JSONObject metaData = new JSONObject(json);
            List<License> licenses = AndroidExtensionsKt.forEachObject(metaData.getJSONObject("licenses"), AndroidParserKt::parseData$lambda$0);
            Iterable $this$associateBy$iv = licenses;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                License license = (License)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                map.put(it.getHash(), element$iv$iv);
            }
            Map mappedLicenses = destination$iv$iv;
            List<Library> libraries = AndroidExtensionsKt.forEachObject(metaData.getJSONArray("libraries"), arg_0 -> AndroidParserKt.parseData$lambda$8(mappedLicenses, arg_0));
            return new Result(libraries, licenses);
        }
        catch (Throwable t) {
            Log.e((String)"AboutLibraries", (String)("Failed to parse the meta data *.json file: " + t));
            return new Result(CollectionsKt.emptyList(), CollectionsKt.emptyList());
        }
    }

    private static final License parseData$lambda$0(JSONObject $this$forEachObject, String key) {
        Intrinsics.checkNotNullParameter((Object)$this$forEachObject, (String)"$this$forEachObject");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = $this$forEachObject.getString("name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return new License(string, $this$forEachObject.optString("url"), $this$forEachObject.optString("year"), $this$forEachObject.optString("spdxId"), $this$forEachObject.optString("content"), key);
    }

    private static final License parseData$lambda$8$lambda$2(Map $mappedLicenses, String $this$forEachString) {
        Intrinsics.checkNotNullParameter((Object)$this$forEachString, (String)"$this$forEachString");
        return (License)$mappedLicenses.get($this$forEachString);
    }

    private static final Developer parseData$lambda$8$lambda$4(JSONObject $this$forEachObject) {
        Intrinsics.checkNotNullParameter((Object)$this$forEachObject, (String)"$this$forEachObject");
        return new Developer($this$forEachObject.optString("name"), $this$forEachObject.optString("organisationUrl"));
    }

    private static final Funding parseData$lambda$8$lambda$7(JSONObject $this$forEachObject) {
        Intrinsics.checkNotNullParameter((Object)$this$forEachObject, (String)"$this$forEachObject");
        String string = $this$forEachObject.getString("platform");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        String string2 = $this$forEachObject.getString("url");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        return new Funding(string, string2);
    }

    /*
     * WARNING - void declaration
     */
    private static final Library parseData$lambda$8(Map $mappedLicenses, JSONObject $this$forEachObject) {
        Scm scm;
        Organization organization;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$forEachObject, (String)"$this$forEachObject");
        Iterable $this$mapNotNull$iv = AndroidExtensionsKt.forEachString($this$forEachObject.optJSONArray("licenses"), arg_0 -> AndroidParserKt.parseData$lambda$8$lambda$2($mappedLicenses, arg_0));
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            License it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            License it = (License)element$iv$iv;
            boolean bl2 = false;
            if (it == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        HashSet libLicenses = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
        Object object = $this$forEachObject.optJSONArray("developers");
        if (object == null || (object = AndroidExtensionsKt.forEachObject(object, AndroidParserKt::parseData$lambda$8$lambda$4)) == null) {
            object = CollectionsKt.emptyList();
        }
        Object developers = object;
        JSONObject jSONObject = $this$forEachObject.optJSONObject("organization");
        if (jSONObject != null) {
            JSONObject it = jSONObject;
            boolean bl = false;
            String string = it.optString("name");
            if (string == null) {
                string = "";
            }
            organization = new Organization(string, it.optString("url"));
        } else {
            organization = null;
        }
        Organization organization2 = organization;
        JSONObject jSONObject2 = $this$forEachObject.optJSONObject("scm");
        if (jSONObject2 != null) {
            JSONObject it = jSONObject2;
            boolean bl = false;
            scm = new Scm(it.optString("connection"), it.optString("developerConnection"), it.optString("url"));
        } else {
            scm = null;
        }
        Scm scm2 = scm;
        Set funding = CollectionsKt.toSet((Iterable)AndroidExtensionsKt.forEachObject($this$forEachObject.optJSONArray("funding"), AndroidParserKt::parseData$lambda$8$lambda$7));
        String id = $this$forEachObject.getString("uniqueId");
        Intrinsics.checkNotNull((Object)id);
        String string = $this$forEachObject.optString("artifactVersion");
        String string2 = $this$forEachObject.optString("name", id);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"optString(...)");
        return new Library(id, string, string2, $this$forEachObject.optString("description"), $this$forEachObject.optString("website"), (ImmutableList<Developer>)ExtensionsKt.toImmutableList((Iterable)((Iterable)developers)), organization2, scm2, (ImmutableSet<License>)ExtensionsKt.toImmutableSet((Iterable)libLicenses), (ImmutableSet<Funding>)ExtensionsKt.toImmutableSet((Iterable)funding), $this$forEachObject.optString("tag"));
    }
}

