package com.mikepenz.aboutlibraries

import org.junit.Test
import kotlin.test.assertEquals

class JvmLibsTest {

    @Test
    fun testLibsParsing() {

        val result = Libs.Builder().withJson(json).build()

        assertEquals(70, result.libraries.size)
        assertEquals(7, result.licenses.size)
    }

    val json = """
        {"libraries":[{"uniqueId":"androidx.databinding:viewbinding","developer":[],"artifactVersion":"7.0.3","description":"","name":"androidx.databinding:viewbinding","openSource":false,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.annotation:annotation","developer":[],"artifactVersion":"1.2.0","description":"The Support Library is a static library that you can add to your Android application in order to use APIs that are either not available for older platform versions or utility APIs that aren't a part of the framework APIs.","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"https://cs.android.com/androidx/platform/frameworks/support"},"name":"Support Annotations","website":"https://developer.android.com/jetpack/androidx/releases/annotation#1.2.0","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"com.mikepenz:materialdrawer","funding":[{"platform":"GITHUB","url":"https://github.com/mikepenz"}],"developer":[],"artifactVersion":"8.4.3","description":"The flexible, easy to use, all in one drawer library for your Android project.","scm":{"connection":"scm:git@github.com:mikepenz/MaterialDrawer.git","url":"https://github.com/mikepenz/MaterialDrawer","developerConnection":"scm:git@github.com:mikepenz/MaterialDrawer.git"},"name":"MaterialDrawer Library","website":"https://github.com/mikepenz/MaterialDrawer","openSource":true,"licenses":["e03770b69fb2a7733eeb9207a2c184ad","293690fb30161eb556054896cb84ef3a"]},{"uniqueId":"org.jetbrains.kotlin:kotlin-stdlib-jdk8","developer":[],"artifactVersion":"1.5.31","description":"Kotlin Standard Library JDK 8 extension","scm":{"connection":"scm:git:https://github.com/JetBrains/kotlin.git","url":"https://github.com/JetBrains/kotlin","developerConnection":"scm:git:https://github.com/JetBrains/kotlin.git"},"name":"Kotlin Stdlib Jdk8","website":"https://kotlinlang.org/","openSource":true,"licenses":["e69365f226b0862743475f0d338bd919"]},{"uniqueId":"org.jetbrains.kotlin:kotlin-stdlib-jdk7","developer":[],"artifactVersion":"1.5.31","description":"Kotlin Standard Library JDK 7 extension","scm":{"connection":"scm:git:https://github.com/JetBrains/kotlin.git","url":"https://github.com/JetBrains/kotlin","developerConnection":"scm:git:https://github.com/JetBrains/kotlin.git"},"name":"Kotlin Stdlib Jdk7","website":"https://kotlinlang.org/","openSource":true,"licenses":["e69365f226b0862743475f0d338bd919"]},{"uniqueId":"org.jetbrains.kotlin:kotlin-stdlib","developer":[],"artifactVersion":"1.5.31","description":"Kotlin Standard Library for JVM","scm":{"connection":"scm:git:https://github.com/JetBrains/kotlin.git","url":"https://github.com/JetBrains/kotlin","developerConnection":"scm:git:https://github.com/JetBrains/kotlin.git"},"name":"Kotlin Stdlib","website":"https://kotlinlang.org/","openSource":true,"licenses":["e69365f226b0862743475f0d338bd919"]},{"uniqueId":"org.jetbrains:annotations","developer":[],"artifactVersion":"13.0","description":"A set of annotations used for code inspection support and code documentation.","scm":{"connection":"scm:git:https://github.com/JetBrains/intellij-community.git","url":"https://github.com/JetBrains/intellij-community"},"name":"IntelliJ IDEA Annotations","website":"http://www.jetbrains.org","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"org.jetbrains.kotlin:kotlin-stdlib-common","developer":[],"artifactVersion":"1.5.31","description":"Kotlin Common Standard Library","scm":{"connection":"scm:git:https://github.com/JetBrains/kotlin.git","url":"https://github.com/JetBrains/kotlin","developerConnection":"scm:git:https://github.com/JetBrains/kotlin.git"},"name":"Kotlin Stdlib Common","website":"https://kotlinlang.org/","openSource":true,"licenses":["e69365f226b0862743475f0d338bd919"]},{"uniqueId":"com.mikepenz:fastadapter","developer":[],"artifactVersion":"5.4.1","description":"The bullet proof, fast and easy to use adapter library, which minimizes developing time to a fraction...","scm":{"connection":"scm:git@github.com:mikepenz/FastAdapter.git","url":"https://github.com/mikepenz/FastAdapter","developerConnection":"scm:git@github.com:mikepenz/FastAdapter.git"},"name":"FastAdapter Library","website":"https://github.com/mikepenz/FastAdapter","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304","161d4ad861a65c64da5d779d72863440"]},{"uniqueId":"androidx.recyclerview:recyclerview","developer":[],"artifactVersion":"1.2.1","description":"Android Support RecyclerView","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"https://cs.android.com/androidx/platform/frameworks/support"},"name":"Support RecyclerView","website":"https://developer.android.com/jetpack/androidx/releases/recyclerview#1.2.1","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.customview:customview","developer":[],"artifactVersion":"1.1.0","description":"The Support Library is a static library that you can add to your Android application in order to use APIs that are either not available for older platform versions or utility APIs that aren't a part of the framework APIs. Compatible on devices running API 14 or later.","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"http://source.android.com"},"name":"Support Custom View","website":"https://developer.android.com/jetpack/androidx","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.core:core","developer":[],"artifactVersion":"1.6.0","description":"The Support Library is a static library that you can add to your Android application in order to use APIs that are either not available for older platform versions or utility APIs that aren't a part of the framework APIs. Compatible on devices running API 14 or later.","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"https://cs.android.com/androidx/platform/frameworks/support"},"name":"Support compat","website":"https://developer.android.com/jetpack/androidx/releases/core#1.6.0","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.lifecycle:lifecycle-runtime","developer":[],"artifactVersion":"2.3.1","description":"Android Lifecycle Runtime","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"https://cs.android.com/androidx/platform/frameworks/support"},"name":"Android Lifecycle Runtime","website":"https://developer.android.com/jetpack/androidx/releases/lifecycle#2.3.1","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.lifecycle:lifecycle-common","developer":[],"artifactVersion":"2.3.1","description":"Android Lifecycle-Common","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"https://cs.android.com/androidx/platform/frameworks/support"},"name":"Android Lifecycle-Common","website":"https://developer.android.com/jetpack/androidx/releases/lifecycle#2.3.1","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.arch.core:core-common","developer":[],"artifactVersion":"2.1.0","description":"Android Arch-Common","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"http://source.android.com"},"name":"Android Arch-Common","website":"https://developer.android.com/topic/libraries/architecture/index.html","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.versionedparcelable:versionedparcelable","developer":[],"artifactVersion":"1.1.1","description":"Provides a stable but relatively compact binary serialization format that can be passed across processes or persisted safely.","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"http://source.android.com"},"name":"VersionedParcelable","website":"http://developer.android.com/tools/extras/support-library.html","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.collection:collection","developer":[],"artifactVersion":"1.1.0","description":"Standalone efficient collections.","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"http://source.android.com"},"name":"Support collections","website":"http://developer.android.com/tools/extras/support-library.html","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.annotation:annotation-experimental","developer":[],"artifactVersion":"1.1.0","description":"Java annotation for use on unstable Android API surfaces. When used in conjunction with the Experimental annotation lint checks, this annotation provides functional parity with Kotlin's Experimental annotation.","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"https://cs.android.com/androidx/platform/frameworks/support"},"name":"Experimental annotation","website":"https://developer.android.com/jetpack/androidx/releases/annotation#1.1.0","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.appcompat:appcompat","developer":[],"artifactVersion":"1.3.1","description":"The Support Library is a static library that you can add to your Android application in order to use APIs that are either not available for older platform versions or utility APIs that aren't a part of the framework APIs. Compatible on devices running API 14 or later.","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"https://cs.android.com/androidx/platform/frameworks/support"},"name":"Android AppCompat Library","website":"https://developer.android.com/jetpack/androidx/releases/appcompat#1.3.1","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.fragment:fragment","developer":[],"artifactVersion":"1.3.6","description":"The Support Library is a static library that you can add to your Android application in order to use APIs that are either not available for older platform versions or utility APIs that aren't a part of the framework APIs. Compatible on devices running API 14 or later.","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"https://cs.android.com/androidx/platform/frameworks/support"},"name":"Support fragment","website":"https://developer.android.com/jetpack/androidx/releases/fragment#1.3.6","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.viewpager:viewpager","developer":[],"artifactVersion":"1.0.0","description":"The Support Library is a static library that you can add to your Android application in order to use APIs that are either not available for older platform versions or utility APIs that aren't a part of the framework APIs. Compatible on devices running API 14 or later.","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"http://source.android.com"},"name":"Support View Pager","website":"http://developer.android.com/tools/extras/support-library.html","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.activity:activity","developer":[],"artifactVersion":"1.2.4","description":"Provides the base Activity subclass and the relevant hooks to build a composable structure on top.","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"https://cs.android.com/androidx/platform/frameworks/support"},"name":"Activity","website":"https://developer.android.com/jetpack/androidx/releases/activity#1.2.4","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.lifecycle:lifecycle-viewmodel-savedstate","developer":[],"artifactVersion":"2.3.1","description":"Android Lifecycle ViewModel","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"https://cs.android.com/androidx/platform/frameworks/support"},"name":"Android Lifecycle ViewModel with SavedState","website":"https://developer.android.com/jetpack/androidx/releases/lifecycle#2.3.1","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.savedstate:savedstate","developer":[],"artifactVersion":"1.1.0","description":"Provides the base Activity subclass and the relevant hooks to build a composable structure on top.","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"https://cs.android.com/androidx/platform/frameworks/support"},"name":"Activity","website":"https://developer.android.com/jetpack/androidx/releases/savedstate#1.1.0","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.lifecycle:lifecycle-viewmodel","developer":[],"artifactVersion":"2.3.1","description":"Android Lifecycle ViewModel","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"https://cs.android.com/androidx/platform/frameworks/support"},"name":"Android Lifecycle ViewModel","website":"https://developer.android.com/jetpack/androidx/releases/lifecycle#2.3.1","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.lifecycle:lifecycle-livedata-core","developer":[],"artifactVersion":"2.3.1","description":"Android Lifecycle LiveData Core","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"https://cs.android.com/androidx/platform/frameworks/support"},"name":"Android Lifecycle LiveData Core","website":"https://developer.android.com/jetpack/androidx/releases/lifecycle#2.3.1","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.loader:loader","developer":[],"artifactVersion":"1.0.0","description":"The Support Library is a static library that you can add to your Android application in order to use APIs that are either not available for older platform versions or utility APIs that aren't a part of the framework APIs. Compatible on devices running API 14 or later.","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"http://source.android.com"},"name":"Support loader","website":"http://developer.android.com/tools/extras/support-library.html","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.lifecycle:lifecycle-livedata","developer":[],"artifactVersion":"2.0.0","description":"Android Lifecycle LiveData","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"http://source.android.com"},"name":"Android Lifecycle LiveData","website":"https://developer.android.com/topic/libraries/architecture/index.html","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.arch.core:core-runtime","developer":[],"artifactVersion":"2.1.0","description":"Android Arch-Runtime","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"http://source.android.com"},"name":"Android Arch-Runtime","website":"https://developer.android.com/topic/libraries/architecture/index.html","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.appcompat:appcompat-resources","developer":[],"artifactVersion":"1.3.1","description":"The Resources Library is a static library that you can add to your Android application in order to use resource APIs that backport the latest APIs to older versions of the platform. Compatible on devices running API 14 or later.","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"https://cs.android.com/androidx/platform/frameworks/support"},"name":"Android Resources Library","website":"https://developer.android.com/jetpack/androidx/releases/appcompat#1.3.1","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.vectordrawable:vectordrawable-animated","developer":[],"artifactVersion":"1.1.0","description":"Android Support AnimatedVectorDrawable","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"http://source.android.com"},"name":"Support AnimatedVectorDrawable","website":"https://developer.android.com/jetpack/androidx","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.vectordrawable:vectordrawable","developer":[],"artifactVersion":"1.1.0","description":"Android Support VectorDrawable","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"http://source.android.com"},"name":"Support VectorDrawable","website":"https://developer.android.com/jetpack/androidx","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.interpolator:interpolator","developer":[],"artifactVersion":"1.0.0","description":"The Support Library is a static library that you can add to your Android application in order to use APIs that are either not available for older platform versions or utility APIs that aren't a part of the framework APIs. Compatible on devices running API 14 or later.","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"http://source.android.com"},"name":"Support Interpolators","website":"http://developer.android.com/tools/extras/support-library.html","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.drawerlayout:drawerlayout","developer":[],"artifactVersion":"1.1.1","description":"The Support Library is a static library that you can add to your Android application in order to use APIs that are either not available for older platform versions or utility APIs that aren't a part of the framework APIs. Compatible on devices running API 14 or later.","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"http://source.android.com"},"name":"Support Drawer Layout","website":"https://developer.android.com/jetpack/androidx","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.cursoradapter:cursoradapter","developer":[],"artifactVersion":"1.0.0","description":"The Support Library is a static library that you can add to your Android application in order to use APIs that are either not available for older platform versions or utility APIs that aren't a part of the framework APIs. Compatible on devices running API 14 or later.","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"http://source.android.com"},"name":"Support Cursor Adapter","website":"http://developer.android.com/tools/extras/support-library.html","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"com.mikepenz:fastadapter-extensions-expandable","developer":[],"artifactVersion":"5.4.1","description":"Commons extension for the FastAdapter library. The bullet proof, fast and easy to use adapter library.","scm":{"connection":"scm:git@github.com:mikepenz/FastAdapter.git","url":"https://github.com/mikepenz/FastAdapter","developerConnection":"scm:git@github.com:mikepenz/FastAdapter.git"},"name":"FastAdapter Library-Extensions-Expandable","website":"https://github.com/mikepenz/FastAdapter","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304","161d4ad861a65c64da5d779d72863440"]},{"uniqueId":"com.mikepenz:iconics-core","developer":[],"artifactVersion":"5.3.1","description":"Android-Iconics Library","scm":{"connection":"scm:git@github.com:mikepenz/Android-Iconics.git","url":"https://github.com/mikepenz/Android-Iconics","developerConnection":"scm:git@github.com:mikepenz/Android-Iconics.git"},"name":"Android-Iconics Library","website":"https://github.com/mikepenz/Android-Iconics","openSource":true,"licenses":["e03770b69fb2a7733eeb9207a2c184ad","c3d2344cfca94c9dd34988875f3d394e"]},{"uniqueId":"com.mikepenz:iconics-typeface-api","developer":[],"artifactVersion":"5.3.1","description":"Android-Iconics Library","scm":{"connection":"scm:git@github.com:mikepenz/Android-Iconics.git","url":"https://github.com/mikepenz/Android-Iconics","developerConnection":"scm:git@github.com:mikepenz/Android-Iconics.git"},"name":"Android-Iconics Typeface API Library","website":"https://github.com/mikepenz/Android-Iconics","openSource":true,"licenses":["e03770b69fb2a7733eeb9207a2c184ad","c3d2344cfca94c9dd34988875f3d394e"]},{"uniqueId":"androidx.core:core-ktx","developer":[],"artifactVersion":"1.6.0","description":"Kotlin extensions for 'core' artifact","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"https://cs.android.com/androidx/platform/frameworks/support"},"name":"Core Kotlin Extensions","website":"https://developer.android.com/jetpack/androidx/releases/core#1.6.0","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.startup:startup-runtime","developer":[],"artifactVersion":"1.1.0","description":"Android App Startup Runtime","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"https://cs.android.com/androidx/platform/frameworks/support"},"name":"Android App Startup Runtime","website":"https://developer.android.com/jetpack/androidx/releases/startup#1.1.0","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.multidex:multidex","developer":[],"artifactVersion":"2.0.0","description":"Library for legacy multi-dex support","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/multidex","url":"http://source.android.com"},"name":"Android Multi-Dex Library","website":"","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"com.google.android.material:material","developer":[],"artifactVersion":"1.4.0","description":"Material Components for Android is a static library that you can add to your Android application in order to use APIs that provide implementations of the Material Design specification. Compatible on devices running API 14 or later.","scm":{"connection":"scm:git:https://github.com/material-components/material-components-android.git","url":"https://github.com/material-components/material-components-android"},"name":"Material Components for Android","website":"https://github.com/material-components/material-components-android","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.viewpager2:viewpager2","developer":[],"artifactVersion":"1.0.0","description":"AndroidX Widget ViewPager2","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"http://source.android.com"},"name":"AndroidX Widget ViewPager2","website":"https://developer.android.com/jetpack/androidx","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.cardview:cardview","developer":[],"artifactVersion":"1.0.0","description":"Android Support CardView v7","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"http://source.android.com"},"name":"Support CardView v7","website":"http://developer.android.com/tools/extras/support-library.html","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.coordinatorlayout:coordinatorlayout","developer":[],"artifactVersion":"1.1.0","description":"The Support Library is a static library that you can add to your Android application in order to use APIs that are either not available for older platform versions or utility APIs that aren't a part of the framework APIs. Compatible on devices running API 14 or later.","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"http://source.android.com"},"name":"Support Coordinator Layout","website":"https://developer.android.com/jetpack/androidx","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.dynamicanimation:dynamicanimation","developer":[],"artifactVersion":"1.0.0","description":"Physics-based animation in support library, where the animations are driven by physics force. You can use this Animation library to create smooth and realistic animations.","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"http://source.android.com"},"name":"Support DynamicAnimation","website":"http://developer.android.com/tools/extras/support-library.html","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.legacy:legacy-support-core-utils","developer":[],"artifactVersion":"1.0.0","description":"The Support Library is a static library that you can add to your Android application in order to use APIs that are either not available for older platform versions or utility APIs that aren't a part of the framework APIs. Compatible on devices running API 14 or later.","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"http://source.android.com"},"name":"Support core utils","website":"http://developer.android.com/tools/extras/support-library.html","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.documentfile:documentfile","developer":[],"artifactVersion":"1.0.0","description":"The Support Library is a static library that you can add to your Android application in order to use APIs that are either not available for older platform versions or utility APIs that aren't a part of the framework APIs. Compatible on devices running API 14 or later.","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"http://source.android.com"},"name":"Support Document File","website":"http://developer.android.com/tools/extras/support-library.html","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.localbroadcastmanager:localbroadcastmanager","developer":[],"artifactVersion":"1.0.0","description":"The Support Library is a static library that you can add to your Android application in order to use APIs that are either not available for older platform versions or utility APIs that aren't a part of the framework APIs. Compatible on devices running API 14 or later.","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"http://source.android.com"},"name":"Support Local Broadcast Manager","website":"http://developer.android.com/tools/extras/support-library.html","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.print:print","developer":[],"artifactVersion":"1.0.0","description":"The Support Library is a static library that you can add to your Android application in order to use APIs that are either not available for older platform versions or utility APIs that aren't a part of the framework APIs. Compatible on devices running API 14 or later.","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"http://source.android.com"},"name":"Support Print","website":"http://developer.android.com/tools/extras/support-library.html","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.transition:transition","developer":[],"artifactVersion":"1.2.0","description":"Android Transition Support Library","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"http://source.android.com"},"name":"Android Transition Support Library","website":"https://developer.android.com/jetpack/androidx","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.constraintlayout:constraintlayout","developer":[],"artifactVersion":"2.1.1","description":"ConstraintLayout for Android","scm":{"connection":"git@github.com:androidx/constraintlayout.git","url":"https://github.com/androidx/constraintlayout"},"name":"Android ConstraintLayout","website":"http://tools.android.com","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"com.mikepenz:itemanimators","developer":[],"artifactVersion":"1.1.0","description":"ItemAnimators Library","scm":{"connection":"scm:git@github.com:mikepenz/itemanimators.git","url":"https://github.com/mikepenz/itemanimators","developerConnection":"scm:git@github.com:mikepenz/itemanimators.git"},"name":"itemanimators Library","website":"https://github.com/mikepenz/itemanimators","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304","bff62e062c565562ab001c29b591eb3c"]},{"uniqueId":"com.mikepenz:material-design-iconic-typeface","developer":[],"artifactVersion":"2.2.0.8-kotlin","description":"Android-Iconics Library","scm":{"connection":"scm:git@github.com:mikepenz/Android-Iconics.git","url":"https://github.com/mikepenz/Android-Iconics","developerConnection":"scm:git@github.com:mikepenz/Android-Iconics.git"},"name":"Android-Iconics Material-Design-Iconic Typeface Library","website":"https://github.com/mikepenz/Android-Iconics","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304","c3d2344cfca94c9dd34988875f3d394e"]},{"uniqueId":"androidx.tracing:tracing","developer":[],"artifactVersion":"1.0.0","description":"Android Tracing","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"https://cs.android.com/androidx/platform/frameworks/support"},"name":"Android Tracing","website":"https://developer.android.com/jetpack/androidx/releases/tracing#1.0.0","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.constraintlayout:constraintlayout-core","developer":[],"artifactVersion":"1.0.1","description":"ConstraintLayout core","scm":{"connection":"git@github.com:androidx/constraintlayout.git","url":"https://github.com/androidx/constraintlayout"},"name":"Android ConstraintLayout Core","website":"http://tools.android.com","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.navigation:navigation-fragment-ktx","developer":[],"artifactVersion":"2.3.5","description":"Android Navigation-Fragment-Ktx","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"http://source.android.com"},"name":"Android Navigation Fragment Kotlin Extensions","website":"https://developer.android.com/topic/libraries/architecture/index.html","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.navigation:navigation-runtime-ktx","developer":[],"artifactVersion":"2.3.5","description":"Android Navigation-Runtime-Ktx","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"http://source.android.com"},"name":"Android Navigation Runtime Kotlin Extensions","website":"https://developer.android.com/topic/libraries/architecture/index.html","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.activity:activity-ktx","developer":[],"artifactVersion":"1.1.0","description":"Kotlin extensions for 'activity' artifact","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"http://source.android.com"},"name":"Activity Kotlin Extensions","website":"https://developer.android.com/jetpack/androidx","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.lifecycle:lifecycle-viewmodel-ktx","developer":[],"artifactVersion":"2.2.0","description":"Kotlin extensions for 'viewmodel' artifact","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"http://source.android.com"},"name":"Android Lifecycle ViewModel Kotlin Extensions","website":"https://developer.android.com/jetpack/androidx","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"org.jetbrains.kotlinx:kotlinx-coroutines-android","developer":[],"artifactVersion":"1.3.0","description":"Coroutines support libraries for Kotlin","scm":{"url":"https://github.com/Kotlin/kotlinx.coroutines"},"name":"kotlinx-coroutines-android","website":"https://github.com/Kotlin/kotlinx.coroutines","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"org.jetbrains.kotlinx:kotlinx-coroutines-core-jvm","developer":[],"artifactVersion":"1.5.2","description":"Coroutines support libraries for Kotlin","scm":{"url":"https://github.com/Kotlin/kotlinx.coroutines"},"name":"kotlinx-coroutines-core","website":"https://github.com/Kotlin/kotlinx.coroutines","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.lifecycle:lifecycle-runtime-ktx","developer":[],"artifactVersion":"2.2.0","description":"Kotlin extensions for 'lifecycle' artifact","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"http://source.android.com"},"name":"Android Lifecycle Kotlin Extensions","website":"https://developer.android.com/jetpack/androidx","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.navigation:navigation-common-ktx","developer":[],"artifactVersion":"2.3.5","description":"Android Navigation-Common-Ktx","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"http://source.android.com"},"name":"Android Navigation Common Kotlin Extensions","website":"https://developer.android.com/topic/libraries/architecture/index.html","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.navigation:navigation-common","developer":[],"artifactVersion":"2.3.5","description":"Android Navigation-Common","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"http://source.android.com"},"name":"Android Navigation Common","website":"https://developer.android.com/topic/libraries/architecture/index.html","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.navigation:navigation-runtime","developer":[],"artifactVersion":"2.3.5","description":"Android Navigation-Runtime","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"http://source.android.com"},"name":"Android Navigation Runtime","website":"https://developer.android.com/topic/libraries/architecture/index.html","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.fragment:fragment-ktx","developer":[],"artifactVersion":"1.2.4","description":"Kotlin extensions for 'fragment' artifact","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"http://source.android.com"},"name":"Fragment Kotlin Extensions","website":"https://developer.android.com/jetpack/androidx","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.collection:collection-ktx","developer":[],"artifactVersion":"1.1.0","description":"Kotlin extensions for 'collection' artifact","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"http://source.android.com"},"name":"Collections Kotlin Extensions","website":"http://developer.android.com/tools/extras/support-library.html","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.lifecycle:lifecycle-livedata-core-ktx","developer":[],"artifactVersion":"2.2.0","description":"Kotlin extensions for 'livedata-core' artifact","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"http://source.android.com"},"name":"LiveData Core Kotlin Extensions","website":"https://developer.android.com/jetpack/androidx","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]},{"uniqueId":"androidx.navigation:navigation-fragment","developer":[],"artifactVersion":"2.3.5","description":"Android Navigation-Fragment","scm":{"connection":"scm:git:https://android.googlesource.com/platform/frameworks/support","url":"http://source.android.com"},"name":"Android Navigation Fragment","website":"https://developer.android.com/topic/libraries/architecture/index.html","openSource":true,"licenses":["5124bfbf5dff7992e44793f13f194304"]}],"licenses":{"161d4ad861a65c64da5d779d72863440":{"content":"                                 Apache License\n                           Version 2.0, January 2004\n                        http://www.apache.org/licenses/\n\n   TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION\n\n   1. Definitions.\n\n      \"License\" shall mean the terms and conditions for use, reproduction,\n      and distribution as defined by Sections 1 through 9 of this document.\n\n      \"Licensor\" shall mean the copyright owner or entity authorized by\n      the copyright owner that is granting the License.\n\n      \"Legal Entity\" shall mean the union of the acting entity and all\n      other entities that control, are controlled by, or are under common\n      control with that entity. For the purposes of this definition,\n      \"control\" means (i) the power, direct or indirect, to cause the\n      direction or management of such entity, whether by contract or\n      otherwise, or (ii) ownership of fifty percent (50%) or more of the\n      outstanding shares, or (iii) beneficial ownership of such entity.\n\n      \"You\" (or \"Your\") shall mean an individual or Legal Entity\n      exercising permissions granted by this License.\n\n      \"Source\" form shall mean the preferred form for making modifications,\n      including but not limited to software source code, documentation\n      source, and configuration files.\n\n      \"Object\" form shall mean any form resulting from mechanical\n      transformation or translation of a Source form, including but\n      not limited to compiled object code, generated documentation,\n      and conversions to other media types.\n\n      \"Work\" shall mean the work of authorship, whether in Source or\n      Object form, made available under the License, as indicated by a\n      copyright notice that is included in or attached to the work\n      (an example is provided in the Appendix below).\n\n      \"Derivative Works\" shall mean any work, whether in Source or Object\n      form, that is based on (or derived from) the Work and for which the\n      editorial revisions, annotations, elaborations, or other modifications\n      represent, as a whole, an original work of authorship. For the purposes\n      of this License, Derivative Works shall not include works that remain\n      separable from, or merely link (or bind by name) to the interfaces of,\n      the Work and Derivative Works thereof.\n\n      \"Contribution\" shall mean any work of authorship, including\n      the original version of the Work and any modifications or additions\n      to that Work or Derivative Works thereof, that is intentionally\n      submitted to Licensor for inclusion in the Work by the copyright owner\n      or by an individual or Legal Entity authorized to submit on behalf of\n      the copyright owner. For the purposes of this definition, \"submitted\"\n      means any form of electronic, verbal, or written communication sent\n      to the Licensor or its representatives, including but not limited to\n      communication on electronic mailing lists, source code control systems,\n      and issue tracking systems that are managed by, or on behalf of, the\n      Licensor for the purpose of discussing and improving the Work, but\n      excluding communication that is conspicuously marked or otherwise\n      designated in writing by the copyright owner as \"Not a Contribution.\"\n\n      \"Contributor\" shall mean Licensor and any individual or Legal Entity\n      on behalf of whom a Contribution has been received by Licensor and\n      subsequently incorporated within the Work.\n\n   2. Grant of Copyright License. Subject to the terms and conditions of\n      this License, each Contributor hereby grants to You a perpetual,\n      worldwide, non-exclusive, no-charge, royalty-free, irrevocable\n      copyright license to reproduce, prepare Derivative Works of,\n      publicly display, publicly perform, sublicense, and distribute the\n      Work and such Derivative Works in Source or Object form.\n\n   3. Grant of Patent License. Subject to the terms and conditions of\n      this License, each Contributor hereby grants to You a perpetual,\n      worldwide, non-exclusive, no-charge, royalty-free, irrevocable\n      (except as stated in this section) patent license to make, have made,\n      use, offer to sell, sell, import, and otherwise transfer the Work,\n      where such license applies only to those patent claims licensable\n      by such Contributor that are necessarily infringed by their\n      Contribution(s) alone or by combination of their Contribution(s)\n      with the Work to which such Contribution(s) was submitted. If You\n      institute patent litigation against any entity (including a\n      cross-claim or counterclaim in a lawsuit) alleging that the Work\n      or a Contribution incorporated within the Work constitutes direct\n      or contributory patent infringement, then any patent licenses\n      granted to You under this License for that Work shall terminate\n      as of the date such litigation is filed.\n\n   4. Redistribution. You may reproduce and distribute copies of the\n      Work or Derivative Works thereof in any medium, with or without\n      modifications, and in Source or Object form, provided that You\n      meet the following conditions:\n\n      (a) You must give any other recipients of the Work or\n          Derivative Works a copy of this License; and\n\n      (b) You must cause any modified files to carry prominent notices\n          stating that You changed the files; and\n\n      (c) You must retain, in the Source form of any Derivative Works\n          that You distribute, all copyright, patent, trademark, and\n          attribution notices from the Source form of the Work,\n          excluding those notices that do not pertain to any part of\n          the Derivative Works; and\n\n      (d) If the Work includes a \"NOTICE\" text file as part of its\n          distribution, then any Derivative Works that You distribute must\n          include a readable copy of the attribution notices contained\n          within such NOTICE file, excluding those notices that do not\n          pertain to any part of the Derivative Works, in at least one\n          of the following places: within a NOTICE text file distributed\n          as part of the Derivative Works; within the Source form or\n          documentation, if provided along with the Derivative Works; or,\n          within a display generated by the Derivative Works, if and\n          wherever such third-party notices normally appear. The contents\n          of the NOTICE file are for informational purposes only and\n          do not modify the License. You may add Your own attribution\n          notices within Derivative Works that You distribute, alongside\n          or as an addendum to the NOTICE text from the Work, provided\n          that such additional attribution notices cannot be construed\n          as modifying the License.\n\n      You may add Your own copyright statement to Your modifications and\n      may provide additional or different license terms and conditions\n      for use, reproduction, or distribution of Your modifications, or\n      for any such Derivative Works as a whole, provided Your use,\n      reproduction, and distribution of the Work otherwise complies with\n      the conditions stated in this License.\n\n   5. Submission of Contributions. Unless You explicitly state otherwise,\n      any Contribution intentionally submitted for inclusion in the Work\n      by You to the Licensor shall be under the terms and conditions of\n      this License, without any additional terms or conditions.\n      Notwithstanding the above, nothing herein shall supersede or modify\n      the terms of any separate license agreement you may have executed\n      with Licensor regarding such Contributions.\n\n   6. Trademarks. This License does not grant permission to use the trade\n      names, trademarks, service marks, or product names of the Licensor,\n      except as required for reasonable and customary use in describing the\n      origin of the Work and reproducing the content of the NOTICE file.\n\n   7. Disclaimer of Warranty. Unless required by applicable law or\n      agreed to in writing, Licensor provides the Work (and each\n      Contributor provides its Contributions) on an \"AS IS\" BASIS,\n      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or\n      implied, including, without limitation, any warranties or conditions\n      of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A\n      PARTICULAR PURPOSE. You are solely responsible for determining the\n      appropriateness of using or redistributing the Work and assume any\n      risks associated with Your exercise of permissions under this License.\n\n   8. Limitation of Liability. In no event and under no legal theory,\n      whether in tort (including negligence), contract, or otherwise,\n      unless required by applicable law (such as deliberate and grossly\n      negligent acts) or agreed to in writing, shall any Contributor be\n      liable to You for damages, including any direct, indirect, special,\n      incidental, or consequential damages of any character arising as a\n      result of this License or out of the use or inability to use the\n      Work (including but not limited to damages for loss of goodwill,\n      work stoppage, computer failure or malfunction, or any and all\n      other commercial damages or losses), even if such Contributor\n      has been advised of the possibility of such damages.\n\n   9. Accepting Warranty or Additional Liability. While redistributing\n      the Work or Derivative Works thereof, You may choose to offer,\n      and charge a fee for, acceptance of support, warranty, indemnity,\n      or other liability obligations and/or rights consistent with this\n      License. However, in accepting such obligations, You may act only\n      on Your own behalf and on Your sole responsibility, not on behalf\n      of any other Contributor, and only if You agree to indemnify,\n      defend, and hold each Contributor harmless for any liability\n      incurred by, or claims asserted against, such Contributor by reason\n      of your accepting any such warranty or additional liability.\n\n   END OF TERMS AND CONDITIONS\n\n   APPENDIX: How to apply the Apache License to your work.\n\n      To apply the Apache License to your work, attach the following\n      boilerplate notice, with the fields enclosed by brackets \"{}\"\n      replaced with your own identifying information. (Don't include\n      the brackets!)  The text should be enclosed in the appropriate\n      comment syntax for the file format. We also recommend that a\n      file or class name and description of purpose be included on the\n      same \"printed page\" as the copyright notice for easier\n      identification within third-party archives.\n\n   Copyright 2021 Mike Penz\n\n   Licensed under the Apache License, Version 2.0 (the \"License\");\n   you may not use this file except in compliance with the License.\n   You may obtain a copy of the License at\n\n       http://www.apache.org/licenses/LICENSE-2.0\n\n   Unless required by applicable law or agreed to in writing, software\n   distributed under the License is distributed on an \"AS IS\" BASIS,\n   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n   See the License for the specific language governing permissions and\n   limitations under the License.\n\n","hash":"161d4ad861a65c64da5d779d72863440","url":"https://github.com/mikepenz/FastAdapter/raw/develop/LICENSE","name":"Repo"},"5124bfbf5dff7992e44793f13f194304":{"content":"Apache License\nVersion 2.0, January 2004\nhttp://www.apache.org/licenses/\n\nTERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION\n\n1. Definitions.\n\n\"License\" shall mean the terms and conditions for use, reproduction, and distribution as defined by Sections 1 through 9 of this document.\n\n\"Licensor\" shall mean the copyright owner or entity authorized by the copyright owner that is granting the License.\n\n\"Legal Entity\" shall mean the union of the acting entity and all other entities that control, are controlled by, or are under common control with that entity. For the purposes of this definition, \"control\" means (i) the power, direct or indirect, to cause the direction or management of such entity, whether by contract or otherwise, or (ii) ownership of fifty percent (50%) or more of the outstanding shares, or (iii) beneficial ownership of such entity.\n\n\"You\" (or \"Your\") shall mean an individual or Legal Entity exercising permissions granted by this License.\n\n\"Source\" form shall mean the preferred form for making modifications, including but not limited to software source code, documentation source, and configuration files.\n\n\"Object\" form shall mean any form resulting from mechanical transformation or translation of a Source form, including but not limited to compiled object code, generated documentation, and conversions to other media types.\n\n\"Work\" shall mean the work of authorship, whether in Source or Object form, made available under the License, as indicated by a copyright notice that is included in or attached to the work (an example is provided in the Appendix below).\n\n\"Derivative Works\" shall mean any work, whether in Source or Object form, that is based on (or derived from) the Work and for which the editorial revisions, annotations, elaborations, or other modifications represent, as a whole, an original work of authorship. For the purposes of this License, Derivative Works shall not include works that remain separable from, or merely link (or bind by name) to the interfaces of, the Work and Derivative Works thereof.\n\n\"Contribution\" shall mean any work of authorship, including the original version of the Work and any modifications or additions to that Work or Derivative Works thereof, that is intentionally submitted to Licensor for inclusion in the Work by the copyright owner or by an individual or Legal Entity authorized to submit on behalf of the copyright owner. For the purposes of this definition, \"submitted\" means any form of electronic, verbal, or written communication sent to the Licensor or its representatives, including but not limited to communication on electronic mailing lists, source code control systems, and issue tracking systems that are managed by, or on behalf of, the Licensor for the purpose of discussing and improving the Work, but excluding communication that is conspicuously marked or otherwise designated in writing by the copyright owner as \"Not a Contribution.\"\n\n\"Contributor\" shall mean Licensor and any individual or Legal Entity on behalf of whom a Contribution has been received by Licensor and subsequently incorporated within the Work.\n\n2. Grant of Copyright License. Subject to the terms and conditions of this License, each Contributor hereby grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable copyright license to reproduce, prepare Derivative Works of, publicly display, publicly perform, sublicense, and distribute the Work and such Derivative Works in Source or Object form.\n\n3. Grant of Patent License. Subject to the terms and conditions of this License, each Contributor hereby grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable (except as stated in this section) patent license to make, have made, use, offer to sell, sell, import, and otherwise transfer the Work, where such license applies only to those patent claims licensable by such Contributor that are necessarily infringed by their Contribution(s) alone or by combination of their Contribution(s) with the Work to which such Contribution(s) was submitted. If You institute patent litigation against any entity (including a cross-claim or counterclaim in a lawsuit) alleging that the Work or a Contribution incorporated within the Work constitutes direct or contributory patent infringement, then any patent licenses granted to You under this License for that Work shall terminate as of the date such litigation is filed.\n\n4. Redistribution. You may reproduce and distribute copies of the Work or Derivative Works thereof in any medium, with or without modifications, and in Source or Object form, provided that You meet the following conditions:\n\n     (a) You must give any other recipients of the Work or Derivative Works a copy of this License; and\n\n     (b) You must cause any modified files to carry prominent notices stating that You changed the files; and\n\n     (c) You must retain, in the Source form of any Derivative Works that You distribute, all copyright, patent, trademark, and attribution notices from the Source form of the Work, excluding those notices that do not pertain to any part of the Derivative Works; and\n\n     (d) If the Work includes a \"NOTICE\" text file as part of its distribution, then any Derivative Works that You distribute must include a readable copy of the attribution notices contained within such NOTICE file, excluding those notices that do not pertain to any part of the Derivative Works, in at least one of the following places: within a NOTICE text file distributed as part of the Derivative Works; within the Source form or documentation, if provided along with the Derivative Works; or, within a display generated by the Derivative Works, if and wherever such third-party notices normally appear. The contents of the NOTICE file are for informational purposes only and do not modify the License. You may add Your own attribution notices within Derivative Works that You distribute, alongside or as an addendum to the NOTICE text from the Work, provided that such additional attribution notices cannot be construed as modifying the License.\n\n     You may add Your own copyright statement to Your modifications and may provide additional or different license terms and conditions for use, reproduction, or distribution of Your modifications, or for any such Derivative Works as a whole, provided Your use, reproduction, and distribution of the Work otherwise complies with the conditions stated in this License.\n\n5. Submission of Contributions. Unless You explicitly state otherwise, any Contribution intentionally submitted for inclusion in the Work by You to the Licensor shall be under the terms and conditions of this License, without any additional terms or conditions. Notwithstanding the above, nothing herein shall supersede or modify the terms of any separate license agreement you may have executed with Licensor regarding such Contributions.\n\n6. Trademarks. This License does not grant permission to use the trade names, trademarks, service marks, or product names of the Licensor, except as required for reasonable and customary use in describing the origin of the Work and reproducing the content of the NOTICE file.\n\n7. Disclaimer of Warranty. Unless required by applicable law or agreed to in writing, Licensor provides the Work (and each Contributor provides its Contributions) on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied, including, without limitation, any warranties or conditions of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A PARTICULAR PURPOSE. You are solely responsible for determining the appropriateness of using or redistributing the Work and assume any risks associated with Your exercise of permissions under this License.\n\n8. Limitation of Liability. In no event and under no legal theory, whether in tort (including negligence), contract, or otherwise, unless required by applicable law (such as deliberate and grossly negligent acts) or agreed to in writing, shall any Contributor be liable to You for damages, including any direct, indirect, special, incidental, or consequential damages of any character arising as a result of this License or out of the use or inability to use the Work (including but not limited to damages for loss of goodwill, work stoppage, computer failure or malfunction, or any and all other commercial damages or losses), even if such Contributor has been advised of the possibility of such damages.\n\n9. Accepting Warranty or Additional Liability. While redistributing the Work or Derivative Works thereof, You may choose to offer, and charge a fee for, acceptance of support, warranty, indemnity, or other liability obligations and/or rights consistent with this License. However, in accepting such obligations, You may act only on Your own behalf and on Your sole responsibility, not on behalf of any other Contributor, and only if You agree to indemnify, defend, and hold each Contributor harmless for any liability incurred by, or claims asserted against, such Contributor by reason of your accepting any such warranty or additional liability.\n\nEND OF TERMS AND CONDITIONS\n\nAPPENDIX: How to apply the Apache License to your work.\n\nTo apply the Apache License to your work, attach the following boilerplate notice, with the fields enclosed by brackets \"[]\" replaced with your own identifying information. (Don't include the brackets!)  The text should be enclosed in the appropriate comment syntax for the file format. We also recommend that a file or class name and description of purpose be included on the same \"printed page\" as the copyright notice for easier identification within third-party archives.\n\nCopyright [yyyy] [name of copyright owner]\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\nhttp://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.","hash":"5124bfbf5dff7992e44793f13f194304","url":"https://spdx.org/licenses/Apache-2.0.txt","spdxId":"Apache_2_0","name":"The Apache Software License, Version 2.0"},"bff62e062c565562ab001c29b591eb3c":{"content":"                                 Apache License\n                           Version 2.0, January 2004\n                        http://www.apache.org/licenses/\n\n   TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION\n\n   1. Definitions.\n\n      \"License\" shall mean the terms and conditions for use, reproduction,\n      and distribution as defined by Sections 1 through 9 of this document.\n\n      \"Licensor\" shall mean the copyright owner or entity authorized by\n      the copyright owner that is granting the License.\n\n      \"Legal Entity\" shall mean the union of the acting entity and all\n      other entities that control, are controlled by, or are under common\n      control with that entity. For the purposes of this definition,\n      \"control\" means (i) the power, direct or indirect, to cause the\n      direction or management of such entity, whether by contract or\n      otherwise, or (ii) ownership of fifty percent (50%) or more of the\n      outstanding shares, or (iii) beneficial ownership of such entity.\n\n      \"You\" (or \"Your\") shall mean an individual or Legal Entity\n      exercising permissions granted by this License.\n\n      \"Source\" form shall mean the preferred form for making modifications,\n      including but not limited to software source code, documentation\n      source, and configuration files.\n\n      \"Object\" form shall mean any form resulting from mechanical\n      transformation or translation of a Source form, including but\n      not limited to compiled object code, generated documentation,\n      and conversions to other media types.\n\n      \"Work\" shall mean the work of authorship, whether in Source or\n      Object form, made available under the License, as indicated by a\n      copyright notice that is included in or attached to the work\n      (an example is provided in the Appendix below).\n\n      \"Derivative Works\" shall mean any work, whether in Source or Object\n      form, that is based on (or derived from) the Work and for which the\n      editorial revisions, annotations, elaborations, or other modifications\n      represent, as a whole, an original work of authorship. For the purposes\n      of this License, Derivative Works shall not include works that remain\n      separable from, or merely link (or bind by name) to the interfaces of,\n      the Work and Derivative Works thereof.\n\n      \"Contribution\" shall mean any work of authorship, including\n      the original version of the Work and any modifications or additions\n      to that Work or Derivative Works thereof, that is intentionally\n      submitted to Licensor for inclusion in the Work by the copyright owner\n      or by an individual or Legal Entity authorized to submit on behalf of\n      the copyright owner. For the purposes of this definition, \"submitted\"\n      means any form of electronic, verbal, or written communication sent\n      to the Licensor or its representatives, including but not limited to\n      communication on electronic mailing lists, source code control systems,\n      and issue tracking systems that are managed by, or on behalf of, the\n      Licensor for the purpose of discussing and improving the Work, but\n      excluding communication that is conspicuously marked or otherwise\n      designated in writing by the copyright owner as \"Not a Contribution.\"\n\n      \"Contributor\" shall mean Licensor and any individual or Legal Entity\n      on behalf of whom a Contribution has been received by Licensor and\n      subsequently incorporated within the Work.\n\n   2. Grant of Copyright License. Subject to the terms and conditions of\n      this License, each Contributor hereby grants to You a perpetual,\n      worldwide, non-exclusive, no-charge, royalty-free, irrevocable\n      copyright license to reproduce, prepare Derivative Works of,\n      publicly display, publicly perform, sublicense, and distribute the\n      Work and such Derivative Works in Source or Object form.\n\n   3. Grant of Patent License. Subject to the terms and conditions of\n      this License, each Contributor hereby grants to You a perpetual,\n      worldwide, non-exclusive, no-charge, royalty-free, irrevocable\n      (except as stated in this section) patent license to make, have made,\n      use, offer to sell, sell, import, and otherwise transfer the Work,\n      where such license applies only to those patent claims licensable\n      by such Contributor that are necessarily infringed by their\n      Contribution(s) alone or by combination of their Contribution(s)\n      with the Work to which such Contribution(s) was submitted. If You\n      institute patent litigation against any entity (including a\n      cross-claim or counterclaim in a lawsuit) alleging that the Work\n      or a Contribution incorporated within the Work constitutes direct\n      or contributory patent infringement, then any patent licenses\n      granted to You under this License for that Work shall terminate\n      as of the date such litigation is filed.\n\n   4. Redistribution. You may reproduce and distribute copies of the\n      Work or Derivative Works thereof in any medium, with or without\n      modifications, and in Source or Object form, provided that You\n      meet the following conditions:\n\n      (a) You must give any other recipients of the Work or\n          Derivative Works a copy of this License; and\n\n      (b) You must cause any modified files to carry prominent notices\n          stating that You changed the files; and\n\n      (c) You must retain, in the Source form of any Derivative Works\n          that You distribute, all copyright, patent, trademark, and\n          attribution notices from the Source form of the Work,\n          excluding those notices that do not pertain to any part of\n          the Derivative Works; and\n\n      (d) If the Work includes a \"NOTICE\" text file as part of its\n          distribution, then any Derivative Works that You distribute must\n          include a readable copy of the attribution notices contained\n          within such NOTICE file, excluding those notices that do not\n          pertain to any part of the Derivative Works, in at least one\n          of the following places: within a NOTICE text file distributed\n          as part of the Derivative Works; within the Source form or\n          documentation, if provided along with the Derivative Works; or,\n          within a display generated by the Derivative Works, if and\n          wherever such third-party notices normally appear. The contents\n          of the NOTICE file are for informational purposes only and\n          do not modify the License. You may add Your own attribution\n          notices within Derivative Works that You distribute, alongside\n          or as an addendum to the NOTICE text from the Work, provided\n          that such additional attribution notices cannot be construed\n          as modifying the License.\n\n      You may add Your own copyright statement to Your modifications and\n      may provide additional or different license terms and conditions\n      for use, reproduction, or distribution of Your modifications, or\n      for any such Derivative Works as a whole, provided Your use,\n      reproduction, and distribution of the Work otherwise complies with\n      the conditions stated in this License.\n\n   5. Submission of Contributions. Unless You explicitly state otherwise,\n      any Contribution intentionally submitted for inclusion in the Work\n      by You to the Licensor shall be under the terms and conditions of\n      this License, without any additional terms or conditions.\n      Notwithstanding the above, nothing herein shall supersede or modify\n      the terms of any separate license agreement you may have executed\n      with Licensor regarding such Contributions.\n\n   6. Trademarks. This License does not grant permission to use the trade\n      names, trademarks, service marks, or product names of the Licensor,\n      except as required for reasonable and customary use in describing the\n      origin of the Work and reproducing the content of the NOTICE file.\n\n   7. Disclaimer of Warranty. Unless required by applicable law or\n      agreed to in writing, Licensor provides the Work (and each\n      Contributor provides its Contributions) on an \"AS IS\" BASIS,\n      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or\n      implied, including, without limitation, any warranties or conditions\n      of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A\n      PARTICULAR PURPOSE. You are solely responsible for determining the\n      appropriateness of using or redistributing the Work and assume any\n      risks associated with Your exercise of permissions under this License.\n\n   8. Limitation of Liability. In no event and under no legal theory,\n      whether in tort (including negligence), contract, or otherwise,\n      unless required by applicable law (such as deliberate and grossly\n      negligent acts) or agreed to in writing, shall any Contributor be\n      liable to You for damages, including any direct, indirect, special,\n      incidental, or consequential damages of any character arising as a\n      result of this License or out of the use or inability to use the\n      Work (including but not limited to damages for loss of goodwill,\n      work stoppage, computer failure or malfunction, or any and all\n      other commercial damages or losses), even if such Contributor\n      has been advised of the possibility of such damages.\n\n   9. Accepting Warranty or Additional Liability. While redistributing\n      the Work or Derivative Works thereof, You may choose to offer,\n      and charge a fee for, acceptance of support, warranty, indemnity,\n      or other liability obligations and/or rights consistent with this\n      License. However, in accepting such obligations, You may act only\n      on Your own behalf and on Your sole responsibility, not on behalf\n      of any other Contributor, and only if You agree to indemnify,\n      defend, and hold each Contributor harmless for any liability\n      incurred by, or claims asserted against, such Contributor by reason\n      of your accepting any such warranty or additional liability.\n\n   END OF TERMS AND CONDITIONS\n\n   APPENDIX: How to apply the Apache License to your work.\n\n      To apply the Apache License to your work, attach the following\n      boilerplate notice, with the fields enclosed by brackets \"{}\"\n      replaced with your own identifying information. (Don't include\n      the brackets!)  The text should be enclosed in the appropriate\n      comment syntax for the file format. We also recommend that a\n      file or class name and description of purpose be included on the\n      same \"printed page\" as the copyright notice for easier\n      identification within third-party archives.\n\n   Copyright {yyyy} {name of copyright owner}\n\n   Licensed under the Apache License, Version 2.0 (the \"License\");\n   you may not use this file except in compliance with the License.\n   You may obtain a copy of the License at\n\n       http://www.apache.org/licenses/LICENSE-2.0\n\n   Unless required by applicable law or agreed to in writing, software\n   distributed under the License is distributed on an \"AS IS\" BASIS,\n   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n   See the License for the specific language governing permissions and\n   limitations under the License.\n\n","hash":"bff62e062c565562ab001c29b591eb3c","url":"https://github.com/mikepenz/itemanimators/raw/develop/LICENSE","name":"Repo"},"293690fb30161eb556054896cb84ef3a":{"content":"                                 Apache License\n                           Version 2.0, January 2004\n                        http://www.apache.org/licenses/\n\n   TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION\n\n   1. Definitions.\n\n      \"License\" shall mean the terms and conditions for use, reproduction,\n      and distribution as defined by Sections 1 through 9 of this document.\n\n      \"Licensor\" shall mean the copyright owner or entity authorized by\n      the copyright owner that is granting the License.\n\n      \"Legal Entity\" shall mean the union of the acting entity and all\n      other entities that control, are controlled by, or are under common\n      control with that entity. For the purposes of this definition,\n      \"control\" means (i) the power, direct or indirect, to cause the\n      direction or management of such entity, whether by contract or\n      otherwise, or (ii) ownership of fifty percent (50%) or more of the\n      outstanding shares, or (iii) beneficial ownership of such entity.\n\n      \"You\" (or \"Your\") shall mean an individual or Legal Entity\n      exercising permissions granted by this License.\n\n      \"Source\" form shall mean the preferred form for making modifications,\n      including but not limited to software source code, documentation\n      source, and configuration files.\n\n      \"Object\" form shall mean any form resulting from mechanical\n      transformation or translation of a Source form, including but\n      not limited to compiled object code, generated documentation,\n      and conversions to other media types.\n\n      \"Work\" shall mean the work of authorship, whether in Source or\n      Object form, made available under the License, as indicated by a\n      copyright notice that is included in or attached to the work\n      (an example is provided in the Appendix below).\n\n      \"Derivative Works\" shall mean any work, whether in Source or Object\n      form, that is based on (or derived from) the Work and for which the\n      editorial revisions, annotations, elaborations, or other modifications\n      represent, as a whole, an original work of authorship. For the purposes\n      of this License, Derivative Works shall not include works that remain\n      separable from, or merely link (or bind by name) to the interfaces of,\n      the Work and Derivative Works thereof.\n\n      \"Contribution\" shall mean any work of authorship, including\n      the original version of the Work and any modifications or additions\n      to that Work or Derivative Works thereof, that is intentionally\n      submitted to Licensor for inclusion in the Work by the copyright owner\n      or by an individual or Legal Entity authorized to submit on behalf of\n      the copyright owner. For the purposes of this definition, \"submitted\"\n      means any form of electronic, verbal, or written communication sent\n      to the Licensor or its representatives, including but not limited to\n      communication on electronic mailing lists, source code control systems,\n      and issue tracking systems that are managed by, or on behalf of, the\n      Licensor for the purpose of discussing and improving the Work, but\n      excluding communication that is conspicuously marked or otherwise\n      designated in writing by the copyright owner as \"Not a Contribution.\"\n\n      \"Contributor\" shall mean Licensor and any individual or Legal Entity\n      on behalf of whom a Contribution has been received by Licensor and\n      subsequently incorporated within the Work.\n\n   2. Grant of Copyright License. Subject to the terms and conditions of\n      this License, each Contributor hereby grants to You a perpetual,\n      worldwide, non-exclusive, no-charge, royalty-free, irrevocable\n      copyright license to reproduce, prepare Derivative Works of,\n      publicly display, publicly perform, sublicense, and distribute the\n      Work and such Derivative Works in Source or Object form.\n\n   3. Grant of Patent License. Subject to the terms and conditions of\n      this License, each Contributor hereby grants to You a perpetual,\n      worldwide, non-exclusive, no-charge, royalty-free, irrevocable\n      (except as stated in this section) patent license to make, have made,\n      use, offer to sell, sell, import, and otherwise transfer the Work,\n      where such license applies only to those patent claims licensable\n      by such Contributor that are necessarily infringed by their\n      Contribution(s) alone or by combination of their Contribution(s)\n      with the Work to which such Contribution(s) was submitted. If You\n      institute patent litigation against any entity (including a\n      cross-claim or counterclaim in a lawsuit) alleging that the Work\n      or a Contribution incorporated within the Work constitutes direct\n      or contributory patent infringement, then any patent licenses\n      granted to You under this License for that Work shall terminate\n      as of the date such litigation is filed.\n\n   4. Redistribution. You may reproduce and distribute copies of the\n      Work or Derivative Works thereof in any medium, with or without\n      modifications, and in Source or Object form, provided that You\n      meet the following conditions:\n\n      (a) You must give any other recipients of the Work or\n          Derivative Works a copy of this License; and\n\n      (b) You must cause any modified files to carry prominent notices\n          stating that You changed the files; and\n\n      (c) You must retain, in the Source form of any Derivative Works\n          that You distribute, all copyright, patent, trademark, and\n          attribution notices from the Source form of the Work,\n          excluding those notices that do not pertain to any part of\n          the Derivative Works; and\n\n      (d) If the Work includes a \"NOTICE\" text file as part of its\n          distribution, then any Derivative Works that You distribute must\n          include a readable copy of the attribution notices contained\n          within such NOTICE file, excluding those notices that do not\n          pertain to any part of the Derivative Works, in at least one\n          of the following places: within a NOTICE text file distributed\n          as part of the Derivative Works; within the Source form or\n          documentation, if provided along with the Derivative Works; or,\n          within a display generated by the Derivative Works, if and\n          wherever such third-party notices normally appear. The contents\n          of the NOTICE file are for informational purposes only and\n          do not modify the License. You may add Your own attribution\n          notices within Derivative Works that You distribute, alongside\n          or as an addendum to the NOTICE text from the Work, provided\n          that such additional attribution notices cannot be construed\n          as modifying the License.\n\n      You may add Your own copyright statement to Your modifications and\n      may provide additional or different license terms and conditions\n      for use, reproduction, or distribution of Your modifications, or\n      for any such Derivative Works as a whole, provided Your use,\n      reproduction, and distribution of the Work otherwise complies with\n      the conditions stated in this License.\n\n   5. Submission of Contributions. Unless You explicitly state otherwise,\n      any Contribution intentionally submitted for inclusion in the Work\n      by You to the Licensor shall be under the terms and conditions of\n      this License, without any additional terms or conditions.\n      Notwithstanding the above, nothing herein shall supersede or modify\n      the terms of any separate license agreement you may have executed\n      with Licensor regarding such Contributions.\n\n   6. Trademarks. This License does not grant permission to use the trade\n      names, trademarks, service marks, or product names of the Licensor,\n      except as required for reasonable and customary use in describing the\n      origin of the Work and reproducing the content of the NOTICE file.\n\n   7. Disclaimer of Warranty. Unless required by applicable law or\n      agreed to in writing, Licensor provides the Work (and each\n      Contributor provides its Contributions) on an \"AS IS\" BASIS,\n      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or\n      implied, including, without limitation, any warranties or conditions\n      of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A\n      PARTICULAR PURPOSE. You are solely responsible for determining the\n      appropriateness of using or redistributing the Work and assume any\n      risks associated with Your exercise of permissions under this License.\n\n   8. Limitation of Liability. In no event and under no legal theory,\n      whether in tort (including negligence), contract, or otherwise,\n      unless required by applicable law (such as deliberate and grossly\n      negligent acts) or agreed to in writing, shall any Contributor be\n      liable to You for damages, including any direct, indirect, special,\n      incidental, or consequential damages of any character arising as a\n      result of this License or out of the use or inability to use the\n      Work (including but not limited to damages for loss of goodwill,\n      work stoppage, computer failure or malfunction, or any and all\n      other commercial damages or losses), even if such Contributor\n      has been advised of the possibility of such damages.\n\n   9. Accepting Warranty or Additional Liability. While redistributing\n      the Work or Derivative Works thereof, You may choose to offer,\n      and charge a fee for, acceptance of support, warranty, indemnity,\n      or other liability obligations and/or rights consistent with this\n      License. However, in accepting such obligations, You may act only\n      on Your own behalf and on Your sole responsibility, not on behalf\n      of any other Contributor, and only if You agree to indemnify,\n      defend, and hold each Contributor harmless for any liability\n      incurred by, or claims asserted against, such Contributor by reason\n      of your accepting any such warranty or additional liability.\n\n   END OF TERMS AND CONDITIONS\n\n   APPENDIX: How to apply the Apache License to your work.\n\n      To apply the Apache License to your work, attach the following\n      boilerplate notice, with the fields enclosed by brackets \"[]\"\n      replaced with your own identifying information. (Don't include\n      the brackets!)  The text should be enclosed in the appropriate\n      comment syntax for the file format. We also recommend that a\n      file or class name and description of purpose be included on the\n      same \"printed page\" as the copyright notice for easier\n      identification within third-party archives.\n\n   Copyright 2021 Mike Penz\n\n   Licensed under the Apache License, Version 2.0 (the \"License\");\n   you may not use this file except in compliance with the License.\n   You may obtain a copy of the License at\n\n       http://www.apache.org/licenses/LICENSE-2.0\n\n   Unless required by applicable law or agreed to in writing, software\n   distributed under the License is distributed on an \"AS IS\" BASIS,\n   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n   See the License for the specific language governing permissions and\n   limitations under the License.\n","hash":"293690fb30161eb556054896cb84ef3a","url":"https://github.com/mikepenz/MaterialDrawer/raw/develop/LICENSE","name":"Repo"},"e69365f226b0862743475f0d338bd919":{"content":"Apache License\nVersion 2.0, January 2004\nhttp://www.apache.org/licenses/\n\nTERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION\n\n1. Definitions.\n\n\"License\" shall mean the terms and conditions for use, reproduction, and distribution as defined by Sections 1 through 9 of this document.\n\n\"Licensor\" shall mean the copyright owner or entity authorized by the copyright owner that is granting the License.\n\n\"Legal Entity\" shall mean the union of the acting entity and all other entities that control, are controlled by, or are under common control with that entity. For the purposes of this definition, \"control\" means (i) the power, direct or indirect, to cause the direction or management of such entity, whether by contract or otherwise, or (ii) ownership of fifty percent (50%) or more of the outstanding shares, or (iii) beneficial ownership of such entity.\n\n\"You\" (or \"Your\") shall mean an individual or Legal Entity exercising permissions granted by this License.\n\n\"Source\" form shall mean the preferred form for making modifications, including but not limited to software source code, documentation source, and configuration files.\n\n\"Object\" form shall mean any form resulting from mechanical transformation or translation of a Source form, including but not limited to compiled object code, generated documentation, and conversions to other media types.\n\n\"Work\" shall mean the work of authorship, whether in Source or Object form, made available under the License, as indicated by a copyright notice that is included in or attached to the work (an example is provided in the Appendix below).\n\n\"Derivative Works\" shall mean any work, whether in Source or Object form, that is based on (or derived from) the Work and for which the editorial revisions, annotations, elaborations, or other modifications represent, as a whole, an original work of authorship. For the purposes of this License, Derivative Works shall not include works that remain separable from, or merely link (or bind by name) to the interfaces of, the Work and Derivative Works thereof.\n\n\"Contribution\" shall mean any work of authorship, including the original version of the Work and any modifications or additions to that Work or Derivative Works thereof, that is intentionally submitted to Licensor for inclusion in the Work by the copyright owner or by an individual or Legal Entity authorized to submit on behalf of the copyright owner. For the purposes of this definition, \"submitted\" means any form of electronic, verbal, or written communication sent to the Licensor or its representatives, including but not limited to communication on electronic mailing lists, source code control systems, and issue tracking systems that are managed by, or on behalf of, the Licensor for the purpose of discussing and improving the Work, but excluding communication that is conspicuously marked or otherwise designated in writing by the copyright owner as \"Not a Contribution.\"\n\n\"Contributor\" shall mean Licensor and any individual or Legal Entity on behalf of whom a Contribution has been received by Licensor and subsequently incorporated within the Work.\n\n2. Grant of Copyright License. Subject to the terms and conditions of this License, each Contributor hereby grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable copyright license to reproduce, prepare Derivative Works of, publicly display, publicly perform, sublicense, and distribute the Work and such Derivative Works in Source or Object form.\n\n3. Grant of Patent License. Subject to the terms and conditions of this License, each Contributor hereby grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable (except as stated in this section) patent license to make, have made, use, offer to sell, sell, import, and otherwise transfer the Work, where such license applies only to those patent claims licensable by such Contributor that are necessarily infringed by their Contribution(s) alone or by combination of their Contribution(s) with the Work to which such Contribution(s) was submitted. If You institute patent litigation against any entity (including a cross-claim or counterclaim in a lawsuit) alleging that the Work or a Contribution incorporated within the Work constitutes direct or contributory patent infringement, then any patent licenses granted to You under this License for that Work shall terminate as of the date such litigation is filed.\n\n4. Redistribution. You may reproduce and distribute copies of the Work or Derivative Works thereof in any medium, with or without modifications, and in Source or Object form, provided that You meet the following conditions:\n\n     (a) You must give any other recipients of the Work or Derivative Works a copy of this License; and\n\n     (b) You must cause any modified files to carry prominent notices stating that You changed the files; and\n\n     (c) You must retain, in the Source form of any Derivative Works that You distribute, all copyright, patent, trademark, and attribution notices from the Source form of the Work, excluding those notices that do not pertain to any part of the Derivative Works; and\n\n     (d) If the Work includes a \"NOTICE\" text file as part of its distribution, then any Derivative Works that You distribute must include a readable copy of the attribution notices contained within such NOTICE file, excluding those notices that do not pertain to any part of the Derivative Works, in at least one of the following places: within a NOTICE text file distributed as part of the Derivative Works; within the Source form or documentation, if provided along with the Derivative Works; or, within a display generated by the Derivative Works, if and wherever such third-party notices normally appear. The contents of the NOTICE file are for informational purposes only and do not modify the License. You may add Your own attribution notices within Derivative Works that You distribute, alongside or as an addendum to the NOTICE text from the Work, provided that such additional attribution notices cannot be construed as modifying the License.\n\n     You may add Your own copyright statement to Your modifications and may provide additional or different license terms and conditions for use, reproduction, or distribution of Your modifications, or for any such Derivative Works as a whole, provided Your use, reproduction, and distribution of the Work otherwise complies with the conditions stated in this License.\n\n5. Submission of Contributions. Unless You explicitly state otherwise, any Contribution intentionally submitted for inclusion in the Work by You to the Licensor shall be under the terms and conditions of this License, without any additional terms or conditions. Notwithstanding the above, nothing herein shall supersede or modify the terms of any separate license agreement you may have executed with Licensor regarding such Contributions.\n\n6. Trademarks. This License does not grant permission to use the trade names, trademarks, service marks, or product names of the Licensor, except as required for reasonable and customary use in describing the origin of the Work and reproducing the content of the NOTICE file.\n\n7. Disclaimer of Warranty. Unless required by applicable law or agreed to in writing, Licensor provides the Work (and each Contributor provides its Contributions) on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied, including, without limitation, any warranties or conditions of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A PARTICULAR PURPOSE. You are solely responsible for determining the appropriateness of using or redistributing the Work and assume any risks associated with Your exercise of permissions under this License.\n\n8. Limitation of Liability. In no event and under no legal theory, whether in tort (including negligence), contract, or otherwise, unless required by applicable law (such as deliberate and grossly negligent acts) or agreed to in writing, shall any Contributor be liable to You for damages, including any direct, indirect, special, incidental, or consequential damages of any character arising as a result of this License or out of the use or inability to use the Work (including but not limited to damages for loss of goodwill, work stoppage, computer failure or malfunction, or any and all other commercial damages or losses), even if such Contributor has been advised of the possibility of such damages.\n\n9. Accepting Warranty or Additional Liability. While redistributing the Work or Derivative Works thereof, You may choose to offer, and charge a fee for, acceptance of support, warranty, indemnity, or other liability obligations and/or rights consistent with this License. However, in accepting such obligations, You may act only on Your own behalf and on Your sole responsibility, not on behalf of any other Contributor, and only if You agree to indemnify, defend, and hold each Contributor harmless for any liability incurred by, or claims asserted against, such Contributor by reason of your accepting any such warranty or additional liability.\n\nEND OF TERMS AND CONDITIONS\n\nAPPENDIX: How to apply the Apache License to your work.\n\nTo apply the Apache License to your work, attach the following boilerplate notice, with the fields enclosed by brackets \"[]\" replaced with your own identifying information. (Don't include the brackets!)  The text should be enclosed in the appropriate comment syntax for the file format. We also recommend that a file or class name and description of purpose be included on the same \"printed page\" as the copyright notice for easier identification within third-party archives.\n\nCopyright [yyyy] [name of copyright owner]\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\nhttp://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.","hash":"e69365f226b0862743475f0d338bd919","url":"https://spdx.org/licenses/Apache-2.0.txt","spdxId":"Apache_2_0","name":"The Apache License, Version 2.0"},"c3d2344cfca94c9dd34988875f3d394e":{"content":"Apache License\n                           Version 2.0, January 2004\n                        http://www.apache.org/licenses/\n\n   TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION\n\n   1. Definitions.\n\n      \"License\" shall mean the terms and conditions for use, reproduction,\n      and distribution as defined by Sections 1 through 9 of this document.\n\n      \"Licensor\" shall mean the copyright owner or entity authorized by\n      the copyright owner that is granting the License.\n\n      \"Legal Entity\" shall mean the union of the acting entity and all\n      other entities that control, are controlled by, or are under common\n      control with that entity. For the purposes of this definition,\n      \"control\" means (i) the power, direct or indirect, to cause the\n      direction or management of such entity, whether by contract or\n      otherwise, or (ii) ownership of fifty percent (50%) or more of the\n      outstanding shares, or (iii) beneficial ownership of such entity.\n\n      \"You\" (or \"Your\") shall mean an individual or Legal Entity\n      exercising permissions granted by this License.\n\n      \"Source\" form shall mean the preferred form for making modifications,\n      including but not limited to software source code, documentation\n      source, and configuration files.\n\n      \"Object\" form shall mean any form resulting from mechanical\n      transformation or translation of a Source form, including but\n      not limited to compiled object code, generated documentation,\n      and conversions to other media types.\n\n      \"Work\" shall mean the work of authorship, whether in Source or\n      Object form, made available under the License, as indicated by a\n      copyright notice that is included in or attached to the work\n      (an example is provided in the Appendix below).\n\n      \"Derivative Works\" shall mean any work, whether in Source or Object\n      form, that is based on (or derived from) the Work and for which the\n      editorial revisions, annotations, elaborations, or other modifications\n      represent, as a whole, an original work of authorship. For the purposes\n      of this License, Derivative Works shall not include works that remain\n      separable from, or merely link (or bind by name) to the interfaces of,\n      the Work and Derivative Works thereof.\n\n      \"Contribution\" shall mean any work of authorship, including\n      the original version of the Work and any modifications or additions\n      to that Work or Derivative Works thereof, that is intentionally\n      submitted to Licensor for inclusion in the Work by the copyright owner\n      or by an individual or Legal Entity authorized to submit on behalf of\n      the copyright owner. For the purposes of this definition, \"submitted\"\n      means any form of electronic, verbal, or written communication sent\n      to the Licensor or its representatives, including but not limited to\n      communication on electronic mailing lists, source code control systems,\n      and issue tracking systems that are managed by, or on behalf of, the\n      Licensor for the purpose of discussing and improving the Work, but\n      excluding communication that is conspicuously marked or otherwise\n      designated in writing by the copyright owner as \"Not a Contribution.\"\n\n      \"Contributor\" shall mean Licensor and any individual or Legal Entity\n      on behalf of whom a Contribution has been received by Licensor and\n      subsequently incorporated within the Work.\n\n   2. Grant of Copyright License. Subject to the terms and conditions of\n      this License, each Contributor hereby grants to You a perpetual,\n      worldwide, non-exclusive, no-charge, royalty-free, irrevocable\n      copyright license to reproduce, prepare Derivative Works of,\n      publicly display, publicly perform, sublicense, and distribute the\n      Work and such Derivative Works in Source or Object form.\n\n   3. Grant of Patent License. Subject to the terms and conditions of\n      this License, each Contributor hereby grants to You a perpetual,\n      worldwide, non-exclusive, no-charge, royalty-free, irrevocable\n      (except as stated in this section) patent license to make, have made,\n      use, offer to sell, sell, import, and otherwise transfer the Work,\n      where such license applies only to those patent claims licensable\n      by such Contributor that are necessarily infringed by their\n      Contribution(s) alone or by combination of their Contribution(s)\n      with the Work to which such Contribution(s) was submitted. If You\n      institute patent litigation against any entity (including a\n      cross-claim or counterclaim in a lawsuit) alleging that the Work\n      or a Contribution incorporated within the Work constitutes direct\n      or contributory patent infringement, then any patent licenses\n      granted to You under this License for that Work shall terminate\n      as of the date such litigation is filed.\n\n   4. Redistribution. You may reproduce and distribute copies of the\n      Work or Derivative Works thereof in any medium, with or without\n      modifications, and in Source or Object form, provided that You\n      meet the following conditions:\n\n      (a) You must give any other recipients of the Work or\n          Derivative Works a copy of this License; and\n\n      (b) You must cause any modified files to carry prominent notices\n          stating that You changed the files; and\n\n      (c) You must retain, in the Source form of any Derivative Works\n          that You distribute, all copyright, patent, trademark, and\n          attribution notices from the Source form of the Work,\n          excluding those notices that do not pertain to any part of\n          the Derivative Works; and\n\n      (d) If the Work includes a \"NOTICE\" text file as part of its\n          distribution, then any Derivative Works that You distribute must\n          include a readable copy of the attribution notices contained\n          within such NOTICE file, excluding those notices that do not\n          pertain to any part of the Derivative Works, in at least one\n          of the following places: within a NOTICE text file distributed\n          as part of the Derivative Works; within the Source form or\n          documentation, if provided along with the Derivative Works; or,\n          within a display generated by the Derivative Works, if and\n          wherever such third-party notices normally appear. The contents\n          of the NOTICE file are for informational purposes only and\n          do not modify the License. You may add Your own attribution\n          notices within Derivative Works that You distribute, alongside\n          or as an addendum to the NOTICE text from the Work, provided\n          that such additional attribution notices cannot be construed\n          as modifying the License.\n\n      You may add Your own copyright statement to Your modifications and\n      may provide additional or different license terms and conditions\n      for use, reproduction, or distribution of Your modifications, or\n      for any such Derivative Works as a whole, provided Your use,\n      reproduction, and distribution of the Work otherwise complies with\n      the conditions stated in this License.\n\n   5. Submission of Contributions. Unless You explicitly state otherwise,\n      any Contribution intentionally submitted for inclusion in the Work\n      by You to the Licensor shall be under the terms and conditions of\n      this License, without any additional terms or conditions.\n      Notwithstanding the above, nothing herein shall supersede or modify\n      the terms of any separate license agreement you may have executed\n      with Licensor regarding such Contributions.\n\n   6. Trademarks. This License does not grant permission to use the trade\n      names, trademarks, service marks, or product names of the Licensor,\n      except as required for reasonable and customary use in describing the\n      origin of the Work and reproducing the content of the NOTICE file.\n\n   7. Disclaimer of Warranty. Unless required by applicable law or\n      agreed to in writing, Licensor provides the Work (and each\n      Contributor provides its Contributions) on an \"AS IS\" BASIS,\n      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or\n      implied, including, without limitation, any warranties or conditions\n      of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A\n      PARTICULAR PURPOSE. You are solely responsible for determining the\n      appropriateness of using or redistributing the Work and assume any\n      risks associated with Your exercise of permissions under this License.\n\n   8. Limitation of Liability. In no event and under no legal theory,\n      whether in tort (including negligence), contract, or otherwise,\n      unless required by applicable law (such as deliberate and grossly\n      negligent acts) or agreed to in writing, shall any Contributor be\n      liable to You for damages, including any direct, indirect, special,\n      incidental, or consequential damages of any character arising as a\n      result of this License or out of the use or inability to use the\n      Work (including but not limited to damages for loss of goodwill,\n      work stoppage, computer failure or malfunction, or any and all\n      other commercial damages or losses), even if such Contributor\n      has been advised of the possibility of such damages.\n\n   9. Accepting Warranty or Additional Liability. While redistributing\n      the Work or Derivative Works thereof, You may choose to offer,\n      and charge a fee for, acceptance of support, warranty, indemnity,\n      or other liability obligations and/or rights consistent with this\n      License. However, in accepting such obligations, You may act only\n      on Your own behalf and on Your sole responsibility, not on behalf\n      of any other Contributor, and only if You agree to indemnify,\n      defend, and hold each Contributor harmless for any liability\n      incurred by, or claims asserted against, such Contributor by reason\n      of your accepting any such warranty or additional liability.\n\n   END OF TERMS AND CONDITIONS\n\n   APPENDIX: How to apply the Apache License to your work.\n\n      To apply the Apache License to your work, attach the following\n      boilerplate notice, with the fields enclosed by brackets \"{}\"\n      replaced with your own identifying information. (Don't include\n      the brackets!)  The text should be enclosed in the appropriate\n      comment syntax for the file format. We also recommend that a\n      file or class name and description of purpose be included on the\n      same \"printed page\" as the copyright notice for easier\n      identification within third-party archives.\n\n   Copyright 2021 Mike Penz\n\n   Licensed under the Apache License, Version 2.0 (the \"License\");\n   you may not use this file except in compliance with the License.\n   You may obtain a copy of the License at\n\n       http://www.apache.org/licenses/LICENSE-2.0\n\n   Unless required by applicable law or agreed to in writing, software\n   distributed under the License is distributed on an \"AS IS\" BASIS,\n   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n   See the License for the specific language governing permissions and\n   limitations under the License.\n\n","hash":"c3d2344cfca94c9dd34988875f3d394e","url":"https://github.com/mikepenz/Android-Iconics/raw/develop/LICENSE","name":"Repo"},"e03770b69fb2a7733eeb9207a2c184ad":{"content":"Apache License\nVersion 2.0, January 2004\nhttp://www.apache.org/licenses/\n\nTERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION\n\n1. Definitions.\n\n\"License\" shall mean the terms and conditions for use, reproduction, and distribution as defined by Sections 1 through 9 of this document.\n\n\"Licensor\" shall mean the copyright owner or entity authorized by the copyright owner that is granting the License.\n\n\"Legal Entity\" shall mean the union of the acting entity and all other entities that control, are controlled by, or are under common control with that entity. For the purposes of this definition, \"control\" means (i) the power, direct or indirect, to cause the direction or management of such entity, whether by contract or otherwise, or (ii) ownership of fifty percent (50%) or more of the outstanding shares, or (iii) beneficial ownership of such entity.\n\n\"You\" (or \"Your\") shall mean an individual or Legal Entity exercising permissions granted by this License.\n\n\"Source\" form shall mean the preferred form for making modifications, including but not limited to software source code, documentation source, and configuration files.\n\n\"Object\" form shall mean any form resulting from mechanical transformation or translation of a Source form, including but not limited to compiled object code, generated documentation, and conversions to other media types.\n\n\"Work\" shall mean the work of authorship, whether in Source or Object form, made available under the License, as indicated by a copyright notice that is included in or attached to the work (an example is provided in the Appendix below).\n\n\"Derivative Works\" shall mean any work, whether in Source or Object form, that is based on (or derived from) the Work and for which the editorial revisions, annotations, elaborations, or other modifications represent, as a whole, an original work of authorship. For the purposes of this License, Derivative Works shall not include works that remain separable from, or merely link (or bind by name) to the interfaces of, the Work and Derivative Works thereof.\n\n\"Contribution\" shall mean any work of authorship, including the original version of the Work and any modifications or additions to that Work or Derivative Works thereof, that is intentionally submitted to Licensor for inclusion in the Work by the copyright owner or by an individual or Legal Entity authorized to submit on behalf of the copyright owner. For the purposes of this definition, \"submitted\" means any form of electronic, verbal, or written communication sent to the Licensor or its representatives, including but not limited to communication on electronic mailing lists, source code control systems, and issue tracking systems that are managed by, or on behalf of, the Licensor for the purpose of discussing and improving the Work, but excluding communication that is conspicuously marked or otherwise designated in writing by the copyright owner as \"Not a Contribution.\"\n\n\"Contributor\" shall mean Licensor and any individual or Legal Entity on behalf of whom a Contribution has been received by Licensor and subsequently incorporated within the Work.\n\n2. Grant of Copyright License. Subject to the terms and conditions of this License, each Contributor hereby grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable copyright license to reproduce, prepare Derivative Works of, publicly display, publicly perform, sublicense, and distribute the Work and such Derivative Works in Source or Object form.\n\n3. Grant of Patent License. Subject to the terms and conditions of this License, each Contributor hereby grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable (except as stated in this section) patent license to make, have made, use, offer to sell, sell, import, and otherwise transfer the Work, where such license applies only to those patent claims licensable by such Contributor that are necessarily infringed by their Contribution(s) alone or by combination of their Contribution(s) with the Work to which such Contribution(s) was submitted. If You institute patent litigation against any entity (including a cross-claim or counterclaim in a lawsuit) alleging that the Work or a Contribution incorporated within the Work constitutes direct or contributory patent infringement, then any patent licenses granted to You under this License for that Work shall terminate as of the date such litigation is filed.\n\n4. Redistribution. You may reproduce and distribute copies of the Work or Derivative Works thereof in any medium, with or without modifications, and in Source or Object form, provided that You meet the following conditions:\n\n     (a) You must give any other recipients of the Work or Derivative Works a copy of this License; and\n\n     (b) You must cause any modified files to carry prominent notices stating that You changed the files; and\n\n     (c) You must retain, in the Source form of any Derivative Works that You distribute, all copyright, patent, trademark, and attribution notices from the Source form of the Work, excluding those notices that do not pertain to any part of the Derivative Works; and\n\n     (d) If the Work includes a \"NOTICE\" text file as part of its distribution, then any Derivative Works that You distribute must include a readable copy of the attribution notices contained within such NOTICE file, excluding those notices that do not pertain to any part of the Derivative Works, in at least one of the following places: within a NOTICE text file distributed as part of the Derivative Works; within the Source form or documentation, if provided along with the Derivative Works; or, within a display generated by the Derivative Works, if and wherever such third-party notices normally appear. The contents of the NOTICE file are for informational purposes only and do not modify the License. You may add Your own attribution notices within Derivative Works that You distribute, alongside or as an addendum to the NOTICE text from the Work, provided that such additional attribution notices cannot be construed as modifying the License.\n\n     You may add Your own copyright statement to Your modifications and may provide additional or different license terms and conditions for use, reproduction, or distribution of Your modifications, or for any such Derivative Works as a whole, provided Your use, reproduction, and distribution of the Work otherwise complies with the conditions stated in this License.\n\n5. Submission of Contributions. Unless You explicitly state otherwise, any Contribution intentionally submitted for inclusion in the Work by You to the Licensor shall be under the terms and conditions of this License, without any additional terms or conditions. Notwithstanding the above, nothing herein shall supersede or modify the terms of any separate license agreement you may have executed with Licensor regarding such Contributions.\n\n6. Trademarks. This License does not grant permission to use the trade names, trademarks, service marks, or product names of the Licensor, except as required for reasonable and customary use in describing the origin of the Work and reproducing the content of the NOTICE file.\n\n7. Disclaimer of Warranty. Unless required by applicable law or agreed to in writing, Licensor provides the Work (and each Contributor provides its Contributions) on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied, including, without limitation, any warranties or conditions of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A PARTICULAR PURPOSE. You are solely responsible for determining the appropriateness of using or redistributing the Work and assume any risks associated with Your exercise of permissions under this License.\n\n8. Limitation of Liability. In no event and under no legal theory, whether in tort (including negligence), contract, or otherwise, unless required by applicable law (such as deliberate and grossly negligent acts) or agreed to in writing, shall any Contributor be liable to You for damages, including any direct, indirect, special, incidental, or consequential damages of any character arising as a result of this License or out of the use or inability to use the Work (including but not limited to damages for loss of goodwill, work stoppage, computer failure or malfunction, or any and all other commercial damages or losses), even if such Contributor has been advised of the possibility of such damages.\n\n9. Accepting Warranty or Additional Liability. While redistributing the Work or Derivative Works thereof, You may choose to offer, and charge a fee for, acceptance of support, warranty, indemnity, or other liability obligations and/or rights consistent with this License. However, in accepting such obligations, You may act only on Your own behalf and on Your sole responsibility, not on behalf of any other Contributor, and only if You agree to indemnify, defend, and hold each Contributor harmless for any liability incurred by, or claims asserted against, such Contributor by reason of your accepting any such warranty or additional liability.\n\nEND OF TERMS AND CONDITIONS\n\nAPPENDIX: How to apply the Apache License to your work.\n\nTo apply the Apache License to your work, attach the following boilerplate notice, with the fields enclosed by brackets \"[]\" replaced with your own identifying information. (Don't include the brackets!)  The text should be enclosed in the appropriate comment syntax for the file format. We also recommend that a file or class name and description of purpose be included on the same \"printed page\" as the copyright notice for easier identification within third-party archives.\n\nCopyright [yyyy] [name of copyright owner]\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\nhttp://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.","hash":"e03770b69fb2a7733eeb9207a2c184ad","url":"https://spdx.org/licenses/Apache-2.0.txt","spdxId":"Apache_2_0","name":"Apache-2.0"}}}
    """.trimIndent()
}