/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries.util;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import androidx.annotation.RestrictTo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u001a%\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010\u0006\u001a \u0010\u0007\u001a\u0004\u0018\u00010\u0005*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u000e\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u0002H\u0001\u001a\u000e\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u0002H\u0001\u001a\u0014\u0010\f\u001a\u00020\r*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0005H\u0001\u001a\u0014\u0010\u000f\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0005H\u0001\u00a8\u0006\u0010"}, d2={"extractBooleanBundleOrResource", "", "Landroid/content/Context;", "value", "resName", "", "(Landroid/content/Context;Ljava/lang/Boolean;Ljava/lang/String;)Ljava/lang/Boolean;", "extractStringBundleOrResource", "getApplicationInfo", "Landroid/content/pm/ApplicationInfo;", "getPackageInfo", "Landroid/content/pm/PackageInfo;", "getRawResourceId", "", "aString", "getStringResourceByName", "aboutlibraries-core"})
public final class ContextExtensionKt {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @Nullable
    public static final PackageInfo getPackageInfo(@NotNull Context $this$getPackageInfo) {
        PackageInfo packageInfo;
        Intrinsics.checkNotNullParameter((Object)$this$getPackageInfo, (String)"$this$getPackageInfo");
        try {
            packageInfo = $this$getPackageInfo.getPackageManager().getPackageInfo($this$getPackageInfo.getPackageName(), 0);
        }
        catch (Exception ex) {
            packageInfo = null;
        }
        return packageInfo;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @Nullable
    public static final ApplicationInfo getApplicationInfo(@NotNull Context $this$getApplicationInfo) {
        ApplicationInfo applicationInfo;
        Intrinsics.checkNotNullParameter((Object)$this$getApplicationInfo, (String)"$this$getApplicationInfo");
        try {
            applicationInfo = $this$getApplicationInfo.getPackageManager().getApplicationInfo($this$getApplicationInfo.getPackageName(), 0);
        }
        catch (Exception ex) {
            applicationInfo = null;
        }
        return applicationInfo;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static final int getRawResourceId(@NotNull Context $this$getRawResourceId, @NotNull String aString) {
        Intrinsics.checkNotNullParameter((Object)$this$getRawResourceId, (String)"$this$getRawResourceId");
        Intrinsics.checkNotNullParameter((Object)aString, (String)"aString");
        return $this$getRawResourceId.getResources().getIdentifier(aString, "raw", $this$getRawResourceId.getPackageName());
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @NotNull
    public static final String getStringResourceByName(@NotNull Context $this$getStringResourceByName, @NotNull String aString) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$getStringResourceByName, (String)"$this$getStringResourceByName");
        Intrinsics.checkNotNullParameter((Object)aString, (String)"aString");
        int resId = $this$getStringResourceByName.getResources().getIdentifier(aString, "string", $this$getStringResourceByName.getPackageName());
        if (resId == 0) {
            string = "";
        } else {
            String string2 = $this$getStringResourceByName.getString(resId);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(resId)");
        }
        return string;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @Nullable
    public static final Boolean extractBooleanBundleOrResource(@NotNull Context $this$extractBooleanBundleOrResource, @Nullable Boolean value, @NotNull String resName) {
        Intrinsics.checkNotNullParameter((Object)$this$extractBooleanBundleOrResource, (String)"$this$extractBooleanBundleOrResource");
        Intrinsics.checkNotNullParameter((Object)resName, (String)"resName");
        Boolean result = null;
        if (value != null) {
            result = value;
        } else {
            String descriptionShowVersion = ContextExtensionKt.getStringResourceByName($this$extractBooleanBundleOrResource, resName);
            CharSequence charSequence = descriptionShowVersion;
            boolean bl = false;
            if (charSequence.length() > 0) {
                try {
                    result = Boolean.parseBoolean(descriptionShowVersion);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @Nullable
    public static final String extractStringBundleOrResource(@NotNull Context $this$extractStringBundleOrResource, @Nullable String value, @NotNull String resName) {
        Intrinsics.checkNotNullParameter((Object)$this$extractStringBundleOrResource, (String)"$this$extractStringBundleOrResource");
        Intrinsics.checkNotNullParameter((Object)resName, (String)"resName");
        String string = value;
        if (string == null) {
            String string2 = ContextExtensionKt.getStringResourceByName($this$extractStringBundleOrResource, resName);
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            CharSequence charSequence = it;
            boolean bl4 = false;
            string = charSequence.length() > 0 ? string2 : null;
        }
        return string;
    }
}

