/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.util.Log;
import com.mikepenz.aboutlibraries.Libs;
import com.mikepenz.aboutlibraries.detector.Detect;
import com.mikepenz.aboutlibraries.entity.Library;
import com.mikepenz.aboutlibraries.entity.License;
import com.mikepenz.aboutlibraries.util.ContextExtensionKt;
import com.mikepenz.aboutlibraries.util.GenericsUtilKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u0000 :2\u00020\u0001:\u0003:;<B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0002\u0010\tJ4\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J$\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aJ$\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aJ\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aJ\u001a\u0010\u001e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0006H\u0002J\u001a\u0010!\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0006H\u0002J\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0015J\"\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060&2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0006J\u0016\u0010'\u001a\u0012\u0012\u0004\u0012\u00020\f0(j\b\u0012\u0004\u0012\u00020\f`)J\u0016\u0010*\u001a\u0012\u0012\u0004\u0012\u00020\f0(j\b\u0012\u0004\u0012\u00020\f`)J\u0010\u0010+\u001a\u0004\u0018\u00010\f2\u0006\u0010 \u001a\u00020\u0006J\u0010\u0010,\u001a\u0004\u0018\u00010\u00132\u0006\u0010\"\u001a\u00020\u0006J\u0016\u0010-\u001a\u0012\u0012\u0004\u0012\u00020\u00130(j\b\u0012\u0004\u0012\u00020\u0013`)J\"\u0010.\u001a\u00020\u00062\u0006\u0010/\u001a\u00020\u00062\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060&J(\u00101\u001a\u0002022 \u00103\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060&\u0018\u00010&Ji\u00104\u001a\u0012\u0012\u0004\u0012\u00020\f0(j\b\u0012\u0004\u0012\u00020\f`)2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u00032\u0010\b\u0002\u00105\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00052\u0010\b\u0002\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00052\b\b\u0002\u00107\u001a\u00020\u00152\b\b\u0002\u0010$\u001a\u00020\u00152\b\b\u0002\u00108\u001a\u00020\u0015\u00a2\u0006\u0002\u00109R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/mikepenz/aboutlibraries/Libs;", "", "context", "Landroid/content/Context;", "fields", "", "", "libraryEnchantments", "", "(Landroid/content/Context;[Ljava/lang/String;Ljava/util/Map;)V", "externLibraries", "", "Lcom/mikepenz/aboutlibraries/entity/Library;", "internLibraries", "libraries", "", "getLibraries", "()Ljava/util/List;", "licenses", "Lcom/mikepenz/aboutlibraries/entity/License;", "usedGradlePlugin", "", "find", "searchTerm", "idOnly", "limit", "", "findInExternalLibrary", "findInInternalLibrary", "findLibrary", "genLibrary", "ctx", "libraryName", "genLicense", "licenseName", "getAutoDetectedLibraries", "checkCachedDetection", "getCustomVariables", "Ljava/util/HashMap;", "getExternLibraries", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getInternLibraries", "getLibrary", "getLicense", "getLicenses", "insertVariables", "insertIntoVar", "variables", "modifyLibraries", "", "modifications", "prepareLibraries", "internalLibraries", "excludeLibraries", "autoDetect", "sort", "(Landroid/content/Context;[Ljava/lang/String;[Ljava/lang/String;ZZZ)Ljava/util/ArrayList;", "Companion", "LibraryFields", "SpecialButton", "aboutlibraries-core"})
public final class Libs {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean usedGradlePlugin;
    @NotNull
    private final List<Library> internLibraries;
    @NotNull
    private final List<Library> externLibraries;
    @NotNull
    private final List<License> licenses;
    @NotNull
    public static final String BUNDLE_TITLE = "ABOUT_LIBRARIES_TITLE";
    @NotNull
    public static final String BUNDLE_EDGE_TO_EDGE = "ABOUT_LIBRARIES_EDGE_TO_EDGE";
    @NotNull
    public static final String BUNDLE_SEARCH_ENABLED = "ABOUT_LIBRARIES_SEARCH_ENABLED";
    @NotNull
    private static final String DEFINE_LICENSE = "define_license_";
    @NotNull
    private static final String DEFINE_INT = "define_int_";
    @NotNull
    private static final String DEFINE_PLUGIN = "define_plu_";
    @NotNull
    public static final String DEFINE_EXT = "define_";
    @NotNull
    private static final String DELIMITER = ";";

    public Libs(@NotNull Context context, @NotNull String[] fields, @NotNull Map<String, String> libraryEnchantments) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fields, (String)"fields");
        Intrinsics.checkNotNullParameter(libraryEnchantments, (String)"libraryEnchantments");
        boolean bl = false;
        this.internLibraries = new ArrayList();
        bl = false;
        this.externLibraries = new ArrayList();
        bl = false;
        this.licenses = new ArrayList();
        ArrayList<String> foundLicenseIdentifiers = new ArrayList<String>();
        ArrayList<String> foundInternalLibraryIdentifiers = new ArrayList<String>();
        ArrayList<String> foundExternalLibraryIdentifiers = new ArrayList<String>();
        ArrayList<String> foundPluginLibraryIdentifiers = new ArrayList<String>();
        for (String library : fields) {
            if (StringsKt.startsWith$default((String)library, (String)DEFINE_LICENSE, (boolean)false, (int)2, null)) {
                foundLicenseIdentifiers.add(StringsKt.replace$default((String)library, (String)DEFINE_LICENSE, (String)"", (boolean)false, (int)4, null));
                continue;
            }
            if (StringsKt.startsWith$default((String)library, (String)DEFINE_INT, (boolean)false, (int)2, null)) {
                foundInternalLibraryIdentifiers.add(StringsKt.replace$default((String)library, (String)DEFINE_INT, (String)"", (boolean)false, (int)4, null));
                continue;
            }
            if (!StringsKt.startsWith$default((String)library, (String)DEFINE_PLUGIN, (boolean)false, (int)2, null)) continue;
            foundPluginLibraryIdentifiers.add(StringsKt.replace$default((String)library, (String)DEFINE_PLUGIN, (String)"", (boolean)false, (int)4, null));
        }
        for (String licenseIdentifier : foundLicenseIdentifiers) {
            Intrinsics.checkNotNullExpressionValue((Object)licenseIdentifier, (String)"licenseIdentifier");
            License license = this.genLicense(context, licenseIdentifier);
            if (license == null) continue;
            License license2 = license;
            this.licenses.add(license2);
        }
        for (String pluginLibraryIdentifier : foundPluginLibraryIdentifiers) {
            String string;
            Library library;
            Intrinsics.checkNotNullExpressionValue((Object)pluginLibraryIdentifier, (String)"pluginLibraryIdentifier");
            Library library2 = this.genLibrary(context, pluginLibraryIdentifier);
            if (library2 == null) continue;
            Library library22 = library2;
            library22.setInternal(false);
            library22.setPlugin(true);
            this.externLibraries.add(library22);
            this.usedGradlePlugin = true;
            String string2 = libraryEnchantments.get(pluginLibraryIdentifier);
            if (string2 == null || (library = this.genLibrary(context, string = string2)) == null) continue;
            Library enchantWith = library;
            library22.enchantBy(enchantWith);
        }
        if (foundPluginLibraryIdentifiers.isEmpty()) {
            for (String internalIdentifier : foundInternalLibraryIdentifiers) {
                Intrinsics.checkNotNullExpressionValue((Object)internalIdentifier, (String)"internalIdentifier");
                Library library = this.genLibrary(context, internalIdentifier);
                if (library == null) continue;
                Library library3 = library;
                library3.setInternal(true);
                this.internLibraries.add(library3);
            }
            for (String externalIdentifier : foundExternalLibraryIdentifiers) {
                Intrinsics.checkNotNullExpressionValue((Object)externalIdentifier, (String)"externalIdentifier");
                Library library = this.genLibrary(context, externalIdentifier);
                if (library == null) continue;
                Library library4 = library;
                library4.setInternal(false);
                this.externLibraries.add(library4);
            }
        }
    }

    public /* synthetic */ Libs(Context context, String[] stringArray, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            stringArray = GenericsUtilKt.getFields(context);
        }
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        this(context, stringArray, map);
    }

    @NotNull
    public final List<Library> getLibraries() {
        boolean bl = false;
        List libs = new ArrayList();
        libs.addAll((Collection)this.getInternLibraries());
        libs.addAll((Collection)this.getExternLibraries());
        return libs;
    }

    @NotNull
    public final ArrayList<Library> prepareLibraries(@Nullable Context ctx, @NotNull String[] internalLibraries, @NotNull String[] excludeLibraries, boolean autoDetect, boolean checkCachedDetection, boolean sort) {
        Object object;
        String string;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)internalLibraries, (String)"internalLibraries");
        Intrinsics.checkNotNullParameter((Object)excludeLibraries, (String)"excludeLibraries");
        String[] stringArray = excludeLibraries;
        boolean bl = false;
        String[] stringArray2 = stringArray;
        boolean bl2 = false;
        boolean isExcluding = !(stringArray2.length == 0);
        HashMap libraries = new HashMap();
        ArrayList<Library> resultLibraries = new ArrayList<Library>();
        if (!this.usedGradlePlugin && autoDetect && ctx != null) {
            List<Library> autoDetected = this.getAutoDetectedLibraries(ctx, checkCachedDetection);
            resultLibraries.addAll((Collection)autoDetected);
            if (isExcluding) {
                for (Library lib : autoDetected) {
                    object2 = libraries;
                    string = lib.getDefinedName();
                    boolean bl3 = false;
                    object2.put(string, lib);
                }
            }
        }
        ArrayList<Library> extern = this.getExternLibraries();
        resultLibraries.addAll((Collection)extern);
        if (isExcluding) {
            for (Library lib : extern) {
                object2 = libraries;
                string = lib.getDefinedName();
                Intrinsics.checkNotNullExpressionValue((Object)lib, (String)"lib");
                Library library = lib;
                boolean bl4 = false;
                object2.put(string, library);
            }
        }
        String[] stringArray3 = internalLibraries;
        int n = 0;
        object2 = stringArray3;
        boolean bl5 = false;
        if (!(((String[])object2).length == 0)) {
            for (String internalLibrary : internalLibraries) {
                Object object3 = this.getLibrary(internalLibrary);
                if (object3 == null) continue;
                Library lib = object3;
                resultLibraries.add(lib);
                object3 = libraries;
                object = lib.getDefinedName();
                boolean bl6 = false;
                object3.put(object, lib);
            }
        }
        if (isExcluding) {
            for (String excludeLibrary : excludeLibraries) {
                Library library;
                object = (Library)libraries.get(excludeLibrary);
                if (object == null) continue;
                Library lib = library = object;
                resultLibraries.remove(lib);
            }
        }
        if (sort) {
            CollectionsKt.sort((List)resultLibraries);
        }
        return resultLibraries;
    }

    public static /* synthetic */ ArrayList prepareLibraries$default(Libs libs, Context context, String[] stringArray, String[] stringArray2, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 1) != 0) {
            context = null;
        }
        if ((n & 2) != 0) {
            stringArray = new String[]{};
        }
        if ((n & 4) != 0) {
            stringArray2 = new String[]{};
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        if ((n & 0x20) != 0) {
            bl3 = true;
        }
        return libs.prepareLibraries(context, stringArray, stringArray2, bl, bl2, bl3);
    }

    @NotNull
    public final List<Library> getAutoDetectedLibraries(@NotNull Context ctx, boolean checkCachedDetection) {
        boolean isCacheUpToDate;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        PackageInfo pi = ContextExtensionKt.getPackageInfo(ctx);
        SharedPreferences sharedPreferences = ctx.getSharedPreferences("aboutLibraries", 0);
        int lastCacheVersion = sharedPreferences.getInt("versionCode", -1);
        boolean bl = isCacheUpToDate = pi != null && lastCacheVersion == pi.versionCode;
        if (checkCachedDetection && pi != null && isCacheUpToDate) {
            Boolean bl2;
            String[] autoDetectedLibraries;
            String[] stringArray;
            String[] stringArray2;
            String[] stringArray3;
            Object object = sharedPreferences.getString("autoDetectedLibraries", "");
            if (object == null) {
                stringArray3 = null;
            } else {
                CharSequence charSequence = (CharSequence)object;
                String string = DELIMITER;
                int n = 0;
                string = new Regex(string);
                n = 0;
                boolean bl3 = false;
                stringArray3 = stringArray2 = string.split(charSequence, n);
            }
            if (stringArray2 == null) {
                stringArray = null;
            } else {
                Object object2;
                String[] $this$dropLastWhile$iv = stringArray2;
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl4 = false;
                        CharSequence charSequence = it;
                        boolean bl5 = false;
                        if (charSequence.length() == 0) continue;
                        object2 = CollectionsKt.take((Iterable)((Iterable)$this$dropLastWhile$iv), (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    object2 = object = CollectionsKt.emptyList();
                }
                if (object == null) {
                    stringArray = null;
                } else {
                    Collection $this$toTypedArray$iv = (Collection)object;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray4 = thisCollection$iv.toArray(new String[0]);
                    if (stringArray4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    stringArray = stringArray4;
                }
            }
            stringArray2 = autoDetectedLibraries = stringArray;
            if (stringArray2 == null) {
                bl2 = null;
            } else {
                object = stringArray2;
                boolean $this$toTypedArray$iv = false;
                Object $i$f$toTypedArray = object;
                boolean bl6 = false;
                bl2 = !(((Object)$i$f$toTypedArray).length == 0);
            }
            if (Intrinsics.areEqual(bl2, (Object)true)) {
                ArrayList<Library> libraries = new ArrayList<Library>(autoDetectedLibraries.length);
                object = ArrayIteratorKt.iterator((Object[])autoDetectedLibraries);
                while (object.hasNext()) {
                    String autoDetectedLibrary = (String)object.next();
                    Library library = this.getLibrary(autoDetectedLibrary);
                    if (library == null) continue;
                    Library lib = library;
                    libraries.add(lib);
                }
                return libraries;
            }
        }
        List<Library> libraries = Detect.INSTANCE.detect(ctx, this.getLibraries());
        if (pi != null && !isCacheUpToDate) {
            StringBuilder autoDetectedLibrariesPref = new StringBuilder();
            for (Library lib : libraries) {
                autoDetectedLibrariesPref.append(DELIMITER).append(lib.getDefinedName());
            }
            sharedPreferences.edit().putInt("versionCode", pi.versionCode).putString("autoDetectedLibraries", autoDetectedLibrariesPref.toString()).apply();
        }
        return libraries;
    }

    @NotNull
    public final ArrayList<Library> getInternLibraries() {
        return new ArrayList<Library>((Collection)this.internLibraries);
    }

    @NotNull
    public final ArrayList<Library> getExternLibraries() {
        return new ArrayList<Library>((Collection)this.externLibraries);
    }

    @NotNull
    public final ArrayList<License> getLicenses() {
        return new ArrayList<License>((Collection)this.licenses);
    }

    @Nullable
    public final Library getLibrary(@NotNull String libraryName) {
        Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
        for (Library library : this.getLibraries()) {
            if (StringsKt.equals((String)library.getLibraryName(), (String)libraryName, (boolean)true)) {
                return library;
            }
            if (!StringsKt.equals((String)library.getDefinedName(), (String)libraryName, (boolean)true)) continue;
            return library;
        }
        return null;
    }

    @NotNull
    public final List<Library> findLibrary(@NotNull String searchTerm, int limit) {
        Intrinsics.checkNotNullParameter((Object)searchTerm, (String)"searchTerm");
        return this.find(this.getLibraries(), searchTerm, false, limit);
    }

    @NotNull
    public final List<Library> findInInternalLibrary(@NotNull String searchTerm, boolean idOnly, int limit) {
        Intrinsics.checkNotNullParameter((Object)searchTerm, (String)"searchTerm");
        return this.find((List<Library>)this.getInternLibraries(), searchTerm, idOnly, limit);
    }

    @NotNull
    public final List<Library> findInExternalLibrary(@NotNull String searchTerm, boolean idOnly, int limit) {
        Intrinsics.checkNotNullParameter((Object)searchTerm, (String)"searchTerm");
        return this.find((List<Library>)this.getExternLibraries(), searchTerm, idOnly, limit);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Library> find(List<Library> libraries, String searchTerm, boolean idOnly, int limit) {
        void $this$filterTo$iv$iv;
        Object object;
        if (limit == 1) {
            Object v0;
            boolean $i$f$firstOrNull;
            Object $this$firstOrNull$iv;
            block4: {
                $this$firstOrNull$iv = libraries;
                $i$f$firstOrNull = false;
                object = $this$firstOrNull$iv.iterator();
                while (object.hasNext()) {
                    Object element$iv = object.next();
                    Library it = (Library)element$iv;
                    boolean bl = false;
                    if (!StringsKt.equals((String)it.getDefinedName(), (String)searchTerm, (boolean)true)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            Library library = v0;
            if (library != null) {
                $this$firstOrNull$iv = library;
                $i$f$firstOrNull = false;
                boolean bl = false;
                Object it = $this$firstOrNull$iv;
                boolean bl2 = false;
                return CollectionsKt.listOf((Object)it);
            }
        }
        Function1 matchFunction2 = idOnly ? (Function1)new Function1<Library, Boolean>(searchTerm){
            final /* synthetic */ String $searchTerm;
            {
                this.$searchTerm = $searchTerm;
                super(1);
            }

            public final boolean invoke(@NotNull Library library) {
                Intrinsics.checkNotNullParameter((Object)library, (String)"library");
                return StringsKt.contains((CharSequence)library.getDefinedName(), (CharSequence)this.$searchTerm, (boolean)true);
            }
        } : (Function1)new Function1<Library, Boolean>(searchTerm){
            final /* synthetic */ String $searchTerm;
            {
                this.$searchTerm = $searchTerm;
                super(1);
            }

            public final boolean invoke(@NotNull Library library) {
                Intrinsics.checkNotNullParameter((Object)library, (String)"library");
                return StringsKt.contains((CharSequence)library.getLibraryName(), (CharSequence)this.$searchTerm, (boolean)true) || StringsKt.contains((CharSequence)library.getDefinedName(), (CharSequence)this.$searchTerm, (boolean)true);
            }
        };
        Iterable $this$filter$iv = libraries;
        boolean $i$f$filter = false;
        object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)matchFunction2.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.take((Iterable)((List)destination$iv$iv), (int)limit);
    }

    @Nullable
    public final License getLicense(@NotNull String licenseName) {
        Intrinsics.checkNotNullParameter((Object)licenseName, (String)"licenseName");
        for (License license : this.getLicenses()) {
            if (StringsKt.equals((String)license.getLicenseName(), (String)licenseName, (boolean)true)) {
                return license;
            }
            if (!StringsKt.equals((String)license.getDefinedName(), (String)licenseName, (boolean)true)) continue;
            return license;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final License genLicense(Context ctx, String licenseName) {
        License license;
        String license2 = StringsKt.replace$default((String)licenseName, (String)"-", (String)"_", (boolean)false, (int)4, null);
        try {
            Object licenseDescription = ContextExtensionKt.getStringResourceByName(ctx, "license_" + license2 + "_licenseDescription");
            if (StringsKt.startsWith$default((String)licenseDescription, (String)"raw:", (boolean)false, (int)2, null)) {
                Closeable closeable = ctx.getResources().openRawResource(ContextExtensionKt.getRawResourceId(ctx, StringsKt.removePrefix((String)licenseDescription, (CharSequence)"raw:")));
                Intrinsics.checkNotNullExpressionValue((Object)closeable, (String)"ctx.resources.openRawResource(ctx.getRawResourceId(licenseDescription.removePrefix(\"raw:\")))");
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                Object object = closeable;
                int n = 0;
                object = new InputStreamReader((InputStream)object, charset);
                n = 8192;
                boolean bl2 = false;
                closeable = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
                boolean bl3 = false;
                bl = false;
                Throwable throwable = null;
                try {
                    BufferedReader it = (BufferedReader)closeable;
                    boolean bl4 = false;
                    object = TextStreamsKt.readText((Reader)it);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                licenseDescription = object;
            }
            license = new License(license2, ContextExtensionKt.getStringResourceByName(ctx, "license_" + license2 + "_licenseName"), ContextExtensionKt.getStringResourceByName(ctx, "license_" + license2 + "_licenseWebsite"), ContextExtensionKt.getStringResourceByName(ctx, "license_" + license2 + "_licenseShortDescription"), (String)licenseDescription);
        }
        catch (Exception ex) {
            Log.e((String)"aboutlibraries", (String)Intrinsics.stringPlus((String)"Failed to generateLicense from file: ", (Object)ex));
            license = null;
        }
        return license;
    }

    private final Library genLibrary(Context ctx, String libraryName) {
        String name = StringsKt.replace$default((String)libraryName, (String)"-", (String)"_", (boolean)false, (int)4, null);
        try {
            Library lib = new Library(name, false, false, ContextExtensionKt.getStringResourceByName(ctx, "library_" + name + "_libraryName"), null, null, null, null, null, null, null, false, null, null, 16374, null);
            HashMap<String, String> customVariables = this.getCustomVariables(ctx, name);
            lib.setAuthor(ContextExtensionKt.getStringResourceByName(ctx, "library_" + name + "_author"));
            lib.setAuthorWebsite(ContextExtensionKt.getStringResourceByName(ctx, "library_" + name + "_authorWebsite"));
            lib.setLibraryDescription(this.insertVariables(ContextExtensionKt.getStringResourceByName(ctx, "library_" + name + "_libraryDescription"), customVariables));
            lib.setLibraryVersion(ContextExtensionKt.getStringResourceByName(ctx, "library_" + name + "_libraryVersion"));
            lib.setLibraryArtifactId(ContextExtensionKt.getStringResourceByName(ctx, "library_" + name + "_libraryArtifactId"));
            lib.setLibraryWebsite(ContextExtensionKt.getStringResourceByName(ctx, "library_" + name + "_libraryWebsite"));
            String licenseIds = ContextExtensionKt.getStringResourceByName(ctx, "library_" + name + "_licenseIds");
            String legacyLicenseId = ContextExtensionKt.getStringResourceByName(ctx, "library_" + name + "_licenseId");
            if (StringsKt.isBlank((CharSequence)licenseIds) && StringsKt.isBlank((CharSequence)legacyLicenseId)) {
                License license = new License("", ContextExtensionKt.getStringResourceByName(ctx, "library_" + name + "_licenseVersion"), ContextExtensionKt.getStringResourceByName(ctx, "library_" + name + "_licenseLink"), this.insertVariables(ContextExtensionKt.getStringResourceByName(ctx, "library_" + name + "_licenseContent"), customVariables), this.insertVariables(ContextExtensionKt.getStringResourceByName(ctx, "library_" + name + "_licenseContent"), customVariables));
                lib.setLicenses(SetsKt.setOf((Object)license));
            } else {
                List list;
                boolean bl = false;
                Set licenses = new LinkedHashSet();
                if (StringsKt.isBlank((CharSequence)licenseIds)) {
                    list = CollectionsKt.listOf((Object)legacyLicenseId);
                } else {
                    String[] stringArray = new String[]{","};
                    list = StringsKt.split$default((CharSequence)licenseIds, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                }
                Iterable $this$onEach$iv = list;
                boolean $i$f$onEach = false;
                Iterable iterable = $this$onEach$iv;
                boolean bl2 = false;
                boolean bl3 = false;
                Iterable $this$apply$iv = iterable;
                boolean bl4 = false;
                for (Object element$iv : $this$apply$iv) {
                    String licenseId = (String)element$iv;
                    boolean bl5 = false;
                    License license = this.getLicense(licenseId);
                    if (license != null) {
                        license = License.copy$default(license, null, null, null, null, null, 31, null);
                        license.setLicenseShortDescription(this.insertVariables(license.getLicenseShortDescription(), customVariables));
                        license.setLicenseDescription(this.insertVariables(license.getLicenseDescription(), customVariables));
                        licenses.add(license);
                        continue;
                    }
                    licenses.add(new License("", licenseId, "", "", ""));
                }
                lib.setLicenses(licenses);
            }
            Boolean bl = Boolean.valueOf(ContextExtensionKt.getStringResourceByName(ctx, "library_" + name + "_isOpenSource"));
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"valueOf(ctx.getStringResourceByName(\"library_\" + name + \"_isOpenSource\"))");
            lib.setOpenSource(bl);
            lib.setRepositoryLink(ContextExtensionKt.getStringResourceByName(ctx, "library_" + name + "_repositoryLink"));
            lib.setClassPath(ContextExtensionKt.getStringResourceByName(ctx, "library_" + name + "_classPath"));
            return StringsKt.isBlank((CharSequence)lib.getLibraryName()) && StringsKt.isBlank((CharSequence)lib.getLibraryDescription()) ? (Library)null : lib;
        }
        catch (Exception ex) {
            Log.e((String)"aboutlibraries", (String)Intrinsics.stringPlus((String)"Failed to generateLibrary from file: ", (Object)ex));
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HashMap<String, String> getCustomVariables(@NotNull Context ctx, @NotNull String libraryName) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
        HashMap<String, String> customVariables = new HashMap<String, String>();
        Object[] objectArray = new String[]{DEFINE_EXT, DEFINE_INT, DEFINE_PLUGIN};
        CharSequence charSequence = (String)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.sequenceOf((Object[])objectArray), (Function1)((Function1)new Function1<String, String>(ctx, libraryName){
            final /* synthetic */ Context $ctx;
            final /* synthetic */ String $libraryName;
            {
                this.$ctx = $ctx;
                this.$libraryName = $libraryName;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ContextExtensionKt.getStringResourceByName(this.$ctx, Intrinsics.stringPlus((String)it, (Object)this.$libraryName));
            }
        })), (Function1)getCustomVariables.customVariablesString.2.INSTANCE));
        String customVariablesString2 = charSequence == null ? "" : charSequence;
        charSequence = customVariablesString2;
        boolean bl = false;
        if (charSequence.length() > 0) {
            String[] customVariableArray;
            void $this$toTypedArray$iv;
            List list;
            boolean bl2;
            Object object;
            Collection $this$dropLastWhile$iv;
            String[] stringArray = customVariablesString2;
            String string = DELIMITER;
            int n = 0;
            string = new Regex(string);
            n = 0;
            boolean bl3 = false;
            stringArray = string.split((CharSequence)stringArray, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl4 = false;
                    object = it;
                    bl2 = false;
                    if (object.length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            if (stringArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            stringArray = customVariableArray = stringArray2;
            int n2 = 0;
            String[] stringArray3 = stringArray;
            boolean it = false;
            if (!(stringArray3.length == 0)) {
                for (String customVariableKey : customVariableArray) {
                    String customVariableContent = ContextExtensionKt.getStringResourceByName(ctx, "library_" + libraryName + '_' + customVariableKey);
                    object = customVariableContent;
                    bl2 = false;
                    if (!(object.length() > 0)) continue;
                    object = customVariables;
                    bl2 = false;
                    object.put(customVariableKey, customVariableContent);
                }
            }
        }
        return customVariables;
    }

    @NotNull
    public final String insertVariables(@NotNull String insertIntoVar, @NotNull HashMap<String, String> variables) {
        Intrinsics.checkNotNullParameter((Object)insertIntoVar, (String)"insertIntoVar");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        String insertInto = insertIntoVar;
        Object object = variables;
        boolean bl = false;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = object = iterator.next();
            boolean bl2 = false;
            String key = (String)object2.getKey();
            Object object3 = object;
            boolean bl3 = false;
            String value = (String)object3.getValue();
            object3 = value;
            bl3 = false;
            if (!(object3.length() > 0)) continue;
            StringBuilder stringBuilder = new StringBuilder().append("<<<");
            object3 = key;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            boolean bl4 = false;
            Object object4 = object3;
            boolean bl5 = false;
            Object object5 = object4;
            if (object5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string = ((String)object5).toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toUpperCase(locale)");
            insertInto = StringsKt.replace$default((String)insertInto, (String)stringBuilder.append(string).append(">>>").toString(), (String)value, (boolean)false, (int)4, null);
        }
        insertInto = StringsKt.replace$default((String)insertInto, (String)"<<<", (String)"", (boolean)false, (int)4, null);
        insertInto = StringsKt.replace$default((String)insertInto, (String)">>>", (String)"", (boolean)false, (int)4, null);
        return insertInto;
    }

    public final void modifyLibraries(@Nullable HashMap<String, HashMap<String, String>> modifications) {
        HashMap<String, HashMap<String, String>> hashMap = modifications;
        if (hashMap == null) {
            return;
        }
        Object object = modifications;
        boolean bl = false;
        hashMap = object.entrySet().iterator();
        while (hashMap.hasNext()) {
            Object object2 = object = (Map.Entry)hashMap.next();
            boolean bl2 = false;
            String key1 = (String)object2.getKey();
            Object object3 = object;
            boolean bl3 = false;
            HashMap value1 = (HashMap)object3.getValue();
            List<Library> foundLibs = this.findInExternalLibrary(key1, true, 1);
            if (foundLibs == null || foundLibs.isEmpty()) {
                foundLibs = this.findInInternalLibrary(key1, true, 1);
            }
            if (foundLibs.size() != 1) continue;
            Library lib = foundLibs.get(0);
            Object object4 = value1;
            boolean bl4 = false;
            Iterator iterator = object4.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object5 = object4 = iterator.next();
                boolean bl5 = false;
                String key2 = (String)object5.getKey();
                Object object6 = object4;
                boolean bl6 = false;
                String value = (String)object6.getValue();
                Object object7 = key2;
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                boolean bl7 = false;
                String string = object7;
                boolean bl8 = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toUpperCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toUpperCase(locale)");
                object6 = string3;
                if (Intrinsics.areEqual((Object)object6, (Object)LibraryFields.AUTHOR_NAME.name())) {
                    lib.setAuthor(value);
                    continue;
                }
                if (Intrinsics.areEqual((Object)object6, (Object)LibraryFields.AUTHOR_WEBSITE.name())) {
                    lib.setAuthorWebsite(value);
                    continue;
                }
                if (Intrinsics.areEqual((Object)object6, (Object)LibraryFields.LIBRARY_NAME.name())) {
                    lib.setLibraryName(value);
                    continue;
                }
                if (Intrinsics.areEqual((Object)object6, (Object)LibraryFields.LIBRARY_DESCRIPTION.name())) {
                    lib.setLibraryDescription(value);
                    continue;
                }
                if (Intrinsics.areEqual((Object)object6, (Object)LibraryFields.LIBRARY_VERSION.name())) {
                    lib.setLibraryVersion(value);
                    continue;
                }
                if (Intrinsics.areEqual((Object)object6, (Object)LibraryFields.LIBRARY_ARTIFACT_ID.name())) {
                    lib.setLibraryArtifactId(value);
                    continue;
                }
                if (Intrinsics.areEqual((Object)object6, (Object)LibraryFields.LIBRARY_WEBSITE.name())) {
                    lib.setLibraryWebsite(value);
                    continue;
                }
                if (Intrinsics.areEqual((Object)object6, (Object)LibraryFields.LIBRARY_OPEN_SOURCE.name())) {
                    lib.setOpenSource(Boolean.parseBoolean(value));
                    continue;
                }
                if (Intrinsics.areEqual((Object)object6, (Object)LibraryFields.LIBRARY_REPOSITORY_LINK.name())) {
                    lib.setRepositoryLink(value);
                    continue;
                }
                if (Intrinsics.areEqual((Object)object6, (Object)LibraryFields.LIBRARY_CLASSPATH.name())) {
                    lib.setClassPath(value);
                    continue;
                }
                if (Intrinsics.areEqual((Object)object6, (Object)LibraryFields.LICENSE_NAME.name())) {
                    if (lib.getLicense() == null) {
                        lib.setLicense(new License("", "", "", "", ""));
                    }
                    if ((object7 = lib.getLicense()) == null) continue;
                    ((License)object7).setLicenseName(value);
                    continue;
                }
                if (Intrinsics.areEqual((Object)object6, (Object)LibraryFields.LICENSE_SHORT_DESCRIPTION.name())) {
                    if (lib.getLicense() == null) {
                        lib.setLicense(new License("", "", "", "", ""));
                    }
                    if ((object7 = lib.getLicense()) == null) continue;
                    ((License)object7).setLicenseShortDescription(value);
                    continue;
                }
                if (Intrinsics.areEqual((Object)object6, (Object)LibraryFields.LICENSE_DESCRIPTION.name())) {
                    if (lib.getLicense() == null) {
                        lib.setLicense(new License("", "", "", "", ""));
                    }
                    if ((object7 = lib.getLicense()) == null) continue;
                    ((License)object7).setLicenseDescription(value);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)object6, (Object)LibraryFields.LICENSE_WEBSITE.name())) continue;
                if (lib.getLicense() == null) {
                    lib.setLicense(new License("", "", "", "", ""));
                }
                if ((object7 = lib.getLicense()) == null) continue;
                ((License)object7).setLicenseWebsite(value);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0010\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lcom/mikepenz/aboutlibraries/Libs$LibraryFields;", "", "(Ljava/lang/String;I)V", "AUTHOR_NAME", "AUTHOR_WEBSITE", "LIBRARY_NAME", "LIBRARY_DESCRIPTION", "LIBRARY_VERSION", "LIBRARY_ARTIFACT_ID", "LIBRARY_WEBSITE", "LIBRARY_OPEN_SOURCE", "LIBRARY_REPOSITORY_LINK", "LIBRARY_CLASSPATH", "LICENSE_NAME", "LICENSE_SHORT_DESCRIPTION", "LICENSE_DESCRIPTION", "LICENSE_WEBSITE", "aboutlibraries-core"})
    public static final class LibraryFields
    extends Enum<LibraryFields> {
        public static final /* enum */ LibraryFields AUTHOR_NAME = new LibraryFields();
        public static final /* enum */ LibraryFields AUTHOR_WEBSITE = new LibraryFields();
        public static final /* enum */ LibraryFields LIBRARY_NAME = new LibraryFields();
        public static final /* enum */ LibraryFields LIBRARY_DESCRIPTION = new LibraryFields();
        public static final /* enum */ LibraryFields LIBRARY_VERSION = new LibraryFields();
        public static final /* enum */ LibraryFields LIBRARY_ARTIFACT_ID = new LibraryFields();
        public static final /* enum */ LibraryFields LIBRARY_WEBSITE = new LibraryFields();
        public static final /* enum */ LibraryFields LIBRARY_OPEN_SOURCE = new LibraryFields();
        public static final /* enum */ LibraryFields LIBRARY_REPOSITORY_LINK = new LibraryFields();
        public static final /* enum */ LibraryFields LIBRARY_CLASSPATH = new LibraryFields();
        @Deprecated(message="Note this only will work for libraries with a single license, otherwise only the first is modified")
        public static final /* enum */ LibraryFields LICENSE_NAME = new LibraryFields();
        @Deprecated(message="Note this only will work for libraries with a single license, otherwise only the first is modified")
        public static final /* enum */ LibraryFields LICENSE_SHORT_DESCRIPTION = new LibraryFields();
        @Deprecated(message="Note this only will work for libraries with a single license, otherwise only the first is modified")
        public static final /* enum */ LibraryFields LICENSE_DESCRIPTION = new LibraryFields();
        @Deprecated(message="Note this only will work for libraries with a single license, otherwise only the first is modified")
        public static final /* enum */ LibraryFields LICENSE_WEBSITE = new LibraryFields();
        private static final /* synthetic */ LibraryFields[] $VALUES;

        public static LibraryFields[] values() {
            LibraryFields[] libraryFieldsArray = $VALUES;
            return Arrays.copyOf(libraryFieldsArray, libraryFieldsArray.length);
        }

        public static LibraryFields valueOf(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Enum.valueOf(LibraryFields.class, value);
        }

        static {
            $VALUES = libraryFieldsArray = new LibraryFields[]{LibraryFields.AUTHOR_NAME, LibraryFields.AUTHOR_WEBSITE, LibraryFields.LIBRARY_NAME, LibraryFields.LIBRARY_DESCRIPTION, LibraryFields.LIBRARY_VERSION, LibraryFields.LIBRARY_ARTIFACT_ID, LibraryFields.LIBRARY_WEBSITE, LibraryFields.LIBRARY_OPEN_SOURCE, LibraryFields.LIBRARY_REPOSITORY_LINK, LibraryFields.LIBRARY_CLASSPATH, LibraryFields.LICENSE_NAME, LibraryFields.LICENSE_SHORT_DESCRIPTION, LibraryFields.LICENSE_DESCRIPTION, LibraryFields.LICENSE_WEBSITE};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/mikepenz/aboutlibraries/Libs$SpecialButton;", "", "(Ljava/lang/String;I)V", "SPECIAL1", "SPECIAL2", "SPECIAL3", "aboutlibraries-core"})
    public static final class SpecialButton
    extends Enum<SpecialButton> {
        public static final /* enum */ SpecialButton SPECIAL1 = new SpecialButton();
        public static final /* enum */ SpecialButton SPECIAL2 = new SpecialButton();
        public static final /* enum */ SpecialButton SPECIAL3 = new SpecialButton();
        private static final /* synthetic */ SpecialButton[] $VALUES;

        public static SpecialButton[] values() {
            SpecialButton[] specialButtonArray = $VALUES;
            return Arrays.copyOf(specialButtonArray, specialButtonArray.length);
        }

        public static SpecialButton valueOf(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Enum.valueOf(SpecialButton.class, value);
        }

        static {
            $VALUES = specialButtonArray = new SpecialButton[]{SpecialButton.SPECIAL1, SpecialButton.SPECIAL2, SpecialButton.SPECIAL3};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/mikepenz/aboutlibraries/Libs$Companion;", "", "()V", "BUNDLE_EDGE_TO_EDGE", "", "BUNDLE_SEARCH_ENABLED", "BUNDLE_TITLE", "DEFINE_EXT", "DEFINE_INT", "DEFINE_LICENSE", "DEFINE_PLUGIN", "DELIMITER", "classFields", "", "rClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)[Ljava/lang/String;", "aboutlibraries-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] classFields(@NotNull Class<?> rClass) {
            Intrinsics.checkNotNullParameter(rClass, (String)"rClass");
            Field[] fieldArray = rClass.getFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"rClass.fields");
            return GenericsUtilKt.toStringArray(fieldArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

