package com.mikepenz.aboutlibraries.ui

import android.os.Bundle
import android.os.Parcelable
import androidx.lifecycle.SavedStateHandle
import androidx.navigation.NavArgs
import java.io.Serializable
import java.lang.IllegalArgumentException
import java.lang.UnsupportedOperationException
import kotlin.Suppress
import kotlin.jvm.JvmStatic

public data class LibsSupportFragmentArgs(
  public val `data`: Serializable?,
) : NavArgs {
  @Suppress("CAST_NEVER_SUCCEEDS")
  public fun toBundle(): Bundle {
    val result = Bundle()
    if (Parcelable::class.java.isAssignableFrom(Serializable::class.java)) {
      result.putParcelable("data", this.data as Parcelable?)
    } else if (Serializable::class.java.isAssignableFrom(Serializable::class.java)) {
      result.putSerializable("data", this.data as Serializable?)
    } else {
      throw UnsupportedOperationException(Serializable::class.java.name +
          " must implement Parcelable or Serializable or must be an Enum.")
    }
    return result
  }

  @Suppress("CAST_NEVER_SUCCEEDS")
  public fun toSavedStateHandle(): SavedStateHandle {
    val result = SavedStateHandle()
    if (Parcelable::class.java.isAssignableFrom(Serializable::class.java)) {
      result.set("data", this.data as Parcelable?)
    } else if (Serializable::class.java.isAssignableFrom(Serializable::class.java)) {
      result.set("data", this.data as Serializable?)
    } else {
      throw UnsupportedOperationException(Serializable::class.java.name +
          " must implement Parcelable or Serializable or must be an Enum.")
    }
    return result
  }

  public companion object {
    @JvmStatic
    @Suppress("DEPRECATION")
    public fun fromBundle(bundle: Bundle): LibsSupportFragmentArgs {
      bundle.setClassLoader(LibsSupportFragmentArgs::class.java.classLoader)
      val __data : Serializable?
      if (bundle.containsKey("data")) {
        if (Parcelable::class.java.isAssignableFrom(Serializable::class.java) ||
            Serializable::class.java.isAssignableFrom(Serializable::class.java)) {
          __data = bundle.get("data") as Serializable?
        } else {
          throw UnsupportedOperationException(Serializable::class.java.name +
              " must implement Parcelable or Serializable or must be an Enum.")
        }
      } else {
        throw IllegalArgumentException("Required argument \"data\" is missing and does not have an android:defaultValue")
      }
      return LibsSupportFragmentArgs(__data)
    }

    @JvmStatic
    public fun fromSavedStateHandle(savedStateHandle: SavedStateHandle): LibsSupportFragmentArgs {
      val __data : Serializable?
      if (savedStateHandle.contains("data")) {
        if (Parcelable::class.java.isAssignableFrom(Serializable::class.java) ||
            Serializable::class.java.isAssignableFrom(Serializable::class.java)) {
          __data = savedStateHandle.get<Serializable?>("data")
        } else {
          throw UnsupportedOperationException(Serializable::class.java.name +
              " must implement Parcelable or Serializable or must be an Enum.")
        }
      } else {
        throw IllegalArgumentException("Required argument \"data\" is missing and does not have an android:defaultValue")
      }
      return LibsSupportFragmentArgs(__data)
    }
  }
}
