/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries.util;

import android.content.Context;
import com.mikepenz.aboutlibraries.Libs;

public class GenericsUtil {
    public static String[] getFields(Context ctx) {
        Class rClass = GenericsUtil.resolveRClass(ctx.getPackageName());
        if (rClass != null) {
            for (Class<?> c : rClass.getClasses()) {
                if (!c.getName().endsWith("string")) continue;
                return Libs.toStringArray(c.getFields());
            }
        }
        return new String[0];
    }

    private static Class resolveRClass(String packageName) {
        try {
            return Class.forName(packageName + ".R");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            try {
                return Class.forName(packageName.replace(".debug", "") + ".R");
            }
            catch (ClassNotFoundException e2) {
                e2.printStackTrace();
                try {
                    return Class.forName(packageName.replace(".release", "") + ".R");
                }
                catch (ClassNotFoundException e3) {
                    e3.printStackTrace();
                    return null;
                }
            }
        }
    }
}

