/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.LayoutAnimationController;
import com.mikepenz.aboutlibraries.Libs;
import com.mikepenz.aboutlibraries.LibsBuilder;
import com.mikepenz.aboutlibraries.LibsConfiguration;
import com.mikepenz.aboutlibraries.R;
import com.mikepenz.aboutlibraries.entity.Library;
import com.mikepenz.aboutlibraries.ui.adapter.LibsRecyclerViewAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class LibsFragmentCompat {
    private RecyclerView mRecyclerView;
    private LibsRecyclerViewAdapter mAdapter;
    private LibsBuilder builder = null;
    private static ArrayList<Library> libraries;
    private Comparator<Library> comparator;
    private AsyncTask mLibTask;

    public void setLibraryComparator(Comparator<Library> comparator) {
        this.comparator = comparator;
    }

    public void onAttach(Context context, Bundle bundle) {
        if (bundle == null) {
            Log.e((String)"AboutLibraries", (String)"The AboutLibraries fragment can't be build without the bundle containing the LibsBuilder");
            return;
        }
        this.builder = (LibsBuilder)bundle.getSerializable("data");
    }

    public View onCreateView(Context context, LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_opensource, container, false);
        if (LibsConfiguration.getInstance().getUiListener() != null) {
            view = LibsConfiguration.getInstance().getUiListener().preOnCreateView(view);
        }
        this.mRecyclerView = view.getId() == R.id.cardListView ? (RecyclerView)view : (RecyclerView)view.findViewById(R.id.cardListView);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
        this.mRecyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        this.mAdapter = new LibsRecyclerViewAdapter(this.builder);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        if (LibsConfiguration.getInstance().getUiListener() != null) {
            view = LibsConfiguration.getInstance().getUiListener().postOnCreateView(view);
        }
        return view;
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        if (view.getContext() != null) {
            this.mLibTask = new LibraryTask(view.getContext()).execute(new String[0]);
        }
    }

    public void onDestroyView() {
        if (this.mLibTask != null) {
            this.mLibTask.cancel(true);
            this.mLibTask = null;
        }
    }

    private Boolean extractBooleanBundleOrResource(Context ctx, Libs libs, Boolean value, String resName) {
        Boolean result = null;
        if (value != null) {
            result = value;
        } else {
            String descriptionShowVersion = libs.getStringResourceByName(ctx, resName);
            if (!TextUtils.isEmpty((CharSequence)descriptionShowVersion)) {
                try {
                    result = Boolean.parseBoolean(descriptionShowVersion);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private String extractStringBundleOrResource(Context ctx, Libs libs, String value, String resName) {
        String result = null;
        if (value != null) {
            result = value;
        } else {
            String descriptionShowVersion = libs.getStringResourceByName(ctx, resName);
            if (!TextUtils.isEmpty((CharSequence)descriptionShowVersion)) {
                result = descriptionShowVersion;
            }
        }
        return result;
    }

    private class LibraryTask
    extends AsyncTask<String, String, String> {
        Context ctx;
        String versionName;
        Integer versionCode;
        Drawable icon = null;

        public LibraryTask(Context ctx) {
            this.ctx = ctx;
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        protected String doInBackground(String ... strings) {
            Libs libs = null;
            libs = LibsFragmentCompat.this.builder == null || ((LibsFragmentCompat)LibsFragmentCompat.this).builder.fields == null ? new Libs(this.ctx) : new Libs(this.ctx, ((LibsFragmentCompat)LibsFragmentCompat.this).builder.fields);
            ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutShowIcon = LibsFragmentCompat.this.extractBooleanBundleOrResource(this.ctx, libs, ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutShowIcon, "aboutLibraries_description_showIcon");
            ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutShowVersion = LibsFragmentCompat.this.extractBooleanBundleOrResource(this.ctx, libs, ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutShowVersion, "aboutLibraries_description_showVersion");
            ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutShowVersionName = LibsFragmentCompat.this.extractBooleanBundleOrResource(this.ctx, libs, ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutShowVersionName, "aboutLibraries_description_showVersionName");
            ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutShowVersionCode = LibsFragmentCompat.this.extractBooleanBundleOrResource(this.ctx, libs, ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutShowVersionCode, "aboutLibraries_description_showVersionCode");
            ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutAppName = LibsFragmentCompat.this.extractStringBundleOrResource(this.ctx, libs, ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutAppName, "aboutLibraries_description_name");
            ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutDescription = LibsFragmentCompat.this.extractStringBundleOrResource(this.ctx, libs, ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutDescription, "aboutLibraries_description_text");
            ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutAppSpecial1 = LibsFragmentCompat.this.extractStringBundleOrResource(this.ctx, libs, ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutAppSpecial1, "aboutLibraries_description_special1_name");
            ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutAppSpecial1Description = LibsFragmentCompat.this.extractStringBundleOrResource(this.ctx, libs, ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutAppSpecial1Description, "aboutLibraries_description_special1_text");
            ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutAppSpecial2 = LibsFragmentCompat.this.extractStringBundleOrResource(this.ctx, libs, ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutAppSpecial2, "aboutLibraries_description_special2_name");
            ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutAppSpecial2Description = LibsFragmentCompat.this.extractStringBundleOrResource(this.ctx, libs, ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutAppSpecial2Description, "aboutLibraries_description_special2_text");
            ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutAppSpecial3 = LibsFragmentCompat.this.extractStringBundleOrResource(this.ctx, libs, ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutAppSpecial3, "aboutLibraries_description_special3_name");
            ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutAppSpecial3Description = LibsFragmentCompat.this.extractStringBundleOrResource(this.ctx, libs, ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutAppSpecial3Description, "aboutLibraries_description_special3_text");
            if (libraries == null) {
                libs.modifyLibraries(((LibsFragmentCompat)LibsFragmentCompat.this).builder.libraryModification);
                boolean doDefaultSort = ((LibsFragmentCompat)LibsFragmentCompat.this).builder.sort != false && null == ((LibsFragmentCompat)LibsFragmentCompat.this).builder.libraryComparator && null == LibsFragmentCompat.this.comparator;
                libraries = libs.prepareLibraries(this.ctx, ((LibsFragmentCompat)LibsFragmentCompat.this).builder.internalLibraries, ((LibsFragmentCompat)LibsFragmentCompat.this).builder.excludeLibraries, ((LibsFragmentCompat)LibsFragmentCompat.this).builder.autoDetect, doDefaultSort);
                if (LibsFragmentCompat.this.comparator != null) {
                    Collections.sort(libraries, LibsFragmentCompat.this.comparator);
                } else if (((LibsFragmentCompat)LibsFragmentCompat.this).builder.libraryComparator != null) {
                    Collections.sort(libraries, ((LibsFragmentCompat)LibsFragmentCompat.this).builder.libraryComparator);
                }
            }
            if (((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutShowIcon != null && (((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutShowVersion != null || ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutShowVersionName != null || ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutShowVersionCode.booleanValue())) {
                PackageManager pm = this.ctx.getPackageManager();
                String packageName = this.ctx.getPackageName();
                ApplicationInfo appInfo = null;
                PackageInfo packageInfo = null;
                try {
                    appInfo = pm.getApplicationInfo(packageName, 0);
                    packageInfo = pm.getPackageInfo(packageName, 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutShowIcon.booleanValue() && appInfo != null) {
                    this.icon = appInfo.loadIcon(pm);
                }
                this.versionName = null;
                this.versionCode = null;
                if (packageInfo != null) {
                    this.versionName = packageInfo.versionName;
                    this.versionCode = packageInfo.versionCode;
                }
            }
            return null;
        }

        protected void onPostExecute(String s) {
            if (((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutShowIcon != null && (((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutShowVersion != null || ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutShowVersionName != null || ((LibsFragmentCompat)LibsFragmentCompat.this).builder.aboutShowVersionCode.booleanValue())) {
                LibsFragmentCompat.this.mAdapter.setHeader(this.versionName, this.versionCode, this.icon);
            }
            LibsFragmentCompat.this.mAdapter.addLibs(libraries);
            if (((LibsFragmentCompat)LibsFragmentCompat.this).builder.animate.booleanValue()) {
                LayoutAnimationController layoutAnimationController;
                if (LibsConfiguration.getInstance().getLayoutAnimationController() == null) {
                    Animation fadeIn = AnimationUtils.loadAnimation((Context)this.ctx, (int)17432578);
                    fadeIn.setDuration(500L);
                    layoutAnimationController = new LayoutAnimationController(fadeIn);
                } else {
                    layoutAnimationController = LibsConfiguration.getInstance().getLayoutAnimationController();
                }
                LibsFragmentCompat.this.mRecyclerView.setLayoutAnimation(layoutAnimationController);
                LibsFragmentCompat.this.mRecyclerView.startLayoutAnimation();
            }
            super.onPostExecute((Object)s);
            this.ctx = null;
        }
    }
}

