/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries.ui;

import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.MenuItem;
import android.view.View;
import android.view.Window;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.Fragment;
import com.mikepenz.aboutlibraries.Libs;
import com.mikepenz.aboutlibraries.R;
import com.mikepenz.aboutlibraries.ui.LibsSupportFragment;
import com.mikepenz.aboutlibraries.util.Colors;
import java.io.Serializable;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/mikepenz/aboutlibraries/ui/LibsActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "onCreate", "", "savedInstanceState", "Landroid/os/Bundle;", "onOptionsItemSelected", "", "item", "Landroid/view/MenuItem;", "library_release"})
public class LibsActivity
extends AppCompatActivity {
    private HashMap _$_findViewCache;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        boolean customTheme = false;
        Libs.ActivityStyle activityStyle = Libs.ActivityStyle.DARK;
        Intent intent = this.getIntent();
        Intrinsics.checkExpressionValueIsNotNull((Object)intent, (String)"intent");
        Bundle bundle = intent.getExtras();
        if (bundle != null) {
            String style2;
            int themeId = bundle.getInt("ABOUT_LIBRARIES_THEME", -1);
            if (themeId != -1) {
                customTheme = true;
                this.setTheme(themeId);
            }
            if ((style2 = bundle.getString("ABOUT_LIBRARIES_STYLE")) != null) {
                activityStyle = Libs.ActivityStyle.valueOf(style2);
            }
        }
        if (!customTheme) {
            if (activityStyle == Libs.ActivityStyle.DARK) {
                this.setTheme(R.style.AboutLibrariesTheme);
            } else if (activityStyle == Libs.ActivityStyle.LIGHT) {
                this.setTheme(R.style.AboutLibrariesTheme_Light);
            } else if (activityStyle == Libs.ActivityStyle.LIGHT_DARK_TOOLBAR) {
                this.setTheme(R.style.AboutLibrariesTheme_Light_DarkToolbar);
            }
        }
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_opensource);
        String title = "";
        if (bundle != null) {
            String string = bundle.getString("ABOUT_LIBRARIES_TITLE", "");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"bundle.getString(Libs.BUNDLE_TITLE, \"\")");
            title = string;
        }
        LibsSupportFragment fragment = new LibsSupportFragment();
        fragment.setArguments(bundle);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        if (activityStyle == Libs.ActivityStyle.LIGHT_DARK_TOOLBAR) {
            toolbar.setTitleTextColor(-1);
            toolbar.setSubtitleTextColor(-1);
        }
        this.setSupportActionBar(toolbar);
        ActionBar ab = this.getSupportActionBar();
        if (ab != null) {
            if (bundle != null && bundle.containsKey("ABOUT_COLOR")) {
                Serializable serializable = bundle.getSerializable("ABOUT_COLOR");
                if (serializable == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.mikepenz.aboutlibraries.util.Colors");
                }
                Colors colors = (Colors)serializable;
                if (colors != null) {
                    ab.setBackgroundDrawable((Drawable)new ColorDrawable(colors.getAppBarColor()));
                    if (Build.VERSION.SDK_INT >= 21) {
                        Window window = this.getWindow();
                        Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"window");
                        window.setStatusBarColor(colors.getStatusBarColor());
                    }
                } else {
                    ab.setBackgroundDrawable(null);
                }
            }
            ab.setDisplayHomeAsUpEnabled(true);
            ab.setDisplayShowTitleEnabled(!TextUtils.isEmpty((CharSequence)title));
            ab.setTitle((CharSequence)title);
        }
        this.getSupportFragmentManager().beginTransaction().replace(R.id.frame_container, (Fragment)fragment).commit();
    }

    public boolean onOptionsItemSelected(@NotNull MenuItem item) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        switch (item.getItemId()) {
            case 16908332: {
                this.finish();
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

