/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries.util;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u0004\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u0006\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007H\u0000\u001a\u0014\u0010\t\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007H\u0000\u001a\u001c\u0010\n\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0000\u001a\u0014\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0000\u00a8\u0006\u0010"}, d2={"convertDpToPixel", "", "Landroid/content/Context;", "dp", "convertPixelsToDp", "px", "getThemeAttributeDimensionSize", "", "attr", "getThemeColor", "getThemeColorFromAttrOrRes", "res", "setBackground", "", "Landroid/view/View;", "drawableRes", "library_release"})
public final class UIUtilsKt {
    public static final int getThemeColor(@NotNull Context $receiver, int attr2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        TypedValue tv = new TypedValue();
        return $receiver.getTheme().resolveAttribute(attr2, tv, true) ? (tv.resourceId != 0 ? ContextCompat.getColor((Context)$receiver, (int)tv.resourceId) : tv.data) : 0;
    }

    public static final int getThemeColorFromAttrOrRes(@NotNull Context $receiver, int attr2, int res) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        int color2 = UIUtilsKt.getThemeColor($receiver, attr2);
        if (color2 == 0) {
            color2 = ContextCompat.getColor((Context)$receiver, (int)res);
        }
        return color2;
    }

    public static final void setBackground(@NotNull View $receiver, int drawableRes) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ViewCompat.setBackground((View)$receiver, (Drawable)ContextCompat.getDrawable((Context)$receiver.getContext(), (int)drawableRes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int getThemeAttributeDimensionSize(@NotNull Context $receiver, int attr2) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        TypedArray a = null;
        try {
            TypedArray typedArray = a = $receiver.getTheme().obtainStyledAttributes(new int[]{attr2});
            if (typedArray == null) {
                Intrinsics.throwNpe();
            }
            n = typedArray.getDimensionPixelSize(0, 0);
        }
        catch (Throwable throwable) {
            block3: {
                TypedArray typedArray = a;
                if (typedArray == null) break block3;
                typedArray.recycle();
            }
            throw throwable;
        }
        a.recycle();
        return n;
    }

    public static final float convertDpToPixel(@NotNull Context $receiver, float dp) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Resources resources = $receiver.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        DisplayMetrics metrics = resources.getDisplayMetrics();
        return dp * ((float)metrics.densityDpi / 160.0f);
    }

    public static final float convertPixelsToDp(@NotNull Context $receiver, float px) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Resources resources = $receiver.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        DisplayMetrics metrics = resources.getDisplayMetrics();
        return px / ((float)metrics.densityDpi / 160.0f);
    }
}

