/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries.ui.item;

import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.net.Uri;
import android.text.Html;
import android.view.View;
import android.widget.TextView;
import androidx.appcompat.app.AlertDialog;
import androidx.recyclerview.widget.RecyclerView;
import com.mikepenz.aboutlibraries.LibsBuilder;
import com.mikepenz.aboutlibraries.LibsConfiguration;
import com.mikepenz.aboutlibraries.R;
import com.mikepenz.aboutlibraries.entity.Library;
import com.mikepenz.aboutlibraries.entity.License;
import com.mikepenz.aboutlibraries.util.UIUtilsKt;
import com.mikepenz.fastadapter.items.AbstractItem;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\"B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00022\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J\u0010\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J \u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0002R$\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011\u00a8\u0006#"}, d2={"Lcom/mikepenz/aboutlibraries/ui/item/SimpleLibraryItem;", "Lcom/mikepenz/fastadapter/items/AbstractItem;", "Lcom/mikepenz/aboutlibraries/ui/item/SimpleLibraryItem$ViewHolder;", "library", "Lcom/mikepenz/aboutlibraries/entity/Library;", "libsBuilder", "Lcom/mikepenz/aboutlibraries/LibsBuilder;", "(Lcom/mikepenz/aboutlibraries/entity/Library;Lcom/mikepenz/aboutlibraries/LibsBuilder;)V", "value", "", "isSelectable", "()Z", "setSelectable", "(Z)V", "layoutRes", "", "getLayoutRes", "()I", "getLibrary$aboutlibraries", "()Lcom/mikepenz/aboutlibraries/entity/Library;", "type", "getType", "bindView", "", "holder", "payloads", "", "", "getViewHolder", "v", "Landroid/view/View;", "openLicense", "ctx", "Landroid/content/Context;", "ViewHolder", "aboutlibraries"})
public final class SimpleLibraryItem
extends AbstractItem<ViewHolder> {
    @NotNull
    private final Library library;
    @NotNull
    private final LibsBuilder libsBuilder;

    public SimpleLibraryItem(@NotNull Library library, @NotNull LibsBuilder libsBuilder) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter((Object)libsBuilder, (String)"libsBuilder");
        this.library = library;
        this.libsBuilder = libsBuilder;
    }

    @NotNull
    public final Library getLibrary$aboutlibraries() {
        return this.library;
    }

    public int getType() {
        return R.id.library_simple_item_id;
    }

    public int getLayoutRes() {
        return R.layout.listitem_minimal_opensource;
    }

    public boolean isSelectable() {
        return false;
    }

    public void setSelectable(boolean value) {
    }

    public void bindView(@NotNull ViewHolder holder, @NotNull List<? extends Object> payloads) {
        LibsConfiguration.LibsRecyclerViewListener libsRecyclerViewListener;
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        Intrinsics.checkNotNullParameter(payloads, (String)"payloads");
        super.bindView((RecyclerView.ViewHolder)holder, payloads);
        Context ctx = holder.itemView.getContext();
        holder.getLibraryName$aboutlibraries().setText((CharSequence)this.library.getLibraryName());
        if (this.library.getLicense() != null) {
            Boolean bl;
            libsRecyclerViewListener = this.library.getLicense();
            if (libsRecyclerViewListener == null) {
                bl = null;
            } else {
                String string2 = libsRecyclerViewListener.getLicenseWebsite();
                if (string2 == null) {
                    bl = null;
                } else {
                    CharSequence charSequence = string2;
                    boolean bl2 = false;
                    bl = charSequence.length() > 0;
                }
            }
            if (Intrinsics.areEqual(bl, (Object)true) || this.libsBuilder.getShowLicenseDialog()) {
                holder.itemView.setOnClickListener(arg_0 -> SimpleLibraryItem.bindView$lambda-0(this, ctx, arg_0));
            }
        }
        if ((libsRecyclerViewListener = LibsConfiguration.INSTANCE.getLibsRecyclerViewListener()) != null) {
            libsRecyclerViewListener.onBindViewHolder(holder);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void openLicense(Context ctx, LibsBuilder libsBuilder, Library library) {
        try {
            License license;
            if (libsBuilder.getShowLicenseDialog()) {
                Boolean bl;
                License license2 = library.getLicense();
                if (license2 == null) {
                    bl = null;
                } else {
                    String string2 = license2.getLicenseDescription();
                    if (string2 == null) {
                        bl = null;
                    } else {
                        CharSequence charSequence = string2;
                        boolean bl2 = false;
                        bl = charSequence.length() > 0;
                    }
                }
                if (Intrinsics.areEqual(bl, (Object)true)) {
                    AlertDialog.Builder builder = new AlertDialog.Builder(ctx);
                    License license3 = library.getLicense();
                    builder.setMessage((CharSequence)Html.fromHtml((String)(license3 == null ? null : license3.getLicenseDescription())));
                    builder.create().show();
                    return;
                }
            }
            Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)((license = library.getLicense()) == null ? null : license.getLicenseWebsite())));
            ctx.startActivity(browserIntent);
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    public ViewHolder getViewHolder(@NotNull View v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new ViewHolder(v);
    }

    private static final void bindView$lambda-0(SimpleLibraryItem this$0, Context $ctx, View view) {
        boolean consumed;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        LibsConfiguration.LibsListener libsListener = LibsConfiguration.INSTANCE.getListener();
        if (libsListener == null) {
            bl = false;
        } else {
            boolean bl2;
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"view");
            bl = consumed = (bl2 = libsListener.onLibraryBottomClicked(view, this$0.getLibrary$aboutlibraries()));
        }
        if (!consumed) {
            Intrinsics.checkNotNullExpressionValue((Object)$ctx, (String)"ctx");
            this$0.openLicense($ctx, this$0.libsBuilder, this$0.getLibrary$aboutlibraries());
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/mikepenz/aboutlibraries/ui/item/SimpleLibraryItem$ViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "libraryName", "Landroid/widget/TextView;", "getLibraryName$aboutlibraries", "()Landroid/widget/TextView;", "setLibraryName$aboutlibraries", "(Landroid/widget/TextView;)V", "aboutlibraries"})
    public static final class ViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private TextView libraryName;

        public ViewHolder(@NotNull View itemView) {
            Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
            super(itemView);
            this.libraryName = (TextView)itemView;
            Context ctx = itemView.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)ctx, (String)"ctx");
            UIUtilsKt.resolveStyledValue$default(ctx, null, 0, 0, (Function1)new Function1<TypedArray, Unit>(){

                public final void invoke(@NotNull TypedArray it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.getLibraryName$aboutlibraries().setTextColor(it.getColorStateList(R.styleable.AboutLibraries_aboutLibrariesOpenSourceTitle));
                }
            }, 7, null);
        }

        @NotNull
        public final TextView getLibraryName$aboutlibraries() {
            return this.libraryName;
        }

        public final void setLibraryName$aboutlibraries(@NotNull TextView textView) {
            Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
            this.libraryName = textView;
        }
    }
}

