/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter_extensions;

import android.support.annotation.MenuRes;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.view.ActionMode;
import android.view.Menu;
import android.view.MenuItem;
import com.mikepenz.fastadapter.FastAdapter;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.expandable.ExpandableExtension;
import com.mikepenz.fastadapter.select.SelectExtension;

public class ActionModeHelper<Item extends IItem> {
    private FastAdapter<Item> mFastAdapter;
    private SelectExtension<Item> mSelectExtension;
    @MenuRes
    private int mCabMenu;
    private ActionMode.Callback mInternalCallback;
    private ActionMode.Callback mCallback;
    private ActionMode mActionMode;
    private boolean mAutoDeselect = true;
    private ActionModeTitleProvider mTitleProvider;
    private ActionItemClickedListener actionItemClickedListener = null;

    public ActionModeHelper(FastAdapter<Item> fastAdapter, int cabMenu) {
        this(fastAdapter, cabMenu, (ActionItemClickedListener)null);
    }

    public ActionModeHelper(FastAdapter<Item> fastAdapter, int cabMenu, ActionItemClickedListener actionItemClickedListener) {
        this.mFastAdapter = fastAdapter;
        this.mCabMenu = cabMenu;
        this.mInternalCallback = new ActionBarCallBack();
        this.actionItemClickedListener = actionItemClickedListener;
        this.mSelectExtension = (SelectExtension)fastAdapter.getExtension(SelectExtension.class);
        if (this.mSelectExtension == null) {
            throw new IllegalStateException("The provided FastAdapter requires the `SelectExtension` or `withSelectable(true)`");
        }
    }

    public ActionModeHelper(FastAdapter<Item> fastAdapter, int cabMenu, ActionMode.Callback callback) {
        this.mFastAdapter = fastAdapter;
        this.mCabMenu = cabMenu;
        this.mCallback = callback;
        this.mInternalCallback = new ActionBarCallBack();
        this.mSelectExtension = (SelectExtension)fastAdapter.getExtension(SelectExtension.class);
        if (this.mSelectExtension == null) {
            throw new IllegalStateException("The provided FastAdapter requires the `SelectExtension` or `withSelectable(true)`");
        }
    }

    public ActionModeHelper<Item> withTitleProvider(ActionModeTitleProvider titleProvider) {
        this.mTitleProvider = titleProvider;
        return this;
    }

    public ActionModeHelper<Item> withAutoDeselect(boolean enabled) {
        this.mAutoDeselect = enabled;
        return this;
    }

    @Deprecated
    public ActionModeHelper<Item> withSupportSubItems(ExpandableExtension expandableExtension) {
        return this;
    }

    public ActionMode getActionMode() {
        return this.mActionMode;
    }

    public boolean isActive() {
        return this.mActionMode != null;
    }

    public Boolean onClick(IItem item) {
        return this.onClick(null, item);
    }

    public Boolean onClick(AppCompatActivity act, IItem item) {
        if (this.mActionMode != null && this.mSelectExtension.getSelectedItems().size() == 1 && item.isSelected()) {
            this.mActionMode.finish();
            this.mSelectExtension.deselect();
            return true;
        }
        if (this.mActionMode != null) {
            int selected = this.mSelectExtension.getSelectedItems().size();
            if (item.isSelected()) {
                --selected;
            } else if (item.isSelectable()) {
                ++selected;
            }
            this.checkActionMode(act, selected);
        }
        return null;
    }

    public ActionMode onLongClick(AppCompatActivity act, int position) {
        if (this.mActionMode == null && this.mFastAdapter.getItem(position).isSelectable()) {
            this.mActionMode = act.startSupportActionMode(this.mInternalCallback);
            this.mSelectExtension.select(position);
            this.checkActionMode(act, 1);
            return this.mActionMode;
        }
        return this.mActionMode;
    }

    public ActionMode checkActionMode(AppCompatActivity act) {
        int selected = this.mSelectExtension.getSelectedItems().size();
        return this.checkActionMode(act, selected);
    }

    public void reset() {
        if (this.mActionMode != null) {
            this.mActionMode.finish();
            this.mActionMode = null;
        }
    }

    private ActionMode checkActionMode(AppCompatActivity act, int selected) {
        if (selected == 0) {
            if (this.mActionMode != null) {
                this.mActionMode.finish();
                this.mActionMode = null;
            }
        } else if (this.mActionMode == null && act != null) {
            this.mActionMode = act.startSupportActionMode(this.mInternalCallback);
        }
        this.updateTitle(selected);
        return this.mActionMode;
    }

    private void updateTitle(int selected) {
        if (this.mActionMode != null) {
            if (this.mTitleProvider != null) {
                this.mActionMode.setTitle((CharSequence)this.mTitleProvider.getTitle(selected));
            } else {
                this.mActionMode.setTitle((CharSequence)String.valueOf(selected));
            }
        }
    }

    public static interface ActionItemClickedListener {
        public boolean onClick(ActionMode var1, MenuItem var2);
    }

    public static interface ActionModeTitleProvider {
        public String getTitle(int var1);
    }

    private class ActionBarCallBack
    implements ActionMode.Callback {
        private ActionBarCallBack() {
        }

        public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
            boolean consumed = false;
            if (ActionModeHelper.this.mCallback != null) {
                consumed = ActionModeHelper.this.mCallback.onActionItemClicked(mode, item);
            }
            if (!consumed && ActionModeHelper.this.actionItemClickedListener != null) {
                consumed = ActionModeHelper.this.actionItemClickedListener.onClick(mode, item);
            }
            if (!consumed) {
                ActionModeHelper.this.mSelectExtension.deleteAllSelectedItems();
                mode.finish();
            }
            return consumed;
        }

        public boolean onCreateActionMode(ActionMode mode, Menu menu) {
            mode.getMenuInflater().inflate(ActionModeHelper.this.mCabMenu, menu);
            ActionModeHelper.this.mFastAdapter.withSelectOnLongClick(false);
            return ActionModeHelper.this.mCallback == null || ActionModeHelper.this.mCallback.onCreateActionMode(mode, menu);
        }

        public void onDestroyActionMode(ActionMode mode) {
            ActionModeHelper.this.mActionMode = null;
            ActionModeHelper.this.mFastAdapter.withSelectOnLongClick(true);
            if (ActionModeHelper.this.mAutoDeselect) {
                ActionModeHelper.this.mSelectExtension.deselect();
            }
            if (ActionModeHelper.this.mCallback != null) {
                ActionModeHelper.this.mCallback.onDestroyActionMode(mode);
            }
        }

        public boolean onPrepareActionMode(ActionMode mode, Menu menu) {
            return ActionModeHelper.this.mCallback != null && ActionModeHelper.this.mCallback.onPrepareActionMode(mode, menu);
        }
    }
}

