/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter_extensions;

import com.mikepenz.fastadapter.adapters.ModelAdapter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class HeaderHelper<Item, HeaderItem> {
    private ModelAdapter modelAdapter;
    private GroupingFunction<Item, HeaderItem> groupingFunction;
    private Comparator<Item> comparator;

    public HeaderHelper(GroupingFunction groupingFunction) {
        this.groupingFunction = groupingFunction;
    }

    public HeaderHelper(ModelAdapter modelAdapter, GroupingFunction<Item, HeaderItem> groupingFunction) {
        this.modelAdapter = modelAdapter;
        this.groupingFunction = groupingFunction;
    }

    public void apply(List items) {
        int size = items.size();
        if (size > 0) {
            if (this.comparator != null) {
                Collections.sort(items, this.comparator);
            }
            for (int i = -1; i < size; ++i) {
                HeaderItem headerItem = i == -1 ? this.groupingFunction.group(null, items.get(i + 1), i) : (i == size - 1 ? this.groupingFunction.group(items.get(i), null, i) : this.groupingFunction.group(items.get(i), items.get(i + 1), i));
                if (headerItem == null) continue;
                items.add(i + 1, headerItem);
                ++i;
                ++size;
            }
        }
        if (this.modelAdapter != null) {
            this.modelAdapter.set(items);
        }
    }

    public Comparator<Item> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<Item> comparator) {
        this.comparator = comparator;
    }

    public ModelAdapter getModelAdapter() {
        return this.modelAdapter;
    }

    public void setModelAdapter(ModelAdapter modelAdapter) {
        this.modelAdapter = modelAdapter;
    }

    public GroupingFunction<Item, HeaderItem> getGroupingFunction() {
        return this.groupingFunction;
    }

    public void setGroupingFunction(GroupingFunction<Item, HeaderItem> groupingFunction) {
        this.groupingFunction = groupingFunction;
    }

    public static interface GroupingFunction<Item, HeaderItem> {
        public HeaderItem group(Item var1, Item var2, int var3);
    }
}

