/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter_extensions;

import android.os.Bundle;
import com.mikepenz.fastadapter.FastAdapter;
import com.mikepenz.fastadapter.IExpandable;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.commons.adapters.FastItemAdapter;
import com.mikepenz.fastadapter_extensions.ActionModeHelper;
import com.mikepenz.fastadapter_extensions.utilities.SubItemUtil;

public class RangeSelectorHelper {
    protected static final String BUNDLE_LAST_LONG_PRESS = "bundle_last_long_press";
    private FastItemAdapter mFastAdapter;
    private ActionModeHelper mActionModeHelper;
    private boolean mSupportSubItems = false;
    private Object mPayload = null;
    private Integer mLastLongPressIndex;

    public RangeSelectorHelper(FastItemAdapter adapter) {
        this.mFastAdapter = adapter;
    }

    public RangeSelectorHelper withActionModeHelper(ActionModeHelper actionModeHelper) {
        this.mActionModeHelper = actionModeHelper;
        return this;
    }

    public RangeSelectorHelper withSupportSubItems(boolean supportSubItems) {
        this.mSupportSubItems = supportSubItems;
        return this;
    }

    public RangeSelectorHelper withPayload(Object payload) {
        this.mPayload = payload;
        return this;
    }

    public void onClick() {
        this.reset();
    }

    public void reset() {
        this.mLastLongPressIndex = null;
    }

    public boolean onLongClick(int index) {
        return this.onLongClick(index, true);
    }

    public boolean onLongClick(int index, boolean selectItem) {
        if (this.mLastLongPressIndex == null) {
            if (this.mFastAdapter.getAdapterItem(index).isSelectable()) {
                this.mLastLongPressIndex = index;
                if (selectItem) {
                    this.mFastAdapter.select(index);
                }
                if (this.mActionModeHelper != null) {
                    this.mActionModeHelper.checkActionMode(null);
                }
                return true;
            }
        } else if (this.mLastLongPressIndex != index) {
            this.selectRange(this.mLastLongPressIndex, index, true);
            this.mLastLongPressIndex = null;
        }
        return false;
    }

    public <T extends IItem & IExpandable> void selectRange(int from, int to, boolean select) {
        this.selectRange(from, to, select, false);
    }

    public <T extends IItem & IExpandable> void selectRange(int from, int to, boolean select, boolean skipHeaders) {
        if (from > to) {
            int temp = from;
            from = to;
            to = temp;
        }
        for (int i = from; i <= to; ++i) {
            IItem item = this.mFastAdapter.getAdapterItem(i);
            if (item.isSelectable()) {
                if (select) {
                    this.mFastAdapter.select(i);
                } else {
                    this.mFastAdapter.deselect(i);
                }
            }
            if (!this.mSupportSubItems || skipHeaders || !(item instanceof IExpandable) || ((IExpandable)item).isExpanded()) continue;
            SubItemUtil.selectAllSubItems((FastAdapter)this.mFastAdapter, this.mFastAdapter.getAdapterItem(i), select, true, this.mPayload);
        }
        if (this.mActionModeHelper != null) {
            this.mActionModeHelper.checkActionMode(null);
        }
    }

    public Bundle saveInstanceState(Bundle savedInstanceState) {
        return this.saveInstanceState(savedInstanceState, "");
    }

    public Bundle saveInstanceState(Bundle savedInstanceState, String prefix) {
        if (savedInstanceState != null && this.mLastLongPressIndex != null) {
            savedInstanceState.putInt(BUNDLE_LAST_LONG_PRESS, this.mLastLongPressIndex.intValue());
        }
        return savedInstanceState;
    }

    public RangeSelectorHelper withSavedInstanceState(Bundle savedInstanceState) {
        return this.withSavedInstanceState(savedInstanceState, "");
    }

    public RangeSelectorHelper withSavedInstanceState(Bundle savedInstanceState, String prefix) {
        if (savedInstanceState != null && savedInstanceState.containsKey(BUNDLE_LAST_LONG_PRESS + prefix)) {
            this.mLastLongPressIndex = savedInstanceState.getInt(BUNDLE_LAST_LONG_PRESS + prefix);
        }
        return this;
    }
}

