/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter_extensions.drag;

import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchHelper;
import com.mikepenz.fastadapter.FastAdapter;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.adapters.ItemAdapter;
import com.mikepenz.fastadapter.commons.adapters.FastItemAdapter;
import com.mikepenz.fastadapter_extensions.drag.IDraggable;
import com.mikepenz.fastadapter_extensions.drag.ItemTouchCallback;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class SimpleDragCallback
extends ItemTouchHelper.SimpleCallback {
    private ItemTouchCallback mCallbackItemTouch;
    private boolean mIsDragEnabled = true;
    private int mFrom = -1;
    private int mTo = -1;
    private int mDirections = 3;
    public static final int ALL = 15;
    public static final int UP_DOWN = 3;
    public static final int LEFT_RIGHT = 12;

    public SimpleDragCallback() {
        super(3, 0);
    }

    public SimpleDragCallback(int directions) {
        super(directions, 0);
        this.mDirections = directions;
    }

    public SimpleDragCallback(int directions, ItemTouchCallback itemTouchCallback) {
        super(directions, 0);
        this.mDirections = directions;
        this.mCallbackItemTouch = itemTouchCallback;
    }

    public SimpleDragCallback(ItemTouchCallback itemTouchCallback) {
        super(3, 0);
        this.mCallbackItemTouch = itemTouchCallback;
    }

    public void setIsDragEnabled(boolean mIsDragEnabled) {
        this.mIsDragEnabled = mIsDragEnabled;
    }

    public boolean isLongPressDragEnabled() {
        return this.mIsDragEnabled;
    }

    public boolean onMove(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, RecyclerView.ViewHolder target) {
        IItem item = FastAdapter.getHolderAdapterItem((RecyclerView.ViewHolder)viewHolder);
        if (item instanceof IDraggable && ((IDraggable)item).isDraggable()) {
            if (this.mFrom == -1) {
                this.mFrom = viewHolder.getAdapterPosition();
            }
            this.mTo = target.getAdapterPosition();
        }
        if (this.mCallbackItemTouch == null) {
            RecyclerView.Adapter adapter = recyclerView.getAdapter();
            ItemAdapter itemAdapter = null;
            if (adapter instanceof FastItemAdapter) {
                itemAdapter = ((FastItemAdapter)adapter).getItemAdapter();
            } else if (adapter instanceof FastAdapter) {
                itemAdapter = (ItemAdapter)((FastAdapter)adapter).adapter(0);
            }
            if (itemAdapter != null) {
                itemAdapter.move(itemAdapter.getFastAdapter().getHolderAdapterPosition(viewHolder), itemAdapter.getFastAdapter().getHolderAdapterPosition(target));
                return true;
            }
            throw new RuntimeException("SimpleDragCallback without an callback is only allowed when using the ItemAdapter or the FastItemAdapter");
        }
        return this.mCallbackItemTouch.itemTouchOnMove(viewHolder.getAdapterPosition(), target.getAdapterPosition());
    }

    public int getDragDirs(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
        IItem item = FastAdapter.getHolderAdapterItem((RecyclerView.ViewHolder)viewHolder);
        if (item instanceof IDraggable) {
            if (((IDraggable)item).isDraggable()) {
                return super.getDragDirs(recyclerView, viewHolder);
            }
            return 0;
        }
        return this.mDirections;
    }

    public void onSwiped(RecyclerView.ViewHolder viewHolder, int direction) {
    }

    public void clearView(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
        super.clearView(recyclerView, viewHolder);
        if (this.mFrom != -1 && this.mTo != -1 && this.mCallbackItemTouch != null) {
            this.mCallbackItemTouch.itemTouchDropped(this.mFrom, this.mTo);
        }
        this.mTo = -1;
        this.mFrom = -1;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Directions {
    }
}

