/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter_extensions.items;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.DrawableRes;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.mikepenz.fastadapter.commons.utils.FastAdapterUIUtils;
import com.mikepenz.fastadapter.items.AbstractItem;
import com.mikepenz.library_extensions.R;
import com.mikepenz.materialize.holder.ImageHolder;
import com.mikepenz.materialize.holder.StringHolder;
import java.util.List;

public class TwoLineItem
extends AbstractItem<TwoLineItem, ViewHolder> {
    private StringHolder mName;
    private StringHolder mDescription;
    private ImageHolder mAvatar;
    private ImageHolder mIcon;

    public TwoLineItem withName(String name) {
        this.mName = new StringHolder(name);
        return this;
    }

    public TwoLineItem withDescription(String description) {
        this.mDescription = new StringHolder(description);
        return this;
    }

    public TwoLineItem withAvatar(Drawable avatar) {
        this.mAvatar = new ImageHolder(avatar);
        return this;
    }

    public TwoLineItem withAvatar(@DrawableRes int avatarRes) {
        this.mAvatar = new ImageHolder(avatarRes);
        return this;
    }

    public TwoLineItem withAvatar(Uri uri) {
        this.mAvatar = new ImageHolder(uri);
        return this;
    }

    public TwoLineItem withAvatar(Bitmap bitmap) {
        this.mAvatar = new ImageHolder(bitmap);
        return this;
    }

    public TwoLineItem withAvatar(String url) {
        this.mAvatar = new ImageHolder(Uri.parse((String)url));
        return this;
    }

    public TwoLineItem withIcon(Drawable icon) {
        this.mIcon = new ImageHolder(icon);
        return this;
    }

    public TwoLineItem withIcon(@DrawableRes int iconRes) {
        this.mIcon = new ImageHolder(iconRes);
        return this;
    }

    public TwoLineItem withIcon(Uri uri) {
        this.mIcon = new ImageHolder(uri);
        return this;
    }

    public TwoLineItem withIcon(Bitmap bitmap) {
        this.mIcon = new ImageHolder(bitmap);
        return this;
    }

    public TwoLineItem withIcon(String url) {
        this.mIcon = new ImageHolder(Uri.parse((String)url));
        return this;
    }

    public StringHolder getName() {
        return this.mName;
    }

    public StringHolder getDescription() {
        return this.mDescription;
    }

    public ImageHolder getAvatar() {
        return this.mAvatar;
    }

    public ImageHolder getIcon() {
        return this.mIcon;
    }

    public int getType() {
        return R.id.two_line_item_id;
    }

    public int getLayoutRes() {
        return R.layout.two_line_item;
    }

    public void bindView(ViewHolder holder, List<Object> payloads) {
        super.bindView((RecyclerView.ViewHolder)holder, payloads);
        if (this.isEnabled()) {
            holder.itemView.setBackgroundResource(FastAdapterUIUtils.getSelectableBackground((Context)holder.itemView.getContext()));
        }
        this.mName.applyTo(holder.name);
        this.mDescription.applyTo(holder.description);
        ImageHolder.applyToOrSetGone((ImageHolder)this.mAvatar, (ImageView)holder.avatar);
        ImageHolder.applyToOrSetGone((ImageHolder)this.mIcon, (ImageView)holder.icon);
    }

    public void unbindView(ViewHolder holder) {
        holder.name.setText(null);
        holder.description.setText(null);
        holder.avatar.setImageDrawable(null);
        holder.avatar.setVisibility(0);
        holder.icon.setImageDrawable(null);
        holder.icon.setVisibility(0);
    }

    public ViewHolder getViewHolder(View v) {
        return new ViewHolder(v);
    }

    protected static class ViewHolder
    extends RecyclerView.ViewHolder {
        protected TextView name;
        protected TextView description;
        protected ImageView avatar;
        protected ImageView icon;

        public ViewHolder(View view) {
            super(view);
            this.name = (TextView)view.findViewById(R.id.name);
            this.description = (TextView)view.findViewById(R.id.description);
            this.avatar = (ImageView)view.findViewById(R.id.avatar);
            this.icon = (ImageView)view.findViewById(R.id.icon);
        }
    }
}

