/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter_extensions.scroll;

import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.OrientationHelper;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.mikepenz.fastadapter.FastAdapter;

public abstract class EndlessRecyclerOnTopScrollListener
extends RecyclerView.OnScrollListener {
    private int mPreviousTotal = 0;
    private boolean mLoading = true;
    private int mCurrentPage = 0;
    private FastAdapter mAdapter;
    private LinearLayoutManager mLayoutManager;
    private int mVisibleThreshold = -1;
    private OrientationHelper mOrientationHelper;
    private boolean mIsOrientationHelperVertical;
    private int mFirstVisibleItem;
    private int mVisibleItemCount;
    private int mTotalItemCount;
    private boolean mAlreadyCalledOnNoMore;
    private int mTotalItems = -1;

    public EndlessRecyclerOnTopScrollListener(FastAdapter adapter, int totalItems) {
        this.mAdapter = adapter;
        this.mTotalItems = totalItems;
    }

    public EndlessRecyclerOnTopScrollListener(FastAdapter adapter) {
        this.mAdapter = adapter;
    }

    public int getVisibleThreshold() {
        return this.mVisibleThreshold;
    }

    public void setVisibleThreshold(int visibleThreshold) {
        this.mVisibleThreshold = visibleThreshold;
    }

    public int getTotalLoadedItems() {
        return this.mTotalItems;
    }

    public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
        super.onScrolled(recyclerView, dx, dy);
        if (this.mLayoutManager == null) {
            this.mLayoutManager = (LinearLayoutManager)recyclerView.getLayoutManager();
        }
        if (this.mVisibleThreshold == -1) {
            this.mVisibleThreshold = this.findLastVisibleItemPosition(recyclerView) - this.findFirstVisibleItemPosition(recyclerView);
        }
        this.mVisibleItemCount = recyclerView.getChildCount();
        this.mTotalItemCount = this.mLayoutManager.getItemCount();
        this.mFirstVisibleItem = this.findFirstVisibleItemPosition(recyclerView);
        this.mTotalItemCount = this.mAdapter.getItemCount();
        if (this.mLoading && this.mTotalItemCount > this.mPreviousTotal) {
            this.mLoading = false;
            this.mPreviousTotal = this.mTotalItemCount;
        }
        if (!this.mLoading && this.mLayoutManager.findFirstVisibleItemPosition() - this.mVisibleThreshold <= 0) {
            ++this.mCurrentPage;
            this.onLoadMore(this.mCurrentPage);
            this.mLoading = true;
        } else if (this.isNothingToLoadFeatureEnabled() && this.isNothingToLoadNeeded()) {
            this.onNothingToLoad();
            this.mAlreadyCalledOnNoMore = true;
        }
    }

    private int findLastVisibleItemPosition(RecyclerView recyclerView) {
        View child = this.findOneVisibleChild(recyclerView.getChildCount() - 1, -1, false, true);
        return child == null ? -1 : recyclerView.getChildAdapterPosition(child);
    }

    private int findFirstVisibleItemPosition(RecyclerView recyclerView) {
        View child = this.findOneVisibleChild(0, this.mLayoutManager.getChildCount(), false, true);
        return child == null ? -1 : recyclerView.getChildAdapterPosition(child);
    }

    public abstract void onLoadMore(int var1);

    public boolean isNothingToLoadFeatureEnabled() {
        return this.mTotalItems != -1;
    }

    private boolean isNothingToLoadNeeded() {
        return this.mAdapter.getItemCount() == this.mTotalItems && !this.mAlreadyCalledOnNoMore;
    }

    public abstract void onNothingToLoad();

    private View findOneVisibleChild(int fromIndex, int toIndex, boolean completelyVisible, boolean acceptPartiallyVisible) {
        if (this.mLayoutManager.canScrollVertically() != this.mIsOrientationHelperVertical || this.mOrientationHelper == null) {
            this.mIsOrientationHelperVertical = this.mLayoutManager.canScrollVertically();
            this.mOrientationHelper = this.mIsOrientationHelperVertical ? OrientationHelper.createVerticalHelper((RecyclerView.LayoutManager)this.mLayoutManager) : OrientationHelper.createHorizontalHelper((RecyclerView.LayoutManager)this.mLayoutManager);
        }
        int start = this.mOrientationHelper.getStartAfterPadding();
        int end = this.mOrientationHelper.getEndAfterPadding();
        int next = toIndex > fromIndex ? 1 : -1;
        View partiallyVisible = null;
        for (int i = fromIndex; i != toIndex; i += next) {
            View child = this.mLayoutManager.getChildAt(i);
            if (child == null) continue;
            int childStart = this.mOrientationHelper.getDecoratedStart(child);
            int childEnd = this.mOrientationHelper.getDecoratedEnd(child);
            if (childStart >= end || childEnd <= start) continue;
            if (completelyVisible) {
                if (childStart >= start && childEnd <= end) {
                    return child;
                }
                if (!acceptPartiallyVisible || partiallyVisible != null) continue;
                partiallyVisible = child;
                continue;
            }
            return child;
        }
        return partiallyVisible;
    }

    public void resetPageCount() {
        this.resetPageCount(0);
    }

    public void resetPageCount(int page) {
        this.mPreviousTotal = 0;
        this.mLoading = true;
        this.mCurrentPage = page;
        this.onLoadMore(this.mCurrentPage);
    }

    public RecyclerView.LayoutManager getLayoutManager() {
        return this.mLayoutManager;
    }

    public int getTotalItemCount() {
        return this.mTotalItemCount;
    }

    public int getFirstVisibleItem() {
        return this.mFirstVisibleItem;
    }

    public int getVisibleItemCount() {
        return this.mVisibleItemCount;
    }

    public int getCurrentPage() {
        return this.mCurrentPage;
    }
}

