/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter_extensions.swipe;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchHelper;
import android.view.View;
import com.mikepenz.fastadapter.FastAdapter;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter_extensions.swipe.ISwipeable;

public class SimpleSwipeCallback
extends ItemTouchHelper.SimpleCallback {
    private final ItemSwipeCallback itemSwipeCallback;
    private int bgColorLeft;
    private int bgColorRight;
    private Drawable leaveBehindDrawableLeft;
    private Drawable leaveBehindDrawableRight;
    private Paint bgPaint;
    private int horizontalMargin = Integer.MAX_VALUE;

    public SimpleSwipeCallback(ItemSwipeCallback itemSwipeCallback, Drawable leaveBehindDrawableLeft) {
        this(itemSwipeCallback, leaveBehindDrawableLeft, 4);
    }

    public SimpleSwipeCallback(ItemSwipeCallback itemSwipeCallback, Drawable leaveBehindDrawableLeft, int swipeDirs) {
        this(itemSwipeCallback, leaveBehindDrawableLeft, swipeDirs, -65536);
    }

    public SimpleSwipeCallback(ItemSwipeCallback itemSwipeCallback, Drawable leaveBehindDrawableLeft, int swipeDirs, @ColorInt int bgColor) {
        super(0, swipeDirs);
        this.itemSwipeCallback = itemSwipeCallback;
        this.leaveBehindDrawableLeft = leaveBehindDrawableLeft;
        this.bgColorLeft = bgColor;
    }

    public SimpleSwipeCallback withLeaveBehindSwipeLeft(Drawable d) {
        this.leaveBehindDrawableLeft = d;
        this.setDefaultSwipeDirs(super.getSwipeDirs(null, null) | 4);
        return this;
    }

    public SimpleSwipeCallback withLeaveBehindSwipeRight(Drawable d) {
        this.leaveBehindDrawableRight = d;
        this.setDefaultSwipeDirs(super.getSwipeDirs(null, null) | 8);
        return this;
    }

    public SimpleSwipeCallback withHorizontalMarginDp(Context ctx, int dp) {
        return this.withHorizontalMarginPx((int)(ctx.getResources().getDisplayMetrics().density * (float)dp));
    }

    public SimpleSwipeCallback withHorizontalMarginPx(int px) {
        this.horizontalMargin = px;
        return this;
    }

    public SimpleSwipeCallback withBackgroundSwipeLeft(@ColorInt int bgColor) {
        this.bgColorLeft = bgColor;
        return this;
    }

    public SimpleSwipeCallback withBackgroundSwipeRight(@ColorInt int bgColor) {
        this.bgColorRight = bgColor;
        return this;
    }

    public int getSwipeDirs(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
        IItem item = FastAdapter.getHolderAdapterItem((RecyclerView.ViewHolder)viewHolder);
        if (item instanceof ISwipeable) {
            if (((ISwipeable)item).isSwipeable()) {
                return super.getSwipeDirs(recyclerView, viewHolder);
            }
            return 0;
        }
        return super.getSwipeDirs(recyclerView, viewHolder);
    }

    public void onSwiped(RecyclerView.ViewHolder viewHolder, int direction) {
        viewHolder.itemView.setTranslationX(0.0f);
        viewHolder.itemView.setTranslationY(0.0f);
        int position = viewHolder.getAdapterPosition();
        if (position != -1) {
            this.itemSwipeCallback.itemSwiped(position, direction);
        }
    }

    public boolean onMove(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, RecyclerView.ViewHolder target) {
        return false;
    }

    public void onChildDraw(Canvas c, RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
        View itemView = viewHolder.itemView;
        if (viewHolder.getAdapterPosition() == -1) {
            return;
        }
        if (Math.abs(dX) > Math.abs(dY)) {
            Drawable drawable;
            boolean isLeft;
            boolean bl = isLeft = dX < 0.0f;
            if (this.bgPaint == null) {
                this.bgPaint = new Paint();
                if (this.horizontalMargin == Integer.MAX_VALUE) {
                    this.withHorizontalMarginDp(recyclerView.getContext(), 16);
                }
            }
            this.bgPaint.setColor(isLeft ? this.bgColorLeft : this.bgColorRight);
            if (this.bgPaint.getColor() != 0) {
                int left = isLeft ? itemView.getRight() + (int)dX : itemView.getLeft();
                int right = isLeft ? itemView.getRight() : itemView.getLeft() + (int)dX;
                c.drawRect((float)left, (float)itemView.getTop(), (float)right, (float)itemView.getBottom(), this.bgPaint);
            }
            Drawable drawable2 = drawable = isLeft ? this.leaveBehindDrawableLeft : this.leaveBehindDrawableRight;
            if (drawable != null) {
                int right;
                int left;
                int itemHeight = itemView.getBottom() - itemView.getTop();
                int intrinsicWidth = drawable.getIntrinsicWidth();
                int intrinsicHeight = drawable.getIntrinsicWidth();
                if (isLeft) {
                    left = itemView.getRight() - this.horizontalMargin - intrinsicWidth;
                    right = itemView.getRight() - this.horizontalMargin;
                } else {
                    left = itemView.getLeft() + this.horizontalMargin;
                    right = itemView.getLeft() + this.horizontalMargin + intrinsicWidth;
                }
                int top = itemView.getTop() + (itemHeight - intrinsicHeight) / 2;
                int bottom = top + intrinsicHeight;
                drawable.setBounds(left, top, right, bottom);
                drawable.draw(c);
            }
        }
        super.onChildDraw(c, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
    }

    public static interface ItemSwipeCallback {
        public void itemSwiped(int var1, int var2);
    }
}

