/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter_extensions;

import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.material.R;
import com.google.android.material.snackbar.BaseTransientBottomBar;
import com.google.android.material.snackbar.Snackbar;
import com.mikepenz.fastadapter.FastAdapter;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.IItemAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

public class UndoHelper<Item extends IItem> {
    private static final int ACTION_REMOVE = 2;
    private FastAdapter<Item> mAdapter;
    private UndoListener<Item> mUndoListener;
    private History mHistory = null;
    private Snackbar mSnackBar = null;
    private String mSnackbarActionText = "";
    private boolean mAlreadyCommitted;
    private Snackbar.Callback mSnackbarCallback = new Snackbar.Callback(){

        public void onShown(Snackbar sb) {
            super.onShown(sb);
            UndoHelper.this.mAlreadyCommitted = false;
        }

        public void onDismissed(Snackbar transientBottomBar, int event) {
            super.onDismissed(transientBottomBar, event);
            if (event == 1 || UndoHelper.this.mAlreadyCommitted) {
                return;
            }
            UndoHelper.this.notifyCommit();
        }
    };

    public UndoHelper(FastAdapter<Item> adapter, UndoListener<Item> undoListener) {
        this.mAdapter = adapter;
        this.mUndoListener = undoListener;
    }

    public void withSnackBar(@NonNull Snackbar snackBar, String actionText) {
        this.mSnackBar = snackBar;
        this.mSnackbarActionText = actionText;
        ((Snackbar)this.mSnackBar.addCallback((BaseTransientBottomBar.BaseCallback)this.mSnackbarCallback)).setAction((CharSequence)actionText, new View.OnClickListener(){

            public void onClick(View v) {
                UndoHelper.this.undoChange();
            }
        });
    }

    @Nullable
    public Snackbar getSnackBar() {
        return this.mSnackBar;
    }

    @Nullable
    public Snackbar remove(Set<Integer> positions) {
        if (this.mSnackBar == null) {
            return null;
        }
        View snackbarView = this.mSnackBar.getView();
        TextView snackbarText = (TextView)snackbarView.findViewById(R.id.snackbar_text);
        return this.remove(snackbarView, snackbarText.getText().toString(), this.mSnackbarActionText, this.mSnackBar.getDuration(), positions);
    }

    public Snackbar remove(View view, String text, String actionText, int duration, Set<Integer> positions) {
        if (this.mHistory != null) {
            this.mAlreadyCommitted = true;
            this.notifyCommit();
        }
        History history = new History();
        history.action = 2;
        for (int position : positions) {
            history.items.add(this.mAdapter.getRelativeInfo(position));
        }
        Collections.sort(history.items, new Comparator<FastAdapter.RelativeInfo<Item>>(){

            @Override
            public int compare(FastAdapter.RelativeInfo<Item> lhs, FastAdapter.RelativeInfo<Item> rhs) {
                return Integer.valueOf(lhs.position).compareTo(rhs.position);
            }
        });
        this.mHistory = history;
        this.doChange();
        this.mSnackBar = (Snackbar)Snackbar.make((View)view, (CharSequence)text, (int)duration).addCallback((BaseTransientBottomBar.BaseCallback)this.mSnackbarCallback);
        this.mSnackBar.setAction((CharSequence)actionText, new View.OnClickListener(){

            public void onClick(View v) {
                UndoHelper.this.undoChange();
            }
        });
        this.mSnackBar.show();
        return this.mSnackBar;
    }

    private void notifyCommit() {
        if (this.mHistory != null && this.mHistory.action == 2) {
            TreeSet<Integer> positions = new TreeSet<Integer>(new Comparator<Integer>(){

                @Override
                public int compare(Integer lhs, Integer rhs) {
                    return lhs.compareTo(rhs);
                }
            });
            for (FastAdapter.RelativeInfo relativeInfo : this.mHistory.items) {
                positions.add(relativeInfo.position);
            }
            this.mUndoListener.commitRemove(positions, this.mHistory.items);
            this.mHistory = null;
        }
    }

    private void doChange() {
        if (this.mHistory != null && this.mHistory.action == 2) {
            for (int i = this.mHistory.items.size() - 1; i >= 0; --i) {
                FastAdapter.RelativeInfo relativeInfo = this.mHistory.items.get(i);
                if (!(relativeInfo.adapter instanceof IItemAdapter)) continue;
                ((IItemAdapter)relativeInfo.adapter).remove(relativeInfo.position);
            }
        }
    }

    private void undoChange() {
        if (this.mHistory != null && this.mHistory.action == 2) {
            int size = this.mHistory.items.size();
            for (int i = 0; i < size; ++i) {
                FastAdapter.RelativeInfo relativeInfo = this.mHistory.items.get(i);
                if (!(relativeInfo.adapter instanceof IItemAdapter)) continue;
                IItemAdapter adapter = (IItemAdapter)relativeInfo.adapter;
                adapter.addInternal(relativeInfo.position, Arrays.asList(relativeInfo.item));
                if (!relativeInfo.item.isSelected()) continue;
                this.mAdapter.select(relativeInfo.position);
            }
        }
        this.mHistory = null;
    }

    private class History {
        public int action;
        public ArrayList<FastAdapter.RelativeInfo<Item>> items = new ArrayList();

        private History() {
        }
    }

    public static interface UndoListener<Item extends IItem> {
        public void commitRemove(Set<Integer> var1, ArrayList<FastAdapter.RelativeInfo<Item>> var2);
    }
}

