/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter_extensions.dialog;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.mikepenz.fastadapter.FastAdapter;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.adapters.ItemAdapter;
import com.mikepenz.fastadapter.listeners.OnClickListener;
import com.mikepenz.fastadapter.listeners.OnLongClickListener;
import com.mikepenz.fastadapter.listeners.OnTouchListener;
import java.util.List;

public class FastAdapterBottomSheetDialog<Item extends IItem>
extends BottomSheetDialog {
    private RecyclerView mRecyclerView = this.createRecyclerView();
    private FastAdapter<Item> mFastAdapter;
    private ItemAdapter<Item> mItemAdapter;

    public FastAdapterBottomSheetDialog(Context context) {
        super(context);
    }

    public FastAdapterBottomSheetDialog(Context context, int theme) {
        super(context, theme);
    }

    private RecyclerView createRecyclerView() {
        RecyclerView recyclerView = new RecyclerView(this.getContext());
        RecyclerView.LayoutParams params = new RecyclerView.LayoutParams(-1, -1);
        recyclerView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.setContentView((View)recyclerView);
        return recyclerView;
    }

    public FastAdapterBottomSheetDialog<Item> withFastItemAdapter(@NonNull FastAdapter<Item> fastAdapter, @NonNull ItemAdapter<Item> itemAdapter) {
        this.mFastAdapter = fastAdapter;
        this.mItemAdapter = itemAdapter;
        this.mRecyclerView.setAdapter(this.mFastAdapter);
        return this;
    }

    private void initAdapterIfNeeded() {
        if (this.mFastAdapter == null || this.mRecyclerView.getAdapter() == null) {
            this.mItemAdapter = ItemAdapter.items();
            this.mFastAdapter = FastAdapter.with(this.mItemAdapter);
            this.mRecyclerView.setAdapter(this.mFastAdapter);
        }
    }

    public FastAdapterBottomSheetDialog<Item> withItems(@NonNull List<Item> items) {
        this.initAdapterIfNeeded();
        this.mItemAdapter.set(items);
        return this;
    }

    public FastAdapterBottomSheetDialog<Item> withItems(Item ... items) {
        this.initAdapterIfNeeded();
        this.mItemAdapter.add((Object[])items);
        return this;
    }

    public FastAdapterBottomSheetDialog<Item> withAdapter(FastAdapter<Item> adapter) {
        this.mRecyclerView.setAdapter(adapter);
        return this;
    }

    public FastAdapterBottomSheetDialog<Item> withLayoutManager(RecyclerView.LayoutManager layoutManager) {
        this.mRecyclerView.setLayoutManager(layoutManager);
        return this;
    }

    public FastAdapterBottomSheetDialog<Item> withOnScrollListener(RecyclerView.OnScrollListener listener) {
        this.mRecyclerView.addOnScrollListener(listener);
        return this;
    }

    public void show() {
        if (this.mRecyclerView.getLayoutManager() == null) {
            this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        }
        this.initAdapterIfNeeded();
        super.show();
    }

    @NonNull
    public RecyclerView getRecyclerView() {
        return this.mRecyclerView;
    }

    public FastAdapterBottomSheetDialog<Item> withOnClickListener(OnClickListener<Item> onClickListener) {
        this.mFastAdapter.withOnClickListener(onClickListener);
        return this;
    }

    public FastAdapterBottomSheetDialog<Item> withOnPreClickListener(OnClickListener<Item> onPreClickListener) {
        this.mFastAdapter.withOnPreClickListener(onPreClickListener);
        return this;
    }

    public FastAdapterBottomSheetDialog<Item> withOnLongClickListener(OnLongClickListener<Item> onLongClickListener) {
        this.mFastAdapter.withOnLongClickListener(onLongClickListener);
        return this;
    }

    public FastAdapterBottomSheetDialog<Item> withOnPreLongClickListener(OnLongClickListener<Item> onPreLongClickListener) {
        this.mFastAdapter.withOnPreLongClickListener(onPreLongClickListener);
        return this;
    }

    public FastAdapterBottomSheetDialog<Item> withOnTouchListener(OnTouchListener<Item> onTouchListener) {
        this.mFastAdapter.withOnTouchListener(onTouchListener);
        return this;
    }

    public FastAdapterBottomSheetDialog<Item> set(List<Item> items) {
        this.mItemAdapter.set(items);
        return this;
    }

    public FastAdapterBottomSheetDialog<Item> setNewList(List<Item> items) {
        this.mItemAdapter.setNewList(items);
        return this;
    }

    @SafeVarargs
    public final FastAdapterBottomSheetDialog<Item> add(Item ... items) {
        this.mItemAdapter.add((Object[])items);
        return this;
    }

    public FastAdapterBottomSheetDialog<Item> add(List<Item> items) {
        this.mItemAdapter.add(items);
        return this;
    }

    @SafeVarargs
    public final FastAdapterBottomSheetDialog<Item> add(int position, Item ... items) {
        this.mItemAdapter.add(position, (Object[])items);
        return this;
    }

    public FastAdapterBottomSheetDialog<Item> add(int position, List<Item> items) {
        this.mItemAdapter.add(position, items);
        return this;
    }

    public FastAdapterBottomSheetDialog<Item> set(int position, Item item) {
        this.mItemAdapter.set(position, item);
        return this;
    }

    public FastAdapterBottomSheetDialog<Item> add(Item item) {
        this.mItemAdapter.add((Object[])new IItem[]{item});
        return this;
    }

    public FastAdapterBottomSheetDialog<Item> add(int position, Item item) {
        this.mItemAdapter.add(position, (Object[])new IItem[]{item});
        return this;
    }

    public FastAdapterBottomSheetDialog<Item> move(int fromPosition, int toPosition) {
        this.mItemAdapter.move(fromPosition, toPosition);
        return this;
    }

    public FastAdapterBottomSheetDialog<Item> remove(int position) {
        this.mItemAdapter.remove(position);
        return this;
    }

    public FastAdapterBottomSheetDialog<Item> removeItemRange(int position, int itemCount) {
        this.mItemAdapter.removeRange(position, itemCount);
        return this;
    }

    public FastAdapterBottomSheetDialog<Item> clear() {
        this.mItemAdapter.clear();
        return this;
    }
}

